(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28153,       1066]
NotebookOptionsPosition[     22287,        860]
NotebookOutlinePosition[     23640,        899]
CellTagsIndexPosition[     23555,        894]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Using Assumptions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assuming" :> Documentation`HelpLookup["paclet:ref/Assuming"], 
          "Block" :> Documentation`HelpLookup["paclet:ref/Block"], 
          "Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/Assumptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assuming\"\>", 2->"\<\"Block\"\>", 
       3->"\<\"Assumptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>",
        2->"\<\"Global Computation Settings & Parameters\"\>", 
       3->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$Assumptions", "ObjectName",
 CellID->8182],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$Assumptions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
     "\[LineSeparator]is the default setting for the ",
     Cell[BoxData[
      ButtonBox["Assumptions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
     " option used in such functions as ",
     Cell[BoxData[
      ButtonBox["Simplify",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Refine",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Integrate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 " can be modified using ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3806],

Cell[TextData[{
 "The initial setting for ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17556]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4099133],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->714409840],

Cell["Set global assumptions:", "ExampleText",
 CellID->188850157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$Assumptions", "=", 
  RowBox[{"a", ">", "0"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263590949],

Cell[BoxData[
 RowBox[{"a", ">", "0"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95456762]
}, Open  ]],

Cell[TextData[{
 "The assumptions are now used by ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->387683152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"a", "^", "2"}], 
    RowBox[{"b", "^", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->963083505],

Cell[BoxData[
 RowBox[{"a", " ", 
  SqrtBox[
   SuperscriptBox["b", "2"]]}]], "Output",
 ImageSize->{46, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->339192951]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "a"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->596805835],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "a"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->947673159]
}, Open  ]],

Cell["Locally add assumptions:", "ExampleText",
 CellID->370515908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"b", "<", "0"}], ",", 
   RowBox[{"Refine", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], 
      RowBox[{"b", "^", "2"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->873406365],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "a"}], " ", "b"}]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->637113716]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Assumptions"], "Input",
 CellLabel->"In[5]:=",
 CellID->397220761],

Cell[BoxData[
 RowBox[{"a", ">", "0"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->341940371]
}, Open  ]],

Cell["Locally change assumptions:", "ExampleText",
 CellID->392299434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$Assumptions", "=", 
     RowBox[{
      RowBox[{"a", "<", "0"}], "&&", 
      RowBox[{"b", "<", "0"}]}]}], "}"}], ",", 
   RowBox[{"Refine", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], 
      RowBox[{"b", "^", "2"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->341263276],

Cell[BoxData[
 RowBox[{"a", " ", "b"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->582480150]
}, Open  ]],

Cell["Remove the global assumptions:", "ExampleText",
 CellID->90975862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$Assumptions", "=", "True"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->65773221],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->657756095]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29877],

Cell["Specify assumptions for simplifiers:", "ExampleText",
 CellID->496046392],

Cell[BoxData[
 RowBox[{
  RowBox[{"operations", ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Refine", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"n", " ", "Pi"}], "]"}], "]"}], ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"n", "^", "p"}], ",", "p"}], "]"}], "]"}], ",", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{
       RowBox[{"EulerPhi", "[", 
        RowBox[{"p", "^", "n"}], "]"}], "-", 
       RowBox[{"p", "^", "n"}]}], "]"}], ",", 
     RowBox[{"FunctionExpand", "[", 
      RowBox[{"Factorial2", "[", "n", "]"}], "]"}]}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->119598163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$Assumptions", "=", 
     RowBox[{
      RowBox[{"n", "\[Element]", "Integers"}], "&&", 
      RowBox[{"p", "\[Element]", "Primes"}], "&&", 
      RowBox[{"n", ">", "0"}]}]}], "}"}], ",", "operations"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->270336134],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"Mod", "[", 
    RowBox[{"n", ",", "p"}], "]"}], ",", 
   RowBox[{"-", 
    SuperscriptBox["p", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}]]}], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{
      FractionBox["1", "4"], "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"], "4"], "+", 
      FractionBox["n", "2"]}]], " ", 
    SuperscriptBox["\[Pi]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "4"]}], "+", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"], "4"]}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", 
      FractionBox["n", "2"]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{357, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->357447637]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->144582480],

Cell[TextData[{
 "Specify assumptions for ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " and in integral transforms:"
}], "ExampleText",
 CellID->148351672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$Assumptions", "=", 
     RowBox[{"a", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"x", "+", "a"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"FourierTransform", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", "a"}], ")"}]}], ",", "x", ",", "w"}], 
      "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46628139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     FractionBox["1", "a"]}], "]"}], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", 
        SqrtBox["a"]}], " ", "w"}]], " ", 
     SqrtBox[
      FractionBox["\[Pi]", "2"]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", 
          SqrtBox["a"], " ", "w"}]], " ", 
        RowBox[{"HeavisideTheta", "[", 
         RowBox[{"-", "w"}], "]"}]}], "+", 
       RowBox[{"HeavisideTheta", "[", "w", "]"}]}], ")"}]}], 
    SqrtBox["a"]]}], "}"}]], "Output",
 ImageSize->{491, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374501218]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130304687],

Cell[TextData[{
 "Specify assumptions for ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->612674636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$Assumptions", "=", 
     RowBox[{"a", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Limit", "[", 
      RowBox[{
       RowBox[{"x", "^", "a"}], ",", 
       RowBox[{"x", "\[Rule]", "Infinity"}]}], "]"}], ",", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Min", "[", 
          RowBox[{
           RowBox[{"x", "^", "2"}], ",", 
           RowBox[{"1", "+", "a"}]}], "]"}], 
         RowBox[{"Cos", "[", "x", "]"}]}], "+", 
        RowBox[{"Sin", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->509467335],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", 
   InterpretationBox[
    RowBox[{"x", "+", 
     SuperscriptBox["x", "2"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "3"],
      SeriesData[$CellContext`x, 0, {}, 1, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1, 1}, 1, 3, 1],
    Editable->False]}], "}"}]], "Output",
 ImageSize->{116, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314451772]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6029],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " locally adds assumptions to ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->327934170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$Assumptions", "=", 
     RowBox[{"x", ">", "0"}]}], "}"}], ",", 
   RowBox[{"Assuming", "[", 
    RowBox[{
     RowBox[{"y", ">", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"$Assumptions", ",", 
       RowBox[{"Refine", "[", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"x", "^", "2"}], 
          RowBox[{"y", "^", "2"}]}], "]"}], "]"}]}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->105796528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"x", ">", "0"}]}], ",", 
   RowBox[{"x", " ", "y"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->877064336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107628890],

Cell[TextData[{
 "Functions affected by the value of ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14679804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"ToExpression", "/@", 
    RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Head", "[", "#", "]"}], "===", "Symbol"}], "&&", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"Options", "[", "#", "]"}], ",", 
       RowBox[{"Assumptions", "\[RuleDelayed]", "$Assumptions"}]}], "]"}]}], 
    "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->387781780],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "FourierCosTransform", ",", "FourierSinTransform", ",", "FourierTransform", 
   ",", "FullSimplify", ",", "FunctionExpand", ",", "Integrate", ",", 
   "InverseFourierCosTransform", ",", "InverseFourierSinTransform", ",", 
   "InverseFourierTransform", ",", "LaplaceTransform", ",", "Limit", ",", 
   "PiecewiseExpand", ",", "PossibleZeroQ", ",", "Refine", ",", "Series", ",",
    "Simplify"}], "}"}]], "Output",
 ImageSize->{496, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210306659]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30589],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " option is set directly, assumptions given with ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 " are not used:"
}], "ExampleText",
 CellID->313243743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$Assumptions", "=", 
     RowBox[{"x", ">", "0"}]}], "}"}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"y", "<", "0"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318847199],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    SuperscriptBox["x", "2"]]}], " ", "y"}]], "Output",
 ImageSize->{54, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231459605]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4784],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assuming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assuming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16730]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28357],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->13415]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->333486152],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->31894099],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->311074571],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->42139502]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$Assumptions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 16.3691774}", "context" -> "System`", 
    "keywords" -> {
     "criteria", "default assumptions", "domain specification", 
      "global assumptions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$Assumptions is the default setting for the Assumptions option used in \
such functions as Simplify, Refine and Integrate. ", "synonyms" -> {}, 
    "title" -> "$Assumptions", "type" -> "Symbol", "uri" -> 
    "ref/$Assumptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5242, 172, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4099133]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23414, 887}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2301, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2924, 81, 49, 1, 70, "ObjectName",
 CellID->8182],
Cell[2976, 84, 1044, 33, 70, "Usage",
 CellID->4219]
}, Open  ]],
Cell[CellGroupData[{
Cell[4057, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4535, 139, 341, 13, 70, "Notes",
 CellID->3806],
Cell[4879, 154, 326, 13, 70, "Notes",
 CellID->17556]
}, Closed]],
Cell[CellGroupData[{
Cell[5242, 172, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4099133],
Cell[CellGroupData[{
Cell[5625, 186, 148, 5, 70, "ExampleSection",
 CellID->714409840],
Cell[5776, 193, 66, 1, 70, "ExampleText",
 CellID->188850157],
Cell[CellGroupData[{
Cell[5867, 198, 126, 4, 28, "Input",
 CellID->263590949],
Cell[5996, 204, 179, 6, 36, "Output",
 CellID->95456762]
}, Open  ]],
Cell[6190, 213, 342, 13, 70, "ExampleText",
 CellID->387683152],
Cell[CellGroupData[{
Cell[6557, 230, 202, 7, 28, "Input",
 CellID->963083505],
Cell[6762, 239, 217, 8, 45, "Output",
 CellID->339192951]
}, Open  ]],
Cell[CellGroupData[{
Cell[7016, 252, 211, 7, 70, "Input",
 CellID->596805835],
Cell[7230, 261, 201, 7, 51, "Output",
 CellID->947673159]
}, Open  ]],
Cell[7446, 271, 67, 1, 70, "ExampleText",
 CellID->370515908],
Cell[CellGroupData[{
Cell[7538, 276, 293, 10, 70, "Input",
 CellID->873406365],
Cell[7834, 288, 198, 7, 36, "Output",
 CellID->637113716]
}, Open  ]],
Cell[CellGroupData[{
Cell[8069, 300, 81, 2, 70, "Input",
 CellID->397220761],
Cell[8153, 304, 180, 6, 36, "Output",
 CellID->341940371]
}, Open  ]],
Cell[8348, 313, 70, 1, 70, "ExampleText",
 CellID->392299434],
Cell[CellGroupData[{
Cell[8443, 318, 407, 14, 70, "Input",
 CellID->341263276],
Cell[8853, 334, 180, 6, 36, "Output",
 CellID->582480150]
}, Open  ]],
Cell[9048, 343, 72, 1, 70, "ExampleText",
 CellID->90975862],
Cell[CellGroupData[{
Cell[9145, 348, 105, 3, 70, "Input",
 CellID->65773221],
Cell[9253, 353, 161, 5, 36, "Output",
 CellID->657756095]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9463, 364, 216, 7, 70, "ExampleSection",
 CellID->29877],
Cell[9682, 373, 79, 1, 70, "ExampleText",
 CellID->496046392],
Cell[9764, 376, 670, 21, 70, "Input",
 CellID->119598163],
Cell[CellGroupData[{
Cell[10459, 401, 344, 11, 70, "Input",
 CellID->270336134],
Cell[10806, 414, 924, 33, 54, "Output",
 CellID->357447637]
}, Open  ]],
Cell[11745, 450, 125, 3, 70, "ExampleDelimiter",
 CellID->144582480],
Cell[11873, 455, 236, 8, 70, "ExampleText",
 CellID->148351672],
Cell[CellGroupData[{
Cell[12134, 467, 686, 23, 70, "Input",
 CellID->46628139],
Cell[12823, 492, 811, 28, 73, "Output",
 CellID->374501218]
}, Open  ]],
Cell[13649, 523, 125, 3, 70, "ExampleDelimiter",
 CellID->130304687],
Cell[13777, 528, 326, 13, 70, "ExampleText",
 CellID->612674636],
Cell[CellGroupData[{
Cell[14128, 545, 780, 26, 70, "Input",
 CellID->509467335],
Cell[14911, 573, 531, 17, 39, "Output",
 CellID->314451772]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15491, 596, 232, 7, 70, "ExampleSection",
 CellID->6029],
Cell[15726, 605, 339, 12, 70, "ExampleText",
 CellID->327934170],
Cell[CellGroupData[{
Cell[16090, 621, 526, 18, 70, "Input",
 CellID->105796528],
Cell[16619, 641, 303, 11, 36, "Output",
 CellID->877064336]
}, Open  ]],
Cell[16937, 655, 125, 3, 70, "ExampleDelimiter",
 CellID->107628890],
Cell[17065, 660, 225, 8, 70, "ExampleText",
 CellID->14679804],
Cell[CellGroupData[{
Cell[17315, 672, 493, 15, 70, "Input",
 CellID->387781780],
Cell[17811, 689, 584, 13, 88, "Output",
 CellID->210306659]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18444, 708, 226, 7, 70, "ExampleSection",
 CellID->30589],
Cell[18673, 717, 387, 13, 70, "ExampleText",
 CellID->313243743],
Cell[CellGroupData[{
Cell[19085, 734, 457, 15, 70, "Input",
 CellID->318847199],
Cell[19545, 751, 237, 9, 45, "Output",
 CellID->231459605]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19843, 767, 310, 9, 70, "SeeAlsoSection",
 CellID->4784],
Cell[20156, 778, 696, 26, 70, "SeeAlso",
 CellID->16730]
}, Open  ]],
Cell[CellGroupData[{
Cell[20889, 809, 314, 9, 70, "TutorialsSection",
 CellID->28357],
Cell[21206, 820, 144, 3, 70, "Tutorials",
 CellID->13415]
}, Open  ]],
Cell[CellGroupData[{
Cell[21387, 828, 319, 9, 70, "MoreAboutSection",
 CellID->333486152],
Cell[21709, 839, 155, 3, 70, "MoreAbout",
 CellID->31894099],
Cell[21867, 844, 193, 4, 70, "MoreAbout",
 CellID->311074571],
Cell[22063, 850, 152, 3, 70, "MoreAbout",
 CellID->42139502]
}, Open  ]],
Cell[22230, 856, 27, 0, 70, "History"],
Cell[22260, 858, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

