(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14432,        527]
NotebookOptionsPosition[     10932,        409]
NotebookOutlinePosition[     12246,        446]
CellTagsIndexPosition[     12161,        441]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global System Information" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GlobalSystemInformation"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Global System Information\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$BatchInput" :> 
          Documentation`HelpLookup["paclet:ref/$BatchInput"], "$Linked" :> 
          Documentation`HelpLookup["paclet:ref/$Linked"], "$CommandLine" :> 
          Documentation`HelpLookup["paclet:ref/$CommandLine"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$BatchInput\"\>", 
       2->"\<\"$Linked\"\>", 3->"\<\"$CommandLine\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stand-Alone Mathematica Kernels" :> 
          Documentation`HelpLookup[
           "paclet:guide/StandaloneMathematicaKernels"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Stand-Alone Mathematica Kernels\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$BatchOutput", "ObjectName",
 CellID->25721],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$BatchOutput",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$BatchOutput"]], "InlineFormula"],
     "\[LineSeparator]is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if output in the current session is being sent in batch mode, suitable \
for reading by other programs. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3231]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The initial value of ",
 Cell[BoxData[
  ButtonBox["$BatchOutput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BatchOutput"]], "InlineFormula"],
 " is typically determined by a command\[Hyphen]line option when the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session is started. "
}], "Notes",
 CellID->22023],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BatchOutput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BatchOutput"]], "InlineFormula"],
 " cannot be reset during a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Notes",
 CellID->29300],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["$BatchOutput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BatchOutput"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " generates all output in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", with the ",
 Cell[BoxData[
  ButtonBox["PageWidth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageWidth"]], "InlineFormula"],
 " option effectively set to ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ", does not give ",
 Cell[BoxData[
  ButtonBox["In",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/In"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Out",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Out"]], "InlineFormula"],
 " labels, and does not give any banner when it starts up. "
}], "Notes",
 CellID->14517]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->817280014],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->540605286],

Cell[TextData[{
 "In an interactive session, ",
 Cell[BoxData[
  ButtonBox["$BatchOutput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BatchOutput"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->552688525],

Cell[CellGroupData[{

Cell[BoxData["$BatchOutput"], "Input",
 CellLabel->"In[1]:=",
 CellID->240988541],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->925351888]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->280411980],

Cell["Run a standalone kernel:", "ExampleText",
 CellID->4261139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"commandstring", "=", 
  RowBox[{
   RowBox[{"First", "[", "$CommandLine", "]"}], "<>", 
   "\"\< -noprompt -run \
\\\"Put[$BatchOutput,ToFileName[$TemporaryPrefix,ToString[temp1]]];Quit[]\\\"\
\>\""}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220595799],

Cell[BoxData["\<\"MathKernel -noprompt -run \
\\\"Put[$BatchOutput,ToFileName[$TemporaryPrefix,ToString[temp1]]];Quit[]\\\"\
\"\>"], "Output",
 ImageSize->{515, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->875075248]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Run", "[", "commandstring", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63312546],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->648929110]
}, Open  ]],

Cell[TextData[{
 "Show the contents of the file.  This will have the value of ",
 Cell[BoxData[
  ButtonBox["$BatchOutput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BatchOutput"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->287019007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", 
  RowBox[{"ToFileName", "[", 
   RowBox[{"$TemporaryPrefix", ",", 
    RowBox[{"ToString", "[", "temp1", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->860985288],

Cell["True", "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->628183729]
}, Open  ]],

Cell["Delete the file:", "ExampleText",
 CellID->573166151],

Cell[BoxData[
 RowBox[{"DeleteFile", "[", 
  RowBox[{"ToFileName", "[", 
   RowBox[{"$TemporaryPrefix", ",", 
    RowBox[{"ToString", "[", "temp1", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->127493167]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28284],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$BatchInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$BatchInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Linked",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Linked"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CommandLine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CommandLine"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4346]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17161],

Cell[TextData[ButtonBox["Global System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GlobalSystemInformation"]], "Tutorials",
 CellID->15798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->899671804],

Cell[TextData[ButtonBox["Stand-Alone Mathematica Kernels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandaloneMathematicaKernels"]], "MoreAbout",
 CellID->388515261]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$BatchOutput - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 18.1192222}", "context" -> "System`", 
    "keywords" -> {"batch mode", "suppressing prompts"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$BatchOutput is True if output in the current session is being sent in \
batch mode, suitable for reading by other programs. ", 
    "synonyms" -> {"batch output"}, "title" -> "$BatchOutput", "type" -> 
    "Symbol", "uri" -> "ref/$BatchOutput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5602, 192, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->817280014]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12018, 434}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2015, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2638, 77, 50, 1, 70, "ObjectName",
 CellID->25721],
Cell[2691, 80, 634, 19, 70, "Usage",
 CellID->3231]
}, Open  ]],
Cell[CellGroupData[{
Cell[3362, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3840, 121, 343, 11, 70, "Notes",
 CellID->22023],
Cell[4186, 134, 265, 10, 70, "Notes",
 CellID->29300],
Cell[4454, 146, 1111, 41, 70, "Notes",
 CellID->14517]
}, Closed]],
Cell[CellGroupData[{
Cell[5602, 192, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->817280014],
Cell[CellGroupData[{
Cell[5987, 206, 148, 5, 70, "ExampleSection",
 CellID->540605286],
Cell[6138, 213, 340, 13, 70, "ExampleText",
 CellID->552688525],
Cell[CellGroupData[{
Cell[6503, 230, 81, 2, 28, "Input",
 CellID->240988541],
Cell[6587, 234, 162, 5, 36, "Output",
 CellID->925351888]
}, Open  ]],
Cell[6764, 242, 125, 3, 70, "ExampleDelimiter",
 CellID->280411980],
Cell[6892, 247, 65, 1, 70, "ExampleText",
 CellID->4261139],
Cell[CellGroupData[{
Cell[6982, 252, 280, 8, 70, "Input",
 CellID->220595799],
Cell[7265, 262, 273, 7, 54, "Output",
 CellID->875075248]
}, Open  ]],
Cell[CellGroupData[{
Cell[7575, 274, 110, 3, 70, "Input",
 CellID->63312546],
Cell[7688, 279, 158, 5, 36, "Output",
 CellID->648929110]
}, Open  ]],
Cell[7861, 287, 251, 8, 70, "ExampleText",
 CellID->287019007],
Cell[CellGroupData[{
Cell[8137, 299, 222, 6, 70, "Input",
 CellID->860985288],
Cell[8362, 307, 85, 2, 70, "Print",
 CellID->628183729]
}, Open  ]],
Cell[8462, 312, 59, 1, 70, "ExampleText",
 CellID->573166151],
Cell[8524, 315, 223, 6, 70, "Input",
 CellID->127493167]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8796, 327, 311, 9, 70, "SeeAlsoSection",
 CellID->28284],
Cell[9110, 338, 707, 26, 70, "SeeAlso",
 CellID->4346]
}, Open  ]],
Cell[CellGroupData[{
Cell[9854, 369, 314, 9, 70, "TutorialsSection",
 CellID->17161],
Cell[10171, 380, 159, 3, 70, "Tutorials",
 CellID->15798]
}, Open  ]],
Cell[CellGroupData[{
Cell[10367, 388, 319, 9, 70, "MoreAboutSection",
 CellID->899671804],
Cell[10689, 399, 171, 3, 70, "MoreAbout",
 CellID->388515261]
}, Open  ]],
Cell[10875, 405, 27, 0, 70, "History"],
Cell[10905, 407, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

