(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15121,        460]
NotebookOptionsPosition[     12416,        372]
NotebookOutlinePosition[     13690,        409]
CellTagsIndexPosition[     13605,        404]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Raw Character Encodings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RawCharacterEncodings"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Raw Character Encodings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$CharacterEncoding"], 
          "$SystemCharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$SystemCharacterEncoding"], 
          "CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/CharacterEncoding"], 
          "ToCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/ToCharacterCode"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$CharacterEncoding\"\>", 
       2->"\<\"$SystemCharacterEncoding\"\>", 3->"\<\"CharacterEncoding\"\>", 
       4->"\<\"ToCharacterCode\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"International Character Sets" :> 
          Documentation`HelpLookup["paclet:guide/InternationalCharacterSets"],
           "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"International Character Sets\"\>", 
       2->"\<\"System Information\"\>", 
       3->"\<\"New in 6.0: System Interfaces & Deployment\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["$CharacterEncodings", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$CharacterEncodings",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$CharacterEncodings"]], "InlineFormula"],
     " \[LineSeparator]gives the list of character encodings that can be \
used."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$CharacterEncodings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncodings"]], "InlineFormula"],
 " gives the list of possible values for ",
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 ", and possible settings for ",
 Cell[BoxData[
  ButtonBox["CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterEncoding"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  ButtonBox["$CharacterEncodings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncodings"]], "InlineFormula"],
 " may vary from one computer system to another, and from one ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation to another."
}], "Notes",
 CellID->284655684]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->338992532],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->241870373],

Cell[CellGroupData[{

Cell[BoxData["$CharacterEncodings"], "Input",
 CellLabel->"In[1]:=",
 CellID->48216763],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AdobeStandard\"\>", ",", "\<\"ASCII\"\>", ",", "\<\"CP936\"\>",
    ",", "\<\"CP949\"\>", ",", "\<\"CP950\"\>", ",", "\<\"Custom\"\>", 
   ",", "\<\"EUC-JP\"\>", ",", "\<\"EUC\"\>", ",", "\<\"IBM-850\"\>", 
   ",", "\<\"ISO10646-1\"\>", ",", "\<\"ISO8859-15\"\>", 
   ",", "\<\"ISO8859-1\"\>", ",", "\<\"ISO8859-2\"\>", 
   ",", "\<\"ISO8859-3\"\>", ",", "\<\"ISO8859-4\"\>", 
   ",", "\<\"ISO8859-5\"\>", ",", "\<\"ISO8859-6\"\>", 
   ",", "\<\"ISO8859-7\"\>", ",", "\<\"ISO8859-8\"\>", 
   ",", "\<\"ISO8859-9\"\>", ",", "\<\"ISOLatin1\"\>", 
   ",", "\<\"ISOLatin2\"\>", ",", "\<\"ISOLatin3\"\>", 
   ",", "\<\"ISOLatin4\"\>", ",", "\<\"ISOLatinCyrillic\"\>", 
   ",", "\<\"Klingon\"\>", ",", "\<\"koi8-r\"\>", 
   ",", "\<\"MacintoshArabic\"\>", ",", "\<\"MacintoshChineseSimplified\"\>", 
   ",", "\<\"MacintoshChineseTraditional\"\>", 
   ",", "\<\"MacintoshCroatian\"\>", ",", "\<\"MacintoshCyrillic\"\>", 
   ",", "\<\"MacintoshGreek\"\>", ",", "\<\"MacintoshHebrew\"\>", 
   ",", "\<\"MacintoshIcelandic\"\>", ",", "\<\"MacintoshKorean\"\>", 
   ",", "\<\"MacintoshNonCyrillicSlavic\"\>", 
   ",", "\<\"MacintoshRomanian\"\>", ",", "\<\"MacintoshRoman\"\>", 
   ",", "\<\"MacintoshThai\"\>", ",", "\<\"MacintoshTurkish\"\>", 
   ",", "\<\"MacintoshUkrainian\"\>", ",", "\<\"Math1\"\>", 
   ",", "\<\"Math2\"\>", ",", "\<\"Math3\"\>", ",", "\<\"Math4\"\>", 
   ",", "\<\"Math5\"\>", ",", "\<\"Mathematica1\"\>", 
   ",", "\<\"Mathematica2\"\>", ",", "\<\"Mathematica3\"\>", 
   ",", "\<\"Mathematica4\"\>", ",", "\<\"Mathematica5\"\>", 
   ",", "\<\"Mathematica6\"\>", ",", "\<\"Mathematica7\"\>", 
   ",", "\<\"PrintableASCII\"\>", ",", "\<\"ShiftJIS\"\>", 
   ",", "\<\"Symbol\"\>", ",", "\<\"Unicode\"\>", ",", "\<\"UTF8\"\>", 
   ",", "\<\"WindowsANSI\"\>", ",", "\<\"WindowsBaltic\"\>", 
   ",", "\<\"WindowsCyrillic\"\>", ",", "\<\"WindowsEastEurope\"\>", 
   ",", "\<\"WindowsGreek\"\>", ",", "\<\"WindowsThai\"\>", 
   ",", "\<\"WindowsTurkish\"\>", ",", "\<\"ZapfDingbats\"\>"}], 
  "}"}]], "Output",
 ImageSize->{534, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->966515709]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$SystemCharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$SystemCharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Raw Character Encodings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RawCharacterEncodings"]], "Tutorials",
 CellID->18211]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["International Character Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InternationalCharacterSets"]], "MoreAbout",
 CellID->184608723],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->141799501],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->7430794]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$CharacterEncodings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 20.7911656}", "context" -> "System`", 
    "keywords" -> {"character set"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$CharacterEncodings gives the list of character encodings that can be \
used.", "synonyms" -> {"character encodings"}, "title" -> 
    "$CharacterEncodings", "type" -> "Symbol", "uri" -> 
    "ref/$CharacterEncodings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6732, 198, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->338992532]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13462, 397}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2602, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3225, 88, 1584, 37, 70, "ObjectNameGrid"],
Cell[4812, 127, 467, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5316, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5794, 163, 548, 17, 70, "Notes",
 CellID->1067943069],
Cell[6345, 182, 350, 11, 70, "Notes",
 CellID->284655684]
}, Closed]],
Cell[CellGroupData[{
Cell[6732, 198, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->338992532],
Cell[CellGroupData[{
Cell[7117, 212, 148, 5, 70, "ExampleSection",
 CellID->241870373],
Cell[CellGroupData[{
Cell[7290, 221, 87, 2, 28, "Input",
 CellID->48216763],
Cell[7380, 225, 2193, 39, 224, "Output",
 CellID->966515709]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9634, 271, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9953, 282, 1029, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[11019, 322, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[11340, 333, 155, 3, 70, "Tutorials",
 CellID->18211]
}, Open  ]],
Cell[CellGroupData[{
Cell[11532, 341, 299, 8, 70, "MoreAboutSection"],
Cell[11834, 351, 166, 3, 70, "MoreAbout",
 CellID->184608723],
Cell[12003, 356, 147, 3, 70, "MoreAbout",
 CellID->141799501],
Cell[12153, 361, 191, 4, 70, "MoreAbout",
 CellID->7430794]
}, Open  ]],
Cell[12359, 368, 27, 0, 70, "History"],
Cell[12389, 370, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

