(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17616,        555]
NotebookOptionsPosition[     14317,        451]
NotebookOutlinePosition[     15841,        492]
CellTagsIndexPosition[     15756,        487]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ControlActive" :> 
          Documentation`HelpLookup["paclet:ref/ControlActive"], 
          "$DynamicEvaluation" :> 
          Documentation`HelpLookup["paclet:ref/$DynamicEvaluation"], 
          "$PerformanceGoal" :> 
          Documentation`HelpLookup["paclet:ref/$PerformanceGoal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ControlActive\"\>", 
       2->"\<\"$DynamicEvaluation\"\>", 
       3->"\<\"$PerformanceGoal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelInterfaceControl"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Dynamic Interactivity Language\"\>", 
       2->"\<\"Low-Level Interface Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["$ControlActiveSetting", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$ControlActiveSetting",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$ControlActiveSetting"]], "InlineFormula"],
     " \[LineSeparator]is a symbol whose value is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if it is evaluated while a control is active, or in certain other \
previewing situations. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"], "[", 
   RowBox[{
    StyleBox["act", "TI"], ",", 
    StyleBox["norm", "TI"]}], "]"}]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"], "[", 
   RowBox[{"$ControlActiveSetting", ",", 
    StyleBox["act", "TI"], ",", 
    StyleBox["norm", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " can be used to localize the setting for ",
 Cell[BoxData[
  ButtonBox["$ControlActiveSetting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ControlActiveSetting"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->874612364]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->132792297],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->196216071],

Cell[TextData[{
 "Detect when controls in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " are being used:"
}], "ExampleText",
 CellID->1818174610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$ControlActiveSetting", ",", "x", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "Red"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->934607914],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`c$$ = RGBColor[
    0.466147859922179, 0.4285801480125124, 1.], $CellContext`x$$ = 0.53, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`c$$], 
      RGBColor[1, 0, 0]}}, Typeset`size$$ = {310.75, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$46823$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`c$$ = RGBColor[1, 0, 0], $CellContext`x$$ = 
        0}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$46823$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$ControlActiveSetting, $CellContext`x$$, $CellContext`c$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`c$$, 
         RGBColor[1, 0, 0]}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{357., {66., 71.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->1342502526]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291244226],

Cell[TextData[{
 "Most plot functions use ",
 Cell[BoxData[
  ButtonBox["$PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PerformanceGoal"]], "InlineFormula"],
 " to control visualization quality: "
}], "ExampleText",
 CellID->866416289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$ControlActiveSetting", "=", "True"}], "}"}], ",", 
     "$PerformanceGoal"}], "]"}], ",", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$ControlActiveSetting", "=", "False"}], "}"}], ",", 
     "$PerformanceGoal"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->548203510],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Speed\"\>", ",", "\<\"Quality\"\>"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->235163975]
}, Open  ]],

Cell["Hence the default behavior is effectively the following:  ", \
"ExampleText",
 CellID->335231061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "a"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"y", "-", "a"}], ")"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", 
      RowBox[{"If", "[", 
       RowBox[{
       "$ControlActiveSetting", ",", "\"\<Speed\>\"", ",", 
        "\"\<Quality\>\""}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->861789],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 4., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 1, 4}}, Typeset`size$$ = {180., {70., 74.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$2795$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$2795$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot3D[
        Sin[($CellContext`x - $CellContext`a$$) ($CellContext`y - \
$CellContext`a$$)], {$CellContext`x, 0, 3}, {$CellContext`y, 0, 3}, 
        PerformanceGoal -> If[$ControlActiveSetting, "Speed", "Quality"]], 
      "Specifications" :> {{$CellContext`a$$, 1, 4}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {114., 119.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[2]=",
 CellID->277236547]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$DynamicEvaluation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$DynamicEvaluation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PerformanceGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$PerformanceGoal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->6404931],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->42215881]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$ControlActiveSetting - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 24.4318838}", "context" -> "System`", 
    "keywords" -> {
     "detect control interaction", "dynamic performance", 
      "static performance", "level of detail", "level of detail computation", 
      "preview computation", "preview image"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$ControlActiveSetting is a symbol whose value is True if it is evaluated \
while a control is active, or in certain other previewing situations. ", 
    "synonyms" -> {"control active setting"}, "title" -> 
    "$ControlActiveSetting", "type" -> "Symbol", "uri" -> 
    "ref/$ControlActiveSetting"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6021, 186, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->132792297]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15613, 480}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1669, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2292, 67, 1586, 37, 70, "ObjectNameGrid"],
Cell[3881, 106, 669, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4587, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5065, 147, 559, 20, 70, "Notes",
 CellID->1067943069],
Cell[5627, 169, 357, 12, 70, "Notes",
 CellID->874612364]
}, Closed]],
Cell[CellGroupData[{
Cell[6021, 186, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->132792297],
Cell[CellGroupData[{
Cell[6406, 200, 148, 5, 70, "ExampleSection",
 CellID->196216071],
Cell[6557, 207, 227, 8, 70, "ExampleText",
 CellID->1818174610],
Cell[CellGroupData[{
Cell[6809, 219, 328, 10, 28, "Input",
 CellID->934607914],
Cell[7140, 231, 1751, 37, 160, "Output",
 CellID->1342502526]
}, Open  ]],
Cell[8906, 271, 125, 3, 70, "ExampleDelimiter",
 CellID->291244226],
Cell[9034, 276, 257, 8, 70, "ExampleText",
 CellID->866416289],
Cell[CellGroupData[{
Cell[9316, 288, 426, 14, 70, "Input",
 CellID->548203510],
Cell[9745, 304, 142, 4, 70, "Output",
 CellID->235163975]
}, Open  ]],
Cell[9902, 311, 103, 2, 70, "ExampleText",
 CellID->335231061],
Cell[CellGroupData[{
Cell[10030, 317, 739, 23, 70, "Input",
 CellID->861789],
Cell[10772, 342, 1675, 35, 70, "Output",
 CellID->277236547]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12508, 384, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[12827, 395, 746, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[13610, 426, 299, 8, 70, "MoreAboutSection"],
Cell[13912, 436, 168, 3, 70, "MoreAbout",
 CellID->6404931],
Cell[14083, 441, 162, 3, 70, "MoreAbout",
 CellID->42215881]
}, Open  ]],
Cell[14260, 447, 27, 0, 70, "History"],
Cell[14290, 449, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

