(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17029,        601]
NotebookOptionsPosition[     12910,        462]
NotebookOutlinePosition[     14272,        501]
CellTagsIndexPosition[     14187,        496]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DateString" :> 
          Documentation`HelpLookup["paclet:ref/DateString"], "$TimeZone" :> 
          Documentation`HelpLookup["paclet:ref/$TimeZone"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DateString\"\>", 
       2->"\<\"$TimeZone\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Date & Time\"\>", 
       2->"\<\"Locale & Internationalization\"\>", 
       3->"\<\"Mathematica System Setup\"\>", 
       4->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["$DateStringFormat", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$DateStringFormat",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$DateStringFormat"]], "InlineFormula"],
     " \[LineSeparator]gives the default format to use for date strings \
generated by ",
     Cell[BoxData[
      ButtonBox["DateString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$DateStringFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$DateStringFormat"]], "InlineFormula"],
 " can be set to any format specification supported by ",
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "A typical initial default setting is ",
 Cell[BoxData[
  RowBox[{"$DateStringFormat", "=", "\"\<DateTimeShort\>\""}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->831493089]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->140003032],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->26810003],

Cell["Use long date format:", "ExampleText",
 CellID->147849101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$DateStringFormat", "=", "\"\<DateTime\>\""}], "}"}], ",", 
   RowBox[{"DateString", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99004954],

Cell[BoxData["\<\"Wednesday 21 March 2007 14:49:36\"\>"], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->395734601]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3164748],

Cell["Specify your own format:", "ExampleText",
 CellID->283594292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$DateStringFormat", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Hour\>\"", ",", "\"\<:\>\"", ",", "\"\<Minute\>\"", ",", 
       "\"\<:\>\"", ",", "\"\<Second\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"DateString", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140689938],

Cell[BoxData["\<\"14:49:36\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->617326800]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell["Include a time zone:", "ExampleText",
 CellID->194172902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$DateStringFormat", "=", 
     RowBox[{"{", 
      RowBox[{"\"\<Time\>\"", ",", "\"\< \>\"", ",", "\"\<TimeZone\>\""}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"DateString", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451934968],

Cell[BoxData["\<\"14:49:57 GMT-05:00\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87660135]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["$DateStringFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$DateStringFormat"]], "InlineFormula"],
 " to set the default format for date strings within ",
 Cell[BoxData[
  ButtonBox["DatePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DatePlus"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->348825690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$DateStringFormat", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Month\>\"", ",", "\"\</\>\"", ",", "\"\<Day\>\"", ",", "\"\</\>\"",
        ",", "\"\<Year\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"DatePlus", "[", 
    RowBox[{
     RowBox[{"DateString", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\"\<Month\>\""}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17483011],

Cell[BoxData["\<\"07/21/2007\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->427741307]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45859649],

Cell["Date string formats match date patterns:", "ExampleText",
 CellID->269675992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$DateStringFormat", "=", 
     RowBox[{"{", 
      RowBox[{"\"\<Hour\>\"", ",", "\"\<:\>\"", ",", "\"\<Minute\>\""}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"DateString", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47707898],

Cell[BoxData["\<\"14:50\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103700231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"DatePattern", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<Hour\>\"", ",", "\"\<:\>\"", ",", "\"\<Minute\>\""}], "}"}],
     "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->293978651],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->84021386]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$TimeZone",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$TimeZone"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->48796384],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->120426521],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->454563571],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->93694328],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->396796890]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$DateStringFormat - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 25.5256618}", "context" -> "System`", 
    "keywords" -> {
     "date formatting", "date parsing", "dates as strings", "DateTime", 
      "string dates"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$DateStringFormat gives the default format to use for date strings \
generated by DateString.", "synonyms" -> {"date string format"}, "title" -> 
    "$DateStringFormat", "type" -> "Symbol", "uri" -> 
    "ref/$DateStringFormat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5694, 174, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->140003032]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14044, 489}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1745, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2368, 68, 1582, 37, 70, "ObjectNameGrid"],
Cell[3953, 107, 619, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4609, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5087, 148, 372, 12, 70, "Notes",
 CellID->1067943069],
Cell[5462, 162, 195, 7, 70, "Notes",
 CellID->831493089]
}, Closed]],
Cell[CellGroupData[{
Cell[5694, 174, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->140003032],
Cell[CellGroupData[{
Cell[6079, 188, 147, 5, 70, "ExampleSection",
 CellID->26810003],
Cell[6229, 195, 64, 1, 70, "ExampleText",
 CellID->147849101],
Cell[CellGroupData[{
Cell[6318, 200, 236, 7, 28, "Input",
 CellID->99004954],
Cell[6557, 209, 198, 5, 36, "Output",
 CellID->395734601]
}, Open  ]],
Cell[6770, 217, 123, 3, 70, "ExampleDelimiter",
 CellID->3164748],
Cell[6896, 222, 67, 1, 70, "ExampleText",
 CellID->283594292],
Cell[CellGroupData[{
Cell[6988, 227, 373, 11, 70, "Input",
 CellID->140689938],
Cell[7364, 240, 173, 5, 36, "Output",
 CellID->617326800]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7586, 251, 244, 7, 70, "ExampleSection",
 CellID->1020263627],
Cell[7833, 260, 63, 1, 70, "ExampleText",
 CellID->194172902],
Cell[CellGroupData[{
Cell[7921, 265, 326, 10, 70, "Input",
 CellID->451934968],
Cell[8250, 277, 183, 5, 36, "Output",
 CellID->87660135]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8482, 288, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[8723, 297, 380, 13, 70, "ExampleText",
 CellID->348825690],
Cell[CellGroupData[{
Cell[9128, 314, 496, 15, 70, "Input",
 CellID->17483011],
Cell[9627, 331, 175, 5, 36, "Output",
 CellID->427741307]
}, Open  ]],
Cell[9817, 339, 124, 3, 70, "ExampleDelimiter",
 CellID->45859649],
Cell[9944, 344, 83, 1, 70, "ExampleText",
 CellID->269675992],
Cell[CellGroupData[{
Cell[10052, 349, 323, 10, 70, "Input",
 CellID->47707898],
Cell[10378, 361, 170, 5, 36, "Output",
 CellID->103700231]
}, Open  ]],
Cell[CellGroupData[{
Cell[10585, 371, 268, 8, 70, "Input",
 CellID->293978651],
Cell[10856, 381, 160, 5, 36, "Output",
 CellID->84021386]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11077, 393, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[11396, 404, 461, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[11894, 426, 318, 9, 70, "MoreAboutSection",
 CellID->48796384],
Cell[12215, 437, 134, 3, 70, "MoreAbout",
 CellID->120426521],
Cell[12352, 442, 170, 3, 70, "MoreAbout",
 CellID->454563571],
Cell[12525, 447, 157, 3, 70, "MoreAbout",
 CellID->93694328],
Cell[12685, 452, 153, 3, 70, "MoreAbout",
 CellID->396796890]
}, Open  ]],
Cell[12853, 458, 27, 0, 70, "History"],
Cell[12883, 460, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

