(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27180,        688]
NotebookOptionsPosition[     23914,        583]
NotebookOutlinePosition[     25346,        622]
CellTagsIndexPosition[     25261,        617]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating the Front End from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingTheFrontEndFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating the Front End from the Kernel\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$FrontEnd" :> Documentation`HelpLookup["paclet:ref/$FrontEnd"],
           "$SessionID" :> 
          Documentation`HelpLookup["paclet:ref/$SessionID"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$FrontEnd\"\>", 
       2->"\<\"$SessionID\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>", 
       2->"\<\"Mathematica Session Information\"\>", 
       3->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       4->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["$FrontEndSession", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$FrontEndSession",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$FrontEndSession"]], "InlineFormula"],
     "\[LineSeparator]is a global variable that represents the current \
session of the front end from which the kernel is being run."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28761]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$FrontEndSession",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$FrontEndSession"]], "InlineFormula"],
 " is either a ",
 Cell[BoxData["FrontEndObject"], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13141],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " on ",
 Cell[BoxData[
  ButtonBox["$FrontEndSession",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$FrontEndSession"]], "InlineFormula"],
 " to read and set global options for the current session of the front end. "
}], "Notes",
 CellID->17909],

Cell[TextData[{
 "Options set for ",
 Cell[BoxData[
  ButtonBox["$FrontEndSession",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$FrontEndSession"]], "InlineFormula"],
 " do not persist between front end sessions."
}], "Notes",
 CellID->27978]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->147093469],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->9074541],

Cell["Make cell brackets thick for the current session:", "ExampleText",
 CellID->48445387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"$FrontEndSession", ",", 
   RowBox[{"CellBracketOptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Thickness\>\"", "\[Rule]", "3"}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->155619579],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1zVNUdx/Ht9PeO/0L/E6etP6IzHX9qZ6o4FbEdp9P+zPQHp2orsVN8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   "], {{0, 0}, {458, 217}}, {0, 255}],
  ImageSize->{458 0.75, 217 0.75},
  PlotRange->{{0, 458}, {0, 217}}]], "NotebookImage",
 CellID->332215115]
}, Open  ]],

Cell["Reset the brackets to their initial thickness:", "ExampleText",
 CellID->71656399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"$FrontEndSession", ",", 
   RowBox[{"CellBracketOptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Thickness\>\"", "\[Rule]", "Inherited"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->211993845],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1vHMd9x/Er+nuQf6H/idE0PyoBhPxUAY1l1DLTIhBa6CdbaICgclKL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   "], {{0, 0}, {458, 217}}, {0, 255}],
  ImageSize->{458 0.75, 217 0.75},
  PlotRange->{{0, 458}, {0, 217}}]], "NotebookImage",
 CellID->62650269]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14004],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$FrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$FrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$SessionID",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$SessionID"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30231]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17372],

Cell[TextData[ButtonBox["Manipulating the Front End from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingTheFrontEndFromTheKernel"]], "Tutorials",
 CellID->13069]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->315190562],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->7333078],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->32705614],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->63986340],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->102016524]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$FrontEndSession - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 40.0572838}", "context" -> "System`", 
    "keywords" -> {
     "non-persistent FrontEnd options", "non-persistent FrontEnd settings", 
      "session-based options", "session-based settings"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$FrontEndSession is a global variable that represents the current \
session of the front end from which the kernel is being run.", 
    "synonyms" -> {"front end session"}, "title" -> "$FrontEndSession", 
    "type" -> "Symbol", "uri" -> "ref/$FrontEndSession"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6984, 212, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->147093469]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25118, 610}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2554, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3177, 88, 1581, 37, 70, "ObjectNameGrid"],
Cell[4761, 127, 510, 14, 70, "Usage",
 CellID->28761]
}, Open  ]],
Cell[CellGroupData[{
Cell[5308, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5786, 163, 375, 14, 70, "Notes",
 CellID->13141],
Cell[6164, 179, 533, 18, 70, "Notes",
 CellID->17909],
Cell[6700, 199, 247, 8, 70, "Notes",
 CellID->27978]
}, Closed]],
Cell[CellGroupData[{
Cell[6984, 212, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->147093469],
Cell[CellGroupData[{
Cell[7369, 226, 146, 5, 70, "ExampleSection",
 CellID->9074541],
Cell[7518, 233, 91, 1, 70, "ExampleText",
 CellID->48445387],
Cell[CellGroupData[{
Cell[7634, 238, 266, 8, 70, "Input",
 CellID->155619579],
Cell[7903, 248, 6382, 107, 70, "NotebookImage",
 CellID->332215115]
}, Open  ]],
Cell[14300, 358, 88, 1, 70, "ExampleText",
 CellID->71656399],
Cell[CellGroupData[{
Cell[14413, 363, 275, 8, 70, "Input",
 CellID->211993845],
Cell[14691, 373, 6706, 112, 70, "NotebookImage",
 CellID->62650269]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21458, 492, 311, 9, 70, "SeeAlsoSection",
 CellID->14004],
Cell[21772, 503, 457, 17, 70, "SeeAlso",
 CellID->30231]
}, Open  ]],
Cell[CellGroupData[{
Cell[22266, 525, 314, 9, 70, "TutorialsSection",
 CellID->17372],
Cell[22583, 536, 192, 4, 70, "Tutorials",
 CellID->13069]
}, Open  ]],
Cell[CellGroupData[{
Cell[22812, 545, 319, 9, 70, "MoreAboutSection",
 CellID->315190562],
Cell[23134, 556, 167, 3, 70, "MoreAbout",
 CellID->7333078],
Cell[23304, 561, 171, 3, 70, "MoreAbout",
 CellID->32705614],
Cell[23478, 566, 208, 5, 70, "MoreAbout",
 CellID->63986340],
Cell[23689, 573, 153, 3, 70, "MoreAbout",
 CellID->102016524]
}, Open  ]],
Cell[23857, 579, 27, 0, 70, "History"],
Cell[23887, 581, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

