(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15348,        562]
NotebookOptionsPosition[     11338,        424]
NotebookOutlinePosition[     12625,        461]
CellTagsIndexPosition[     12540,        456]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"], 
          "Memory Management" :> 
          Documentation`HelpLookup["paclet:tutorial/MemoryManagement"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"The Main Loop\"\>", 
       2->"\<\"Memory Management\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$Line" :> Documentation`HelpLookup["paclet:ref/$Line"], "In" :> 
          Documentation`HelpLookup["paclet:ref/In"], "Out" :> 
          Documentation`HelpLookup["paclet:ref/Out"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$Line\"\>", 2->"\<\"In\"\>", 
       3->"\<\"Out\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Session History" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessionHistory"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 2]& 
        , Evaluator -> Automatic], {1->"\<\"Mathematica Session History\"\>", 
       2->"\<\"Mathematica System Setup\"\>", 
       3->"\<\"Memory Measurement & Optimization\"\>", 
       4->"\<\"Session Customization\"\>", 
       5->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$HistoryLength", "ObjectName",
 CellID->25141],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$HistoryLength",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$HistoryLength"]], "InlineFormula"],
     "\[LineSeparator]specifies the number of previous lines of input and \
output to keep in a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24252]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["$HistoryLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$HistoryLength"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29186],

Cell[TextData[{
 "Values of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " corresponding to lines before those kept are explicitly cleared. "
}], "Notes",
 CellID->2771],

Cell[TextData[{
 "Using smaller values of ",
 Cell[BoxData[
  ButtonBox["$HistoryLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$HistoryLength"]], "InlineFormula"],
 " can save substantial amounts of memory in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Notes",
 CellID->16614]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5918998],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->236351419],

Cell["The default is to save the entire history:", "ExampleText",
 CellID->156142625],

Cell[CellGroupData[{

Cell[BoxData["$HistoryLength"], "Input",
 CellLabel->"In[1]:=",
 CellID->131509127],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->461901823]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->614609066],

Cell["Change the setting to save no history: ", "ExampleText",
 CellID->698516973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$HistoryLength", "=", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11487794],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95823728]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "+", "y"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9767343],

Cell[BoxData[
 RowBox[{"x", "+", "y"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7084785]
}, Open  ]],

Cell["\<\
This means the previous input can no longer be used directly:\
\>", "ExampleText",
 CellID->72925754],

Cell[CellGroupData[{

Cell[BoxData["%"], "Input",
 CellLabel->"In[3]:=",
 CellID->203550305],

Cell[BoxData["%2"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->367409411]
}, Open  ]],

Cell["\<\
By assigning to a variable you can still refer to previous results:\
\>", "ExampleText",
 CellID->77130529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res", "=", 
  RowBox[{"x", "+", "y"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->356034552],

Cell[BoxData[
 RowBox[{"x", "+", "y"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->64768263]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["res"], "Input",
 CellLabel->"In[5]:=",
 CellID->335196947],

Cell[BoxData[
 RowBox[{"x", "+", "y"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->233203303]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30562],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Line",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Line"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10185]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29641],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->6070],

Cell[TextData[ButtonBox["Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MemoryManagement"]], "Tutorials",
 CellID->20907]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->161475665],

Cell[TextData[ButtonBox["Mathematica Session History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionHistory"]], "MoreAbout",
 CellID->472009518],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->105903194],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->7466536],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->497113500],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->97267641]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$HistoryLength - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 40.6041728}", "context" -> "System`", 
    "keywords" -> {"command history"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$HistoryLength specifies the number of previous lines of input and \
output to keep in a Mathematica session. ", "synonyms" -> {"history length"}, 
    "title" -> "$HistoryLength", "type" -> "Symbol", "uri" -> 
    "ref/$HistoryLength"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5569, 180, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5918998]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12399, 449}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2677, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3300, 88, 52, 1, 70, "ObjectName",
 CellID->25141],
Cell[3355, 91, 545, 17, 70, "Usage",
 CellID->24252]
}, Open  ]],
Cell[CellGroupData[{
Cell[3937, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4415, 130, 338, 13, 70, "Notes",
 CellID->29186],
Cell[4756, 145, 456, 17, 70, "Notes",
 CellID->2771],
Cell[5215, 164, 317, 11, 70, "Notes",
 CellID->16614]
}, Closed]],
Cell[CellGroupData[{
Cell[5569, 180, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5918998],
Cell[CellGroupData[{
Cell[5952, 194, 148, 5, 70, "ExampleSection",
 CellID->236351419],
Cell[6103, 201, 85, 1, 70, "ExampleText",
 CellID->156142625],
Cell[CellGroupData[{
Cell[6213, 206, 83, 2, 28, "Input",
 CellID->131509127],
Cell[6299, 210, 168, 5, 36, "Output",
 CellID->461901823]
}, Open  ]],
Cell[6482, 218, 125, 3, 70, "ExampleDelimiter",
 CellID->614609066],
Cell[6610, 223, 82, 1, 70, "ExampleText",
 CellID->698516973],
Cell[CellGroupData[{
Cell[6717, 228, 104, 3, 70, "Input",
 CellID->11487794],
Cell[6824, 233, 157, 5, 36, "Output",
 CellID->95823728]
}, Open  ]],
Cell[CellGroupData[{
Cell[7018, 243, 90, 3, 70, "Input",
 CellID->9767343],
Cell[7111, 248, 178, 6, 36, "Output",
 CellID->7084785]
}, Open  ]],
Cell[7304, 257, 111, 3, 70, "ExampleText",
 CellID->72925754],
Cell[CellGroupData[{
Cell[7440, 264, 70, 2, 70, "Input",
 CellID->203550305],
Cell[7513, 268, 159, 5, 36, "Output",
 CellID->367409411]
}, Open  ]],
Cell[7687, 276, 117, 3, 70, "ExampleText",
 CellID->77130529],
Cell[CellGroupData[{
Cell[7829, 283, 117, 4, 70, "Input",
 CellID->356034552],
Cell[7949, 289, 179, 6, 36, "Output",
 CellID->64768263]
}, Open  ]],
Cell[CellGroupData[{
Cell[8165, 300, 72, 2, 70, "Input",
 CellID->335196947],
Cell[8240, 304, 180, 6, 36, "Output",
 CellID->233203303]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8481, 317, 311, 9, 70, "SeeAlsoSection",
 CellID->30562],
Cell[8795, 328, 668, 26, 70, "SeeAlso",
 CellID->10185]
}, Open  ]],
Cell[CellGroupData[{
Cell[9500, 359, 314, 9, 70, "TutorialsSection",
 CellID->29641],
Cell[9817, 370, 134, 3, 70, "Tutorials",
 CellID->6070],
Cell[9954, 375, 144, 3, 70, "Tutorials",
 CellID->20907]
}, Open  ]],
Cell[CellGroupData[{
Cell[10135, 383, 319, 9, 70, "MoreAboutSection",
 CellID->161475665],
Cell[10457, 394, 164, 3, 70, "MoreAbout",
 CellID->472009518],
Cell[10624, 399, 158, 3, 70, "MoreAbout",
 CellID->105903194],
Cell[10785, 404, 175, 3, 70, "MoreAbout",
 CellID->7466536],
Cell[10963, 409, 153, 3, 70, "MoreAbout",
 CellID->497113500],
Cell[11119, 414, 147, 3, 70, "MoreAbout",
 CellID->97267641]
}, Open  ]],
Cell[11281, 420, 27, 0, 70, "History"],
Cell[11311, 422, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

