(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24073,        868]
NotebookOptionsPosition[     18345,        671]
NotebookOutlinePosition[     19686,        709]
CellTagsIndexPosition[     19601,        704]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/Evaluation"], 
          "Controlling Infinite Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ControllingInfiniteEvaluation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Evaluation\"\>", 
       2->"\<\"Controlling Infinite Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$RecursionLimit" :> 
          Documentation`HelpLookup["paclet:ref/$RecursionLimit"], 
          "TimeConstrained" :> 
          Documentation`HelpLookup["paclet:ref/TimeConstrained"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$RecursionLimit\"\>", 
       2->"\<\"TimeConstrained\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Evaluation Control\"\>", 
       2->"\<\"Global Computation Settings & Parameters\"\>", 
       3->"\<\"Memory Measurement & Optimization\"\>", 
       4->"\<\"Time Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$IterationLimit", "ObjectName",
 CellID->17527],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$IterationLimit",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
     "\[LineSeparator]gives the maximum length of evaluation chain used in \
trying to evaluate any expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1585]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 " limits the number of times ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to re\[Hyphen]evaluate a particular expression. "
}], "Notes",
 CellID->25647],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 " gives an upper limit on the length of any list that can be generated by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->229]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->102184137],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->223980779],

Cell[TextData[{
 "The default ",
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->488816306],

Cell[CellGroupData[{

Cell[BoxData["$IterationLimit"], "Input",
 CellLabel->"In[1]:=",
 CellID->1165971],

Cell[BoxData["4096"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41159361]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58874636],

Cell["Define a function in an iterative fashion:", "ExampleText",
 CellID->548927839],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "0", "]"}], "=", "1"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58633625],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "p_", "]"}], ":=", 
  RowBox[{"f", "[", 
   RowBox[{"p", "-", "1"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->438270287],

Cell[TextData[{
 "Evaluate by temporarily setting ",
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 " to a different value:"
}], "ExampleText",
 CellID->27181909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$IterationLimit", "=", "20"}], "}"}], ",", 
   RowBox[{"f", "[", "20", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->36031344],

Cell[BoxData[
 RowBox[{
  RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], ":", 
  " ", "\<\"Iteration limit of \\!\\(20\\) exceeded. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$IterationLimit/itlim\\\", ButtonNote -> \
\\\"$IterationLimit::itlim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->100930934],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"f", "[", 
   RowBox[{"1", "-", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->186666419]
}, Open  ]],

Cell[TextData[{
 "With a higher ",
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 " we can compute the function:"
}], "ExampleText",
 CellID->115503808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$IterationLimit", "=", "22"}], "}"}], ",", 
   RowBox[{"f", "[", "20", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->398677089],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->24229934]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21984],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 " to keep going with the iteration:"
}], "ExampleText",
 CellID->145188547],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "n_", "]"}], ":=", 
  RowBox[{"f", "[", 
   RowBox[{"n", "-", "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68830097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->723119765],

Cell[BoxData[
 RowBox[{
  RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], ":", 
  " ", "\<\"Iteration limit of \\!\\(4096\\) exceeded. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/$IterationLimit/itlim\\\
\", ButtonNote -> \\\"$IterationLimit::itlim\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->238273112],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"-", "4095"}], "-", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133001714]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->9238369],

Cell[BoxData[
 RowBox[{
  RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], ":", 
  " ", "\<\"Iteration limit of \\!\\(4096\\) exceeded. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/$IterationLimit/itlim\\\
\", ButtonNote -> \\\"$IterationLimit::itlim\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->418323294],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"-", "8190"}], "-", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->48263495]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11505],

Cell[TextData[{
 "The iteration limit can be set to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 " to allow any number of evaluation steps:"
}], "ExampleText",
 CellID->910078503],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "0", "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "n_", "]"}], ":=", 
  RowBox[{"f", "[", 
   RowBox[{"n", "-", "1"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->813324193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$IterationLimit", "=", "Infinity"}], "}"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"10", "^", "6"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->291549090],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144600747]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32497],

Cell["The iteration limit protects against runaway definitions:", \
"ExampleText",
 CellID->450264515],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"f", "[", 
   RowBox[{"x", "+", "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1609391322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "1", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->268254547],

Cell[BoxData[
 RowBox[{
  RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], ":", 
  " ", "\<\"Iteration limit of \\!\\(4096\\) exceeded. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/$IterationLimit/itlim\\\
\", ButtonNote -> \\\"$IterationLimit::itlim\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->226485362],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"f", "[", 
   RowBox[{"4096", "+", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->648703330]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17890820],

Cell["\<\
The recursion limit protects against recursive runaway definitions:\
\>", "ExampleText",
 CellID->738962059],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Floor", "[", 
     RowBox[{"x", "/", "2"}], "]"}], "]"}], "+", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2125860283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "10", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1993220647],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->215023532],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->88172578],

Cell[BoxData[
 RowBox[{"255", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"Hold", "[", 
    RowBox[{"f", "[", 
     RowBox[{"Floor", "[", 
      FractionBox["0", "2"], "]"}], "]"}], "]"}], "]"}]}]], "Output",
 ImageSize->{203, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->181999020]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14668],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$RecursionLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$RecursionLimit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18429]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26144],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "Tutorials",
 CellID->959752411],

Cell[TextData[ButtonBox["Controlling Infinite Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ControllingInfiniteEvaluation"]], "Tutorials",
 CellID->9738]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->8226832],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->761678757],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->513535966],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->150694068],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->7744652]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
$IterationLimit"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$IterationLimit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 48.6981300}", "context" -> "System`", 
    "keywords" -> {
     "evaluation chain", "stopping iteration", "infinite evaluation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$IterationLimit gives the maximum length of evaluation chain used in \
trying to evaluate any expression. ", "synonyms" -> {"iteration limit"}, 
    "title" -> "$IterationLimit", "type" -> "Symbol", "uri" -> 
    "ref/$IterationLimit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5069, 157, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->102184137]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19458, 697}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2659, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3282, 89, 53, 1, 70, "ObjectName",
 CellID->17527],
Cell[3338, 92, 486, 14, 70, "Usage",
 CellID->1585]
}, Open  ]],
Cell[CellGroupData[{
Cell[3861, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4339, 128, 318, 10, 70, "Notes",
 CellID->25647],
Cell[4660, 140, 372, 12, 70, "Notes",
 CellID->229]
}, Closed]],
Cell[CellGroupData[{
Cell[5069, 157, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->102184137],
Cell[CellGroupData[{
Cell[5454, 171, 148, 5, 70, "ExampleSection",
 CellID->223980779],
Cell[5605, 178, 209, 8, 70, "ExampleText",
 CellID->488816306],
Cell[CellGroupData[{
Cell[5839, 190, 82, 2, 28, "Input",
 CellID->1165971],
Cell[5924, 194, 160, 5, 36, "Output",
 CellID->41159361]
}, Open  ]],
Cell[6099, 202, 124, 3, 70, "ExampleDelimiter",
 CellID->58874636],
Cell[6226, 207, 85, 1, 70, "ExampleText",
 CellID->548927839],
Cell[6314, 210, 138, 5, 70, "Input",
 CellID->58633625],
Cell[6455, 217, 174, 6, 70, "Input",
 CellID->438270287],
Cell[6632, 225, 249, 8, 70, "ExampleText",
 CellID->27181909],
Cell[CellGroupData[{
Cell[6906, 237, 217, 7, 70, "Input",
 CellID->36031344],
Cell[7126, 246, 391, 7, 70, "Message",
 CellID->100930934],
Cell[7520, 255, 240, 8, 36, "Output",
 CellID->186666419]
}, Open  ]],
Cell[7775, 266, 239, 8, 70, "ExampleText",
 CellID->115503808],
Cell[CellGroupData[{
Cell[8039, 278, 218, 7, 70, "Input",
 CellID->398677089],
Cell[8260, 287, 157, 5, 36, "Output",
 CellID->24229934]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8466, 298, 216, 7, 70, "ExampleSection",
 CellID->21984],
Cell[8685, 307, 226, 8, 70, "ExampleText",
 CellID->145188547],
Cell[8914, 317, 173, 6, 70, "Input",
 CellID->68830097],
Cell[CellGroupData[{
Cell[9112, 327, 97, 3, 70, "Input",
 CellID->723119765],
Cell[9212, 332, 395, 8, 70, "Message",
 CellID->238273112],
Cell[9610, 342, 264, 9, 36, "Output",
 CellID->133001714]
}, Open  ]],
Cell[CellGroupData[{
Cell[9911, 356, 105, 3, 70, "Input",
 CellID->9238369],
Cell[10019, 361, 395, 8, 70, "Message",
 CellID->418323294],
Cell[10417, 371, 263, 9, 36, "Output",
 CellID->48263495]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10729, 386, 239, 7, 70, "ExampleSection",
 CellID->11505],
Cell[10971, 395, 212, 6, 70, "ExampleText",
 CellID->910078503],
Cell[11186, 403, 256, 9, 70, "Input",
 CellID->813324193],
Cell[CellGroupData[{
Cell[11467, 416, 249, 8, 70, "Input",
 CellID->291549090],
Cell[11719, 426, 158, 5, 36, "Output",
 CellID->144600747]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11926, 437, 233, 7, 70, "ExampleSection",
 CellID->32497],
Cell[12162, 446, 102, 2, 70, "ExampleText",
 CellID->450264515],
Cell[12267, 450, 175, 6, 70, "Input",
 CellID->1609391322],
Cell[CellGroupData[{
Cell[12467, 460, 97, 3, 70, "Input",
 CellID->268254547],
Cell[12567, 465, 395, 8, 70, "Message",
 CellID->226485362],
Cell[12965, 475, 244, 8, 36, "Output",
 CellID->648703330]
}, Open  ]],
Cell[13224, 486, 124, 3, 70, "ExampleDelimiter",
 CellID->17890820],
Cell[13351, 491, 118, 3, 70, "ExampleText",
 CellID->738962059],
Cell[13472, 496, 235, 8, 70, "Input",
 CellID->2125860283],
Cell[CellGroupData[{
Cell[13732, 508, 99, 3, 70, "Input",
 CellID->1993220647],
Cell[13834, 513, 395, 7, 70, "Message",
 CellID->215023532],
Cell[14232, 522, 394, 7, 70, "Message",
 CellID->88172578],
Cell[14629, 531, 336, 11, 51, "Output",
 CellID->181999020]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15026, 549, 311, 9, 70, "SeeAlsoSection",
 CellID->14668],
Cell[15340, 560, 479, 17, 70, "SeeAlso",
 CellID->18429]
}, Open  ]],
Cell[CellGroupData[{
Cell[15856, 582, 314, 9, 70, "TutorialsSection",
 CellID->26144],
Cell[16173, 593, 135, 3, 70, "Tutorials",
 CellID->959752411],
Cell[16311, 598, 170, 3, 70, "Tutorials",
 CellID->9738]
}, Open  ]],
Cell[CellGroupData[{
Cell[16518, 606, 317, 9, 70, "MoreAboutSection",
 CellID->8226832],
Cell[16838, 617, 147, 3, 70, "MoreAbout",
 CellID->761678757],
Cell[16988, 622, 193, 4, 70, "MoreAbout",
 CellID->513535966],
Cell[17184, 628, 177, 3, 70, "MoreAbout",
 CellID->150694068],
Cell[17364, 633, 171, 3, 70, "MoreAbout",
 CellID->7744652]
}, Open  ]],
Cell[CellGroupData[{
Cell[17572, 641, 305, 8, 70, "RelatedLinksSection"],
Cell[17880, 651, 393, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[18288, 667, 27, 0, 70, "History"],
Cell[18318, 669, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

