(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10957,        362]
NotebookOptionsPosition[      8766,        291]
NotebookOutlinePosition[      9811,        320]
CellTagsIndexPosition[      9768,        317]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"International Messages" :> 
          Documentation`HelpLookup["paclet:tutorial/InternationalMessages"], 
          "The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"International Messages\"\>", 
       2->"\<\"The Main Loop\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$CharacterEncoding"], 
          "$DateStringFormat" :> 
          Documentation`HelpLookup["paclet:ref/$DateStringFormat"], 
          "MessageName" :> Documentation`HelpLookup["paclet:ref/MessageName"],
           "LanguageCategory" :> 
          Documentation`HelpLookup["paclet:ref/LanguageCategory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$CharacterEncoding\"\>", 
       2->"\<\"$DateStringFormat\"\>", 3->"\<\"MessageName\"\>", 
       4->"\<\"LanguageCategory\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "Messages" :> Documentation`HelpLookup["paclet:guide/Messages"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Locale & Internationalization\"\>", 
       2->"\<\"Mathematica System Setup\"\>", 3->"\<\"Messages\"\>", 
       4->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$Language", "ObjectName",
 CellID->13789],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$Language",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Language"]], "InlineFormula"],
     "\[LineSeparator]is a list of strings which give the names of languages \
to use for messages. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23439]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "All language names are conventionally given in English, and are \
capitalized, as in ",
 Cell[BoxData["\"\<French\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4028],

Cell[TextData[{
 "When a message with a name ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 " is requested either internally or through the ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 " function, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " searches for messages with names ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["tag", "TI"], "::", 
   SubscriptBox[
    StyleBox["lang", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 " corresponding to the entries ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"lang\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " in the list ",
 Cell[BoxData[
  ButtonBox["$Language",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Language"]], "InlineFormula"],
 ". Only if it fails to find any of these messages will it use the message \
with the actual name ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16989]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2851],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$DateStringFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$DateStringFormat"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LanguageCategory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LanguageCategory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18970]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16436],

Cell[TextData[ButtonBox["International Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/InternationalMessages"]], "Tutorials",
 CellID->15341],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->1460]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->254521369],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->496224985],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->48618700],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Messages"]], "MoreAbout",
 CellID->260165564],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->389029611]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$Language - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 49.0575142}", "context" -> "System`", 
    "keywords" -> {"language for messages"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$Language is a list of strings which give the names of languages to use \
for messages. ", "synonyms" -> {}, "title" -> "$Language", "type" -> "Symbol",
     "uri" -> "ref/$Language"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2737, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3360, 89, 47, 1, 70, "ObjectName",
 CellID->13789],
Cell[3410, 92, 463, 14, 70, "Usage",
 CellID->23439]
}, Open  ]],
Cell[CellGroupData[{
Cell[3910, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4388, 128, 190, 6, 70, "Notes",
 CellID->4028],
Cell[4581, 136, 1141, 39, 70, "Notes",
 CellID->16989]
}, Closed]],
Cell[CellGroupData[{
Cell[5759, 180, 310, 9, 70, "SeeAlsoSection",
 CellID->2851],
Cell[6072, 191, 1001, 35, 70, "SeeAlso",
 CellID->18970]
}, Open  ]],
Cell[CellGroupData[{
Cell[7110, 231, 314, 9, 70, "TutorialsSection",
 CellID->16436],
Cell[7427, 242, 154, 3, 70, "Tutorials",
 CellID->15341],
Cell[7584, 247, 134, 3, 70, "Tutorials",
 CellID->1460]
}, Open  ]],
Cell[CellGroupData[{
Cell[7755, 255, 319, 9, 70, "MoreAboutSection",
 CellID->254521369],
Cell[8077, 266, 170, 3, 70, "MoreAbout",
 CellID->496224985],
Cell[8250, 271, 157, 3, 70, "MoreAbout",
 CellID->48618700],
Cell[8410, 276, 128, 3, 70, "MoreAbout",
 CellID->260165564],
Cell[8541, 281, 153, 3, 70, "MoreAbout",
 CellID->389029611]
}, Open  ]],
Cell[8709, 287, 27, 0, 70, "History"],
Cell[8739, 289, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

