(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8570,        287]
NotebookOptionsPosition[      6544,        223]
NotebookOutlinePosition[      7677,        254]
CellTagsIndexPosition[      7634,        251]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"], 
          "System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"System Administration for Single-User Licenses\"\>", 
       2->"\<\"System Administration for Network Licenses\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$LicenseID" :> 
          Documentation`HelpLookup["paclet:ref/$LicenseID"], "$CreationDate" :> 
          Documentation`HelpLookup["paclet:ref/$CreationDate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$LicenseID\"\>", 
       2->"\<\"$CreationDate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"System & License Management" :> 
          Documentation`HelpLookup[
           "paclet:guide/SystemAndLicenseManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"System & License Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$LicenseExpirationDate", "ObjectName",
 CellID->1951],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$LicenseExpirationDate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$LicenseExpirationDate"]], "InlineFormula"],
     " \[LineSeparator]is a date list which gives the expiration date for the \
license under which ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " is being run."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27080]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The first element of ",
 Cell[BoxData[
  ButtonBox["$LicenseExpirationDate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$LicenseExpirationDate"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " if there is no explicit expiration date."
}], "Notes",
 CellID->31216]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17404],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$LicenseID",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$LicenseID"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CreationDate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CreationDate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2738]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26372],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"Tutorials",
 CellID->34241995],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"Tutorials",
 CellID->157642292]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["System & License Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemAndLicenseManagement"]], "MoreAbout",
 CellID->384739152]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$LicenseExpirationDate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 55.2607980}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$LicenseExpirationDate is a date list which gives the expiration date \
for the license under which Mathematica is being run.", 
    "synonyms" -> {"license expiration date"}, "title" -> 
    "$LicenseExpirationDate", "type" -> "Symbol", "uri" -> 
    "ref/$LicenseExpirationDate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2215, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2838, 82, 59, 1, 70, "ObjectName",
 CellID->1951],
Cell[2900, 85, 569, 17, 70, "Usage",
 CellID->27080]
}, Open  ]],
Cell[CellGroupData[{
Cell[3506, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3984, 124, 390, 13, 70, "Notes",
 CellID->31216]
}, Closed]],
Cell[CellGroupData[{
Cell[4411, 142, 311, 9, 70, "SeeAlsoSection",
 CellID->17404],
Cell[4725, 153, 464, 17, 70, "SeeAlso",
 CellID->2738]
}, Open  ]],
Cell[CellGroupData[{
Cell[5226, 175, 314, 9, 70, "TutorialsSection",
 CellID->26372],
Cell[5543, 186, 214, 5, 70, "Tutorials",
 CellID->34241995],
Cell[5760, 193, 208, 5, 70, "Tutorials",
 CellID->157642292]
}, Open  ]],
Cell[CellGroupData[{
Cell[6005, 203, 299, 8, 70, "MoreAboutSection"],
Cell[6307, 213, 165, 3, 70, "MoreAbout",
 CellID->384739152]
}, Open  ]],
Cell[6487, 219, 27, 0, 70, "History"],
Cell[6517, 221, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

