(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9318,        308]
NotebookOptionsPosition[      7248,        242]
NotebookOutlinePosition[      8343,        272]
CellTagsIndexPosition[      8300,        269]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"], 
          "System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"System Administration for Single-User Licenses\"\>", 
       2->"\<\"System Administration for Network Licenses\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$LicenseID" :> 
          Documentation`HelpLookup["paclet:ref/$LicenseID"], "$MachineName" :> 
          Documentation`HelpLookup["paclet:ref/$MachineName"], 
          "SystemInformation" :> 
          Documentation`HelpLookup["paclet:ref/SystemInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$LicenseID\"\>", 
       2->"\<\"$MachineName\"\>", 
       3->"\<\"SystemInformation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "System & License Management" :> 
          Documentation`HelpLookup[
           "paclet:guide/SystemAndLicenseManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Mathematica System Setup\"\>", 
       2->"\<\"System & License Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$LicenseServer", "ObjectName",
 CellID->5932],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$LicenseServer",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$LicenseServer"]], "InlineFormula"],
     " \[LineSeparator]is a string which gives the name of the license server \
which is currently authorizing ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " to be run."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11309]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If multiple servers are running, ",
 Cell[BoxData[
  ButtonBox["$LicenseServer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$LicenseServer"]], "InlineFormula"],
 " always returns the name of the one that originally authorized the \
particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " currently being run."
}], "Notes",
 CellID->706043]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32678],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$LicenseID",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$LicenseID"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemInformation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23927]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31955],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"Tutorials",
 CellID->34241995],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"Tutorials",
 CellID->157642292]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->711946069],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->434084740],

Cell[TextData[ButtonBox["System & License Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemAndLicenseManagement"]], "MoreAbout",
 CellID->8179843]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$LicenseServer - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 55.7451854}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$LicenseServer is a string which gives the name of the license server \
which is currently authorizing Mathematica to be run.", 
    "synonyms" -> {"license server"}, "title" -> "$LicenseServer", "type" -> 
    "Symbol", "uri" -> "ref/$LicenseServer"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2511, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3134, 87, 51, 1, 70, "ObjectName",
 CellID->5932],
Cell[3188, 90, 561, 17, 70, "Usage",
 CellID->11309]
}, Open  ]],
Cell[CellGroupData[{
Cell[3786, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4264, 129, 373, 12, 70, "Notes",
 CellID->706043]
}, Closed]],
Cell[CellGroupData[{
Cell[4674, 146, 311, 9, 70, "SeeAlsoSection",
 CellID->32678],
Cell[4988, 157, 726, 26, 70, "SeeAlso",
 CellID->23927]
}, Open  ]],
Cell[CellGroupData[{
Cell[5751, 188, 314, 9, 70, "TutorialsSection",
 CellID->31955],
Cell[6068, 199, 214, 5, 70, "Tutorials",
 CellID->34241995],
Cell[6285, 206, 208, 5, 70, "Tutorials",
 CellID->157642292]
}, Open  ]],
Cell[CellGroupData[{
Cell[6530, 216, 319, 9, 70, "MoreAboutSection",
 CellID->711946069],
Cell[6852, 227, 158, 3, 70, "MoreAbout",
 CellID->434084740],
Cell[7013, 232, 163, 3, 70, "MoreAbout",
 CellID->8179843]
}, Open  ]],
Cell[7191, 238, 27, 0, 70, "History"],
Cell[7221, 240, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

