(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36462,       1302]
NotebookOptionsPosition[     28695,       1027]
NotebookOutlinePosition[     30125,       1066]
CellTagsIndexPosition[     30039,       1061]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Machine\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MachinePrecisionNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Machine\[Hyphen]Precision Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MachinePrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MachinePrecision"], 
          "$MinMachineNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MinMachineNumber"], 
          "$MaxMachineNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MaxMachineNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$MachinePrecision\"\>", 
       2->"\<\"$MinMachineNumber\"\>", 
       3->"\<\"$MaxMachineNumber\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/RepresentationOfNumbers"], 
          "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Precision & Accuracy Control\"\>", 
       2->"\<\"Representation of Numbers\"\>", 
       3->"\<\"System Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MachineEpsilon", "ObjectName",
 CellID->17473],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MachineEpsilon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
     "\[LineSeparator]gives the smallest machine\[Hyphen]precision number \
which can be added to ",
     Cell[BoxData["1.0"], "InlineFormula"],
     " to give a result that is distinguishable from ",
     Cell[BoxData["1.0"], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20414]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MachineEpsilon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
 " is typically ",
 Cell[BoxData[
  SuperscriptBox["2", 
   RowBox[{"-", 
    StyleBox["n", "TI"], "+", "1"}]]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is the number of binary bits used in the internal representation of \
machine\[Hyphen]precision floating\[Hyphen]point numbers. "
}], "Notes",
 CellID->18374],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MachineEpsilon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
 " measures the granularity of machine\[Hyphen]precision numbers. "
}], "Notes",
 CellID->17505]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->120615065],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->40191458],

Cell[CellGroupData[{

Cell[BoxData["$MachineEpsilon"], "Input",
 CellLabel->"In[1]:=",
 CellID->377499943],

Cell[BoxData["2.220446049250313`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->473697662]
}, Open  ]],

Cell[TextData[{
 "The result of adding 1 to ",
 Cell[BoxData[
  ButtonBox["$MachineEpsilon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
 " is distinct from 1:"
}], "ExampleText",
 CellID->490943217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"1.", "+", "$MachineEpsilon"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->423646670],

Cell[BoxData["1.0000000000000002`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->609655388]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "-", "1."}]], "Input",
 CellLabel->"In[3]:=",
 CellID->263692523],

Cell[BoxData["2.220446049250313`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->15299686]
}, Open  ]],

Cell["This does not work for any smaller machine precision number:", \
"ExampleText",
 CellID->2854509],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", 
   RowBox[{"1.", "+", 
    RowBox[{"$MachineEpsilon", "/", "2"}]}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->108184440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "-", "1."}]], "Input",
 CellLabel->"In[5]:=",
 CellID->168881475],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->179754152]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->853943688],

Cell[TextData[{
 "The result of subtracting ",
 Cell[BoxData[
  ButtonBox["$MachineEpsilon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
 "/2 from 1 is distinct from 1:"
}], "ExampleText",
 CellID->156103104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"1.", "-", 
   RowBox[{"$MachineEpsilon", "/", "2"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361035905],

Cell[BoxData["0.9999999999999999`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42232638]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "-", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->481167964],

Cell[BoxData["1.1102230246251565`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->398692047]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->568883984],

Cell["Find machine epsilon algorithmically:", "ExampleText",
 CellID->365864753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", "=", "1."}], "}"}], ",", 
   RowBox[{
    RowBox[{"While", "[", 
     RowBox[{
      RowBox[{"Not", "[", 
       RowBox[{"PossibleZeroQ", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.", "+", "\[Epsilon]"}], ")"}], " ", "-", " ", "1."}], 
        "]"}], "]"}], ",", 
      RowBox[{"\[Epsilon]", "/=", "2"}]}], "]"}], ";", 
    RowBox[{"\[Epsilon]", "*", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19761995],

Cell[BoxData["2.220446049250313`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->343544987]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "\[Equal]", "$MachineEpsilon"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->293299547],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->300460764]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->567938440],

Cell["\<\
Get the nearest machine number greater than another machine number:\
\>", "ExampleText",
 CellID->203966356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "100"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96559716],

Cell[BoxData["74.05285302052607`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->465745701]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", 
   RowBox[{"x", "*", 
    RowBox[{"(", 
     RowBox[{"1.", "+", "$MachineEpsilon"}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->647943976],

Cell[TextData[{
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " are distinct:"
}], "ExampleText",
 CellID->133129037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "-", "y"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->60451424],

Cell[BoxData[
 RowBox[{"-", "1.4210854715202004`*^-14"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19355806]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " differ only in the least significant bit:"
}], "ExampleText",
 CellID->125016539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"x", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->642813252],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
     ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
     ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", 
     ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", 
     ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", 
     ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0"}], "}"}], ",", "7"}], "}"}]], "Output",
 ImageSize->{512, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->41083206]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"y", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->63323880],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
     ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
     ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", 
     ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", 
     ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", 
     ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "1"}], "}"}], ",", "7"}], "}"}]], "Output",
 ImageSize->{512, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->39717425]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->201472659],

Cell["\<\
Horner's method for evaluating a polynomial with running error bound:\
\>", "ExampleText",
 CellID->524787271],

Cell[BoxData[
 RowBox[{
  RowBox[{"horner", "[", 
   RowBox[{"p_List", ",", "x_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", "y", ",", "mu"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"y", "=", 
      RowBox[{"Last", "[", "p", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"mu", "=", 
      RowBox[{
       RowBox[{"Abs", "[", "y", "]"}], "/", "2"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "=", 
         RowBox[{
          RowBox[{"x", "*", "y"}], "+", "c"}]}], ";", 
        RowBox[{"mu", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", "x", "]"}], "*", "mu"}], "+", 
          RowBox[{"Abs", "[", "y", "]"}]}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", 
         RowBox[{"Take", "[", 
          RowBox[{"p", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2"}], ",", "1", ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"u", " ", "is", " ", "\"\<unit roundoff\>\""}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"u", "=", 
      RowBox[{"$MachineEpsilon", "/", "2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"mu", "=", 
      RowBox[{"u", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "mu"}], "-", 
         RowBox[{"Abs", "[", "y", "]"}]}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"y", ",", "mu"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246019663],

Cell["A polynomial with large coefficients:", "ExampleText",
 CellID->15139767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"poly", "=", 
  RowBox[{"N", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{"Product", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "i"}], ")"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "20"}], "}"}]}], "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->117017680],

Cell[BoxData[
 RowBox[{"2.43290200817664`*^18", "-", 
  RowBox[{"8.7529480367616`*^18", " ", "x"}], "+", 
  RowBox[{"1.3803759753640704`*^19", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"1.2870931245150988`*^19", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"8.037811822645051`*^18", " ", 
   SuperscriptBox["x", "4"]}], "-", 
  RowBox[{"3.599979517947607`*^18", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"1.2066478037803732`*^18", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"3.1133364316139066`*^17", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"6.30308120992949`*^16", " ", 
   SuperscriptBox["x", "8"]}], "-", 
  RowBox[{"1.014229986551145`*^16", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{"1.307535010540395`*^15", " ", 
   SuperscriptBox["x", "10"]}], "-", 
  RowBox[{"1.3558518289953`*^14", " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"1.1310276995381`*^13", " ", 
   SuperscriptBox["x", "12"]}], "-", 
  RowBox[{"7.561111845`*^11", " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"4.017177163`*^10", " ", 
   SuperscriptBox["x", "14"]}], "-", 
  RowBox[{"1.67228082`*^9", " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{"5.3327946`*^7", " ", 
   SuperscriptBox["x", "16"]}], "-", 
  RowBox[{"1.25685`*^6", " ", 
   SuperscriptBox["x", "17"]}], "+", 
  RowBox[{"20615.`", " ", 
   SuperscriptBox["x", "18"]}], "-", 
  RowBox[{"210.`", " ", 
   SuperscriptBox["x", "19"]}], "+", 
  SuperscriptBox["x", "20"]}]], "Output",
 ImageSize->{475, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42901743]
}, Open  ]],

Cell["Evaluate at x=10.  The error is large, but within the bound:", \
"ExampleText",
 CellID->764408962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"horner", "[", 
  RowBox[{
   RowBox[{"CoefficientList", "[", 
    RowBox[{"poly", ",", "x"}], "]"}], ",", "10."}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->69183685],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "9.9328`*^7"}], ",", "8.115339214986559`*^9"}], 
  "}"}]], "Output",
 ImageSize->{190, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->87948128]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16183452],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MachineEpsilon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
 " is a power of 2:"
}], "ExampleText",
 CellID->99427919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"2.", ",", "$MachineEpsilon"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->964685643],

Cell[BoxData[
 RowBox[{"-", "52.`"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->350999889]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->839973786],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MachineEpsilon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
 " is twice ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["10", 
    RowBox[{"-", 
     ButtonBox["MachinePrecision",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MachinePrecision"]}]], ":"}]], "InlineFormula"]
}], "ExampleText",
 CellID->505591396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$MachineEpsilon", "\[Equal]", 
  RowBox[{"2", "/", 
   RowBox[{"10", "^", "MachinePrecision"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->376649925],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153812724]
}, Open  ]],

Cell[TextData[{
 "This is effectively ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", 
    RowBox[{"1", "-", "b"}]], TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " is the number of bits of machine precision:"
}], "ExampleText",
 CellID->332285911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"MachinePrecision", "*", 
   RowBox[{"Log", "[", 
    RowBox[{"2.", ",", "10."}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->181644170],

Cell[BoxData["53.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25933344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "^", 
   RowBox[{"(", 
    RowBox[{"1", "-", "b"}], ")"}]}], "\[Equal]", 
  "$MachineEpsilon"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->409431992],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->259358995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->642623626],

Cell[TextData[{
 "1 and 1+",
 Cell[BoxData[
  ButtonBox["$MachineEpsilon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
 " differ only in the least significant bit:"
}], "ExampleText",
 CellID->536246867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"1.", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115984054],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWttuwjAMTek62NC4PG2P7Ge2p31EhZDgYRpifP6mLrbVabIyEqRCXcdI
zcU28UlzHBKLt/q43bzXx926Xr0e6v12t/5cvXwcvKgsnCu+nHPPT863G9/C
Bz7f/qEmtR6hLFtt4+Yd9xeZjdf1+DcRfdm0qzjywkVivezJLma/DMwuJB/h
rOFbIKyYdtyTfGJ+Vb9/Hou3vqh8l8uJnRip1a8UZWQLjB6L1E4M1cBRycPM
Iwis7wLy1Ah6uKp0Zt4GiYHv3TPW5/qiMcZp83ZdDLGTuu1x+r0Z4ySuimZv
xjiJq6LZ2xAY12aG5ol1qn3Xdqn2obcA9yh+iqVsIDR5nvf8Vuju9rfP73DS
MqdDG+/S499DQQw5sapgpSGTzOtp0uxh96gC8aY1o2l+ZeLBvTXK1v+ya5Z7
NFSGmbT0q4enwhORw+NPx9k5P28SMOC57ey9W/Mb0exNAgZjXE7eJGAwxuXk
TQIGY1xO3iRgIMbFGAY3izbP1EcG+VKZbvzHJU4yJVfsih+3WnQQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{508, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110638792]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{
   RowBox[{"1.", "+", "$MachineEpsilon"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->805699366],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1uwjAMTikdbGhQTuzIXoadeIgKIcFhGmI8/lAWOyoHizZBaqmTGKn5
cUzsNF+M84ltdTnsv6vLcVetv87V6XDc/a43P2cjyjOlsj+l1OeHMm1tWvjA
52oe27StFZR5ParVouN+mdh8Xc8/doznut7FkRGWnvVyID2X/vLO6u7JR7hq
+BYICzI6GUg+FbtRvP8XUxSmS88e7TfpWXTiSS1uUpRZXUD0hOXoVLwK3Kuh
fH7V7WfFV6/t7Lw/VToXa8x9oLkQjeNzx3imBWuxWXsW1lx5ucS1+K0J1vp/
F2JNsMZxP2K2xhtrNeuz8Kx99bvW89GHGxHNSpvklumDJuVwH2+5mA16S+PG
ioY2X9/zv0FhEdKyq6AVA0tM65nX6iF6QEii8tDZSrEblj8YW51obeLPUuMV
xSsOozx9tr96mBW2nBx6/kLLmsUaHx8wb3s4dsf8RmK2xsEHQVxK1jj4IIhL
yRoHHwRxKVnj4INFnAthcLOoeaYhGOS+mG78NyUu0ocrVtk/r/piIg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{508, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->450202852]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1984],

Cell[TextData[{
 "The resolution of machine numbers is twice as fine just below ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " versus just above ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText",
 CellID->656643620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "$MachineEpsilon"}], ",", 
     RowBox[{"2", " ", "$MachineEpsilon"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3451370],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW01IVEEcn9333N0O9qWWHQor+3AvRambh5AumYpEhz4kOiwiuX2oqHSo
S3QoyPWel4SCIC0wJMVb0DUUhEDq5MG8BEGehOA1/5n3fPPmzb55+96sruwu
uzNvZv5f8/+/N/Obmbdd6ZG+3ofpkUxPuq5tKD3Yl+kZrrs8MISrtAhCkWGE
0K9ahK8NfEV+84ZhIA2uyAfNQYK2vhYqaSlOaFZW/gz0z+AvqoZEm5tdNnle
CWVQro2Nf4sLq/iLqiDRpiaXMDc0jQu5DpNaTFpCVA8gqdikIjQIaTlrQWAU
51GcH/CvgaGKMWWQWgG5brdT+SxHlS89vTjRN42nH7AywXHrivTd4/qRMIL0
C5z8WSj/vunluDAW8l7EuGjFDD+9srTulcqPSym0QPdHpWmBxuS6FVYF+sZU
ymG5fPt4TBjRuC/erOkV3cwrfHEV6+gDVPZYv132/Pzxu7N9AiaWJJldnjye
x1OHIbg3KdcRi8ucXRrI7HLt6tu1tb+5uTpI7c3r70qMyo5vcdhTpirHT0aF
R4DWi+P4i5KQMHizVcj1CKfRidffLnm27jfoTEbmGzHm0tlaOdayJLOIhZ9L
wmAsS36lwczBPAZQgK0sPTVcKzu7BcFUueTqwgiowlRsvJ3y9kg1BEVV7J0Q
NTWpRFGW/CYV/L5Qk4PDJ1qyeBoNPyjJ31Nb2FZ7dC0Ga7a6FWm4+cXzLwCg
kgRF0cHZ8BwpCPYy9wMaCGLL9E3fuf0emqqFXG9ILZaNh/9CUNlRLLSm0qQi
a+uAuxQpI/ise15iXXMI2S0h+lRreyXUzkoTx5E/bjgr8VAqtIbm0L2sodXc
vlD4faIzhipUJPIiNF8ILbnRtDH/3lGv8d7Of5crxZXzx3Sye6wltIbG0L2k
3oL4qNyzS4qipkDu8Tw9qkrvacX+STi8rmLPst5FoQKz10n83VwQrScU+oU8
Aa5RJPherWVb8HWKzKep0BpOKust9V6DlK4tdK+7FehgrOVWah2COtlY0u1T
TsLW6hoZOoW19X40+5S1i+TW+GStG69w5WMSjbck/OQ5Kwx+7myfwGspVA0J
UOEcLpOkvL6+YXK9pP1lsA/kg/gXIVX8SnnfTijH2Gji5eTc7PLuLbZDK3sv
tPcOcbVdkjIdoajFcHlUQn+QaMmElHqXSOHfXeC5RkuKCoiKyZ4yVTHEbyz7
9dP0d28q2B/Mlmyr5ffisKYwrYA4NvfIHLiT3zeJGt5nXk65o0wr4Bh+pyLm
0ic7i3LKz3Kt/ClF/mdqTvn8+yO6Yvtd76cQo9m5HrTIeyE68wIxp1xRLvxZ
l/sOUHvW5ZT/UQU/S43cZ10CDulZFx1dpyaXzDPqG+SMGi8AzJPtc4Tvg+F9
BvaMlAf6ZxYXVm0u/lneeVRAVEz2lKnK8SslqnL8VFGROcE1G4jPGnXDGzt5
aOAxTSgMItZjYUB+JssfQ+WWz9rNnzL66wc49alQvoU0YkLfB8NQ8l5ZWgvx
Lra/+0Hdu9hiffkjLA85EqTlwSlFXGLeIkZYGBza79TYu78VHlz03zH2W9BU
kZMLmLbrP0HuWhT5D0ik5cs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{371, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->40183162]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13005],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachinePrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MinMachineNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MinMachineNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxMachineNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxMachineNumber"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23516]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17387],

Cell[TextData[ButtonBox["Machine\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MachinePrecisionNumbers"]], "Tutorials",
 CellID->15086]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->507890795],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->356401021],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->59518747],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->452946094]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MachineEpsilon - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 3.7141394}", "context" -> "System`", 
    "keywords" -> {
     "granularity of machine number", "floating point resolution at 1", 
      "machine epsilon", "epsilon", "unit roundoff"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$MachineEpsilon gives the smallest machine-precision number which can be \
added to 1.0 to give a result that is distinguishable from 1.0. ", 
    "synonyms" -> {"machine epsilon"}, "title" -> "$MachineEpsilon", "type" -> 
    "Symbol", "uri" -> "ref/$MachineEpsilon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5050, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->120615065]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29896, 1054}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2432, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3055, 86, 53, 1, 70, "ObjectName",
 CellID->17473],
Cell[3111, 89, 628, 18, 70, "Usage",
 CellID->20414]
}, Open  ]],
Cell[CellGroupData[{
Cell[3776, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4254, 129, 511, 16, 70, "Notes",
 CellID->18374],
Cell[4768, 147, 245, 7, 70, "Notes",
 CellID->17505]
}, Closed]],
Cell[CellGroupData[{
Cell[5050, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->120615065],
Cell[CellGroupData[{
Cell[5435, 173, 147, 5, 70, "ExampleSection",
 CellID->40191458],
Cell[CellGroupData[{
Cell[5607, 182, 84, 2, 28, "Input",
 CellID->377499943],
Cell[5694, 186, 180, 5, 36, "Output",
 CellID->473697662]
}, Open  ]],
Cell[5889, 194, 242, 8, 70, "ExampleText",
 CellID->490943217],
Cell[CellGroupData[{
Cell[6156, 206, 130, 4, 28, "Input",
 CellID->423646670],
Cell[6289, 212, 176, 5, 36, "Output",
 CellID->609655388]
}, Open  ]],
Cell[CellGroupData[{
Cell[6502, 222, 93, 3, 28, "Input",
 CellID->263692523],
Cell[6598, 227, 179, 5, 36, "Output",
 CellID->15299686]
}, Open  ]],
Cell[6792, 235, 103, 2, 70, "ExampleText",
 CellID->2854509],
Cell[6898, 239, 174, 6, 70, "Input",
 CellID->108184440],
Cell[CellGroupData[{
Cell[7097, 249, 93, 3, 70, "Input",
 CellID->168881475],
Cell[7193, 254, 160, 5, 36, "Output",
 CellID->179754152]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7402, 265, 220, 7, 70, "ExampleSection",
 CellID->853943688],
Cell[7625, 274, 251, 8, 70, "ExampleText",
 CellID->156103104],
Cell[CellGroupData[{
Cell[7901, 286, 154, 5, 70, "Input",
 CellID->361035905],
Cell[8058, 293, 175, 5, 36, "Output",
 CellID->42232638]
}, Open  ]],
Cell[CellGroupData[{
Cell[8270, 303, 93, 3, 70, "Input",
 CellID->481167964],
Cell[8366, 308, 181, 5, 36, "Output",
 CellID->398692047]
}, Open  ]],
Cell[8562, 316, 125, 3, 70, "ExampleDelimiter",
 CellID->568883984],
Cell[8690, 321, 80, 1, 70, "ExampleText",
 CellID->365864753],
Cell[CellGroupData[{
Cell[8795, 326, 536, 17, 70, "Input",
 CellID->19761995],
Cell[9334, 345, 180, 5, 36, "Output",
 CellID->343544987]
}, Open  ]],
Cell[CellGroupData[{
Cell[9551, 355, 113, 3, 70, "Input",
 CellID->293299547],
Cell[9667, 360, 161, 5, 36, "Output",
 CellID->300460764]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9877, 371, 227, 7, 70, "ExampleSection",
 CellID->567938440],
Cell[10107, 380, 118, 3, 70, "ExampleText",
 CellID->203966356],
Cell[CellGroupData[{
Cell[10250, 387, 179, 6, 70, "Input",
 CellID->96559716],
Cell[10432, 395, 175, 5, 36, "Output",
 CellID->465745701]
}, Open  ]],
Cell[10622, 403, 200, 7, 70, "Input",
 CellID->647943976],
Cell[10825, 412, 210, 8, 70, "ExampleText",
 CellID->133129037],
Cell[CellGroupData[{
Cell[11060, 424, 91, 3, 70, "Input",
 CellID->60451424],
Cell[11154, 429, 198, 6, 36, "Output",
 CellID->19355806]
}, Open  ]],
Cell[11367, 438, 238, 8, 70, "ExampleText",
 CellID->125016539],
Cell[CellGroupData[{
Cell[11630, 450, 129, 4, 70, "Input",
 CellID->642813252],
Cell[11762, 456, 809, 17, 54, "Output",
 CellID->41083206]
}, Open  ]],
Cell[CellGroupData[{
Cell[12608, 478, 128, 4, 70, "Input",
 CellID->63323880],
Cell[12739, 484, 809, 17, 54, "Output",
 CellID->39717425]
}, Open  ]],
Cell[13563, 504, 125, 3, 70, "ExampleDelimiter",
 CellID->201472659],
Cell[13691, 509, 120, 3, 70, "ExampleText",
 CellID->524787271],
Cell[13814, 514, 1676, 50, 70, "Input",
 CellID->246019663],
Cell[15493, 566, 79, 1, 70, "ExampleText",
 CellID->15139767],
Cell[CellGroupData[{
Cell[15597, 571, 330, 11, 70, "Input",
 CellID->117017680],
Cell[15930, 584, 1636, 44, 105, "Output",
 CellID->42901743]
}, Open  ]],
Cell[17581, 631, 105, 2, 70, "ExampleText",
 CellID->764408962],
Cell[CellGroupData[{
Cell[17711, 637, 197, 6, 70, "Input",
 CellID->69183685],
Cell[17911, 645, 254, 9, 39, "Output",
 CellID->87948128]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18214, 660, 236, 7, 70, "ExampleSection",
 CellID->16183452],
Cell[18453, 669, 207, 7, 70, "ExampleText",
 CellID->99427919],
Cell[CellGroupData[{
Cell[18685, 680, 137, 4, 70, "Input",
 CellID->964685643],
Cell[18825, 686, 178, 6, 36, "Output",
 CellID->350999889]
}, Open  ]],
Cell[19018, 695, 125, 3, 70, "ExampleDelimiter",
 CellID->839973786],
Cell[19146, 700, 409, 14, 70, "ExampleText",
 CellID->505591396],
Cell[CellGroupData[{
Cell[19580, 718, 176, 5, 70, "Input",
 CellID->376649925],
Cell[19759, 725, 161, 5, 36, "Output",
 CellID->153812724]
}, Open  ]],
Cell[19935, 733, 317, 11, 70, "ExampleText",
 CellID->332285911],
Cell[CellGroupData[{
Cell[20277, 748, 189, 6, 70, "Input",
 CellID->181644170],
Cell[20469, 756, 160, 5, 36, "Output",
 CellID->25933344]
}, Open  ]],
Cell[CellGroupData[{
Cell[20666, 766, 188, 7, 70, "Input",
 CellID->409431992],
Cell[20857, 775, 161, 5, 36, "Output",
 CellID->259358995]
}, Open  ]],
Cell[21033, 783, 125, 3, 70, "ExampleDelimiter",
 CellID->642623626],
Cell[21161, 788, 246, 8, 70, "ExampleText",
 CellID->536246867],
Cell[CellGroupData[{
Cell[21432, 800, 130, 4, 70, "Input",
 CellID->115984054],
Cell[21565, 806, 752, 16, 70, "Output",
 Evaluatable->False,
 CellID->110638792]
}, Open  ]],
Cell[CellGroupData[{
Cell[22354, 827, 168, 5, 70, "Input",
 CellID->805699366],
Cell[22525, 834, 756, 16, 70, "Output",
 Evaluatable->False,
 CellID->450202852]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23330, 856, 223, 7, 70, "ExampleSection",
 CellID->1984],
Cell[23556, 865, 279, 9, 70, "ExampleText",
 CellID->656643620],
Cell[CellGroupData[{
Cell[23860, 878, 402, 13, 70, "Input",
 CellID->3451370],
Cell[24265, 893, 1874, 35, 70, "Output",
 Evaluatable->False,
 CellID->40183162]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26200, 935, 311, 9, 70, "SeeAlsoSection",
 CellID->13005],
Cell[26514, 946, 750, 26, 70, "SeeAlso",
 CellID->23516]
}, Open  ]],
Cell[CellGroupData[{
Cell[27301, 977, 314, 9, 70, "TutorialsSection",
 CellID->17387],
Cell[27618, 988, 167, 3, 70, "Tutorials",
 CellID->15086]
}, Open  ]],
Cell[CellGroupData[{
Cell[27822, 996, 319, 9, 70, "MoreAboutSection",
 CellID->507890795],
Cell[28144, 1007, 167, 3, 70, "MoreAbout",
 CellID->356401021],
Cell[28314, 1012, 159, 3, 70, "MoreAbout",
 CellID->59518747],
Cell[28476, 1017, 147, 3, 70, "MoreAbout",
 CellID->452946094]
}, Open  ]],
Cell[28638, 1023, 27, 0, 70, "History"],
Cell[28668, 1025, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

