(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27387,       1023]
NotebookOptionsPosition[     20881,        796]
NotebookOutlinePosition[     22360,        836]
CellTagsIndexPosition[     22275,        831]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Precision" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalPrecision"], 
          "Machine\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MachinePrecisionNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Numerical Precision\"\>", 
       2->"\<\"Machine\[Hyphen]Precision Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MachinePrecision" :> 
          Documentation`HelpLookup["paclet:ref/MachinePrecision"], 
          "$MachineEpsilon" :> 
          Documentation`HelpLookup["paclet:ref/$MachineEpsilon"], 
          "$MinMachineNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MinMachineNumber"], 
          "$MaxMachineNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MaxMachineNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MachinePrecision\"\>", 
       2->"\<\"$MachineEpsilon\"\>", 3->"\<\"$MinMachineNumber\"\>", 
       4->"\<\"$MaxMachineNumber\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/RepresentationOfNumbers"], 
          "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Precision & Accuracy Control\"\>", 
       2->"\<\"Representation of Numbers\"\>", 
       3->"\<\"System Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MachinePrecision", "ObjectName",
 CellID->31690],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MachinePrecision",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
     "\[LineSeparator]gives the number of decimal digits of precision used \
for machine\[Hyphen]precision numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20117]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A typical value of ",
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"53", 
   SubscriptBox["log", "10"], "2"}]], "InlineFormula"],
 " or approximately 16. "
}], "Notes",
 CellID->6254],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " is the numerical value of ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12901]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->202231693],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->488695256],

Cell["\<\
Hardware machine precision used for floating point computation:\
\>", "ExampleText",
 CellID->474063530],

Cell[CellGroupData[{

Cell[BoxData["$MachinePrecision"], "Input",
 CellLabel->"In[1]:=",
 CellID->703313607],

Cell[BoxData["15.954589770191003`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199250475]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->98109485],

Cell["\<\
Machine number approximating \[Pi]:\
\>", "ExampleText",
 CellID->167451840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", ",", "MachinePrecision"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1920081],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70221454]
}, Open  ]],

Cell["\<\
Arbitrary precision number approximating \[Pi] with the same precision as \
machine numbers:\
\>", "ExampleText",
 CellID->4072069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", ",", "$MachinePrecision"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129061757],

Cell[BoxData["3.14159265358979323846264338328`15.954589770191005"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->320269720]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->62344868],

Cell["\<\
Make sure computations are carried out with the same precision as machine \
numbers:\
\>", "ExampleText",
 CellID->39026634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"$MinPrecision", "=", "$MachinePrecision"}], ",", 
     RowBox[{"$MaxPrecision", "=", "$MachinePrecision"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"Exp", "[", "1000.", "]"}], "-", 
    RowBox[{"Exp", "[", "1001.", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25139004],

Cell[BoxData[
 RowBox[{"-", 
  "3.38513739598755969003174590664`15.954589770191005*^434"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37158960]
}, Open  ]],

Cell["\<\
Without fixing the precision, the resulting precision may be lower:\
\>", "ExampleText",
 CellID->8540175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", "1000.", "]"}], "-", 
  RowBox[{"Exp", "[", "1001.", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->246285016],

Cell[BoxData[
 RowBox[{"-", 
  "3.38513739598755969003174751361`12.619024484572742*^434"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->523545185]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->246449744],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " evaluates to a number while ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " is a numerical constant:"
}], "ExampleText",
 CellID->331129743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$MachinePrecision", ",", "MachinePrecision"}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->746206151],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"15.954589770191003`", ",", "MachinePrecision"}], "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191802585]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " is numerically ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " to MachinePrecision:"
}], "ExampleText",
 CellID->349136385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$MachinePrecision", "\[Equal]", "MachinePrecision"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->564656874],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146380378]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " is the machine precision approximation to ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->183258476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"{", 
   RowBox[{"$MachinePrecision", ",", "MachinePrecision"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->54612880],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"15.954589770191003`", ",", "15.954589770191003`"}], 
  "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->431259333]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MachinePrecision", ",", "MachinePrecision"}], "}"}], ",", 
   "30"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->260151904],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "15.954589770191003`", ",", 
   "15.95458977019100334632816142039813041871`30."}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->52131693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->559872782],

Cell["\<\
Numbers with just a few digits entered are assumed to have machine precision:\
\
\>", "ExampleText",
 CellID->46111664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", "1.23456789"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132452023],

Cell[BoxData["1.23456789`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66783148]
}, Open  ]],

Cell[TextData[{
 "Precision is based on the number of digits when more than ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftCeiling]", "$MachinePrecision", "\[RightCeiling]"}], "+", 
    "1"}], TraditionalForm]], "InlineMath"],
 " are entered:"
}], "ExampleText",
 CellID->176047431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "=", "1.234567890123456789"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17486813],

Cell[BoxData["1.234567890123456789`18.091514977212704"], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->468290768]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Precision", "[", "x", "]"}], ",", 
   RowBox[{"Precision", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->377238855],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"MachinePrecision", ",", "18.091514977212704`"}], "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->171667609]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119517451],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " times the number of bits per digit gives the binary machine precision:"
}], "ExampleText",
 CellID->107065090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$MachinePrecision", "*", 
  RowBox[{"Log", "[", 
   RowBox[{"2.", ",", "10."}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66355674],

Cell[BoxData["53.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285170126]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28641],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " uses arbitrary precision computations with machine precision resolution: "
}], "ExampleText",
 CellID->36310944],

Cell[BoxData[
 RowBox[{
  RowBox[{"ode", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", "[", "t", "]"}], "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->413661034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"asol", "=", 
  RowBox[{
   RowBox[{"NDSolve", "[", 
    RowBox[{"ode", ",", "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{
        RowBox[{"10", "^", "3"}], "Pi"}]}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "$MachinePrecision"}], ",", 
     RowBox[{"MaxSteps", "\[Rule]", "Infinity"}]}], "]"}], "//", 
   "Timing"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->60416119],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"13.484000000000044`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
           "0", ",", 
            "3141.59265358979323846264338327933`15.954589770191003"}], "}"}], 
          "}"}], ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{474, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->656810246]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " uses machine number computations: "
}], "ExampleText",
 CellID->83922983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msol", "=", 
  RowBox[{
   RowBox[{"NDSolve", "[", 
    RowBox[{"ode", ",", "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{
        RowBox[{"10", "^", "3"}], "Pi"}]}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}], ",", 
     RowBox[{"MaxSteps", "\[Rule]", "Infinity"}]}], "]"}], "//", 
   "Timing"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->87859545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.4219999999999923`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", 
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "3141.592653589793`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{404, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->460549758]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26938],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MachinePrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineEpsilon",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineEpsilon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MinMachineNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MinMachineNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxMachineNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxMachineNumber"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24070]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->874],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "Tutorials",
 CellID->25426],

Cell[TextData[ButtonBox["Machine\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MachinePrecisionNumbers"]], "Tutorials",
 CellID->31650]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->12518403],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->60237645],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->259697096],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->636115407]
}, Open  ]],

Cell["New in 2  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MachinePrecision - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 4.6360380}", "context" -> "System`", 
    "keywords" -> {
     "machine number", "double precision numbers", "floating point precision",
       "double flouting point precision", "IEEE floating point", 
      "IEEE 53-bit precision", "machine mantissa length"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$MachinePrecision gives the number of decimal digits of precision used \
for machine-precision numbers. ", "synonyms" -> {"machine precision"}, 
    "title" -> "$MachinePrecision", "type" -> "Symbol", "uri" -> 
    "ref/$MachinePrecision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5115, 160, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->202231693]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22132, 824}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2703, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3326, 90, 55, 1, 70, "ObjectName",
 CellID->31690],
Cell[3384, 93, 495, 14, 70, "Usage",
 CellID->20117]
}, Open  ]],
Cell[CellGroupData[{
Cell[3916, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4394, 129, 327, 12, 70, "Notes",
 CellID->6254],
Cell[4724, 143, 354, 12, 70, "Notes",
 CellID->12901]
}, Closed]],
Cell[CellGroupData[{
Cell[5115, 160, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->202231693],
Cell[CellGroupData[{
Cell[5500, 174, 148, 5, 70, "ExampleSection",
 CellID->488695256],
Cell[5651, 181, 114, 3, 70, "ExampleText",
 CellID->474063530],
Cell[CellGroupData[{
Cell[5790, 188, 86, 2, 28, "Input",
 CellID->703313607],
Cell[5879, 192, 176, 5, 36, "Output",
 CellID->199250475]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6104, 203, 219, 7, 70, "ExampleSection",
 CellID->98109485],
Cell[6326, 212, 86, 3, 70, "ExampleText",
 CellID->167451840],
Cell[CellGroupData[{
Cell[6437, 219, 134, 4, 70, "Input",
 CellID->1920081],
Cell[6574, 225, 174, 5, 36, "Output",
 CellID->70221454]
}, Open  ]],
Cell[6763, 233, 141, 4, 70, "ExampleText",
 CellID->4072069],
Cell[CellGroupData[{
Cell[6929, 241, 137, 4, 70, "Input",
 CellID->129061757],
Cell[7069, 247, 208, 5, 36, "Output",
 CellID->320269720]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7326, 258, 226, 7, 70, "ExampleSection",
 CellID->62344868],
Cell[7555, 267, 134, 4, 70, "ExampleText",
 CellID->39026634],
Cell[CellGroupData[{
Cell[7714, 275, 376, 11, 70, "Input",
 CellID->25139004],
Cell[8093, 288, 232, 7, 36, "Output",
 CellID->37158960]
}, Open  ]],
Cell[8340, 298, 116, 3, 70, "ExampleText",
 CellID->8540175],
Cell[CellGroupData[{
Cell[8481, 305, 160, 5, 70, "Input",
 CellID->246285016],
Cell[8644, 312, 233, 7, 36, "Output",
 CellID->523545185]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8926, 325, 237, 7, 70, "ExampleSection",
 CellID->246449744],
Cell[9166, 334, 389, 12, 70, "ExampleText",
 CellID->331129743],
Cell[CellGroupData[{
Cell[9580, 350, 146, 4, 70, "Input",
 CellID->746206151],
Cell[9729, 356, 237, 7, 36, "Output",
 CellID->191802585]
}, Open  ]],
Cell[9981, 366, 350, 12, 70, "ExampleText",
 CellID->349136385],
Cell[CellGroupData[{
Cell[10356, 382, 130, 3, 70, "Input",
 CellID->564656874],
Cell[10489, 387, 161, 5, 36, "Output",
 CellID->146380378]
}, Open  ]],
Cell[10665, 395, 379, 12, 70, "ExampleText",
 CellID->183258476],
Cell[CellGroupData[{
Cell[11069, 411, 177, 6, 70, "Input",
 CellID->54612880],
Cell[11249, 419, 243, 8, 36, "Output",
 CellID->431259333]
}, Open  ]],
Cell[CellGroupData[{
Cell[11529, 432, 205, 7, 70, "Input",
 CellID->260151904],
Cell[11737, 441, 272, 9, 36, "Output",
 CellID->52131693]
}, Open  ]],
Cell[12024, 453, 125, 3, 70, "ExampleDelimiter",
 CellID->559872782],
Cell[12152, 458, 129, 4, 70, "ExampleText",
 CellID->46111664],
Cell[CellGroupData[{
Cell[12306, 466, 101, 3, 70, "Input",
 CellID->132452023],
Cell[12410, 471, 167, 5, 36, "Output",
 CellID->66783148]
}, Open  ]],
Cell[12592, 479, 295, 9, 70, "ExampleText",
 CellID->176047431],
Cell[CellGroupData[{
Cell[12912, 492, 110, 3, 70, "Input",
 CellID->17486813],
Cell[13025, 497, 197, 5, 36, "Output",
 CellID->468290768]
}, Open  ]],
Cell[CellGroupData[{
Cell[13259, 507, 189, 6, 70, "Input",
 CellID->377238855],
Cell[13451, 515, 237, 7, 36, "Output",
 CellID->171667609]
}, Open  ]],
Cell[13703, 525, 125, 3, 70, "ExampleDelimiter",
 CellID->119517451],
Cell[13831, 530, 266, 7, 70, "ExampleText",
 CellID->107065090],
Cell[CellGroupData[{
Cell[14122, 541, 164, 5, 70, "Input",
 CellID->66355674],
Cell[14289, 548, 161, 5, 36, "Output",
 CellID->285170126]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14499, 559, 226, 7, 70, "ExampleSection",
 CellID->28641],
Cell[14728, 568, 268, 7, 70, "ExampleText",
 CellID->36310944],
Cell[14999, 577, 514, 18, 70, "Input",
 CellID->413661034],
Cell[CellGroupData[{
Cell[15538, 599, 445, 13, 70, "Input",
 CellID->60416119],
Cell[15986, 614, 628, 21, 36, "Output",
 CellID->656810246]
}, Open  ]],
Cell[16629, 638, 227, 7, 70, "ExampleText",
 CellID->83922983],
Cell[CellGroupData[{
Cell[16881, 649, 444, 13, 70, "Input",
 CellID->87859545],
Cell[17328, 664, 569, 19, 36, "Output",
 CellID->460549758]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17958, 690, 311, 9, 70, "SeeAlsoSection",
 CellID->26938],
Cell[18272, 701, 1007, 35, 70, "SeeAlso",
 CellID->24070]
}, Open  ]],
Cell[CellGroupData[{
Cell[19316, 741, 312, 9, 70, "TutorialsSection",
 CellID->874],
Cell[19631, 752, 148, 3, 70, "Tutorials",
 CellID->25426],
Cell[19782, 757, 167, 3, 70, "Tutorials",
 CellID->31650]
}, Open  ]],
Cell[CellGroupData[{
Cell[19986, 765, 318, 9, 70, "MoreAboutSection",
 CellID->12518403],
Cell[20307, 776, 166, 3, 70, "MoreAbout",
 CellID->60237645],
Cell[20476, 781, 160, 3, 70, "MoreAbout",
 CellID->259697096],
Cell[20639, 786, 147, 3, 70, "MoreAbout",
 CellID->636115407]
}, Open  ]],
Cell[20801, 792, 50, 0, 70, "History"],
Cell[20854, 794, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

