(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18644,        671]
NotebookOptionsPosition[     14151,        516]
NotebookOutlinePosition[     15492,        553]
CellTagsIndexPosition[     15407,        548]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Machine\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MachinePrecisionNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Machine\[Hyphen]Precision Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MinMachineNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MinMachineNumber"], 
          "$MachineEpsilon" :> 
          Documentation`HelpLookup["paclet:ref/$MachineEpsilon"], 
          "$MachinePrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MachinePrecision"], 
          "$MaxNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MaxNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$MinMachineNumber\"\>", 
       2->"\<\"$MachineEpsilon\"\>", 3->"\<\"$MachinePrecision\"\>", 
       4->"\<\"$MaxNumber\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/RepresentationOfNumbers"], 
          "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Precision & Accuracy Control\"\>", 
       2->"\<\"Representation of Numbers\"\>", 
       3->"\<\"System Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MaxMachineNumber", "ObjectName",
 CellID->32138],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MaxMachineNumber",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MaxMachineNumber"]], "InlineFormula"],
     "\[LineSeparator]is the largest machine\[Hyphen]precision number that \
can be used on a particular computer system. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11181]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Numbers larger than ",
 Cell[BoxData[
  ButtonBox["$MaxMachineNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxMachineNumber"]], "InlineFormula"],
 " are always represented in arbitrary\[Hyphen]precision form. "
}], "Notes",
 CellID->20249],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MaxMachineNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxMachineNumber"]], "InlineFormula"],
 " is typically ",
 Cell[BoxData[
  SuperscriptBox["2", 
   StyleBox["n", "TI"]]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is the maximum exponent that can be used in the internal representation of \
machine\[Hyphen]precision numbers. "
}], "Notes",
 CellID->17799]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->505732475],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->8308355],

Cell["The largest hardware floating point number:", "ExampleText",
 CellID->69480389],

Cell[CellGroupData[{

Cell[BoxData["$MaxMachineNumber"], "Input",
 CellLabel->"In[1]:=",
 CellID->682717577],

Cell[BoxData["1.7976931348623157`*^308"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290239002]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->176600163],

Cell[TextData[{
 "Numbers larger than ",
 Cell[BoxData[
  ButtonBox["$MaxMachineNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxMachineNumber"]], "InlineFormula"],
 " are represented as arbitrary precision numbers:"
}], "ExampleText",
 CellID->414707577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"2", "*", "$MaxMachineNumber"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222478936],

Cell[BoxData["3.5953862697246314162905484746`15.954589770191005*^308"], \
"Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46986993]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MachineNumberQ", "[", "x", "]"}], ",", 
   RowBox[{"Precision", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->230623131],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "15.954589770191005`"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->767008464]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128412861],

Cell["Find the maximum machine number algorithmatically:", "ExampleText",
 CellID->14421510],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"1.", "-", 
    RowBox[{"$MachineEpsilon", "/", "2"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"MachineNumberQ", "[", "x", "]"}], ",", 
    RowBox[{
     RowBox[{"y", "=", "x"}], ";", 
     RowBox[{"x", "*=", "2"}]}]}], "]"}], ";"}], "\n", "y"}], "Input",
 CellLabel->"In[1]:=",
 CellID->113388238],

Cell[BoxData["1.7976931348623157`*^308"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9131170]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "-", "$MaxMachineNumber"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20370786],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->240401308]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->80814315],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MaxMachineNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxMachineNumber"]], "InlineFormula"],
 " has the largest possible binary exponent and all bits set to 1:"
}], "ExampleText",
 CellID->333460643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"$MaxMachineNumber", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17570765],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1uwjAMDk1bBpsGnNiRSWiPsp32EBWaBIdpCHj/Lk5SQCZZgmBNkzpS
m36u6/z4i5P6szqsv76rw2ZVLT521Xa9We0X7z87IeIDxrIHxtjrCxPPtXiS
V1PG4jpBheZw50ctNrkznvbM3q32c4SXCD/VjdcyIZx61rNAejb9GRoV1/I3
JH+Uo4U5KoQQz00ZSD6kdpOYf5sesJHrGnBxhi/ZibkMVoHLo0DyMbUb/fz7
6GVwK44YkChmaWn61snk0Hth7PZutV8g/Iyw2dc4SgEuDdFPnf/I590aP/YS
fm/2Of7KT4tW/X/YC8MAHCukVn7C5P127IXx/l/7O638tH3vjvV2Bvj+v3c1
j9DUOPpNzuRcj57rdQJyfEZSWZVm/kx5svsg1x8oPuOHZmTs9trur+TVBbtM
J+8UVp1NL/eaBYhbKWaVqN24+mNrV+6rThb7Zmtiyj5Ru/H1x9au2pFwvg+z
1nR+imnf7Zq9tvsrWXF1rIptlF2zR17ugz3ych/skZf7YC+Ml11ehdNZyvkA
lWusdbk2Z8YGv5MZuTo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{520, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59203733]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86538961],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"$MaxMachineNumber", "\[Times]", 
   ButtonBox["$MinMachineNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MinMachineNumber"]}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"4.", "\[Times]", 
   RowBox[{"(", 
    RowBox[{"1.", "-", 
     RowBox[{
      ButtonBox["$MachineEpsilon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MachineEpsilon"], "/", "2"}]}], ")"}]}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->494050984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"$MaxMachineNumber", "\[Times]", "$MinMachineNumber"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10910368],

Cell[BoxData["3.9999999999999996`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331205254]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "-", 
  RowBox[{"4.", 
   RowBox[{"(", 
    RowBox[{"1.", "-", 
     RowBox[{"$MachineEpsilon", "/", "2"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->55652915],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->258511736]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30100],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MinMachineNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MinMachineNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineEpsilon",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineEpsilon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachinePrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxNumber"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26517]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16793],

Cell[TextData[ButtonBox["Machine\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MachinePrecisionNumbers"]], "Tutorials",
 CellID->27395]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->797248161],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->74582251],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->36737233],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->673846759]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MaxMachineNumber - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 5.4798096}", "context" -> "System`", 
    "keywords" -> {"largest machine number", "largest floating point number"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$MaxMachineNumber is the largest machine-precision number that can be \
used on a particular computer system. ", "synonyms" -> {"max machine number"},
     "title" -> "$MaxMachineNumber", "type" -> "Symbol", "uri" -> 
    "ref/$MaxMachineNumber"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5017, 157, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->505732475]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15264, 541}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2540, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3163, 88, 55, 1, 70, "ObjectName",
 CellID->32138],
Cell[3221, 91, 501, 14, 70, "Usage",
 CellID->11181]
}, Open  ]],
Cell[CellGroupData[{
Cell[3759, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4237, 127, 271, 8, 70, "Notes",
 CellID->20249],
Cell[4511, 137, 469, 15, 70, "Notes",
 CellID->17799]
}, Closed]],
Cell[CellGroupData[{
Cell[5017, 157, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->505732475],
Cell[CellGroupData[{
Cell[5402, 171, 146, 5, 70, "ExampleSection",
 CellID->8308355],
Cell[5551, 178, 85, 1, 70, "ExampleText",
 CellID->69480389],
Cell[CellGroupData[{
Cell[5661, 183, 86, 2, 28, "Input",
 CellID->682717577],
Cell[5750, 187, 181, 5, 36, "Output",
 CellID->290239002]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5980, 198, 220, 7, 70, "ExampleSection",
 CellID->176600163],
Cell[6203, 207, 268, 8, 70, "ExampleText",
 CellID->414707577],
Cell[CellGroupData[{
Cell[6496, 219, 131, 4, 70, "Input",
 CellID->222478936],
Cell[6630, 225, 213, 6, 36, "Output",
 CellID->46986993]
}, Open  ]],
Cell[CellGroupData[{
Cell[6880, 236, 194, 6, 70, "Input",
 CellID->230623131],
Cell[7077, 244, 226, 7, 36, "Output",
 CellID->767008464]
}, Open  ]],
Cell[7318, 254, 125, 3, 70, "ExampleDelimiter",
 CellID->128412861],
Cell[7446, 259, 92, 1, 70, "ExampleText",
 CellID->14421510],
Cell[CellGroupData[{
Cell[7563, 264, 392, 13, 70, "Input",
 CellID->113388238],
Cell[7958, 279, 179, 5, 36, "Output",
 CellID->9131170]
}, Open  ]],
Cell[CellGroupData[{
Cell[8174, 289, 107, 3, 70, "Input",
 CellID->20370786],
Cell[8284, 294, 160, 5, 36, "Output",
 CellID->240401308]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8493, 305, 236, 7, 70, "ExampleSection",
 CellID->80814315],
Cell[8732, 314, 259, 7, 70, "ExampleText",
 CellID->333460643],
Cell[CellGroupData[{
Cell[9016, 325, 144, 4, 70, "Input",
 CellID->17570765],
Cell[9163, 331, 780, 17, 70, "Output",
 Evaluatable->False,
 CellID->59203733]
}, Open  ]],
Cell[9958, 351, 124, 3, 70, "ExampleDelimiter",
 CellID->86538961],
Cell[10085, 356, 509, 18, 70, "ExampleText",
 CellID->494050984],
Cell[CellGroupData[{
Cell[10619, 378, 153, 4, 70, "Input",
 CellID->10910368],
Cell[10775, 384, 176, 5, 36, "Output",
 CellID->331205254]
}, Open  ]],
Cell[CellGroupData[{
Cell[10988, 394, 200, 7, 70, "Input",
 CellID->55652915],
Cell[11191, 403, 160, 5, 36, "Output",
 CellID->258511736]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11412, 415, 311, 9, 70, "SeeAlsoSection",
 CellID->30100],
Cell[11726, 426, 995, 35, 70, "SeeAlso",
 CellID->26517]
}, Open  ]],
Cell[CellGroupData[{
Cell[12758, 466, 314, 9, 70, "TutorialsSection",
 CellID->16793],
Cell[13075, 477, 167, 3, 70, "Tutorials",
 CellID->27395]
}, Open  ]],
Cell[CellGroupData[{
Cell[13279, 485, 319, 9, 70, "MoreAboutSection",
 CellID->797248161],
Cell[13601, 496, 166, 3, 70, "MoreAbout",
 CellID->74582251],
Cell[13770, 501, 159, 3, 70, "MoreAbout",
 CellID->36737233],
Cell[13932, 506, 147, 3, 70, "MoreAbout",
 CellID->673846759]
}, Open  ]],
Cell[14094, 512, 27, 0, 70, "History"],
Cell[14124, 514, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

