(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16555,        589]
NotebookOptionsPosition[     12328,        446]
NotebookOutlinePosition[     13682,        484]
CellTagsIndexPosition[     13597,        479]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Machine\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MachinePrecisionNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Machine\[Hyphen]Precision Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MaxPrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MaxPrecision"], 
          "$MaxMachineNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MaxMachineNumber"], 
          "$MinNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MinNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$MaxPrecision\"\>", 
       2->"\<\"$MaxMachineNumber\"\>", 
       3->"\<\"$MinNumber\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/RepresentationOfNumbers"], 
          "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Memory Measurement & Optimization\"\>", 
       2->"\<\"Representation of Numbers\"\>", 
       3->"\<\"System Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MaxNumber", "ObjectName",
 CellID->28374],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MaxNumber",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MaxNumber"]], "InlineFormula"],
     "\[LineSeparator]gives the magnitude of the maximum \
arbitrary\[Hyphen]precision number that can be represented on a particular \
computer system. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19850]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A typical value for ",
 Cell[BoxData[
  ButtonBox["$MaxNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxNumber"]], "InlineFormula"],
 " is around ",
 Cell[BoxData[
  SuperscriptBox["10", "646456887"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->206075261]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->247284445],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->15215111],

Cell["The maximum number representable on this computer system:", \
"ExampleText",
 CellID->40634092],

Cell[CellGroupData[{

Cell[BoxData["$MaxNumber"], "Input",
 CellLabel->"In[1]:=",
 CellID->779334441],

Cell[BoxData["1.9202246726923565854204690606`15.954589770191005*^646456887"], \
"Output",
 ImageSize->{197, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92741440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145026213],

Cell["Larger numbers yield overflows:", "ExampleText",
 CellID->354788522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", " ", "$MaxNumber"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168417323],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->505011225],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->265430747]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->110094715],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MaxNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxNumber"]], "InlineFormula"],
 " has the maximal possible exponent and all significant bits set to 1:"
}], "ExampleText",
 CellID->26848726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"$MaxNumber", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137357546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
     ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
     ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
     ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
     ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
     ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
     ",", "1", ",", "1", ",", "1"}], "}"}], ",", "2147483296"}], 
  "}"}]], "Output",
 ImageSize->{560, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20054820]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->916822991],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MaxNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxNumber"]], "InlineFormula"],
 "\[Times]",
 Cell[BoxData[
  ButtonBox["$MinNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinNumber"]], "InlineFormula"],
 " is approximately 1:"
}], "ExampleText",
 CellID->686828458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$MaxNumber", "*", "$MinNumber"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184336668],

Cell[BoxData["0.99999999999999988897769753748`15.653559774527023"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->761126601]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401718434],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MaxNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxNumber"]], "InlineFormula"],
 " is not a machine number:"
}], "ExampleText",
 CellID->90692076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "$MaxNumber", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91555625],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101995478]
}, Open  ]],

Cell["\<\
It does have precision equivalent to that of machine numbers:\
\>", "ExampleText",
 CellID->32292427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Precision", "[", "$MaxNumber", "]"}], "\[Equal]", 
  "MachinePrecision"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->281017039],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->212914571]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27494],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxMachineNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxMachineNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MinNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MinNumber"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32617]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15595],

Cell[TextData[ButtonBox["Machine\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MachinePrecisionNumbers"]], "Tutorials",
 CellID->29359]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->447181746],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->53146162],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->525803838],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->4238614]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MaxNumber - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 5.7298160}", "context" -> "System`", 
    "keywords" -> {
     "largest representable number", "largest number", "largest real number"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$MaxNumber gives the magnitude of the maximum arbitrary-precision number \
that can be represented on a particular computer system. ", 
    "synonyms" -> {"max number"}, "title" -> "$MaxNumber", "type" -> "Symbol",
     "uri" -> "ref/$MaxNumber"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4447, 142, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->247284445]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13454, 472}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2414, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3037, 86, 48, 1, 70, "ObjectName",
 CellID->28374],
Cell[3088, 89, 518, 15, 70, "Usage",
 CellID->19850]
}, Open  ]],
Cell[CellGroupData[{
Cell[3643, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4121, 126, 289, 11, 70, "Notes",
 CellID->206075261]
}, Closed]],
Cell[CellGroupData[{
Cell[4447, 142, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->247284445],
Cell[CellGroupData[{
Cell[4832, 156, 147, 5, 70, "ExampleSection",
 CellID->15215111],
Cell[4982, 163, 101, 2, 70, "ExampleText",
 CellID->40634092],
Cell[CellGroupData[{
Cell[5108, 169, 79, 2, 28, "Input",
 CellID->779334441],
Cell[5190, 173, 219, 6, 36, "Output",
 CellID->92741440]
}, Open  ]],
Cell[5424, 182, 125, 3, 70, "ExampleDelimiter",
 CellID->145026213],
Cell[5552, 187, 74, 1, 70, "ExampleText",
 CellID->354788522],
Cell[CellGroupData[{
Cell[5651, 192, 101, 3, 70, "Input",
 CellID->168417323],
Cell[5755, 197, 357, 7, 70, "Message",
 CellID->505011225],
Cell[6115, 206, 187, 6, 36, "Output",
 CellID->265430747]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6351, 218, 237, 7, 70, "ExampleSection",
 CellID->110094715],
Cell[6591, 227, 249, 7, 70, "ExampleText",
 CellID->26848726],
Cell[CellGroupData[{
Cell[6865, 238, 138, 4, 70, "Input",
 CellID->137357546],
Cell[7006, 244, 821, 18, 54, "Output",
 CellID->20054820]
}, Open  ]],
Cell[7842, 265, 125, 3, 70, "ExampleDelimiter",
 CellID->916822991],
Cell[7970, 270, 337, 12, 70, "ExampleText",
 CellID->686828458],
Cell[CellGroupData[{
Cell[8332, 286, 110, 3, 70, "Input",
 CellID->184336668],
Cell[8445, 291, 208, 5, 36, "Output",
 CellID->761126601]
}, Open  ]],
Cell[8668, 299, 125, 3, 70, "ExampleDelimiter",
 CellID->401718434],
Cell[8796, 304, 205, 7, 70, "ExampleText",
 CellID->90692076],
Cell[CellGroupData[{
Cell[9026, 315, 118, 3, 70, "Input",
 CellID->91555625],
Cell[9147, 320, 162, 5, 36, "Output",
 CellID->101995478]
}, Open  ]],
Cell[9324, 328, 111, 3, 70, "ExampleText",
 CellID->32292427],
Cell[CellGroupData[{
Cell[9460, 335, 162, 5, 70, "Input",
 CellID->281017039],
Cell[9625, 342, 161, 5, 36, "Output",
 CellID->212914571]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9847, 354, 311, 9, 70, "SeeAlsoSection",
 CellID->27494],
Cell[10161, 365, 728, 26, 70, "SeeAlso",
 CellID->32617]
}, Open  ]],
Cell[CellGroupData[{
Cell[10926, 396, 314, 9, 70, "TutorialsSection",
 CellID->15595],
Cell[11243, 407, 167, 3, 70, "Tutorials",
 CellID->29359]
}, Open  ]],
Cell[CellGroupData[{
Cell[11447, 415, 319, 9, 70, "MoreAboutSection",
 CellID->447181746],
Cell[11769, 426, 176, 3, 70, "MoreAbout",
 CellID->53146162],
Cell[11948, 431, 160, 3, 70, "MoreAbout",
 CellID->525803838],
Cell[12111, 436, 145, 3, 70, "MoreAbout",
 CellID->4238614]
}, Open  ]],
Cell[12271, 442, 27, 0, 70, "History"],
Cell[12301, 444, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

