(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20564,        697]
NotebookOptionsPosition[     17275,        589]
NotebookOutlinePosition[     18671,        628]
CellTagsIndexPosition[     18586,        623]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logical and Piecewise Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LogicalAndPiecewiseFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Logical and Piecewise Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PiecewiseExpand" :> 
          Documentation`HelpLookup["paclet:ref/PiecewiseExpand"], "Piecewise" :> 
          Documentation`HelpLookup["paclet:ref/Piecewise"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PiecewiseExpand\"\>", 
       2->"\<\"Piecewise\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Global Computation Settings & Parameters\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MaxPiecewiseCases", "ObjectName",
 CellID->21338],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MaxPiecewiseCases",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MaxPiecewiseCases"]], "InlineFormula"],
     "\[LineSeparator]gives the maximum number of cases to allow in explicit \
",
     Cell[BoxData[
      ButtonBox["Piecewise",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
     " objects generated by expanding any single piecewise function. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31483]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default value of ",
 Cell[BoxData[
  ButtonBox["$MaxPiecewiseCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPiecewiseCases"]], "InlineFormula"],
 " is ",
 Cell[BoxData["100"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14955],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MaxPiecewiseCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPiecewiseCases"]], "InlineFormula"],
 " is used not only in ",
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 ", but also such functions as ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21902]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->600259595],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->17867710],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " is not converted to ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " because the number of piecewise cases exceeds 100:"
}], "ExampleText",
 CellID->60239772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Floor", "[", "x", "]"}], ",", 
   RowBox[{"1", "<=", "x", "<=", "101"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365204398],

Cell[BoxData[
 RowBox[{
  RowBox[{"PiecewiseExpand", "::", "\<\"mpwc\"\>"}], ":", 
  " ", "\<\"\\!\\(PiecewiseExpand\\) was unable to convert \\!\\(Floor[x]\\) \
to Piecewise, because the required number \\!\\(101\\) of piecewise cases \
sought exceeds the internal limit $MaxPiecewiseCases = \\!\\(100\\).\"\>"}]], \
"Message", "MSG",
 CellID->245969446],

Cell[BoxData[
 RowBox[{"Floor", "[", "x", "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281949324]
}, Open  ]],

Cell["This increases the limit on the number of cases to 200:", "ExampleText",
 CellID->414169990],

Cell[BoxData[
 RowBox[{
  RowBox[{"$MaxPiecewiseCases", "=", "200"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->275494143],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " converts ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4292725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Floor", "[", "x", "]"}], ",", 
   RowBox[{"1", "<=", "x", "<=", "101"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->48326887],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{"x", "<", "2"}]},
    {"2", 
     RowBox[{"2", "\[LessEqual]", "x", "<", "3"}]},
    {"3", 
     RowBox[{"3", "\[LessEqual]", "x", "<", "4"}]},
    {"4", 
     RowBox[{"4", "\[LessEqual]", "x", "<", "5"}]},
    {"5", 
     RowBox[{"5", "\[LessEqual]", "x", "<", "6"}]},
    {"6", 
     RowBox[{"6", "\[LessEqual]", "x", "<", "7"}]},
    {"7", 
     RowBox[{"7", "\[LessEqual]", "x", "<", "8"}]},
    {"8", 
     RowBox[{"8", "\[LessEqual]", "x", "<", "9"}]},
    {"9", 
     RowBox[{"9", "\[LessEqual]", "x", "<", "10"}]},
    {"10", 
     RowBox[{"10", "\[LessEqual]", "x", "<", "11"}]},
    {"11", 
     RowBox[{"11", "\[LessEqual]", "x", "<", "12"}]},
    {"12", 
     RowBox[{"12", "\[LessEqual]", "x", "<", "13"}]},
    {"13", 
     RowBox[{"13", "\[LessEqual]", "x", "<", "14"}]},
    {"14", 
     RowBox[{"14", "\[LessEqual]", "x", "<", "15"}]},
    {"15", 
     RowBox[{"15", "\[LessEqual]", "x", "<", "16"}]},
    {"16", 
     RowBox[{"16", "\[LessEqual]", "x", "<", "17"}]},
    {"17", 
     RowBox[{"17", "\[LessEqual]", "x", "<", "18"}]},
    {"18", 
     RowBox[{"18", "\[LessEqual]", "x", "<", "19"}]},
    {"19", 
     RowBox[{"19", "\[LessEqual]", "x", "<", "20"}]},
    {"20", 
     RowBox[{"20", "\[LessEqual]", "x", "<", "21"}]},
    {"21", 
     RowBox[{"21", "\[LessEqual]", "x", "<", "22"}]},
    {"22", 
     RowBox[{"22", "\[LessEqual]", "x", "<", "23"}]},
    {"23", 
     RowBox[{"23", "\[LessEqual]", "x", "<", "24"}]},
    {"24", 
     RowBox[{"24", "\[LessEqual]", "x", "<", "25"}]},
    {"25", 
     RowBox[{"25", "\[LessEqual]", "x", "<", "26"}]},
    {"26", 
     RowBox[{"26", "\[LessEqual]", "x", "<", "27"}]},
    {"27", 
     RowBox[{"27", "\[LessEqual]", "x", "<", "28"}]},
    {"28", 
     RowBox[{"28", "\[LessEqual]", "x", "<", "29"}]},
    {"29", 
     RowBox[{"29", "\[LessEqual]", "x", "<", "30"}]},
    {"30", 
     RowBox[{"30", "\[LessEqual]", "x", "<", "31"}]},
    {"31", 
     RowBox[{"31", "\[LessEqual]", "x", "<", "32"}]},
    {"32", 
     RowBox[{"32", "\[LessEqual]", "x", "<", "33"}]},
    {"33", 
     RowBox[{"33", "\[LessEqual]", "x", "<", "34"}]},
    {"34", 
     RowBox[{"34", "\[LessEqual]", "x", "<", "35"}]},
    {"35", 
     RowBox[{"35", "\[LessEqual]", "x", "<", "36"}]},
    {"36", 
     RowBox[{"36", "\[LessEqual]", "x", "<", "37"}]},
    {"37", 
     RowBox[{"37", "\[LessEqual]", "x", "<", "38"}]},
    {"38", 
     RowBox[{"38", "\[LessEqual]", "x", "<", "39"}]},
    {"39", 
     RowBox[{"39", "\[LessEqual]", "x", "<", "40"}]},
    {"40", 
     RowBox[{"40", "\[LessEqual]", "x", "<", "41"}]},
    {"41", 
     RowBox[{"41", "\[LessEqual]", "x", "<", "42"}]},
    {"42", 
     RowBox[{"42", "\[LessEqual]", "x", "<", "43"}]},
    {"43", 
     RowBox[{"43", "\[LessEqual]", "x", "<", "44"}]},
    {"44", 
     RowBox[{"44", "\[LessEqual]", "x", "<", "45"}]},
    {"45", 
     RowBox[{"45", "\[LessEqual]", "x", "<", "46"}]},
    {"46", 
     RowBox[{"46", "\[LessEqual]", "x", "<", "47"}]},
    {"47", 
     RowBox[{"47", "\[LessEqual]", "x", "<", "48"}]},
    {"48", 
     RowBox[{"48", "\[LessEqual]", "x", "<", "49"}]},
    {"49", 
     RowBox[{"49", "\[LessEqual]", "x", "<", "50"}]},
    {"50", 
     RowBox[{"50", "\[LessEqual]", "x", "<", "51"}]},
    {"51", 
     RowBox[{"51", "\[LessEqual]", "x", "<", "52"}]},
    {"52", 
     RowBox[{"52", "\[LessEqual]", "x", "<", "53"}]},
    {"53", 
     RowBox[{"53", "\[LessEqual]", "x", "<", "54"}]},
    {"54", 
     RowBox[{"54", "\[LessEqual]", "x", "<", "55"}]},
    {"55", 
     RowBox[{"55", "\[LessEqual]", "x", "<", "56"}]},
    {"56", 
     RowBox[{"56", "\[LessEqual]", "x", "<", "57"}]},
    {"57", 
     RowBox[{"57", "\[LessEqual]", "x", "<", "58"}]},
    {"58", 
     RowBox[{"58", "\[LessEqual]", "x", "<", "59"}]},
    {"59", 
     RowBox[{"59", "\[LessEqual]", "x", "<", "60"}]},
    {"60", 
     RowBox[{"60", "\[LessEqual]", "x", "<", "61"}]},
    {"61", 
     RowBox[{"61", "\[LessEqual]", "x", "<", "62"}]},
    {"62", 
     RowBox[{"62", "\[LessEqual]", "x", "<", "63"}]},
    {"63", 
     RowBox[{"63", "\[LessEqual]", "x", "<", "64"}]},
    {"64", 
     RowBox[{"64", "\[LessEqual]", "x", "<", "65"}]},
    {"65", 
     RowBox[{"65", "\[LessEqual]", "x", "<", "66"}]},
    {"66", 
     RowBox[{"66", "\[LessEqual]", "x", "<", "67"}]},
    {"67", 
     RowBox[{"67", "\[LessEqual]", "x", "<", "68"}]},
    {"68", 
     RowBox[{"68", "\[LessEqual]", "x", "<", "69"}]},
    {"69", 
     RowBox[{"69", "\[LessEqual]", "x", "<", "70"}]},
    {"70", 
     RowBox[{"70", "\[LessEqual]", "x", "<", "71"}]},
    {"71", 
     RowBox[{"71", "\[LessEqual]", "x", "<", "72"}]},
    {"72", 
     RowBox[{"72", "\[LessEqual]", "x", "<", "73"}]},
    {"73", 
     RowBox[{"73", "\[LessEqual]", "x", "<", "74"}]},
    {"74", 
     RowBox[{"74", "\[LessEqual]", "x", "<", "75"}]},
    {"75", 
     RowBox[{"75", "\[LessEqual]", "x", "<", "76"}]},
    {"76", 
     RowBox[{"76", "\[LessEqual]", "x", "<", "77"}]},
    {"77", 
     RowBox[{"77", "\[LessEqual]", "x", "<", "78"}]},
    {"78", 
     RowBox[{"78", "\[LessEqual]", "x", "<", "79"}]},
    {"79", 
     RowBox[{"79", "\[LessEqual]", "x", "<", "80"}]},
    {"80", 
     RowBox[{"80", "\[LessEqual]", "x", "<", "81"}]},
    {"81", 
     RowBox[{"81", "\[LessEqual]", "x", "<", "82"}]},
    {"82", 
     RowBox[{"82", "\[LessEqual]", "x", "<", "83"}]},
    {"83", 
     RowBox[{"83", "\[LessEqual]", "x", "<", "84"}]},
    {"84", 
     RowBox[{"84", "\[LessEqual]", "x", "<", "85"}]},
    {"85", 
     RowBox[{"85", "\[LessEqual]", "x", "<", "86"}]},
    {"86", 
     RowBox[{"86", "\[LessEqual]", "x", "<", "87"}]},
    {"87", 
     RowBox[{"87", "\[LessEqual]", "x", "<", "88"}]},
    {"88", 
     RowBox[{"88", "\[LessEqual]", "x", "<", "89"}]},
    {"89", 
     RowBox[{"89", "\[LessEqual]", "x", "<", "90"}]},
    {"90", 
     RowBox[{"90", "\[LessEqual]", "x", "<", "91"}]},
    {"91", 
     RowBox[{"91", "\[LessEqual]", "x", "<", "92"}]},
    {"92", 
     RowBox[{"92", "\[LessEqual]", "x", "<", "93"}]},
    {"93", 
     RowBox[{"93", "\[LessEqual]", "x", "<", "94"}]},
    {"94", 
     RowBox[{"94", "\[LessEqual]", "x", "<", "95"}]},
    {"95", 
     RowBox[{"95", "\[LessEqual]", "x", "<", "96"}]},
    {"96", 
     RowBox[{"96", "\[LessEqual]", "x", "<", "97"}]},
    {"97", 
     RowBox[{"97", "\[LessEqual]", "x", "<", "98"}]},
    {"98", 
     RowBox[{"98", "\[LessEqual]", "x", "<", "99"}]},
    {"99", 
     RowBox[{"99", "\[LessEqual]", "x", "<", "100"}]},
    {"100", 
     RowBox[{"100", "\[LessEqual]", "x", "<", "101"}]},
    {"101", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{124, 1513},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->224479792]
}, Open  ]],

Cell[TextData[{
 "This reverts ",
 Cell[BoxData[
  ButtonBox["$MaxPiecewiseCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPiecewiseCases"]], "InlineFormula"],
 " to the default setting:"
}], "ExampleText",
 CellID->174698511],

Cell[BoxData[
 RowBox[{
  RowBox[{"$MaxPiecewiseCases", "=", "100"}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->605381713]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27740],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PiecewiseExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PiecewiseExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31176]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17021],

Cell[TextData[ButtonBox["Logical and Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LogicalAndPiecewiseFunctions"]], "Tutorials",
 CellID->8347]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->181436987],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->766790835]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MaxPiecewiseCases - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 11.4643378}", "context" -> "System`", 
    "keywords" -> {
     "global piecewise bound", "maximal number of piecewise cases"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$MaxPiecewiseCases gives the maximum number of cases to allow in \
explicit Piecewise objects generated by expanding any single piecewise \
function. ", "synonyms" -> {"max piecewise cases"}, "title" -> 
    "$MaxPiecewiseCases", "type" -> "Symbol", "uri" -> 
    "ref/$MaxPiecewiseCases"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4907, 165, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->600259595]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18443, 616}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1971, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2594, 77, 56, 1, 70, "ObjectName",
 CellID->21338],
Cell[2653, 80, 669, 19, 70, "Usage",
 CellID->31483]
}, Open  ]],
Cell[CellGroupData[{
Cell[3359, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3837, 121, 264, 10, 70, "Notes",
 CellID->14955],
Cell[4104, 133, 766, 27, 70, "Notes",
 CellID->21902]
}, Closed]],
Cell[CellGroupData[{
Cell[4907, 165, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->600259595],
Cell[CellGroupData[{
Cell[5292, 179, 147, 5, 70, "ExampleSection",
 CellID->17867710],
Cell[5442, 186, 368, 12, 70, "ExampleText",
 CellID->60239772],
Cell[CellGroupData[{
Cell[5835, 202, 205, 6, 70, "Input",
 CellID->365204398],
Cell[6043, 210, 355, 7, 48, "Message",
 CellID->245969446],
Cell[6401, 219, 189, 6, 36, "Output",
 CellID->281949324]
}, Open  ]],
Cell[6605, 228, 98, 1, 70, "ExampleText",
 CellID->414169990],
Cell[6706, 231, 129, 4, 70, "Input",
 CellID->275494143],
Cell[6838, 237, 457, 18, 70, "ExampleText",
 CellID->4292725],
Cell[CellGroupData[{
Cell[7320, 259, 204, 6, 70, "Input",
 CellID->48326887],
Cell[7527, 267, 7383, 225, 1534, "Output",
 CellID->224479792]
}, Open  ]],
Cell[14925, 495, 239, 8, 70, "ExampleText",
 CellID->174698511],
Cell[15167, 505, 129, 4, 70, "Input",
 CellID->605381713]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15345, 515, 311, 9, 70, "SeeAlsoSection",
 CellID->27740],
Cell[15659, 526, 467, 17, 70, "SeeAlso",
 CellID->31176]
}, Open  ]],
Cell[CellGroupData[{
Cell[16163, 548, 314, 9, 70, "TutorialsSection",
 CellID->17021],
Cell[16480, 559, 169, 3, 70, "Tutorials",
 CellID->8347]
}, Open  ]],
Cell[CellGroupData[{
Cell[16686, 567, 319, 9, 70, "MoreAboutSection",
 CellID->181436987],
Cell[17008, 578, 193, 4, 70, "MoreAbout",
 CellID->766790835]
}, Open  ]],
Cell[17216, 585, 29, 0, 70, "History"],
Cell[17248, 587, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

