(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31364,       1082]
NotebookOptionsPosition[     26212,        903]
NotebookOutlinePosition[     27454,        939]
CellTagsIndexPosition[     27369,        934]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Root" :> Documentation`HelpLookup["paclet:ref/Root"], 
          "RootReduce" :> Documentation`HelpLookup["paclet:ref/RootReduce"], 
          "Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], "Cubics" :> 
          Documentation`HelpLookup["paclet:ref/Cubics"], "Quartics" :> 
          Documentation`HelpLookup["paclet:ref/Quartics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Root\"\>", 2->"\<\"RootReduce\"\>", 
       3->"\<\"Solve\"\>", 4->"\<\"Cubics\"\>", 
       5->"\<\"Quartics\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Global Computation Settings & Parameters\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MaxRootDegree", "ObjectName",
 CellID->9480],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MaxRootDegree",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MaxRootDegree"]], "InlineFormula"],
     " \[LineSeparator]specifies the maximum degree of polynomial to allow in \
",
     Cell[BoxData[
      ButtonBox["Root",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Root"]], "InlineFormula"],
     " objects."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1859]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["$MaxRootDegree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxRootDegree"]], "InlineFormula"],
 " is typically ",
 Cell[BoxData["1000"], "InlineFormula"],
 "."
}], "Notes",
 CellID->435332749]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->87718319],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->460431509],

Cell[TextData[{
 "Evaluation of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects with high degree minimal polynomials may be slow:"
}], "ExampleText",
 CellID->429510319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "1000"}], "-", 
      RowBox[{"123", 
       RowBox[{"#", "^", "777"}]}], "+", 
      RowBox[{"211", 
       RowBox[{"#", "^", "356"}]}], "-", 
      RowBox[{"127", 
       RowBox[{"#", "^", "123"}]}], "+", 
      RowBox[{"888", 
       RowBox[{"#", "^", "11"}]}], "-", "2"}], "&"}], ",", "1"}], "]"}], "//",
   "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79601379],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"67.56700000000001`", ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"888", " ", 
        SuperscriptBox["#1", "11"]}], "-", 
       RowBox[{"127", " ", 
        SuperscriptBox["#1", "123"]}], "+", 
       RowBox[{"211", " ", 
        SuperscriptBox["#1", "356"]}], "-", 
       RowBox[{"123", " ", 
        SuperscriptBox["#1", "777"]}], "+", 
       SuperscriptBox["#1", "1000"]}], "&"}], ",", "1"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{464, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->918561602]
}, Open  ]],

Cell["\<\
The result is a valid algebraic number with minimal polynomial proven \
irreducible:\
\>", "ExampleText",
 CellID->50592588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->140991735],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102886898]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " does not attempt factoring polynomials with degrees higher than ",
 Cell[BoxData[
  ButtonBox["$MaxRootDegree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxRootDegree"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->269185772],

Cell[CellGroupData[{

Cell[BoxData["$MaxRootDegree"], "Input",
 CellLabel->"In[3]:=",
 CellID->91547964],

Cell[BoxData["1000"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->456055078]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "1001"}], "-", 
      RowBox[{"123", 
       RowBox[{"#", "^", "777"}]}], "+", 
      RowBox[{"211", 
       RowBox[{"#", "^", "356"}]}], "-", 
      RowBox[{"127", 
       RowBox[{"#", "^", "123"}]}], "+", 
      RowBox[{"888", 
       RowBox[{"#", "^", "11"}]}], "-", "2"}], "&"}], ",", "1"}], "]"}], "//",
   "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->876800162],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"mdeg\"\>"}], ":", 
  " ", "\<\"The degree \\!\\(1001\\) of the input polynomial \
\\!\\(\\(\\(-2\\)\\) + \\(\\(888\\\\ #1\\^11\\)\\) - \\(\\(127\\\\ \
#1\\^123\\)\\) + \\(\\(211\\\\ #1\\^356\\)\\) - \\(\\(123\\\\ #1\\^777\\)\\) \
+ #1\\^1001\\) is not an integer between 1 and $MaxRootDegree. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Root/mdeg\\\", \
ButtonNote -> \\\"Root::mdeg\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->83054770],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.010000000000012055`", ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["#1", "1001"], "-", 
       RowBox[{"123", " ", 
        SuperscriptBox["#1", "777"]}], "+", 
       RowBox[{"211", " ", 
        SuperscriptBox["#1", "356"]}], "-", 
       RowBox[{"127", " ", 
        SuperscriptBox["#1", "123"]}], "+", 
       RowBox[{"888", " ", 
        SuperscriptBox["#1", "11"]}], "-", "2"}], "&"}], ",", "1"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{442, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->410049117]
}, Open  ]],

Cell["The result is not a valid algebraic number:", "ExampleText",
 CellID->149417872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2136749],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->647701905]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18186943],

Cell[TextData[{
 "The degree of the sum of two ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects may be as high as the product of their degrees:"
}], "ExampleText",
 CellID->408568951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "10"}], "-", 
       RowBox[{"9", "#"}], "+", "7"}], "&"}], ",", "10"}], "]"}], "+", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "11"}], "+", 
       RowBox[{"3", "#"}], "-", "5"}], "&"}], ",", "2"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69333851],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"231701687393", "+", 
     RowBox[{"141981806014", " ", "#1"}], "+", 
     RowBox[{"8686408345625", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{"106824875093875", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     RowBox[{"316300367675095", " ", 
      SuperscriptBox["#1", "4"]}], "-", 
     RowBox[{"294560371333859", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     RowBox[{"17117104222552548", " ", 
      SuperscriptBox["#1", "6"]}], "+", 
     RowBox[{"203451631759342860", " ", 
      SuperscriptBox["#1", "7"]}], "+", 
     RowBox[{"1159463633898357990", " ", 
      SuperscriptBox["#1", "8"]}], "+", 
     RowBox[{"4434104783200996825", " ", 
      SuperscriptBox["#1", "9"]}], "+", 
     RowBox[{"12046267252950700496", " ", 
      SuperscriptBox["#1", "10"]}], "+", 
     RowBox[{"23262566679357994081", " ", 
      SuperscriptBox["#1", "11"]}], "+", 
     RowBox[{"31814585741071880255", " ", 
      SuperscriptBox["#1", "12"]}], "+", 
     RowBox[{"26866285004366502435", " ", 
      SuperscriptBox["#1", "13"]}], "+", 
     RowBox[{"12931768134574562795", " ", 
      SuperscriptBox["#1", "14"]}], "-", 
     RowBox[{"7706746968513410612", " ", 
      SuperscriptBox["#1", "15"]}], "-", 
     RowBox[{"8965481932963843530", " ", 
      SuperscriptBox["#1", "16"]}], "+", 
     RowBox[{"8830661798870684835", " ", 
      SuperscriptBox["#1", "17"]}], "+", 
     RowBox[{"192075246239980134830", " ", 
      SuperscriptBox["#1", "18"]}], "+", 
     RowBox[{"446376121570040181305", " ", 
      SuperscriptBox["#1", "19"]}], "+", 
     RowBox[{"602591656277596203676", " ", 
      SuperscriptBox["#1", "20"]}], "+", 
     RowBox[{"303224418655297496280", " ", 
      SuperscriptBox["#1", "21"]}], "-", 
     RowBox[{"38585279107185386130", " ", 
      SuperscriptBox["#1", "22"]}], "-", 
     RowBox[{"79117836698626531955", " ", 
      SuperscriptBox["#1", "23"]}], "-", 
     RowBox[{"30814176728418682305", " ", 
      SuperscriptBox["#1", "24"]}], "+", 
     RowBox[{"93643449189434685726", " ", 
      SuperscriptBox["#1", "25"]}], "+", 
     RowBox[{"1001761672729319562303", " ", 
      SuperscriptBox["#1", "26"]}], "+", 
     RowBox[{"1387986213034720879180", " ", 
      SuperscriptBox["#1", "27"]}], "+", 
     RowBox[{"630053703303073150155", " ", 
      SuperscriptBox["#1", "28"]}], "+", 
     RowBox[{"1533545685032125440580", " ", 
      SuperscriptBox["#1", "29"]}], "+", 
     RowBox[{"143389065245920406445", " ", 
      SuperscriptBox["#1", "30"]}], "+", 
     RowBox[{"8743095385384990905", " ", 
      SuperscriptBox["#1", "31"]}], "+", 
     RowBox[{"46975411370391918480", " ", 
      SuperscriptBox["#1", "32"]}], "-", 
     RowBox[{"65270914204153224795", " ", 
      SuperscriptBox["#1", "33"]}], "+", 
     RowBox[{"4129001839738751660", " ", 
      SuperscriptBox["#1", "34"]}], "-", 
     RowBox[{"11851707045714148082", " ", 
      SuperscriptBox["#1", "35"]}], "+", 
     RowBox[{"314037778758616276120", " ", 
      SuperscriptBox["#1", "36"]}], "-", 
     RowBox[{"1059604396164075056725", " ", 
      SuperscriptBox["#1", "37"]}], "+", 
     RowBox[{"1471716243588924774840", " ", 
      SuperscriptBox["#1", "38"]}], "-", 
     RowBox[{"1491316321641743264200", " ", 
      SuperscriptBox["#1", "39"]}], "+", 
     RowBox[{"892681004164726434165", " ", 
      SuperscriptBox["#1", "40"]}], "-", 
     RowBox[{"393376677769575954630", " ", 
      SuperscriptBox["#1", "41"]}], "+", 
     RowBox[{"127074639281719475115", " ", 
      SuperscriptBox["#1", "42"]}], "-", 
     RowBox[{"21128740051097548980", " ", 
      SuperscriptBox["#1", "43"]}], "+", 
     RowBox[{"2101007243281124775", " ", 
      SuperscriptBox["#1", "44"]}], "-", 
     RowBox[{"622571240711918305", " ", 
      SuperscriptBox["#1", "45"]}], "+", 
     RowBox[{"1483500215402633785", " ", 
      SuperscriptBox["#1", "46"]}], "+", 
     RowBox[{"37797481591774875230", " ", 
      SuperscriptBox["#1", "47"]}], "-", 
     RowBox[{"56094328247006524625", " ", 
      SuperscriptBox["#1", "48"]}], "+", 
     RowBox[{"32400582512688394150", " ", 
      SuperscriptBox["#1", "49"]}], "-", 
     RowBox[{"1109607652360678380", " ", 
      SuperscriptBox["#1", "50"]}], "-", 
     RowBox[{"7554554232888739725", " ", 
      SuperscriptBox["#1", "51"]}], "+", 
     RowBox[{"3374831698107115950", " ", 
      SuperscriptBox["#1", "52"]}], "-", 
     RowBox[{"619645727731184550", " ", 
      SuperscriptBox["#1", "53"]}], "+", 
     RowBox[{"73370511000625905", " ", 
      SuperscriptBox["#1", "54"]}], "-", 
     RowBox[{"14764359663486", " ", 
      SuperscriptBox["#1", "55"]}], "+", 
     RowBox[{"41375419947617", " ", 
      SuperscriptBox["#1", "56"]}], "-", 
     RowBox[{"84971630807438125", " ", 
      SuperscriptBox["#1", "57"]}], "+", 
     RowBox[{"313753795341155250", " ", 
      SuperscriptBox["#1", "58"]}], "-", 
     RowBox[{"488851521121746925", " ", 
      SuperscriptBox["#1", "59"]}], "+", 
     RowBox[{"385943755008204975", " ", 
      SuperscriptBox["#1", "60"]}], "-", 
     RowBox[{"158010938434502010", " ", 
      SuperscriptBox["#1", "61"]}], "+", 
     RowBox[{"32204493534651570", " ", 
      SuperscriptBox["#1", "62"]}], "-", 
     RowBox[{"3056757542312760", " ", 
      SuperscriptBox["#1", "63"]}], "+", 
     RowBox[{"17775124054380", " ", 
      SuperscriptBox["#1", "64"]}], "-", 
     RowBox[{"27280638", " ", 
      SuperscriptBox["#1", "65"]}], "+", 
     RowBox[{"131250", " ", 
      SuperscriptBox["#1", "66"]}], "+", 
     RowBox[{"2424047657500", " ", 
      SuperscriptBox["#1", "67"]}], "+", 
     RowBox[{"445006810156125", " ", 
      SuperscriptBox["#1", "68"]}], "-", 
     RowBox[{"700721184686150", " ", 
      SuperscriptBox["#1", "69"]}], "+", 
     RowBox[{"406763368326825", " ", 
      SuperscriptBox["#1", "70"]}], "-", 
     RowBox[{"92494553574555", " ", 
      SuperscriptBox["#1", "71"]}], "+", 
     RowBox[{"2632923336780", " ", 
      SuperscriptBox["#1", "72"]}], "+", 
     RowBox[{"890887604805", " ", 
      SuperscriptBox["#1", "73"]}], "+", 
     RowBox[{"2165130", " ", 
      SuperscriptBox["#1", "74"]}], "-", 
     RowBox[{"15000", " ", 
      SuperscriptBox["#1", "77"]}], "+", 
     RowBox[{"35575028000", " ", 
      SuperscriptBox["#1", "78"]}], "-", 
     RowBox[{"109884172450", " ", 
      SuperscriptBox["#1", "79"]}], "+", 
     RowBox[{"140008540755", " ", 
      SuperscriptBox["#1", "80"]}], "-", 
     RowBox[{"68266064790", " ", 
      SuperscriptBox["#1", "81"]}], "+", 
     RowBox[{"9080849250", " ", 
      SuperscriptBox["#1", "82"]}], "-", 
     RowBox[{"120285", " ", 
      SuperscriptBox["#1", "83"]}], "+", 
     RowBox[{"1125", " ", 
      SuperscriptBox["#1", "88"]}], "+", 
     RowBox[{"64659400", " ", 
      SuperscriptBox["#1", "89"]}], "-", 
     RowBox[{"56802110", " ", 
      SuperscriptBox["#1", "90"]}], "+", 
     RowBox[{"11804760", " ", 
      SuperscriptBox["#1", "91"]}], "+", 
     RowBox[{"4455", " ", 
      SuperscriptBox["#1", "92"]}], "-", 
     RowBox[{"50", " ", 
      SuperscriptBox["#1", "99"]}], "+", 
     RowBox[{"107", " ", 
      SuperscriptBox["#1", "100"]}], "-", 
     RowBox[{"99", " ", 
      SuperscriptBox["#1", "101"]}], "+", 
     SuperscriptBox["#1", "110"]}], "&"}], ",", "46"}], "]"}]], "Output",
 ImageSize->{580, 581},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314642279]
}, Open  ]],

Cell[TextData[{
 "This prevents ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from creating ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects with degrees greater than 100:"
}], "ExampleText",
 CellID->669930137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$MaxRootDegree", "=", "100"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37633042],

Cell[BoxData["100"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->98084710]
}, Open  ]],

Cell["\<\
Root objects already created are cached; this removes the cached results:\
\>", "ExampleText",
 CellID->266251425],

Cell[BoxData[
 RowBox[{"ClearSystemCache", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->807653817],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " is not allowed to create a ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object with degree 110:"
}], "ExampleText",
 CellID->231530139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "10"}], "-", 
       RowBox[{"9", "#"}], "+", "7"}], "&"}], ",", "10"}], "]"}], "+", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "11"}], "+", 
       RowBox[{"3", "#"}], "-", "5"}], "&"}], ",", "2"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->66332497],

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "::", "\<\"rdeg\"\>"}], ":", 
  " ", "\<\"\\!\\(RootReduce\\) computation failed due to inability to use \
roots of the polynomial \\!\\(\\(\\(231701687393 + \\(\\(141981806014\\\\ \
#1\\)\\) + \\(\\(8686408345625\\\\ #1\\^2\\)\\) + \\(\\(\[LeftSkeleton] 6 \
\[RightSkeleton]\\)\\) + \\(\\(1159463633898357990\\\\ #1\\^8\\)\\) + \
\\(\\(4434104783200996825\\\\ #1\\^9\\)\\) + \\(\\(\[LeftSkeleton] 81 \
\[RightSkeleton]\\)\\)\\)\\) &\\) of degree \\!\\(110\\), which exceeds \
$MaxRootDegree. Increasing the value of $MaxRootDegree may allow \
\\!\\(RootReduce\\) to succeed.\"\>"}]], "Message", "MSG",
 CellID->349062735],

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"7", "-", 
       RowBox[{"9", " ", "#1"}], "+", 
       SuperscriptBox["#1", "10"]}], "&"}], ",", "10"}], "]"}], "+", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "11"]}], "&"}], ",", "2"}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{419, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->93782433]
}, Open  ]],

Cell[TextData[{
 "This resets ",
 Cell[BoxData[
  ButtonBox["$MaxRootDegree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxRootDegree"]], "InlineFormula"],
 " to the default value:"
}], "ExampleText",
 CellID->268472093],

Cell[BoxData[
 RowBox[{
  RowBox[{"$MaxRootDegree", "=", "1000"}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->315480856],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->341475970],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not use ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects with degrees exceeding 1000:"
}], "ExampleText",
 CellID->170195091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "1001"}], "-", 
     RowBox[{"2", "#"}], "+", "3"}], "&"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->490988086],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"mdeg\"\>"}], ":", 
  " ", "\<\"The degree \\!\\(1001\\) of the input polynomial \\!\\(3 - \
\\(\\(2\\\\ #1\\)\\) + #1\\^1001\\) is not an integer between 1 and \
$MaxRootDegree. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Root/mdeg\\\", ButtonNote -> \
\\\"Root::mdeg\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->13582490],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["#1", "1001"], "-", 
     RowBox[{"2", " ", "#1"}], "+", "3"}], "&"}], ",", "1"}], "]"}]], "Output",\

 ImageSize->{166, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233417916]
}, Open  ]],

Cell[TextData[{
 "Increasing the value of ",
 Cell[BoxData[
  ButtonBox["$MaxRootDegree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxRootDegree"]], "InlineFormula"],
 " allows ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to create the algebraic number:"
}], "ExampleText",
 CellID->103521290],

Cell[BoxData[
 RowBox[{
  RowBox[{"$MaxRootDegree", "=", "1001"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8080305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "1001"}], "-", 
      RowBox[{"2", "#"}], "+", "3"}], "&"}], ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->57902082],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", "-", 
     RowBox[{"2", " ", "#1"}], "+", 
     SuperscriptBox["#1", "1001"]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{166, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->246417997]
}, Open  ]],

Cell[TextData[{
 "Since this ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object is real, computing its numeric approximation is reasonably fast:"
}], "ExampleText",
 CellID->696949076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"r", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->459964973],

Cell[BoxData[
 RowBox[{"-", "1.00160976742581455998563909532871950572`20."}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->125440]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16846],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cubics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cubics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quartics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quartics"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6878]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->314002645],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->444695403]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MaxRootDegree - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 12.1206046}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$MaxRootDegree specifies the maximum degree of polynomial to allow in \
Root objects.", "synonyms" -> {"max root degree"}, "title" -> 
    "$MaxRootDegree", "type" -> "Symbol", "uri" -> "ref/$MaxRootDegree"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3695, 123, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->87718319]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27227, 927}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1596, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2219, 64, 51, 1, 70, "ObjectName",
 CellID->9480],
Cell[2273, 67, 597, 19, 70, "Usage",
 CellID->1859]
}, Open  ]],
Cell[CellGroupData[{
Cell[2907, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3385, 108, 273, 10, 70, "Notes",
 CellID->435332749]
}, Closed]],
Cell[CellGroupData[{
Cell[3695, 123, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->87718319],
Cell[CellGroupData[{
Cell[4079, 137, 148, 5, 70, "ExampleSection",
 CellID->460431509],
Cell[4230, 144, 246, 8, 70, "ExampleText",
 CellID->429510319],
Cell[CellGroupData[{
Cell[4501, 156, 486, 17, 28, "Input",
 CellID->79601379],
Cell[4990, 175, 676, 22, 39, "Output",
 CellID->918561602]
}, Open  ]],
Cell[5681, 200, 134, 4, 70, "ExampleText",
 CellID->50592588],
Cell[CellGroupData[{
Cell[5840, 208, 156, 5, 28, "Input",
 CellID->140991735],
Cell[5999, 215, 161, 5, 36, "Output",
 CellID->102886898]
}, Open  ]],
Cell[6175, 223, 371, 12, 70, "ExampleText",
 CellID->269185772],
Cell[CellGroupData[{
Cell[6571, 239, 82, 2, 70, "Input",
 CellID->91547964],
Cell[6656, 243, 161, 5, 36, "Output",
 CellID->456055078]
}, Open  ]],
Cell[CellGroupData[{
Cell[6854, 253, 487, 17, 70, "Input",
 CellID->876800162],
Cell[7344, 272, 575, 10, 70, "Message",
 CellID->83054770],
Cell[7922, 284, 656, 21, 39, "Output",
 CellID->410049117]
}, Open  ]],
Cell[8593, 308, 86, 1, 70, "ExampleText",
 CellID->149417872],
Cell[CellGroupData[{
Cell[8704, 313, 154, 5, 70, "Input",
 CellID->2136749],
Cell[8861, 320, 162, 5, 36, "Output",
 CellID->647701905]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9072, 331, 219, 7, 70, "ExampleSection",
 CellID->18186943],
Cell[9294, 340, 259, 8, 70, "ExampleText",
 CellID->408568951],
Cell[CellGroupData[{
Cell[9578, 352, 466, 17, 70, "Input",
 CellID->69333851],
Cell[10047, 371, 7485, 187, 602, "Output",
 CellID->314642279]
}, Open  ]],
Cell[17547, 561, 296, 11, 70, "ExampleText",
 CellID->669930137],
Cell[CellGroupData[{
Cell[17868, 576, 106, 3, 70, "Input",
 CellID->37633042],
Cell[17977, 581, 159, 5, 36, "Output",
 CellID->98084710]
}, Open  ]],
Cell[18151, 589, 124, 3, 70, "ExampleText",
 CellID->266251425],
Cell[18278, 594, 107, 3, 70, "Input",
 CellID->807653817],
Cell[18388, 599, 358, 13, 70, "ExampleText",
 CellID->231530139],
Cell[CellGroupData[{
Cell[18771, 616, 466, 17, 70, "Input",
 CellID->66332497],
Cell[19240, 635, 670, 11, 70, "Message",
 CellID->349062735],
Cell[19913, 648, 594, 21, 39, "Output",
 CellID->93782433]
}, Open  ]],
Cell[20522, 672, 228, 8, 70, "ExampleText",
 CellID->268472093],
Cell[20753, 682, 126, 4, 70, "Input",
 CellID->315480856],
Cell[20882, 688, 125, 3, 70, "ExampleDelimiter",
 CellID->341475970],
Cell[21010, 693, 291, 11, 70, "ExampleText",
 CellID->170195091],
Cell[CellGroupData[{
Cell[21326, 708, 227, 8, 70, "Input",
 CellID->490988086],
Cell[21556, 718, 460, 9, 70, "Message",
 CellID->13582490],
Cell[22019, 729, 326, 12, 39, "Output",
 CellID->233417916]
}, Open  ]],
Cell[22360, 744, 312, 11, 70, "ExampleText",
 CellID->103521290],
Cell[22675, 757, 124, 4, 70, "Input",
 CellID->8080305],
Cell[CellGroupData[{
Cell[22824, 765, 254, 9, 70, "Input",
 CellID->57902082],
Cell[23081, 776, 324, 11, 39, "Output",
 CellID->246417997]
}, Open  ]],
Cell[23420, 790, 257, 8, 70, "ExampleText",
 CellID->696949076],
Cell[CellGroupData[{
Cell[23702, 802, 121, 4, 70, "Input",
 CellID->459964973],
Cell[23826, 808, 216, 6, 36, "Output",
 CellID->125440]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24103, 821, 311, 9, 70, "SeeAlsoSection",
 CellID->16846],
Cell[24417, 832, 1171, 44, 70, "SeeAlso",
 CellID->6878]
}, Open  ]],
Cell[CellGroupData[{
Cell[25625, 881, 319, 9, 70, "MoreAboutSection",
 CellID->314002645],
Cell[25947, 892, 193, 4, 70, "MoreAbout",
 CellID->444695403]
}, Open  ]],
Cell[26155, 899, 27, 0, 70, "History"],
Cell[26185, 901, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

