(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15955,        571]
NotebookOptionsPosition[     12343,        452]
NotebookOutlinePosition[     13760,        491]
CellTagsIndexPosition[     13675,        486]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Messages" :> 
          Documentation`HelpLookup["paclet:tutorial/Messages"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Messages\"\>", 
       2->"\<\"Mathematica Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MessageList" :> 
          Documentation`HelpLookup["paclet:ref/MessageList"], "MessageName" :> 
          Documentation`HelpLookup["paclet:ref/MessageName"], "Check" :> 
          Documentation`HelpLookup["paclet:ref/Check"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MessageList\"\>", 2->"\<\"MessageName\"\>", 
       3->"\<\"Check\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Messages" :> 
          Documentation`HelpLookup["paclet:guide/Messages"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Messages\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MessageList", "ObjectName",
 CellID->5934],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MessageList",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
     "\[LineSeparator]is a global variable that gives a list of the names of \
messages generated during the evaluation of the current input line. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Whenever a message is output, its name, wrapped with ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 ", is appended to ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17125],

Cell[TextData[{
 "With the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " main loop, ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 " is reset to ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " when the processing of a particular input line is complete. "
}], "Notes",
 CellID->28487],

Cell[TextData[{
 "You can reset ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 " during a computation. "
}], "Notes",
 CellID->898]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->244859499],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->169983372],

Cell["Get a list of messages produced in a computation:", "ExampleText",
 CellID->64993081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"x", "[", "t", "]"}]}], "}"}], ",", "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}], ";", 
  "$MessageList"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4685603],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndnco\"\>"}], ":", 
  " ", "\<\"The number of constraints (\\!\\(0\\)) (initial conditions) is \
not equal to the total differential order of the system (\\!\\(1\\)). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/ndnco\\\", \
ButtonNote -> \\\"NDSolve::ndnco\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->218484219],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[
   RowBox[{"NDSolve", "::", "\<\"ndnco\"\>"}],
   HoldForm], "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117723113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->604158880],

Cell["Use messages for processing:", "ExampleText",
 CellID->152998308],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"m_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{
     RowBox[{"x", " ", "=", " ", 
      RowBox[{"LinearSolve", "[", 
       RowBox[{"m", ",", "b"}], "]"}]}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "$MessageList", "]"}], ">", "0"}], ",", 
       RowBox[{"x", "=", 
        RowBox[{"LeastSquares", "[", 
         RowBox[{"m", ",", "b"}], "]"}]}]}], "]"}], ";", "x"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21189248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->344529802],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}], ":", 
  " ", "\<\"Linear equation encountered that has no solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LinearSolve/nosol\\\", \
ButtonNote -> \\\"LinearSolve::nosol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->8801116],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["17", "25"], ",", 
   FractionBox["34", "25"]}], "}"}]], "Output",
 ImageSize->{66, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->635442244]
}, Open  ]],

Cell[TextData[{
 "Printing can be suppressed by using ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 " inside of ",
 Cell[BoxData[
  ButtonBox["Quiet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quiet"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->789039089],

Cell[BoxData[
 RowBox[{
  RowBox[{"fq", "[", 
   RowBox[{"m_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"Quiet", "[", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "=", " ", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"m", ",", "b"}], "]"}]}], ";", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "$MessageList", "]"}], ">", "0"}], ",", 
        RowBox[{"x", "=", 
         RowBox[{"LeastSquares", "[", 
          RowBox[{"m", ",", "b"}], "]"}]}]}], "]"}], ";", "x"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->358078054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fq", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->90358145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["17", "25"], ",", 
   FractionBox["34", "25"]}], "}"}]], "Output",
 ImageSize->{66, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->90929976]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15429],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Check",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Check"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22888]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15389],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Messages"]], "Tutorials",
 CellID->11802],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->522604605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Messages"]], "MoreAbout",
 CellID->782872322]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MessageList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 12.4799888}", "context" -> "System`", 
    "keywords" -> {
     "list of errors", "messages during calculations", "warnings", "errors", 
      "message processing", "message handling"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$MessageList is a global variable that gives a list of the names of \
messages generated during the evaluation of the current input line. ", 
    "synonyms" -> {"message list"}, "title" -> "$MessageList", "type" -> 
    "Symbol", "uri" -> "ref/$MessageList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4755, 160, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->244859499]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13532, 479}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2016, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2639, 77, 49, 1, 70, "ObjectName",
 CellID->5934],
Cell[2691, 80, 516, 14, 70, "Usage",
 CellID->27716]
}, Open  ]],
Cell[CellGroupData[{
Cell[3244, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3722, 116, 376, 13, 70, "Notes",
 CellID->17125],
Cell[4101, 131, 399, 14, 70, "Notes",
 CellID->28487],
Cell[4503, 147, 215, 8, 70, "Notes",
 CellID->898]
}, Closed]],
Cell[CellGroupData[{
Cell[4755, 160, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->244859499],
Cell[CellGroupData[{
Cell[5140, 174, 148, 5, 70, "ExampleSection",
 CellID->169983372],
Cell[5291, 181, 91, 1, 70, "ExampleText",
 CellID->64993081],
Cell[CellGroupData[{
Cell[5407, 186, 378, 13, 70, "Input",
 CellID->4685603],
Cell[5788, 201, 461, 8, 34, "Message",
 CellID->218484219],
Cell[6252, 211, 248, 9, 36, "Output",
 CellID->117723113]
}, Open  ]],
Cell[6515, 223, 125, 3, 70, "ExampleDelimiter",
 CellID->604158880],
Cell[6643, 228, 71, 1, 70, "ExampleText",
 CellID->152998308],
Cell[6717, 231, 613, 20, 70, "Input",
 CellID->21189248],
Cell[CellGroupData[{
Cell[7355, 255, 324, 12, 70, "Input",
 CellID->344529802],
Cell[7682, 269, 386, 7, 70, "Message",
 CellID->8801116],
Cell[8071, 278, 251, 9, 51, "Output",
 CellID->635442244]
}, Open  ]],
Cell[8337, 290, 356, 13, 70, "ExampleText",
 CellID->789039089],
Cell[8696, 305, 661, 21, 70, "Input",
 CellID->358078054],
Cell[CellGroupData[{
Cell[9382, 330, 324, 12, 70, "Input",
 CellID->90358145],
Cell[9709, 344, 250, 9, 51, "Output",
 CellID->90929976]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10020, 360, 311, 9, 70, "SeeAlsoSection",
 CellID->15429],
Cell[10334, 371, 702, 26, 70, "SeeAlso",
 CellID->22888]
}, Open  ]],
Cell[CellGroupData[{
Cell[11073, 402, 314, 9, 70, "TutorialsSection",
 CellID->15389],
Cell[11390, 413, 127, 3, 70, "Tutorials",
 CellID->11802],
Cell[11520, 418, 284, 9, 70, "Tutorials",
 CellID->522604605]
}, Open  ]],
Cell[CellGroupData[{
Cell[11841, 432, 299, 8, 70, "MoreAboutSection"],
Cell[12143, 442, 128, 3, 70, "MoreAbout",
 CellID->782872322]
}, Open  ]],
Cell[12286, 448, 27, 0, 70, "History"],
Cell[12316, 450, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

