(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21117,        770]
NotebookOptionsPosition[     16305,        604]
NotebookOutlinePosition[     17619,        641]
CellTagsIndexPosition[     17534,        636]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arbitrary\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ArbitraryPrecisionNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Arbitrary\[Hyphen]Precision Numbers\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetPrecision" :> 
          Documentation`HelpLookup["paclet:ref/SetPrecision"], "$MinNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MinNumber"], "$MaxPrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MaxPrecision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SetPrecision\"\>", 
       2->"\<\"$MinNumber\"\>", 
       3->"\<\"$MaxPrecision\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"], 
          "Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/RepresentationOfNumbers"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Global Computation Settings & Parameters\"\>", 
       2->"\<\"Precision & Accuracy Control\"\>", 
       3->"\<\"Representation of Numbers\"\>", 
       4->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MinPrecision", "ObjectName",
 CellID->32369],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MinPrecision",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
     "\[LineSeparator]gives the minimum number of digits of precision to be \
allowed in arbitrary\[Hyphen]precision numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28709]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default value of ",
 Cell[BoxData[
  ButtonBox["$MinPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"-", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5521],

Cell[TextData[{
 "Positive values of ",
 Cell[BoxData[
  ButtonBox["$MinPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
 " make ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pad arbitrary\[Hyphen]precision numbers with zero digits to achieve the \
specified nominal precision. The zero digits are taken to be in base 2, and \
may not correspond to zeros in base 10. "
}], "Notes",
 CellID->31328],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["$MaxPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxPrecision"], "=", 
   RowBox[{"$MinPrecision", "=", 
    StyleBox["n", "TI"]}]}]], "InlineFormula"],
 " makes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " do fixed\[Hyphen]precision arithmetic. "
}], "Notes",
 CellID->16041],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MinPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
 " is measured in decimal digits, and need not be an integer. "
}], "Notes",
 CellID->992]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->805994870],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->683293701],

Cell["\<\
Make sure precision is kept at or above machine precision in a calculation:\
\>", "ExampleText",
 CellID->81306251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MinPrecision", "=", "$MachinePrecision"}], "}"}], ",", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"Pi", ",", "50"}], "]"}], "-", 
    FractionBox["265099323460521503743", "84383735478118508040"]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2327468],

Cell[BoxData["4.06672232057263451353274719`15.954589770191003*^-41"], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163661304]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->218407877],

Cell["Do a computation with fixed 20-digit precision:", "ExampleText",
 CellID->364943194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"$MinPrecision", "=", "20"}], ",", 
     RowBox[{"$MaxPrecision", "=", "20"}]}], "}"}], ",", 
   RowBox[{"1", "-", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "-", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", "10`20"}], "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->658834208],

Cell[BoxData["0.00002270022253129391089966156492737796`20."], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->484632885]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->386293709],

Cell["\<\
Power method for the largest eigenvalue using fixed precision:\
\>", "ExampleText",
 CellID->99659802],

Cell[BoxData[
 RowBox[{
  RowBox[{"pm", "[", 
   RowBox[{"m_", ",", "prec_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"$MinPrecision", "=", "prec"}], ",", 
      RowBox[{"$MaxPrecision", "=", "prec"}]}], "}"}], ",", 
    RowBox[{"Norm", "[", 
     RowBox[{"FixedPoint", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"m", ".", "#"}], "/", 
         RowBox[{"Norm", "[", "#", "]"}]}], "&"}], ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", "4", ",", 
         RowBox[{"WorkingPrecision", "\[Rule]", "prec"}]}], "]"}]}], "]"}], 
     "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103256476],

Cell["\<\
Find the largest eigenvalue of the 4\[Times]4 Hilbert matrix to 47 digits:\
\>", "ExampleText",
 CellID->64322356],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"HilbertMatrix", "[", "4", "]"}]}], ";"}], "\n", 
 RowBox[{"pm", "[", 
  RowBox[{"m", ",", "47"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->7725959],

Cell[BoxData["1.5002142800592428232151851887792297587489008538100421990953`47.\
"], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->728725128]
}, Open  ]],

Cell["Without fixed precision the result indicates lost precision:", \
"ExampleText",
 CellID->147682474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"FixedPoint", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"m", ".", "#"}], "/", 
      RowBox[{"Norm", "[", 
       RowBox[{"#", ",", "2"}], "]"}]}], "&"}], ",", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", "4", ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", "47"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->532165222],

Cell[BoxData["1.500214280059242823215185188779229758747553885962`35.\
56086016476863"], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->50358814]
}, Open  ]],

Cell["\<\
The fixed precision is correct to 47 digits since the iteration is \
self-correcting:\
\>", "ExampleText",
 CellID->8476709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"m", ",", "47"}], "]"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->103315803],

Cell[BoxData[
 RowBox[{"{", 
  "1.5002142800592428232151851887792297587489008538093298463476`47.", 
  "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->395451075]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->104612008],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MinPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
 " does not affect parts of computations with machine numbers:"
}], "ExampleText",
 CellID->487322744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"N", "[", "1", "]"}], ",", 
    RowBox[{"N", "[", 
     RowBox[{"1", ",", "$MachinePrecision"}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459347475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "1.`15.954589770191003"}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19044535]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MinPrecision", "=", "24"}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "+", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->96766689],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.`", ",", "2.`24."}], "}"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31423744]
}, Open  ]],

Cell[TextData[{
 "If needed, use ",
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " to eliminate machine numbers from the input:"
}], "ExampleText",
 CellID->198582630],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], "=", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "24"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MinPrecision", "=", "24"}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "+", "1"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->504542355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.`24.30102999566398", ",", "2.`24.30102999566398"}], 
  "}"}]], "Output",
 ImageSize->{380, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->308860931]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19977],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MinNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MinNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14848]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32629],

Cell[TextData[ButtonBox["Arbitrary\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ArbitraryPrecisionNumbers"]], "Tutorials",
 CellID->26293]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->327094764],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->177154319],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->242978908],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->799294407],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->114011596]
}, Open  ]],

Cell["New in 3  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MinPrecision - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 14.0112780}", "context" -> "System`", 
    "keywords" -> {"fixed precision", "minimum allowed precision"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$MinPrecision gives the minimum number of digits of precision to be \
allowed in arbitrary-precision numbers. ", "synonyms" -> {"min precision"}, 
    "title" -> "$MinPrecision", "type" -> "Symbol", "uri" -> 
    "ref/$MinPrecision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5747, 186, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->805994870]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17391, 629}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2609, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3232, 89, 51, 1, 70, "ObjectName",
 CellID->32369],
Cell[3286, 92, 497, 14, 70, "Usage",
 CellID->28709]
}, Open  ]],
Cell[CellGroupData[{
Cell[3820, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4298, 128, 353, 14, 70, "Notes",
 CellID->5521],
Cell[4654, 144, 454, 13, 70, "Notes",
 CellID->31328],
Cell[5111, 159, 361, 13, 70, "Notes",
 CellID->16041],
Cell[5475, 174, 235, 7, 70, "Notes",
 CellID->992]
}, Closed]],
Cell[CellGroupData[{
Cell[5747, 186, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->805994870],
Cell[CellGroupData[{
Cell[6132, 200, 148, 5, 70, "ExampleSection",
 CellID->683293701],
Cell[6283, 207, 125, 3, 70, "ExampleText",
 CellID->81306251],
Cell[CellGroupData[{
Cell[6433, 214, 346, 11, 42, "Input",
 CellID->2327468],
Cell[6782, 227, 210, 5, 36, "Output",
 CellID->163661304]
}, Open  ]],
Cell[7007, 235, 125, 3, 70, "ExampleDelimiter",
 CellID->218407877],
Cell[7135, 240, 90, 1, 70, "ExampleText",
 CellID->364943194],
Cell[CellGroupData[{
Cell[7250, 245, 395, 13, 70, "Input",
 CellID->658834208],
Cell[7648, 260, 202, 5, 36, "Output",
 CellID->484632885]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7899, 271, 227, 7, 70, "ExampleSection",
 CellID->386293709],
Cell[8129, 280, 112, 3, 70, "ExampleText",
 CellID->99659802],
Cell[8244, 285, 703, 22, 70, "Input",
 CellID->103256476],
Cell[8950, 309, 124, 3, 70, "ExampleText",
 CellID->64322356],
Cell[CellGroupData[{
Cell[9099, 316, 214, 7, 70, "Input",
 CellID->7725959],
Cell[9316, 325, 224, 6, 36, "Output",
 CellID->728725128]
}, Open  ]],
Cell[9555, 334, 105, 2, 70, "ExampleText",
 CellID->147682474],
Cell[CellGroupData[{
Cell[9685, 340, 424, 14, 70, "Input",
 CellID->532165222],
Cell[10112, 356, 227, 6, 36, "Output",
 CellID->50358814]
}, Open  ]],
Cell[10354, 365, 134, 4, 70, "ExampleText",
 CellID->8476709],
Cell[CellGroupData[{
Cell[10513, 373, 185, 6, 70, "Input",
 CellID->103315803],
Cell[10701, 381, 250, 8, 36, "Output",
 CellID->395451075]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11000, 395, 230, 7, 70, "ExampleSection",
 CellID->104612008],
Cell[11233, 404, 247, 7, 70, "ExampleText",
 CellID->487322744],
Cell[CellGroupData[{
Cell[11505, 415, 288, 10, 70, "Input",
 CellID->459347475],
Cell[11796, 427, 225, 7, 36, "Output",
 CellID->19044535]
}, Open  ]],
Cell[CellGroupData[{
Cell[12058, 439, 260, 9, 70, "Input",
 CellID->96766689],
Cell[12321, 450, 210, 7, 36, "Output",
 CellID->31423744]
}, Open  ]],
Cell[12546, 460, 250, 8, 70, "ExampleText",
 CellID->198582630],
Cell[CellGroupData[{
Cell[12821, 472, 482, 17, 70, "Input",
 CellID->504542355],
Cell[13306, 491, 245, 8, 36, "Output",
 CellID->308860931]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13612, 506, 311, 9, 70, "SeeAlsoSection",
 CellID->19977],
Cell[13926, 517, 718, 26, 70, "SeeAlso",
 CellID->14848]
}, Open  ]],
Cell[CellGroupData[{
Cell[14681, 548, 314, 9, 70, "TutorialsSection",
 CellID->32629],
Cell[14998, 559, 171, 3, 70, "Tutorials",
 CellID->26293]
}, Open  ]],
Cell[CellGroupData[{
Cell[15206, 567, 319, 9, 70, "MoreAboutSection",
 CellID->327094764],
Cell[15528, 578, 193, 4, 70, "MoreAbout",
 CellID->177154319],
Cell[15724, 584, 167, 3, 70, "MoreAbout",
 CellID->242978908],
Cell[15894, 589, 160, 3, 70, "MoreAbout",
 CellID->799294407],
Cell[16057, 594, 153, 3, 70, "MoreAbout",
 CellID->114011596]
}, Open  ]],
Cell[16225, 600, 50, 0, 70, "History"],
Cell[16278, 602, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

