(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12403,        446]
NotebookOptionsPosition[      9320,        344]
NotebookOutlinePosition[     10691,        383]
CellTagsIndexPosition[     10606,        378]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global System Information" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GlobalSystemInformation"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Global System Information\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$CurrentLink" :> 
          Documentation`HelpLookup["paclet:ref/$CurrentLink"], "Links" :> 
          Documentation`HelpLookup["paclet:ref/Links"], "$Input" :> 
          Documentation`HelpLookup["paclet:ref/$Input"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$CurrentLink\"\>", 2->"\<\"Links\"\>", 
       3->"\<\"$Input\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink Mathematica Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkMathematicaFunctions"], 
          "Parallel & Grid Computing" :> 
          Documentation`HelpLookup[
           "paclet:guide/ParallelAndGridComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MathLink Mathematica Functions\"\>", 
       2->"\<\"Parallel & Grid Computing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$ParentLink", "ObjectName",
 CellID->22933],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$ParentLink",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$ParentLink"]], "InlineFormula"],
     "\[LineSeparator]is the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " ",
     Cell[BoxData[
      ButtonBox["LinkObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
     " currently used for input and output by the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel in a particular session. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17563]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel is started by a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end, ",
 Cell[BoxData[
  ButtonBox["$ParentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ParentLink"]], "InlineFormula"],
 " gives the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection between the front end and the kernel. "
}], "Notes",
 CellID->21623],

Cell[TextData[{
 "You can reset ",
 Cell[BoxData[
  ButtonBox["$ParentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ParentLink"]], "InlineFormula"],
 " in the middle of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session to connect the kernel to a different front end. "
}], "Notes",
 CellID->32519]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53345157],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->59633078],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 " currently used for input and output by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel:"
}], "ExampleText",
 CellID->293787239],

Cell[CellGroupData[{

Cell[BoxData["$ParentLink"], "Input",
 CellLabel->"In[1]:=",
 CellID->617221420],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"dc5_shm\"\>", ",", "1", ",", "1"}], "]"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18152679]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->819016400],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$ParentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ParentLink"]], "InlineFormula"],
 " is an active link listed in ",
 Cell[BoxData[
  ButtonBox["Links",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Links"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1522520165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"Links", "[", "]"}], ",", "$ParentLink"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1728759150],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->550042262]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6269],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CurrentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CurrentLink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Links",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Links"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Input"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25688]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18970],

Cell[TextData[ButtonBox["Global System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GlobalSystemInformation"]], "Tutorials",
 CellID->240936605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->61894336],

Cell[TextData[ButtonBox["MathLink Mathematica Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], "MoreAbout",
 CellID->149964869],

Cell[TextData[ButtonBox["Parallel & Grid Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "MoreAbout",
 CellID->523054008]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$ParentLink - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 44.1214238}", "context" -> "System`", 
    "keywords" -> {
     "parent link", "active link", "MathLink connection to kernel", 
      "controlling link"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$ParentLink is the MathLink LinkObject currently used for input and \
output by the Mathematica kernel in a particular session. ", 
    "synonyms" -> {"parent link"}, "title" -> "$ParentLink", "type" -> 
    "Symbol", "uri" -> "ref/$ParentLink"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4911, 164, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->53345157]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10464, 371}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2164, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2787, 80, 49, 1, 70, "ObjectName",
 CellID->22933],
Cell[2839, 83, 751, 24, 70, "Usage",
 CellID->17563]
}, Open  ]],
Cell[CellGroupData[{
Cell[3627, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4105, 129, 443, 17, 70, "Notes",
 CellID->21623],
Cell[4551, 148, 323, 11, 70, "Notes",
 CellID->32519]
}, Closed]],
Cell[CellGroupData[{
Cell[4911, 164, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53345157],
Cell[CellGroupData[{
Cell[5295, 178, 147, 5, 70, "ExampleSection",
 CellID->59633078],
Cell[5445, 185, 348, 14, 70, "ExampleText",
 CellID->293787239],
Cell[CellGroupData[{
Cell[5818, 203, 80, 2, 28, "Input",
 CellID->617221420],
Cell[5901, 207, 241, 7, 36, "Output",
 CellID->18152679]
}, Open  ]],
Cell[6157, 217, 125, 3, 70, "ExampleDelimiter",
 CellID->819016400],
Cell[6285, 222, 332, 12, 70, "ExampleText",
 CellID->1522520165],
Cell[CellGroupData[{
Cell[6642, 238, 165, 5, 70, "Input",
 CellID->1728759150],
Cell[6810, 245, 161, 5, 36, "Output",
 CellID->550042262]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7032, 257, 310, 9, 70, "SeeAlsoSection",
 CellID->6269],
Cell[7345, 268, 694, 26, 70, "SeeAlso",
 CellID->25688]
}, Open  ]],
Cell[CellGroupData[{
Cell[8076, 299, 314, 9, 70, "TutorialsSection",
 CellID->18970],
Cell[8393, 310, 163, 3, 70, "Tutorials",
 CellID->240936605]
}, Open  ]],
Cell[CellGroupData[{
Cell[8593, 318, 318, 9, 70, "MoreAboutSection",
 CellID->61894336],
Cell[8914, 329, 170, 3, 70, "MoreAbout",
 CellID->149964869],
Cell[9087, 334, 161, 3, 70, "MoreAbout",
 CellID->523054008]
}, Open  ]],
Cell[9263, 340, 27, 0, 70, "History"],
Cell[9293, 342, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

