(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19685,        546]
NotebookOptionsPosition[     16898,        460]
NotebookOutlinePosition[     18390,        500]
CellTagsIndexPosition[     18305,        495]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ControlActive" :> 
         Documentation`HelpLookup["paclet:ref/ControlActive"], 
         "$ControlActiveSetting" :> 
         Documentation`HelpLookup["paclet:ref/$ControlActiveSetting"], 
         "Timing" :> Documentation`HelpLookup["paclet:ref/Timing"], 
         "ByteCount" :> Documentation`HelpLookup["paclet:ref/ByteCount"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"ControlActive\"\>", 
      2->"\<\"$ControlActiveSetting\"\>", 3->"\<\"Timing\"\>", 
      4->"\<\"ByteCount\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["$PerformanceGoal", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$PerformanceGoal",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$PerformanceGoal"]], "InlineFormula"],
     " \[LineSeparator]gives the default setting for the option ",
     Cell[BoxData[
      ButtonBox["PerformanceGoal",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFormula"],
     " for graphics and other algorithmic functions."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The typical default value of ",
 Cell[BoxData[
  ButtonBox["$PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PerformanceGoal"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"], "[", 
   RowBox[{"\"\<Speed\>\"", ",", "\"\<Quality\>\""}], "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14236033],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->941986901],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PerformanceGoal"]], "InlineFormula"],
 " normally changes when ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " controls are active:"
}], "ExampleText",
 CellID->1150332408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", ",", "$PerformanceGoal"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1988990962],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 0.224, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 0, 1}}, Typeset`size$$ = {109.1875, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$10964$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$10964$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`n$$, $PerformanceGoal}, 
      "Specifications" :> {{$CellContext`n$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->20660889]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1471067294],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PerformanceGoal"]], "InlineFormula"],
 " can be set locally to affect the setting of ",
 Cell[BoxData[
  ButtonBox["PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->248782347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$PerformanceGoal", "=", "\"\<Speed\>\""}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"1", "/", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "0.01"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"1", "/", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0.01", ",", "1"}], "}"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134245320],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVVXk01AsbNpRySa4lhbQqbbRdSeUnla69DVNKpWtadFNuqcRN2eJmK8RY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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-1, 0.01}, {-0.9999964468722465, 0.9999949716113746}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVVXk41A0XnRahUpRUikqKaJUslQ6KSrRZohRZyp5PNNHLl5JUyCeSimyh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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0.01, 1}, {-0.9982734455099648, 0.9999928359311289}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->583927924]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ControlActiveSetting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ControlActiveSetting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Timing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Timing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$PerformanceGoal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 45.1527002}", "context" -> "System`", 
    "keywords" -> {
     "objective goal", "optimization for accuracy", "optimization for speed", 
      "optimization goal", "quality goal", "quality target", 
      "speed accuracy objective", "speed accuracy trade-off"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$PerformanceGoal gives the default setting for the option \
PerformanceGoal for graphics and other algorithmic functions.", 
    "synonyms" -> {"performance goal"}, "title" -> "$PerformanceGoal", "type" -> 
    "Symbol", "uri" -> "ref/$PerformanceGoal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4775, 147, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->14236033]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18163, 488}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 922, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1545, 47, 1581, 37, 70, "ObjectNameGrid"],
Cell[3129, 86, 649, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3815, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4293, 126, 445, 16, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[4775, 147, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14236033],
Cell[CellGroupData[{
Cell[5159, 161, 148, 5, 70, "ExampleSection",
 CellID->941986901],
Cell[5310, 168, 366, 12, 70, "ExampleText",
 CellID->1150332408],
Cell[CellGroupData[{
Cell[5701, 184, 253, 8, 28, "Input",
 CellID->1988990962],
Cell[5957, 194, 1504, 33, 124, "Output",
 CellID->20660889]
}, Open  ]],
Cell[7476, 230, 126, 3, 70, "ExampleDelimiter",
 CellID->1471067294],
Cell[7605, 235, 377, 12, 70, "ExampleText",
 CellID->248782347],
Cell[CellGroupData[{
Cell[8007, 251, 667, 22, 70, "Input",
 CellID->134245320],
Cell[8677, 275, 6790, 125, 70, "Output",
 CellID->583927924]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15528, 407, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[15847, 418, 979, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[16841, 456, 27, 0, 70, "History"],
Cell[16871, 458, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

