(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24519,        821]
NotebookOptionsPosition[     19992,        664]
NotebookOutlinePosition[     21256,        700]
CellTagsIndexPosition[     21171,        695]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"The Main Loop\"\>", 
       2->"\<\"Mathematica Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$Post" :> Documentation`HelpLookup["paclet:ref/$Post"], 
          "$MessagePrePrint" :> 
          Documentation`HelpLookup["paclet:ref/$MessagePrePrint"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$Post\"\>", 
       2->"\<\"$MessagePrePrint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$PrePrint", "ObjectName",
 CellID->18946],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$PrePrint",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$PrePrint"]], "InlineFormula"],
     "\[LineSeparator]is a global variable whose value, if set, is applied to \
every expression before it is printed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->237]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$PrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PrePrint"]], "InlineFormula"],
 " is applied after ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " is assigned, but before the output result is printed. "
}], "Notes",
 CellID->24902]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->263055192],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->224087343],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["$PrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PrePrint"]], "InlineFormula"],
 " is not defined, meaning output is shown as it comes from evaluation:"
}], "ExampleText",
 CellID->36771305],

Cell[CellGroupData[{

Cell[BoxData["$PrePrint"], "Input",
 CellLabel->"In[1]:=",
 CellID->572061151],

Cell[BoxData["$PrePrint"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->459533865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->328434340],

Cell["Show exact quantities by their numerical value:", "ExampleText",
 CellID->8212277],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrePrint", "=", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Precision", "[", "#", "]"}], "\[Equal]", "\[Infinity]"}], ",",
       
      RowBox[{"N", "[", "#", "]"}], ",", 
      RowBox[{"N", "[", 
       RowBox[{"#", ",", 
        RowBox[{"Precision", "[", "#", "]"}]}], "]"}]}], "]"}], "&"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85105816],

Cell[CellGroupData[{

Cell[BoxData["Pi"], "Input",
 CellLabel->"In[2]:=",
 CellID->457198956],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->293503225]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->738826197],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.167303978261419`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.18123244446987535`"}], "-", 
      RowBox[{"1.0839541013177107`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.18123244446987535`"}], "+", 
      RowBox[{"1.0839541013177107`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.7648844336005848`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.35247154603172615`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.7648844336005848`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.35247154603172615`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{474, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->236987222]
}, Open  ]],

Cell["\<\
The function is designed to preserve arbitrary precision numbers if they are \
in the output:\
\>", "ExampleText",
 CellID->113265255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", ",", " ", "20"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1047634426],

Cell[BoxData["3.14159265358979323846264338358607339165`20."], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->391060560]
}, Open  ]],

Cell[TextData[{
 "Restore ",
 Cell[BoxData[
  ButtonBox["$PrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PrePrint"]], "InlineFormula"],
 " to the default:"
}], "ExampleText",
 CellID->173285343],

Cell[BoxData[
 RowBox[{"$PrePrint", "=."}]], "Input",
 CellLabel->"In[5]:=",
 CellID->250210368],

Cell[TextData[{
 "Note that changing ",
 Cell[BoxData[
  ButtonBox["$PrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PrePrint"]], "InlineFormula"],
 " did not change the values saved in ",
 Cell[BoxData[
  ButtonBox["Out",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Out"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->252966443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Out", "[", "2", "]"}], ",", 
   RowBox[{"Out", "[", "3", "]"}], ",", 
   RowBox[{"Out", "[", "4", "]"}]}], "}"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->187683075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Pi]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "-", "#1", "+", 
           SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "-", "#1", "+", 
           SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "-", "#1", "+", 
           SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "-", "#1", "+", 
           SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "-", "#1", "+", 
           SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
    "}"}], ",", "3.14159265358979323846264338358607339165`20."}], 
  "}"}]], "Output",
 ImageSize->{403, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->847162986]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24111],

Cell["Show matrices using plots:", "ExampleText",
 CellID->115669198],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrePrint", "=", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"MatrixQ", "[", "#", "]"}], ",", 
      RowBox[{"MatrixPlot", "[", "#", "]"}], ",", "#"}], "]"}], "&"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->403860554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Band", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.", ",", "2."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.", ",", "4."}], "}"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", "47"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->285659367],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWk9PE0EU33bbosGiBgWamMBFT5w4GA7+OaEH4oGD4omkARMgUREhnLhI
YqIHw9nP4JGDn8IvYfRrjDO7bzuv897OzrQFXiNNuruzM7/fe2/m/Zl290X3
YPvN2+7BzmZ34fl+d297Z/PjwrP3+/pWWkuS5Ex/f84l+lrpq+x7ppQ+0+Mt
fUz1gBk41/W5rs9z+txA7VnoT6HdMWgzQBUfc9ewJU18V18nt7Nzdkx7fZlE
xACyyAhg6x3JqFnU5vqr5bRHqvVs2AiPxndg7pNmz3AY2Yae1EFMDajrXIUm
d2Fd64RphkP2jWg7IxoXpHM1Q7lVU9AzKl2NpKSFR/DjqjyiWmPac1MV8V3E
b92JX9yOiO++u2lPUlmGMX7wvfCHPq8wl66lHad9L7I9XcE/mWmR3SUR37pk
3XitGhEaP3baryIkcHnFbZ/qQ/r31yf3Poet5eyeDGAQplmwgiLwwbPDoQt+
i+H4S7Unvl3NT2PMxXw1Ev58rqXqXb42RArlqNv1JZFVye+uLWHI2d2o8/FM
liPM3P3+8WicESdgeUNbfkMWQtvR0HbIQRwr6yVu7rpkBKw5j6CRYCKvGcHD
M6Qce0KrtduOkARsZhNv8k+eg/i9oJsbjtBMupWKZ8hzg38XZ6SYAZi92Cu4
Gbost8XlUGJHcA4dQA6sSpycMP8i/IH+5fq7j4ePkA9oBudlIcCOcUbsKpvd
78tCQHaXg9hS1ksWZSFgzeUgNpAdS7IQYAePSBP7q9HNgT40xuWZD+/Xeznc
U1e97AxXf1WNlfYazd1ytLTq2mTgWMZD1f+LPLAaDWlJyH5koJmDdYqfOZ9/
eZmJf7m+7UPz0RCPWFM2kz+RhYBMLgexqqxfrshCwJrLQawgO1ZlIcAOOYin
yI41WQiwY1QI/MTGzZU+NMZBoWrlJ3ysyvNEwvVeHyVjMn1YJTPNZWUz3kuF
/isbceXCctadvtHvMIaTFvKcgZUIOXrdO/slMtGupqxGe2So/mcQfJUm+Mo4
WVI2FjdkISA65CAWkR1bshBghxzEA2THriwE2DHOiHlls9+eLARkHx5Bn1px
WZDwsE9qhvmX2adpyK+68OrbUdZHD1V49Y23CUs6OjebBEiESBlEYkgNJjIi
a7BPRz5uptE8HstCgB1yEG1kx4ksBNgxzoiWsjn/iywEZGs5iMJDTtnRGV/C
vGeBUaSuTWTYCRcTKNnNlq0wNvCQwdlMs2D5VmL3RelSVT1w+1zeSSJamiNX
Zy5EO1K7rqnCl+17ZmVvo1299Yoz6dVbr5wmV2+9Dqfr//3Wa1L7B375UiQ=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->130184409]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ".", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"47", ",", "47"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->561617340],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->110211571]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"%", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->191737306],

Cell[BoxData[
 RowBox[{"{", "114.49751584014292`", "}"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->538007301]
}, Open  ]],

Cell[TextData[{
 "Restore ",
 Cell[BoxData[
  ButtonBox["$PrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PrePrint"]], "InlineFormula"],
 " to the default:"
}], "ExampleText",
 CellID->194813328],

Cell[BoxData[
 RowBox[{"$PrePrint", "=."}]], "Input",
 CellLabel->"In[5]:=",
 CellID->264235711]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15098],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Post",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Post"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MessagePrePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MessagePrePrint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15669]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5025],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->6736],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->522604605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->114007506],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->184314920]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$PrePrint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 51.9810000}", "context" -> "System`", 
    "keywords" -> {"global print forms"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$PrePrint is a global variable whose value, if set, is applied to every \
expression before it is printed. ", "synonyms" -> {"pre print"}, "title" -> 
    "$PrePrint", "type" -> "Symbol", "uri" -> "ref/$PrePrint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4089, 134, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->263055192]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21028, 688}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1977, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2600, 76, 47, 1, 70, "ObjectName",
 CellID->18946],
Cell[2650, 79, 480, 14, 70, "Usage",
 CellID->237]
}, Open  ]],
Cell[CellGroupData[{
Cell[3167, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3645, 115, 407, 14, 70, "Notes",
 CellID->24902]
}, Closed]],
Cell[CellGroupData[{
Cell[4089, 134, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->263055192],
Cell[CellGroupData[{
Cell[4474, 148, 148, 5, 70, "ExampleSection",
 CellID->224087343],
Cell[4625, 155, 264, 8, 70, "ExampleText",
 CellID->36771305],
Cell[CellGroupData[{
Cell[4914, 167, 78, 2, 28, "Input",
 CellID->572061151],
Cell[4995, 171, 166, 5, 36, "Output",
 CellID->459533865]
}, Open  ]],
Cell[5176, 179, 125, 3, 70, "ExampleDelimiter",
 CellID->328434340],
Cell[5304, 184, 88, 1, 70, "ExampleText",
 CellID->8212277],
Cell[5395, 187, 432, 15, 70, "Input",
 CellID->85105816],
Cell[CellGroupData[{
Cell[5852, 206, 71, 2, 70, "Input",
 CellID->457198956],
Cell[5926, 210, 175, 5, 36, "Output",
 CellID->293503225]
}, Open  ]],
Cell[CellGroupData[{
Cell[6138, 220, 220, 8, 70, "Input",
 CellID->738826197],
Cell[6361, 230, 1048, 30, 54, "Output",
 CellID->236987222]
}, Open  ]],
Cell[7424, 263, 144, 4, 70, "ExampleText",
 CellID->113265255],
Cell[CellGroupData[{
Cell[7593, 271, 128, 4, 70, "Input",
 CellID->1047634426],
Cell[7724, 277, 202, 5, 36, "Output",
 CellID->391060560]
}, Open  ]],
Cell[7941, 285, 208, 8, 70, "ExampleText",
 CellID->173285343],
Cell[8152, 295, 96, 3, 70, "Input",
 CellID->250210368],
Cell[8251, 300, 354, 13, 70, "ExampleText",
 CellID->252966443],
Cell[CellGroupData[{
Cell[8630, 317, 218, 7, 70, "Input",
 CellID->187683075],
Cell[8851, 326, 1497, 50, 77, "Output",
 CellID->847162986]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10397, 382, 216, 7, 70, "ExampleSection",
 CellID->24111],
Cell[10616, 391, 69, 1, 70, "ExampleText",
 CellID->115669198],
Cell[10688, 394, 286, 10, 70, "Input",
 CellID->403860554],
Cell[CellGroupData[{
Cell[10999, 408, 624, 22, 70, "Input",
 CellID->285659367],
Cell[11626, 432, 1555, 30, 70, "Output",
 Evaluatable->False,
 CellID->130184409]
}, Open  ]],
Cell[CellGroupData[{
Cell[13218, 467, 209, 7, 70, "Input",
 CellID->561617340],
Cell[13430, 476, 3690, 65, 70, "Output",
 Evaluatable->False,
 CellID->110211571]
}, Open  ]],
Cell[CellGroupData[{
Cell[17157, 546, 130, 4, 70, "Input",
 CellID->191737306],
Cell[17290, 552, 198, 6, 36, "Output",
 CellID->538007301]
}, Open  ]],
Cell[17503, 561, 208, 8, 70, "ExampleText",
 CellID->194813328],
Cell[17714, 571, 96, 3, 70, "Input",
 CellID->264235711]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17859, 580, 311, 9, 70, "SeeAlsoSection",
 CellID->15098],
Cell[18173, 591, 461, 17, 70, "SeeAlso",
 CellID->15669]
}, Open  ]],
Cell[CellGroupData[{
Cell[18671, 613, 313, 9, 70, "TutorialsSection",
 CellID->5025],
Cell[18987, 624, 134, 3, 70, "Tutorials",
 CellID->6736],
Cell[19124, 629, 284, 9, 70, "Tutorials",
 CellID->522604605]
}, Open  ]],
Cell[CellGroupData[{
Cell[19445, 643, 319, 9, 70, "MoreAboutSection",
 CellID->114007506],
Cell[19767, 654, 153, 3, 70, "MoreAbout",
 CellID->184314920]
}, Open  ]],
Cell[19935, 660, 27, 0, 70, "History"],
Cell[19965, 662, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

