(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20305,        754]
NotebookOptionsPosition[     15703,        599]
NotebookOutlinePosition[     17238,        641]
CellTagsIndexPosition[     17153,        636]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"The Main Loop\"\>", 
       2->"\<\"Mathematica Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$Pre" :> Documentation`HelpLookup["paclet:ref/$Pre"], 
          "CellEvaluationFunction" :> 
          Documentation`HelpLookup["paclet:ref/CellEvaluationFunction"], 
          "StringReplace" :> 
          Documentation`HelpLookup["paclet:ref/StringReplace"], 
          "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], "InputAliases" :> 
          Documentation`HelpLookup["paclet:ref/InputAliases"], 
          "InputAutoReplacements" :> 
          Documentation`HelpLookup["paclet:ref/InputAutoReplacements"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"$Pre\"\>", 
       2->"\<\"CellEvaluationFunction\"\>", 3->"\<\"StringReplace\"\>", 
       4->"\<\"ToExpression\"\>", 5->"\<\"InputAliases\"\>", 
       6->"\<\"InputAutoReplacements\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$PreRead", "ObjectName",
 CellID->25113],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$PreRead",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
     "\[LineSeparator]is a global variable whose value, if set, is applied to \
the text or box form of every input expression before it is fed to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17577]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 " is always applied to each complete input string that will be fed to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->26543],

Cell[TextData[{
 "In multiline input with a text\[Hyphen]based interface, whenever each line \
is terminated, ",
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 " is typically applied to the input so far. "
}], "Notes",
 CellID->10925],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 " is applied to all strings returned by a ",
 Cell[BoxData[
  ButtonBox["$SyntaxHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SyntaxHandler"]], "InlineFormula"],
 " function. "
}], "Notes",
 CellID->30964],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 " is applied before ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InString"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " is assigned. "
}], "Notes",
 CellID->13840]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->723077791],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->360818836],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 " is not defined, meaning input strings are sent directly to evaluation:"
}], "ExampleText",
 CellID->289932834],

Cell[CellGroupData[{

Cell[BoxData["$PreRead"], "Input",
 CellLabel->"In[1]:=",
 CellID->614411681],

Cell[BoxData["$PreRead"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3644862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145113662],

Cell[TextData[{
 "Use hf as an alias for ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->98485506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$PreRead", "=", 
  RowBox[{
   RowBox[{"ReplaceAll", "[", 
    RowBox[{"#", ",", 
     RowBox[{"\"\<hf\>\"", "\[Rule]", "\"\<HoldForm\>\""}]}], "]"}], 
   "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488301475],

Cell[BoxData[
 RowBox[{
  RowBox[{"#1", "/.", "\[InvisibleSpace]", 
   RowBox[{"\<\"hf\"\>", "\[Rule]", "\<\"HoldForm\"\>"}]}], "&"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95200360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"hf", "[", 
    RowBox[{"2", "+", "3"}], "]"}], ",", 
   RowBox[{"hf", "[", 
    RowBox[{"2", "/", "3"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->132860003],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"2", "+", "3"}],
    HoldForm], ",", 
   TagBox[
    FractionBox["2", "3"],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{67, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->213891426]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->106124773],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{
     RowBox[{"HoldForm", "[", 
      RowBox[{"Plus", "[", 
       RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"HoldForm", "[", 
      RowBox[{"Times", "[", 
       RowBox[{"2", ",", 
        RowBox[{"Power", "[", 
         RowBox[{"3", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{414, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->532783366]
}, Open  ]],

Cell[TextData[{
 "Restore ",
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 " to its default value:"
}], "ExampleText",
 CellID->2890270],

Cell[BoxData[
 RowBox[{"$PreRead", "=."}]], "Input",
 CellLabel->"In[4]:=",
 CellID->134899990],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->301218473],

Cell[TextData[{
 "Have ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " print the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of parsed input expressions before evaluation:"
}], "ExampleText",
 CellID->67863],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PreRead", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"FullForm", "[", "#", "]"}], "]"}], ";", "#"}], ")"}], "&"}]}],
   ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176003988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "+", 
  SuperscriptBox["b", "2"]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->425980104],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"RowBox", "[", 
    RowBox[{"List", "[", 
     RowBox[{"\"\<a\>\"", ",", "\"\<+\>\"", ",", 
      RowBox[{"SuperscriptBox", "[", 
       RowBox[{"\"\<b\>\"", ",", "\"\<2\>\""}], "]"}]}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellLabel->"During evaluation of In[30]:=",
 CellID->365564383],

Cell[BoxData[
 RowBox[{"a", "+", 
  SuperscriptBox["b", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->839557249]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", " ", "b", 
  RowBox[{"(", 
   RowBox[{"c", "+", "d"}], ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->366174633],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"RowBox", "[", 
    RowBox[{"List", "[", 
     RowBox[{"\"\<a\>\"", ",", "\"\<b\>\"", ",", 
      RowBox[{"RowBox", "[", 
       RowBox[{"List", "[", 
        RowBox[{"\"\<(\>\"", ",", 
         RowBox[{"RowBox", "[", 
          RowBox[{"List", "[", 
           RowBox[{"\"\<c\>\"", ",", "\"\<+\>\"", ",", "\"\<d\>\""}], "]"}], 
          "]"}], ",", "\"\<)\>\""}], "]"}], "]"}]}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellLabel->"During evaluation of In[31]:=",
 CellID->5421813],

Cell[BoxData[
 RowBox[{"a", " ", "b", " ", 
  RowBox[{"(", 
   RowBox[{"c", "+", "d"}], ")"}]}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->97696964]
}, Open  ]],

Cell[TextData[{
 "Restore ",
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 " to its default value:"
}], "ExampleText",
 CellID->365350627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$PreRead", "=."}]], "Input",
 CellLabel->"In[4]:=",
 CellID->462135745],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"RowBox", "[", 
    RowBox[{"List", "[", 
     RowBox[{"\"\<$PreRead\>\"", ",", "\"\<=.\>\""}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellLabel->"During evaluation of In[32]:=",
 CellID->4276948]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25118],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Pre",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Pre"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellEvaluationFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEvaluationFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputAliases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputAliases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputAutoReplacements",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputAutoReplacements"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15545]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32216],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->1112],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->522604605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->157506265],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->16412866]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$PreRead - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 52.2778826}", "context" -> "System`", 
    "keywords" -> {
     "alias", "EBCDIC", "preprocessing input from keyboard", 
      "preprocessing input from terminals", 
      "preprocessing of special characters", 
      "processing before interactive reading", "processing before parsing", 
      "text macros"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$PreRead is a global variable whose value, if set, is applied to the \
text or box form of every input expression before it is fed to Mathematica. ",
     "synonyms" -> {"pre read"}, "title" -> "$PreRead", "type" -> "Symbol", 
    "uri" -> "ref/$PreRead"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5646, 183, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->723077791]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17010, 629}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2508, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3131, 85, 46, 1, 70, "ObjectName",
 CellID->25113],
Cell[3180, 88, 576, 17, 70, "Usage",
 CellID->17577]
}, Open  ]],
Cell[CellGroupData[{
Cell[3793, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4271, 127, 292, 10, 70, "Notes",
 CellID->26543],
Cell[4566, 139, 307, 9, 70, "Notes",
 CellID->10925],
Cell[4876, 150, 355, 12, 70, "Notes",
 CellID->30964],
Cell[5234, 164, 375, 14, 70, "Notes",
 CellID->13840]
}, Closed]],
Cell[CellGroupData[{
Cell[5646, 183, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->723077791],
Cell[CellGroupData[{
Cell[6031, 197, 148, 5, 70, "ExampleSection",
 CellID->360818836],
Cell[6182, 204, 265, 8, 70, "ExampleText",
 CellID->289932834],
Cell[CellGroupData[{
Cell[6472, 216, 77, 2, 28, "Input",
 CellID->614411681],
Cell[6552, 220, 163, 5, 36, "Output",
 CellID->3644862]
}, Open  ]],
Cell[6730, 228, 125, 3, 70, "ExampleDelimiter",
 CellID->145113662],
Cell[6858, 233, 205, 8, 70, "ExampleText",
 CellID->98485506],
Cell[CellGroupData[{
Cell[7088, 245, 240, 8, 70, "Input",
 CellID->488301475],
Cell[7331, 255, 275, 8, 36, "Output",
 CellID->95200360]
}, Open  ]],
Cell[CellGroupData[{
Cell[7643, 268, 225, 8, 70, "Input",
 CellID->132860003],
Cell[7871, 278, 303, 13, 51, "Output",
 CellID->213891426]
}, Open  ]],
Cell[CellGroupData[{
Cell[8211, 296, 104, 3, 70, "Input",
 CellID->106124773],
Cell[8318, 301, 644, 22, 50, "Output",
 CellID->532783366]
}, Open  ]],
Cell[8977, 326, 210, 8, 70, "ExampleText",
 CellID->2890270],
Cell[9190, 336, 95, 3, 70, "Input",
 CellID->134899990],
Cell[9288, 341, 125, 3, 70, "ExampleDelimiter",
 CellID->301218473],
Cell[9416, 346, 295, 11, 70, "ExampleText",
 CellID->67863],
Cell[9714, 359, 266, 10, 70, "Input",
 CellID->176003988],
Cell[CellGroupData[{
Cell[10005, 373, 116, 4, 70, "Input",
 CellID->425980104],
Cell[10124, 379, 421, 13, 70, "Print",
 CellID->365564383],
Cell[10548, 394, 204, 7, 36, "Output",
 CellID->839557249]
}, Open  ]],
Cell[CellGroupData[{
Cell[10789, 406, 144, 5, 70, "Input",
 CellID->366174633],
Cell[10936, 413, 614, 18, 70, "Print",
 CellID->5421813],
Cell[11553, 433, 236, 8, 36, "Output",
 CellID->97696964]
}, Open  ]],
Cell[11804, 444, 212, 8, 70, "ExampleText",
 CellID->365350627],
Cell[CellGroupData[{
Cell[12041, 456, 95, 3, 70, "Input",
 CellID->462135745],
Cell[12139, 461, 328, 11, 70, "Print",
 CellID->4276948]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12528, 479, 311, 9, 70, "SeeAlsoSection",
 CellID->25118],
Cell[12842, 490, 1503, 53, 70, "SeeAlso",
 CellID->15545]
}, Open  ]],
Cell[CellGroupData[{
Cell[14382, 548, 314, 9, 70, "TutorialsSection",
 CellID->32216],
Cell[14699, 559, 134, 3, 70, "Tutorials",
 CellID->1112],
Cell[14836, 564, 284, 9, 70, "Tutorials",
 CellID->522604605]
}, Open  ]],
Cell[CellGroupData[{
Cell[15157, 578, 319, 9, 70, "MoreAboutSection",
 CellID->157506265],
Cell[15479, 589, 152, 3, 70, "MoreAbout",
 CellID->16412866]
}, Open  ]],
Cell[15646, 595, 27, 0, 70, "History"],
Cell[15676, 597, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

