(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24269,        873]
NotebookOptionsPosition[     18736,        683]
NotebookOutlinePosition[     20050,        720]
CellTagsIndexPosition[     19965,        715]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/Evaluation"], 
          "Controlling Infinite Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ControllingInfiniteEvaluation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Evaluation\"\>", 
       2->"\<\"Controlling Infinite Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$IterationLimit" :> 
          Documentation`HelpLookup["paclet:ref/$IterationLimit"], 
          "MemoryConstrained" :> 
          Documentation`HelpLookup["paclet:ref/MemoryConstrained"], 
          "TimeConstrained" :> 
          Documentation`HelpLookup["paclet:ref/TimeConstrained"], 
          "MaxRecursion" :> 
          Documentation`HelpLookup["paclet:ref/MaxRecursion"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$IterationLimit\"\>", 
       2->"\<\"MemoryConstrained\"\>", 3->"\<\"TimeConstrained\"\>", 
       4->"\<\"MaxRecursion\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Evaluation Control\"\>", 
       2->"\<\"Global Computation Settings & Parameters\"\>", 
       3->"\<\"Mathematica Sessions\"\>", 
       4->"\<\"Mathematica System Setup\"\>", 
       5->"\<\"Memory Measurement & Optimization\"\>", 
       6->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$RecursionLimit", "ObjectName",
 CellID->4136],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$RecursionLimit",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
     "\[LineSeparator]gives the current limit on the number of levels of \
recursion that ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " can use. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7318]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"$RecursionLimit", "=", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " sets the limit on the number of recursion levels that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can use to be ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21979],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"$RecursionLimit", "=", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " removes any limit on the number of recursion levels. "
}], "Notes",
 CellID->10644],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 " gives the maximum length of the stack returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Stack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Stack"], "[", "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7742],

Cell["\<\
Each time the evaluation of a function requires the nested evaluation of the \
same or another function, one recursion level is used up. \
\>", "Notes",
 CellID->25968],

Cell[TextData[{
 "On most computers, each level of recursion uses a certain amount of stack \
space. ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 " allows you to control the amount of stack space that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can use from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". On some computer systems, your whole ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session may crash if you allow it to use more stack space than the \
computer system allows. "
}], "Notes",
 CellID->569],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MemoryInUse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemoryInUse"]], "InlineFormula"],
 " and related functions do not count stack space. "
}], "Notes",
 CellID->28396]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->634061570],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->258541341],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 " limits infinite recursion with circular definitions:"
}], "ExampleText",
 CellID->464822300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"x", "+", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394515242],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded.\"\>"}]], "Message", \
"MSG",
 CellID->283630651],

Cell[BoxData[
 RowBox[{"255", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "x"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160354394]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->426247176],

Cell[TextData[{
 "Temporarily reset ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->70467657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$RecursionLimit", "=", "1000"}], "}"}], ",", 
   RowBox[{"x", "=", 
    RowBox[{"x", "+", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->818636673],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(1000\\) exceeded.\"\>"}]], "Message", \
"MSG",
 CellID->104760701],

Cell[BoxData[
 RowBox[{"998", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "x"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202924652]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32322],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 " to keep going with the recursion:"
}], "ExampleText",
 CellID->199380079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"x", "+", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104126791],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Recursion depth of \\\\\\\"\\\", \\\
\"MSG\\\"]\\)\\!\\(256\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" \
exceeded.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet://Messages/$RecursionLimit/reclim\\\
\"]\\)\"\>"}]], "Message", "MSG",
 CellID->753555065],

Cell[BoxData[
 RowBox[{"255", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "x"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549896180]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->510979399],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Recursion depth of \\\\\\\"\\\", \\\
\"MSG\\\"]\\)\\!\\(256\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" \
exceeded.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet://Messages/$RecursionLimit/reclim\\\
\"]\\)\"\>"}]], "Message", "MSG",
 CellID->344437157],

Cell[BoxData[
 RowBox[{"510", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "x"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->163030207]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17407],

Cell[TextData[{
 "The recursion limit can be set to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 " to allow any number of recursion steps:"
}], "ExampleText",
 CellID->231470838],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "0", "]"}], "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"n", "-", "1"}], "]"}], "+", "1"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->16368944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$RecursionLimit", "=", "Infinity"}], "}"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"10", "^", "4"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8023482],

Cell[BoxData["10000"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->346755094]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32313],

Cell["\<\
The recursion limit protects against recursive runaway definitions:\
\>", "ExampleText",
 CellID->738962059],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Floor", "[", 
     RowBox[{"x", "/", "2"}], "]"}], "]"}], "+", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2125860283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "10", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1993220647],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded.\"\>"}]], "Message", \
"MSG",
 CellID->31692400],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded.\"\>"}]], "Message", \
"MSG",
 CellID->9495272],

Cell[BoxData[
 RowBox[{"255", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"Hold", "[", 
    RowBox[{"f", "[", 
     RowBox[{"Floor", "[", 
      FractionBox["0", "2"], "]"}], "]"}], "]"}], "]"}]}]], "Output",
 ImageSize->{203, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->43334947]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130488592],

Cell["The iteration limit protects against runaway definitions:", \
"ExampleText",
 CellID->450264515],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"f", "[", 
   RowBox[{"x", "+", "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1609391322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "1", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->268254547],

Cell[BoxData[
 RowBox[{
  RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], ":", 
  " ", "\<\"Iteration limit of \\!\\(4096\\) exceeded.\"\>"}]], "Message", \
"MSG",
 CellID->371547159],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"f", "[", 
   RowBox[{"4096", "+", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->250337450]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11968],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$IterationLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$IterationLimit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemoryConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemoryConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxRecursion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxRecursion"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6492]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20762],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "Tutorials",
 CellID->959752411],

Cell[TextData[ButtonBox["Controlling Infinite Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ControllingInfiniteEvaluation"]], "Tutorials",
 CellID->7532]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->372883610],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->280221874],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->175022758],

Cell[TextData[ButtonBox["Mathematica Sessions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessions"]], "MoreAbout",
 CellID->552572116],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->191569005],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->737063137],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->39158800]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$RecursionLimit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 59.7468238}", "context" -> "System`", 
    "keywords" -> {"stopping recursion", "infinite evaluation"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$RecursionLimit gives the current limit on the number of levels of \
recursion that Mathematica can use. ", "synonyms" -> {"recursion limit"}, 
    "title" -> "$RecursionLimit", "type" -> "Symbol", "uri" -> 
    "ref/$RecursionLimit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6989, 219, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->634061570]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19822, 708}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3198, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3821, 99, 52, 1, 70, "ObjectName",
 CellID->4136],
Cell[3876, 102, 540, 17, 70, "Usage",
 CellID->7318]
}, Open  ]],
Cell[CellGroupData[{
Cell[4453, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4931, 141, 331, 12, 70, "Notes",
 CellID->21979],
Cell[5265, 155, 261, 8, 70, "Notes",
 CellID->10644],
Cell[5529, 165, 377, 13, 70, "Notes",
 CellID->7742],
Cell[5909, 180, 178, 4, 70, "Notes",
 CellID->25968],
Cell[6090, 186, 637, 19, 70, "Notes",
 CellID->569],
Cell[6730, 207, 222, 7, 70, "Notes",
 CellID->28396]
}, Closed]],
Cell[CellGroupData[{
Cell[6989, 219, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->634061570],
Cell[CellGroupData[{
Cell[7374, 233, 148, 5, 70, "ExampleSection",
 CellID->258541341],
Cell[7525, 240, 244, 7, 70, "ExampleText",
 CellID->464822300],
Cell[CellGroupData[{
Cell[7794, 251, 115, 4, 70, "Input",
 CellID->394515242],
Cell[7912, 257, 187, 5, 19, "Message",
 CellID->283630651],
Cell[8102, 264, 238, 8, 36, "Output",
 CellID->160354394]
}, Open  ]],
Cell[8355, 275, 125, 3, 70, "ExampleDelimiter",
 CellID->426247176],
Cell[8483, 280, 214, 8, 70, "ExampleText",
 CellID->70467657],
Cell[CellGroupData[{
Cell[8722, 292, 239, 8, 70, "Input",
 CellID->818636673],
Cell[8964, 302, 188, 5, 70, "Message",
 CellID->104760701],
Cell[9155, 309, 238, 8, 36, "Output",
 CellID->202924652]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9442, 323, 216, 7, 70, "ExampleSection",
 CellID->32322],
Cell[9661, 332, 226, 8, 70, "ExampleText",
 CellID->199380079],
Cell[CellGroupData[{
Cell[9912, 344, 115, 4, 70, "Input",
 CellID->104126791],
Cell[10030, 350, 469, 9, 70, "Message",
 CellID->753555065],
Cell[10502, 361, 238, 8, 36, "Output",
 CellID->549896180]
}, Open  ]],
Cell[CellGroupData[{
Cell[10777, 374, 107, 3, 70, "Input",
 CellID->510979399],
Cell[10887, 379, 469, 9, 70, "Message",
 CellID->344437157],
Cell[11359, 390, 238, 8, 36, "Output",
 CellID->163030207]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11646, 404, 239, 7, 70, "ExampleSection",
 CellID->17407],
Cell[11888, 413, 211, 6, 70, "ExampleText",
 CellID->231470838],
Cell[12102, 421, 280, 10, 70, "Input",
 CellID->16368944],
Cell[CellGroupData[{
Cell[12407, 435, 247, 8, 70, "Input",
 CellID->8023482],
Cell[12657, 445, 162, 5, 36, "Output",
 CellID->346755094]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12868, 456, 233, 7, 70, "ExampleSection",
 CellID->32313],
Cell[13104, 465, 118, 3, 70, "ExampleText",
 CellID->738962059],
Cell[13225, 470, 235, 8, 70, "Input",
 CellID->2125860283],
Cell[CellGroupData[{
Cell[13485, 482, 99, 3, 70, "Input",
 CellID->1993220647],
Cell[13587, 487, 186, 5, 70, "Message",
 CellID->31692400],
Cell[13776, 494, 185, 5, 70, "Message",
 CellID->9495272],
Cell[13964, 501, 335, 11, 51, "Output",
 CellID->43334947]
}, Open  ]],
Cell[14314, 515, 125, 3, 70, "ExampleDelimiter",
 CellID->130488592],
Cell[14442, 520, 102, 2, 70, "ExampleText",
 CellID->450264515],
Cell[14547, 524, 175, 6, 70, "Input",
 CellID->1609391322],
Cell[CellGroupData[{
Cell[14747, 534, 97, 3, 70, "Input",
 CellID->268254547],
Cell[14847, 539, 187, 5, 70, "Message",
 CellID->371547159],
Cell[15037, 546, 244, 8, 36, "Output",
 CellID->250337450]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15342, 561, 311, 9, 70, "SeeAlsoSection",
 CellID->11968],
Cell[15656, 572, 994, 35, 70, "SeeAlso",
 CellID->6492]
}, Open  ]],
Cell[CellGroupData[{
Cell[16687, 612, 314, 9, 70, "TutorialsSection",
 CellID->20762],
Cell[17004, 623, 135, 3, 70, "Tutorials",
 CellID->959752411],
Cell[17142, 628, 170, 3, 70, "Tutorials",
 CellID->7532]
}, Open  ]],
Cell[CellGroupData[{
Cell[17349, 636, 319, 9, 70, "MoreAboutSection",
 CellID->372883610],
Cell[17671, 647, 147, 3, 70, "MoreAbout",
 CellID->280221874],
Cell[17821, 652, 193, 4, 70, "MoreAbout",
 CellID->175022758],
Cell[18017, 658, 151, 3, 70, "MoreAbout",
 CellID->552572116],
Cell[18171, 663, 158, 3, 70, "MoreAbout",
 CellID->191569005],
Cell[18332, 668, 177, 3, 70, "MoreAbout",
 CellID->737063137],
Cell[18512, 673, 152, 3, 70, "MoreAbout",
 CellID->39158800]
}, Open  ]],
Cell[18679, 679, 27, 0, 70, "History"],
Cell[18709, 681, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

