(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7470,        257]
NotebookOptionsPosition[      5682,        200]
NotebookOutlinePosition[      6786,        231]
CellTagsIndexPosition[      6743,        228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Representation of Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfSound"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"The Representation of Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Play" :> Documentation`HelpLookup["paclet:ref/Play"], 
          "ListPlay" :> Documentation`HelpLookup["paclet:ref/ListPlay"], 
          "Show" :> Documentation`HelpLookup["paclet:ref/Show"], 
          "$DisplayFunction" :> 
          Documentation`HelpLookup["paclet:ref/$DisplayFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Play\"\>", 2->"\<\"ListPlay\"\>", 
       3->"\<\"Show\"\>", 4->"\<\"$DisplayFunction\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$SoundDisplayFunction", "ObjectName",
 CellID->8399],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$SoundDisplayFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$SoundDisplayFunction"]], "InlineFormula"],
     "\[LineSeparator]gives the default setting for the option ",
     Cell[BoxData[
      ButtonBox["DisplayFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DisplayFunction"]], "InlineFormula"],
     " in sound functions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31512]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The initial setting of ",
 Cell[BoxData[
  ButtonBox["$SoundDisplayFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SoundDisplayFunction"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export",
     ButtonNote->"ObsLink: Display -> Export"], "[", 
    RowBox[{"$SoundDisplay", ",", "#"}], "]"}], "&"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21501]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26150],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Play",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Play"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlay",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlay"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Show",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Show"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$DisplayFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$DisplayFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16983]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16640],

Cell[TextData[ButtonBox["The Representation of Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfSound"]], "Tutorials",
 CellID->17934]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$SoundDisplayFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 0.6218462}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$SoundDisplayFunction gives the default setting for the option \
DisplayFunction in sound functions. ", 
    "synonyms" -> {"sound display function"}, "title" -> 
    "$SoundDisplayFunction", "type" -> "Symbol", "uri" -> 
    "ref/$SoundDisplayFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1490, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2113, 63, 58, 1, 70, "ObjectName",
 CellID->8399],
Cell[2174, 66, 629, 18, 70, "Usage",
 CellID->31512]
}, Open  ]],
Cell[CellGroupData[{
Cell[2840, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3318, 106, 484, 17, 70, "Notes",
 CellID->21501]
}, Closed]],
Cell[CellGroupData[{
Cell[3839, 128, 311, 9, 70, "SeeAlsoSection",
 CellID->26150],
Cell[4153, 139, 941, 35, 70, "SeeAlso",
 CellID->16983]
}, Open  ]],
Cell[CellGroupData[{
Cell[5131, 179, 314, 9, 70, "TutorialsSection",
 CellID->16640],
Cell[5448, 190, 162, 3, 70, "Tutorials",
 CellID->17934]
}, Open  ]],
Cell[5625, 196, 27, 0, 70, "History"],
Cell[5655, 198, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

