(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9935,        350]
NotebookOptionsPosition[      7692,        278]
NotebookOutlinePosition[      8813,        308]
CellTagsIndexPosition[      8770,        305]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematica Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SyntaxLength" :> 
          Documentation`HelpLookup["paclet:ref/SyntaxLength"], "SyntaxQ" :> 
          Documentation`HelpLookup["paclet:ref/SyntaxQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SyntaxLength\"\>", 
       2->"\<\"SyntaxQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$SyntaxHandler", "ObjectName",
 CellID->30776],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$SyntaxHandler",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$SyntaxHandler"]], "InlineFormula"],
     "\[LineSeparator]is a global variable which, if set, is applied to any \
input string that is found to contain a syntax error. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1699]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The arguments given to ",
 Cell[BoxData[
  ButtonBox["$SyntaxHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SyntaxHandler"]], "InlineFormula"],
 " are the complete input string and an integer specifying the character \
position at which the syntax error was detected. "
}], "Notes",
 CellID->23851],

Cell[TextData[{
 "The first character in the string is taken to have position ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32428],

Cell[TextData[{
 "Any string returned by ",
 Cell[BoxData[
  ButtonBox["$SyntaxHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SyntaxHandler"]], "InlineFormula"],
 " is used as a new version of the input string, and is fed to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If the string does not end with a newline, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " waits for input to complete the line. "
}], "Notes",
 CellID->27535],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["$SyntaxHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SyntaxHandler"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 ", input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is abandoned if possible. "
}], "Notes",
 CellID->11938],

Cell[TextData[{
 "Input is not assigned to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InString"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " until after ",
 Cell[BoxData[
  ButtonBox["$SyntaxHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SyntaxHandler"]], "InlineFormula"],
 " is applied. "
}], "Notes",
 CellID->3684],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$SyntaxHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SyntaxHandler"]], "InlineFormula"],
 " is not called for input from files obtained using ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24984]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1836],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SyntaxLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SyntaxLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SyntaxQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SyntaxQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23491]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2110],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->522604605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->196264375],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->907846323]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$SyntaxHandler - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 7.4970222}", "context" -> "System`", 
    "keywords" -> {"handling of syntax errors"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$SyntaxHandler is a global variable which, if set, is applied to any \
input string that is found to contain a syntax error. ", 
    "synonyms" -> {"syntax handler"}, "title" -> "$SyntaxHandler", "type" -> 
    "Symbol", "uri" -> "ref/$SyntaxHandler"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1845, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2468, 74, 52, 1, 70, "ObjectName",
 CellID->30776],
Cell[2523, 77, 504, 14, 70, "Usage",
 CellID->1699]
}, Open  ]],
Cell[CellGroupData[{
Cell[3064, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3542, 113, 329, 9, 70, "Notes",
 CellID->23851],
Cell[3874, 124, 153, 5, 70, "Notes",
 CellID->32428],
Cell[4030, 131, 460, 14, 70, "Notes",
 CellID->27535],
Cell[4493, 147, 410, 16, 70, "Notes",
 CellID->11938],
Cell[4906, 165, 409, 15, 70, "Notes",
 CellID->3684],
Cell[5318, 182, 346, 12, 70, "Notes",
 CellID->24984]
}, Closed]],
Cell[CellGroupData[{
Cell[5701, 199, 310, 9, 70, "SeeAlsoSection",
 CellID->1836],
Cell[6014, 210, 457, 17, 70, "SeeAlso",
 CellID->23491]
}, Open  ]],
Cell[CellGroupData[{
Cell[6508, 232, 313, 9, 70, "TutorialsSection",
 CellID->2110],
Cell[6824, 243, 284, 9, 70, "Tutorials",
 CellID->522604605]
}, Open  ]],
Cell[CellGroupData[{
Cell[7145, 257, 319, 9, 70, "MoreAboutSection",
 CellID->196264375],
Cell[7467, 268, 153, 3, 70, "MoreAbout",
 CellID->907846323]
}, Open  ]],
Cell[7635, 274, 27, 0, 70, "History"],
Cell[7665, 276, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

