(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11351,        390]
NotebookOptionsPosition[      8546,        297]
NotebookOutlinePosition[      9878,        335]
CellTagsIndexPosition[      9794,        330]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Raw Character Encodings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RawCharacterEncodings"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Raw Character Encodings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$CharacterEncoding"], 
          "CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/CharacterEncoding"], 
          "$CharacterEncodings" :> 
          Documentation`HelpLookup["paclet:ref/$CharacterEncodings"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"$CharacterEncoding\"\>", 
       2->"\<\"CharacterEncoding\"\>", 
       3->"\<\"$CharacterEncodings\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"International Character Sets" :> 
          Documentation`HelpLookup["paclet:guide/InternationalCharacterSets"],
           "Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"International Character Sets\"\>", 
       2->"\<\"Locale & Internationalization\"\>", 
       3->"\<\"System Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$SystemCharacterEncoding", "ObjectName",
 CellID->24519],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$SystemCharacterEncoding",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$SystemCharacterEncoding"]], "InlineFormula"],
     "\[LineSeparator]gives the default raw character encoding for the \
computer system on which ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " is being run. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2056]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$SystemCharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemCharacterEncoding"]], "InlineFormula"],
 " is used to determine the default value of ",
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26903],

Cell["\<\
The notebook front end handles raw character encodings independent of the \
kernel. \
\>", "Notes",
 CellID->16806],

Cell[TextData[{
 "The possible settings for ",
 Cell[BoxData[
  ButtonBox["$SystemCharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemCharacterEncoding"]], "InlineFormula"],
 " are the same as for ",
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26926]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->90301855],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->4172989],

Cell[CellGroupData[{

Cell[BoxData["$SystemCharacterEncoding"], "Input",
 CellLabel->"In[1]:=",
 CellID->271592708],

Cell[BoxData["\<\"WindowsANSI\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160621366]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2977],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CharacterEncodings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CharacterEncodings"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22797]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12712],

Cell[TextData[ButtonBox["Raw Character Encodings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RawCharacterEncodings"]], "Tutorials",
 CellID->25334]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->396514064],

Cell[TextData[ButtonBox["International Character Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InternationalCharacterSets"]], "MoreAbout",
 CellID->392424179],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->431533844],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->141039725]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$SystemCharacterEncoding - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 7.6845270}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$SystemCharacterEncoding gives the default raw character encoding for \
the computer system on which Mathematica is being run. ", 
    "synonyms" -> {"system character encoding"}, "title" -> 
    "$SystemCharacterEncoding", "type" -> "Symbol", "uri" -> 
    "ref/$SystemCharacterEncoding"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5160, 166, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->90301855]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9652, 323}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2433, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3056, 86, 62, 1, 70, "ObjectName",
 CellID->24519],
Cell[3121, 89, 571, 17, 70, "Usage",
 CellID->2056]
}, Open  ]],
Cell[CellGroupData[{
Cell[3729, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4207, 128, 388, 12, 70, "Notes",
 CellID->26903],
Cell[4598, 142, 125, 4, 70, "Notes",
 CellID->16806],
Cell[4726, 148, 397, 13, 70, "Notes",
 CellID->26926]
}, Closed]],
Cell[CellGroupData[{
Cell[5160, 166, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->90301855],
Cell[CellGroupData[{
Cell[5544, 180, 146, 5, 70, "ExampleSection",
 CellID->4172989],
Cell[CellGroupData[{
Cell[5715, 189, 93, 2, 28, "Input",
 CellID->271592708],
Cell[5811, 193, 176, 5, 36, "Output",
 CellID->160621366]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6048, 205, 310, 9, 70, "SeeAlsoSection",
 CellID->2977],
Cell[6361, 216, 756, 26, 70, "SeeAlso",
 CellID->22797]
}, Open  ]],
Cell[CellGroupData[{
Cell[7154, 247, 314, 9, 70, "TutorialsSection",
 CellID->12712],
Cell[7471, 258, 155, 3, 70, "Tutorials",
 CellID->25334]
}, Open  ]],
Cell[CellGroupData[{
Cell[7663, 266, 319, 9, 70, "MoreAboutSection",
 CellID->396514064],
Cell[7985, 277, 166, 3, 70, "MoreAbout",
 CellID->392424179],
Cell[8154, 282, 170, 3, 70, "MoreAbout",
 CellID->431533844],
Cell[8327, 287, 147, 3, 70, "MoreAbout",
 CellID->141039725]
}, Open  ]],
Cell[8489, 293, 27, 0, 70, "History"],
Cell[8519, 295, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

