(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15066,        553]
NotebookOptionsPosition[     11219,        421]
NotebookOutlinePosition[     12580,        460]
CellTagsIndexPosition[     12495,        455]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date and Time Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DateAndTimeFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Date and Time Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RefreshRate" :> 
          Documentation`HelpLookup["paclet:ref/RefreshRate"], "AbsoluteTime" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTime"], 
          "AbsoluteTiming" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTiming"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RefreshRate\"\>", 
       2->"\<\"AbsoluteTime\"\>", 
       3->"\<\"AbsoluteTiming\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"], 
          "Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"System Information\"\>", 
       2->"\<\"Time Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$TimeUnit", "ObjectName",
 CellID->11795],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$TimeUnit",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
     "\[LineSeparator]gives the minimum time interval in seconds recorded on \
your computer system. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19434]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typical values for ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 " are 1/100 and 1/1000. "
}], "Notes",
 CellID->19228],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 " determines the minimum granularity of measurement in functions like ",
 Cell[BoxData[
  ButtonBox["Timing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Timing"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25746],

Cell[TextData[{
 "In some functions the actual time granularity may be much smaller than ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12156]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->94666220],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->67976754],

Cell["The timing granularity on this machine:", "ExampleText",
 CellID->34570414],

Cell[CellGroupData[{

Cell[BoxData["$TimeUnit"], "Input",
 CellLabel->"In[1]:=",
 CellID->458287672],

Cell[BoxData[
 FractionBox["1", "1000"]], "Output",
 ImageSize->{37, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->610814410]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->445827821],

Cell[TextData[{
 "When a computation takes less than ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 " seconds, repeat to get a better timing:"
}], "ExampleText",
 CellID->160635095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Total", "[", 
   RowBox[{"N", "[", 
    RowBox[{"Range", "[", "1234", "]"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->185375605],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.4016565685892601`*^-14", ",", "761995.`"}], "}"}]], "Output",
 ImageSize->{171, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->301279823]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"First", "[", "%", "]"}], " ", "<", " ", "$TimeUnit"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->427742769],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5663274]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"reps", " ", "=", " ", "100000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"time", ",", "res"}], "}"}], "=", 
  RowBox[{"Timing", "[", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"N", "[", 
       RowBox[{"Range", "[", "1234", "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", "reps", "}"}]}], "]"}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->16317638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.3509999999999944`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->466039315]
}, Open  ]],

Cell["\<\
Divide by the number of repetitions to get the average timing:\
\>", "ExampleText",
 CellID->207149569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"time", "/", "reps"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->139030287],

Cell[BoxData["0.000013509999999999945`"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->31540389]
}, Open  ]],

Cell["You may want to time just a part of the computation:", "ExampleText",
 CellID->353963640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{
   RowBox[{"x", " ", "=", " ", 
    RowBox[{"N", "[", 
     RowBox[{"Range", "[", "1234", "]"}], "]"}]}], ";", 
   RowBox[{"First", "[", 
    RowBox[{
     RowBox[{"Timing", "[", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"Total", "[", "x", "]"}], ",", 
        RowBox[{"{", "reps", "}"}]}], "]"}], "]"}], "/", "reps"}], "]"}]}], 
  ")"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->238661136],

Cell[BoxData["3.8099999999999224`*^-6"], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->141814551]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3685],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RefreshRate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RefreshRate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTiming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTiming"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12992]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13197],

Cell[TextData[ButtonBox["Date and Time Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DateAndTimeFunctions"]], "Tutorials",
 CellID->14556]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->71715090],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->434848663],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->106893395]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$TimeUnit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 9.2314416}", "context" -> "System`", 
    "keywords" -> {
     "accuracy in timing", "beat", "clicks", 
      "granularity of time measurement", "quantization of time measurement", 
      "tick"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "$TimeUnit gives the minimum time interval in seconds recorded on your \
computer system. ", "synonyms" -> {"time unit"}, "title" -> "$TimeUnit", 
    "type" -> "Symbol", "uri" -> "ref/$TimeUnit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4836, 162, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->94666220]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12353, 448}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2189, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2812, 81, 47, 1, 70, "ObjectName",
 CellID->11795],
Cell[2862, 84, 464, 14, 70, "Usage",
 CellID->19434]
}, Open  ]],
Cell[CellGroupData[{
Cell[3363, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3841, 120, 216, 8, 70, "Notes",
 CellID->19228],
Cell[4060, 130, 489, 17, 70, "Notes",
 CellID->25746],
Cell[4552, 149, 247, 8, 70, "Notes",
 CellID->12156]
}, Closed]],
Cell[CellGroupData[{
Cell[4836, 162, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->94666220],
Cell[CellGroupData[{
Cell[5220, 176, 147, 5, 70, "ExampleSection",
 CellID->67976754],
Cell[5370, 183, 81, 1, 70, "ExampleText",
 CellID->34570414],
Cell[CellGroupData[{
Cell[5476, 188, 78, 2, 28, "Input",
 CellID->458287672],
Cell[5557, 192, 181, 6, 51, "Output",
 CellID->610814410]
}, Open  ]],
Cell[5753, 201, 125, 3, 70, "ExampleDelimiter",
 CellID->445827821],
Cell[5881, 206, 259, 8, 70, "ExampleText",
 CellID->160635095],
Cell[CellGroupData[{
Cell[6165, 218, 200, 6, 70, "Input",
 CellID->185375605],
Cell[6368, 226, 234, 7, 39, "Output",
 CellID->301279823]
}, Open  ]],
Cell[CellGroupData[{
Cell[6639, 238, 142, 4, 70, "Input",
 CellID->427742769],
Cell[6784, 244, 159, 5, 36, "Output",
 CellID->5663274]
}, Open  ]],
Cell[CellGroupData[{
Cell[6980, 254, 455, 14, 70, "Input",
 CellID->16317638],
Cell[7438, 270, 224, 7, 36, "Output",
 CellID->466039315]
}, Open  ]],
Cell[7677, 280, 113, 3, 70, "ExampleText",
 CellID->207149569],
Cell[CellGroupData[{
Cell[7815, 287, 98, 3, 70, "Input",
 CellID->139030287],
Cell[7916, 292, 180, 5, 36, "Output",
 CellID->31540389]
}, Open  ]],
Cell[8111, 300, 95, 1, 70, "ExampleText",
 CellID->353963640],
Cell[CellGroupData[{
Cell[8231, 305, 448, 15, 70, "Input",
 CellID->238661136],
Cell[8682, 322, 180, 5, 36, "Output",
 CellID->141814551]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8923, 334, 310, 9, 70, "SeeAlsoSection",
 CellID->3685],
Cell[9236, 345, 722, 26, 70, "SeeAlso",
 CellID->12992]
}, Open  ]],
Cell[CellGroupData[{
Cell[9995, 376, 314, 9, 70, "TutorialsSection",
 CellID->13197],
Cell[10312, 387, 154, 3, 70, "Tutorials",
 CellID->14556]
}, Open  ]],
Cell[CellGroupData[{
Cell[10503, 395, 318, 9, 70, "MoreAboutSection",
 CellID->71715090],
Cell[10824, 406, 147, 3, 70, "MoreAbout",
 CellID->434848663],
Cell[10974, 411, 173, 3, 70, "MoreAbout",
 CellID->106893395]
}, Open  ]],
Cell[11162, 417, 27, 0, 70, "History"],
Cell[11192, 419, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

