(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13356,        440]
NotebookOptionsPosition[     10924,        360]
NotebookOutlinePosition[     11942,        389]
CellTagsIndexPosition[     11899,        386]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date and Time Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DateAndTimeFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Date and Time Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TimeZone" :> Documentation`HelpLookup["paclet:ref/TimeZone"], 
          "AbsoluteTime" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTime"], "DateList" :> 
          Documentation`HelpLookup["paclet:ref/DateList"], "DateString" :> 
          Documentation`HelpLookup["paclet:ref/DateString"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TimeZone\"\>", 
       2->"\<\"AbsoluteTime\"\>", 3->"\<\"DateList\"\>", 
       4->"\<\"DateString\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Date & Time\"\>", 
       2->"\<\"Locale & Internationalization\"\>", 
       3->"\<\"Mathematica Sessions\"\>", 
       4->"\<\"Mathematica System Setup\"\>", 
       5->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["$TimeZone", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$TimeZone",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$TimeZone"]], "InlineFormula"],
     "\[LineSeparator]gives the current time zone to assume for dates and \
times. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6442]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The time zone gives the number of hours which must be added to Greenwich Mean \
Time (GMT) to obtain local time. \
\>", "Notes",
 CellID->8181],

Cell[TextData[{
 "U.S. Eastern Standard Time (EST) corresponds to time zone ",
 Cell[BoxData[
  RowBox[{"-", "5"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24209],

Cell[TextData[{
 "Daylight Saving Time corrections must be included in the time zone, so U.S. \
Eastern Daylight Time (EDT) corresponds to time zone ",
 Cell[BoxData[
  RowBox[{"-", "4"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3312],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$TimeZone",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeZone"]], "InlineFormula"],
 " is set at the beginning of your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session to the time zone specified by your computer operating system."
}], "Notes",
 CellID->22954],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"$TimeZone", "=", 
   StyleBox["z", "TI"]}]], "InlineFormula"],
 " resets the current time zone for purposes of functions like ",
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AbsoluteTime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTime"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26791],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["$TimeZone",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeZone"]], "InlineFormula"],
 " need not be integers."
}], "Notes",
 CellID->9762],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that the time returned by the system clock on your computer system \
is for the time zone corresponding to ",
 Cell[BoxData[
  ButtonBox["$TimeZone",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeZone"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->569]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32060],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeZone",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeZone"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5475]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3618],

Cell[TextData[ButtonBox["Date and Time Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DateAndTimeFunctions"]], "Tutorials",
 CellID->11385]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->325612730],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->400287140],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->327599039],

Cell[TextData[ButtonBox["Mathematica Sessions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessions"]], "MoreAbout",
 CellID->436265126],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->91387833],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->370069977]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$TimeZone - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 9.5126988}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$TimeZone gives the current time zone to assume for dates and times. ", 
    "synonyms" -> {"time zone"}, "title" -> "$TimeZone", "type" -> "Symbol", 
    "uri" -> "ref/$TimeZone"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2703, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3326, 90, 1574, 37, 70, "ObjectNameGrid"],
Cell[4903, 129, 445, 14, 70, "Usage",
 CellID->6442]
}, Open  ]],
Cell[CellGroupData[{
Cell[5385, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5863, 165, 153, 4, 70, "Notes",
 CellID->8181],
Cell[6019, 171, 169, 6, 70, "Notes",
 CellID->24209],
Cell[6191, 179, 241, 7, 70, "Notes",
 CellID->3312],
Cell[6435, 188, 326, 10, 70, "Notes",
 CellID->22954],
Cell[6764, 200, 590, 21, 70, "Notes",
 CellID->26791],
Cell[7357, 223, 208, 8, 70, "Notes",
 CellID->9762],
Cell[7568, 233, 338, 11, 70, "Notes",
 CellID->569]
}, Closed]],
Cell[CellGroupData[{
Cell[7943, 249, 311, 9, 70, "SeeAlsoSection",
 CellID->32060],
Cell[8257, 260, 952, 35, 70, "SeeAlso",
 CellID->5475]
}, Open  ]],
Cell[CellGroupData[{
Cell[9246, 300, 313, 9, 70, "TutorialsSection",
 CellID->3618],
Cell[9562, 311, 154, 3, 70, "Tutorials",
 CellID->11385]
}, Open  ]],
Cell[CellGroupData[{
Cell[9753, 319, 319, 9, 70, "MoreAboutSection",
 CellID->325612730],
Cell[10075, 330, 134, 3, 70, "MoreAbout",
 CellID->400287140],
Cell[10212, 335, 170, 3, 70, "MoreAbout",
 CellID->327599039],
Cell[10385, 340, 151, 3, 70, "MoreAbout",
 CellID->436265126],
Cell[10539, 345, 157, 3, 70, "MoreAbout",
 CellID->91387833],
Cell[10699, 350, 153, 3, 70, "MoreAbout",
 CellID->370069977]
}, Open  ]],
Cell[10867, 356, 27, 0, 70, "History"],
Cell[10897, 358, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

