(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19483,        635]
NotebookOptionsPosition[     15219,        503]
NotebookOutlinePosition[     17052,        548]
CellTagsIndexPosition[     16967,        543]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Naming and Finding Files" :> 
          Documentation`HelpLookup["paclet:tutorial/NamingAndFindingFiles"], 
          "Mathematica File Organization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicaFileOrganization"], 
          "System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"], 
          "System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Naming and Finding Files\"\>", 
       2->"\<\"Mathematica File Organization\"\>", 
       3->"\<\"System Administration for Single-User Licenses\"\>", 
       4->"\<\"System Administration for Network Licenses\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$BaseDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$BaseDirectory"], 
          "$InitialDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$InitialDirectory"], 
          "$HomeDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$HomeDirectory"], 
          "$InstallationDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$InstallationDirectory"], 
          "$UserName" :> Documentation`HelpLookup["paclet:ref/$UserName"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"$BaseDirectory\"\>", 
       2->"\<\"$InitialDirectory\"\>", 3->"\<\"$HomeDirectory\"\>", 
       4->"\<\"$InstallationDirectory\"\>", 
       5->"\<\"$UserName\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"Mathematica System Setup\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$UserBaseDirectory", "ObjectName",
 CellID->19596],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$UserBaseDirectory",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
     "\[LineSeparator]gives the base directory in which user\[Hyphen]specific \
files to be loaded by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " are conventionally placed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2339]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " returns the full name of the directory as a string. "
}], "Notes",
 CellID->15546],

Cell["Typical values are: ", "Notes",
 CellID->31318],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"C", ":", 
     RowBox[{
      RowBox[{"\[Backslash]", "Documents"}], "\[SpaceIndicator]", "and", 
      "\[SpaceIndicator]", 
      RowBox[{"Settings", "\[Backslash]", 
       StyleBox["username", "TI"], "\[Backslash]", "Application"}], 
      "\[SpaceIndicator]", 
      RowBox[{"Data", "\[Backslash]", 
       StyleBox["Mathematica",
        FontSlant->"Plain"]}]}]}], "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell["Windows ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"~", 
      RowBox[{"/", "Library"}]}], "/", 
     StyleBox["Mathematica",
      FontSlant->"Plain"]}], Cell["Macintosh ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"~", 
     RowBox[{"/.", 
      StyleBox["Mathematica",
       FontSlant->"Plain"]}]}], Cell["Unix ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, False, True, True, True}}}},
 CellID->15118],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " can be specified by setting the ",
 Cell[BoxData["MATHEMATICA_USERBASE"], "InlineCode"],
 " operating system environment variable when the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel is launched. It cannot be reset from inside the kernel. "
}], "Notes",
 CellID->17453],

Cell[TextData[{
 "Typical subdirectories of ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->24361],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "Applications", Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " application packages "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Autoload", Cell[
    "packages to be autoloaded on startup ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "FrontEnd", Cell[
    "front end initialization files ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Kernel", Cell[
    "kernel initialization files ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Licensing", Cell[
    "license management files ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "SystemFiles", Cell[
    "general system files ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->25245],

Cell[TextData[{
 "These subdirectories are, if possible, created automatically the first time \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is run by a given user. "
}], "Notes",
 CellID->13489],

Cell[TextData[{
 "Appropriate subdirectories are automatically included on ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23574],

Cell[TextData[{
 "The subdirectories of ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " are given in ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 " before the corresponding subdirectories of ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13369]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34264174],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->37135361],

Cell["The base directory in which user-specific files are placed:", \
"ExampleText",
 CellID->904142163],

Cell[CellGroupData[{

Cell[BoxData["$UserBaseDirectory"], "Input",
 CellLabel->"In[1]:=",
 CellID->323047369],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Application Data\\\
\\Mathematica\"\>"], "Output",
 ImageSize->{424, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19961211]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1453145935],

Cell[TextData[{
 "Subdirectories and files of ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->1484427362],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "$UserBaseDirectory", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->879122256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->824052289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Applications\"\>", ",", "\<\"Autoload\"\>", 
   ",", "\<\"DatabaseResources\"\>", ",", "\<\"FrontEnd\"\>", 
   ",", "\<\"Kernel\"\>", ",", "\<\"Licensing\"\>", ",", "\<\"Paclets\"\>", 
   ",", "\<\"SystemFiles\"\>"}], "}"}]], "Output",
 ImageSize->{350, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->525930503]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1839695861]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20527],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$BaseDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$BaseDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$InitialDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$InitialDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$HomeDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$HomeDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$InstallationDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$InstallationDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$UserName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$UserName"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30789]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2896],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->18490],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"],
  FontSlant->"Italic"],
 ButtonBox[" File Organization",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"]
}], "Tutorials",
 CellID->126070248],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"Tutorials",
 CellID->34241995],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"Tutorials",
 CellID->157642292]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->44049298],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->164055483],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->470126055]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$UserBaseDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 15.9816144}", "context" -> "System`", 
    "keywords" -> {
     "user directory", "base directory", "user preferences directorry", 
      "user addons directory", "user package directory", 
      "user paletter directory", "user stylesheet directory", 
      "user init file directory", "user application directory", 
      "user settings directory", "user options directory", 
      "applications directory", "preferences directorry", "addons directory", 
      "package directory", "paletter directory", "stylesheet directory", 
      "init file directory", "application directory"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$UserBaseDirectory gives the base directory in which user-specific files \
to be loaded by Mathematica are conventionally placed. ", 
    "synonyms" -> {"user base directory"}, "title" -> "$UserBaseDirectory", 
    "type" -> "Symbol", "uri" -> "ref/$UserBaseDirectory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9387, 282, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->34264174]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16825, 536}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3181, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3804, 99, 56, 1, 70, "ObjectName",
 CellID->19596],
Cell[3863, 102, 576, 17, 70, "Usage",
 CellID->2339]
}, Open  ]],
Cell[CellGroupData[{
Cell[4476, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4954, 141, 240, 7, 70, "Notes",
 CellID->15546],
Cell[5197, 150, 53, 1, 70, "Notes",
 CellID->31318],
Cell[5253, 153, 1292, 33, 70, "2ColumnTableMod",
 CellID->15118],
Cell[6548, 188, 463, 13, 70, "Notes",
 CellID->17453],
Cell[7014, 203, 224, 8, 70, "Notes",
 CellID->24361],
Cell[7241, 213, 1142, 25, 70, "2ColumnTableMod",
 CellID->25245],
Cell[8386, 240, 205, 7, 70, "Notes",
 CellID->13489],
Cell[8594, 249, 225, 8, 70, "Notes",
 CellID->23574],
Cell[8822, 259, 528, 18, 70, "Notes",
 CellID->13369]
}, Closed]],
Cell[CellGroupData[{
Cell[9387, 282, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34264174],
Cell[CellGroupData[{
Cell[9771, 296, 147, 5, 70, "ExampleSection",
 CellID->37135361],
Cell[9921, 303, 104, 2, 70, "ExampleText",
 CellID->904142163],
Cell[CellGroupData[{
Cell[10050, 309, 87, 2, 28, "Input",
 CellID->323047369],
Cell[10140, 313, 239, 6, 36, "Output",
 CellID->19961211]
}, Open  ]],
Cell[10394, 322, 126, 3, 70, "ExampleDelimiter",
 CellID->1453145935],
Cell[10523, 327, 233, 8, 70, "ExampleText",
 CellID->1484427362],
Cell[10759, 337, 143, 4, 70, "Input",
 CellID->879122256],
Cell[CellGroupData[{
Cell[10927, 345, 100, 3, 70, "Input",
 CellID->824052289],
Cell[11030, 350, 410, 10, 54, "Output",
 CellID->525930503]
}, Open  ]],
Cell[11455, 363, 124, 4, 70, "Input",
 CellID->1839695861]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11628, 373, 311, 9, 70, "SeeAlsoSection",
 CellID->20527],
Cell[11942, 384, 1258, 44, 70, "SeeAlso",
 CellID->30789]
}, Open  ]],
Cell[CellGroupData[{
Cell[13237, 433, 313, 9, 70, "TutorialsSection",
 CellID->2896],
Cell[13553, 444, 156, 3, 70, "Tutorials",
 CellID->18490],
Cell[13712, 449, 309, 9, 70, "Tutorials",
 CellID->126070248],
Cell[14024, 460, 214, 5, 70, "Tutorials",
 CellID->34241995],
Cell[14241, 467, 208, 5, 70, "Tutorials",
 CellID->157642292]
}, Open  ]],
Cell[CellGroupData[{
Cell[14486, 477, 318, 9, 70, "MoreAboutSection",
 CellID->44049298],
Cell[14807, 488, 179, 3, 70, "MoreAbout",
 CellID->164055483],
Cell[14989, 493, 158, 3, 70, "MoreAbout",
 CellID->470126055]
}, Open  ]],
Cell[15162, 499, 27, 0, 70, "History"],
Cell[15192, 501, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

