(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15114,        538]
NotebookOptionsPosition[     11663,        423]
NotebookOutlinePosition[     12972,        460]
CellTagsIndexPosition[     12887,        455]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interrupts and Aborts" :> 
          Documentation`HelpLookup["paclet:tutorial/InterruptsAndAborts"], 
          "Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/Evaluation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interrupts and Aborts\"\>", 
       2->"\<\"Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abort" :> Documentation`HelpLookup["paclet:ref/Abort"], 
          "Check" :> Documentation`HelpLookup["paclet:ref/Check"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Abort\"\>", 
       2->"\<\"Check\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"], 
          "Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Flow Control\"\>", 
       2->"\<\"Package Bulletproofing\"\>", 
       3->"\<\"Package Development\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AbortProtect", "ObjectName",
 CellID->27350],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbortProtect",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbortProtect"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", saving any aborts until the evaluation is complete. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1150]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Aborts that are generated during an ",
 Cell[BoxData[
  ButtonBox["AbortProtect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbortProtect"]], "InlineFormula"],
 " take effect as soon as the execution of the ",
 Cell[BoxData[
  ButtonBox["AbortProtect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbortProtect"]], "InlineFormula"],
 " is over. "
}], "Notes",
 CellID->16941],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 " can be used inside ",
 Cell[BoxData[
  ButtonBox["AbortProtect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbortProtect"]], "InlineFormula"],
 " to catch and absorb any aborts that occur. "
}], "Notes",
 CellID->21724],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbortProtect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbortProtect"]], "InlineFormula"],
 " also protects against aborts generated by ",
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MemoryConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemoryConstrained"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13966]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89619377],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->121280134],

Cell["Protect part of a computation from early termination:", "ExampleText",
 CellID->215411818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AbortProtect", "[", 
   RowBox[{
    RowBox[{"Abort", "[", "]"}], ";", 
    RowBox[{"Print", "[", "a", "]"}]}], "]"}], ";", 
  RowBox[{"Print", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22966020],

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->283031376],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136634863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53872871],

Cell["\<\
Make sure that an iteration is finished in a time-constrained computation:\
\>", "ExampleText",
 CellID->104824094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"TimeConstrained", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", "=", " ", 
      RowBox[{"1", "/", "10"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AbortProtect", "[", 
        RowBox[{
         RowBox[{"imax", "=", "i"}], ";", 
         RowBox[{"x", "=", 
          RowBox[{"4", " ", "x", 
           RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1000000"}], "}"}]}], "]"}]}], ",", "1"}], "]"}], 
  ";", 
  RowBox[{"{", 
   RowBox[{"imax", ",", 
    RowBox[{"N", "[", "x", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->588730011],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"22", ",", "0.9673370406238253`"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->412024366]
}, Open  ]],

Cell[TextData[{
 "Without ",
 Cell[BoxData[
  ButtonBox["AbortProtect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbortProtect"]], "InlineFormula"],
 ", typically ",
 Cell[BoxData[
  StyleBox["imax", "TI"]], "InlineFormula"],
 " is updated, but not ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->115748730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"TimeConstrained", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "=", " ", 
        RowBox[{"1", "/", "10"}]}], ";", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"imax", "=", "i"}], ";", 
          RowBox[{"x", "=", 
           RowBox[{"4", " ", "x", 
            RowBox[{"(", 
             RowBox[{"1", "-", "x"}], ")"}]}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1000000"}], "}"}]}], "]"}]}], ",", ".5"}], "]"}],
     ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"imax", ",", 
      RowBox[{"N", "[", "x", "]"}]}], "}"}]}], ",", 
   RowBox[{"{", "4", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->416593214],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"21", ",", "0.8200138734059479`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "0.5903644833108878`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "0.8200138734059479`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "0.5903644833108878`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{433, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77467303]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11337],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Check",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Check"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3430],

Cell[TextData[ButtonBox["Interrupts and Aborts",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/InterruptsAndAborts"]], "Tutorials",
 CellID->31107],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "Tutorials",
 CellID->959752411]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->247415082],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->84019464],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->22962311]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AbortProtect - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 15.5631224}", "context" -> "System`", 
    "keywords" -> {
     "critical section", "uninterruptible code", "prevent termination"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "AbortProtect[expr] evaluates expr, saving any aborts until the \
evaluation is complete. ", "synonyms" -> {"abort protect"}, "title" -> 
    "AbortProtect", "type" -> "Symbol", "uri" -> "ref/AbortProtect"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5303, 174, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->89619377]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12745, 448}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2201, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2824, 80, 50, 1, 70, "ObjectName",
 CellID->27350],
Cell[2877, 83, 593, 18, 70, "Usage",
 CellID->1150]
}, Open  ]],
Cell[CellGroupData[{
Cell[3507, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3985, 123, 403, 13, 70, "Notes",
 CellID->16941],
Cell[4391, 138, 367, 12, 70, "Notes",
 CellID->21724],
Cell[4761, 152, 505, 17, 70, "Notes",
 CellID->13966]
}, Closed]],
Cell[CellGroupData[{
Cell[5303, 174, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89619377],
Cell[CellGroupData[{
Cell[5687, 188, 148, 5, 70, "ExampleSection",
 CellID->121280134],
Cell[5838, 195, 96, 1, 70, "ExampleText",
 CellID->215411818],
Cell[CellGroupData[{
Cell[5959, 200, 249, 8, 70, "Input",
 CellID->22966020],
Cell[6211, 210, 91, 2, 23, "Print",
 CellID->283031376],
Cell[6305, 214, 165, 5, 36, "Output",
 CellID->136634863]
}, Open  ]],
Cell[6485, 222, 124, 3, 70, "ExampleDelimiter",
 CellID->53872871],
Cell[6612, 227, 125, 3, 70, "ExampleText",
 CellID->104824094],
Cell[CellGroupData[{
Cell[6762, 234, 689, 23, 70, "Input",
 CellID->588730011],
Cell[7454, 259, 223, 7, 36, "Output",
 CellID->412024366]
}, Open  ]],
Cell[7692, 269, 359, 14, 70, "ExampleText",
 CellID->115748730],
Cell[CellGroupData[{
Cell[8076, 287, 781, 25, 70, "Input",
 CellID->416593214],
Cell[8860, 314, 495, 15, 36, "Output",
 CellID->77467303]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9416, 336, 311, 9, 70, "SeeAlsoSection",
 CellID->11337],
Cell[9730, 347, 437, 17, 70, "SeeAlso",
 CellID->153]
}, Open  ]],
Cell[CellGroupData[{
Cell[10204, 369, 313, 9, 70, "TutorialsSection",
 CellID->3430],
Cell[10520, 380, 151, 3, 70, "Tutorials",
 CellID->31107],
Cell[10674, 385, 135, 3, 70, "Tutorials",
 CellID->959752411]
}, Open  ]],
Cell[CellGroupData[{
Cell[10846, 393, 299, 8, 70, "MoreAboutSection"],
Cell[11148, 403, 135, 3, 70, "MoreAbout",
 CellID->247415082],
Cell[11286, 408, 154, 3, 70, "MoreAbout",
 CellID->84019464],
Cell[11443, 413, 148, 3, 70, "MoreAbout",
 CellID->22962311]
}, Open  ]],
Cell[11606, 419, 27, 0, 70, "History"],
Cell[11636, 421, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

