(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15861,        491]
NotebookOptionsPosition[     12874,        399]
NotebookOutlinePosition[     14501,        442]
CellTagsIndexPosition[     14416,        437]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], 
          "AbsoluteOptions" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CurrentValue\"\>", 
       2->"\<\"AbsoluteOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Interface Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelInterfaceControl"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Interface Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AbsoluteCurrentValue", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteCurrentValue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteCurrentValue"], "[", 
       StyleBox["item", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the absolute current value of ",
     Cell[BoxData[
      StyleBox["item", "TI"]], "InlineFormula"],
     " at a location in the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " system and interface. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteCurrentValue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteCurrentValue"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["item", "TI"], ",", 
         StyleBox["spec", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the absolute current value for the feature of ",
     Cell[BoxData[
      StyleBox["item", "TI"]], "InlineFormula"],
     " specified by ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteCurrentValue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteCurrentValue"], "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        StyleBox["item", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the absolute current value of ",
     Cell[BoxData[
      StyleBox["item", "TI"]], "InlineFormula"],
     " associated with the object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->15062]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteCurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteCurrentValue"]], "InlineFormula"],
 " gives the same results as ",
 Cell[BoxData[
  ButtonBox["CurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CurrentValue"]], "InlineFormula"],
 ", except that ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " and related constructs are resolved to absolute values."
}], "Notes",
 CellID->10585]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->706753417],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->90151424],

Cell["Create a window: ", "ExampleText",
 CellID->82923108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateWindow", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1809083001],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt2mtvlncdB3CMz83egm9FfewSs0eaOEqkbJrF6AvwwSKbjs3IgHIY1I0B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   "], {{0, 0}, {458, 140}}, {0, 255}],
  ImageSize->{458 0.75, 140 0.75},
  PlotRange->{{0, 458}, {0, 140}}]], "NotebookImage",
 CellID->52626221]
}, Open  ]],

Cell[TextData[{
 "Compare ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " returned by ",
 Cell[BoxData[
  ButtonBox["CurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CurrentValue"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AbsoluteCurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteCurrentValue"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1486244586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CurrentValue", "[", 
    RowBox[{"nb", ",", "WindowMargins"}], "]"}], ",", 
   RowBox[{"AbsoluteCurrentValue", "[", 
    RowBox[{"nb", ",", "WindowMargins"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1184523581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"398", ",", "Automatic"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", "53"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"398", ",", "398"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"53", ",", "53"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{412, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->148433079]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28617],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23757]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->455508495]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AbsoluteCurrentValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 18.3913198}", "context" -> "System`", 
    "keywords" -> {
     "current value", "resolving symbolic values", 
      "resolving automatic values"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AbsoluteCurrentValue[item] gives the absolute current value of item at a \
location in the Mathematica system and interface. AbsoluteCurrentValue[{item, \
spec}] gives the absolute current value for the feature of item specified by \
spec. AbsoluteCurrentValue[obj, item] gives the absolute current value of \
item associated with the object obj. ", 
    "synonyms" -> {"absolute current value"}, "title" -> 
    "AbsoluteCurrentValue", "type" -> "Symbol", "uri" -> 
    "ref/AbsoluteCurrentValue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6604, 205, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->706753417]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14273, 430}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1331, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1954, 61, 1585, 37, 70, "ObjectNameGrid"],
Cell[3542, 100, 1848, 56, 70, "Usage",
 CellID->15062]
}, Open  ]],
Cell[CellGroupData[{
Cell[5427, 161, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5905, 178, 662, 22, 70, "Notes",
 CellID->10585]
}, Closed]],
Cell[CellGroupData[{
Cell[6604, 205, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->706753417],
Cell[CellGroupData[{
Cell[6989, 219, 147, 5, 70, "ExampleSection",
 CellID->90151424],
Cell[7139, 226, 59, 1, 70, "ExampleText",
 CellID->82923108],
Cell[CellGroupData[{
Cell[7223, 231, 147, 5, 70, "Input",
 CellID->1809083001],
Cell[7373, 238, 2717, 47, 70, "NotebookImage",
 CellID->52626221]
}, Open  ]],
Cell[10105, 288, 500, 18, 70, "ExampleText",
 CellID->1486244586],
Cell[CellGroupData[{
Cell[10630, 310, 280, 8, 70, "Input",
 CellID->1184523581],
Cell[10913, 320, 539, 19, 36, "Output",
 CellID->148433079]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11513, 346, 311, 9, 70, "SeeAlsoSection",
 CellID->28617],
Cell[11827, 357, 473, 17, 70, "SeeAlso",
 CellID->23757]
}, Open  ]],
Cell[CellGroupData[{
Cell[12337, 379, 299, 8, 70, "MoreAboutSection"],
Cell[12639, 389, 163, 3, 70, "MoreAbout",
 CellID->455508495]
}, Open  ]],
Cell[12817, 395, 27, 0, 70, "History"],
Cell[12847, 397, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

