(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41836,       1349]
NotebookOptionsPosition[     36303,       1163]
NotebookOutlinePosition[     37813,       1203]
CellTagsIndexPosition[     37727,       1198]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dashing" :> Documentation`HelpLookup["paclet:ref/Dashing"], 
          "Dashed" :> Documentation`HelpLookup["paclet:ref/Dashed"], "Dotted" :> 
          Documentation`HelpLookup["paclet:ref/Dotted"], "DotDashed" :> 
          Documentation`HelpLookup["paclet:ref/DotDashed"], 
          "AbsoluteThickness" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteThickness"], 
          "AbsolutePointSize" :> 
          Documentation`HelpLookup["paclet:ref/AbsolutePointSize"], "Offset" :> 
          Documentation`HelpLookup["paclet:ref/Offset"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Dashing\"\>", 2->"\<\"Dashed\"\>", 
       3->"\<\"Dotted\"\>", 4->"\<\"DotDashed\"\>", 
       5->"\<\"AbsoluteThickness\"\>", 6->"\<\"AbsolutePointSize\"\>", 
       7->"\<\"Offset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Directives\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AbsoluteDashing", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteDashing",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteDashing"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["d", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["d", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that lines \
which follow are to be drawn dashed, with successive segments having absolute \
lengths ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis] (repeated cyclically). "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteDashing",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteDashing"], "[", 
       StyleBox["d", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is equivalent to ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteDashing",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteDashing"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["d", "TI"], ",", 
         StyleBox["d", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->5786]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The absolute lengths are measured in units of printer\[CloseCurlyQuote]s \
points, equal before magnification to ",
 Cell[BoxData[
  FractionBox["1", "72"]], "InlineFormula"],
 " of an inch. "
}], "Notes",
 CellID->12263],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteDashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteDashing"], "[", 
   RowBox[{"{", "}"}], "]"}]], "InlineFormula"],
 " specifies that lines should be solid. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->4313],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteDashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteDashing"]], "InlineFormula"],
 " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics, \
as well as in ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " specifications. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24355],

Cell[TextData[{
 "The following symbolic forms for ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " can be used: ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->31185],

Cell[TextData[{
 "If a segment has a length ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["d", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " specified as 0, it is drawn as a dot whose diameter is the thickness of \
the line. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->41]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->77548582],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->225932913],

Cell["\<\
Specify the dashing of lines as successive segments with lengths in printer's \
points:\
\>", "ExampleText",
 CellID->424926237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteDashing", "[", 
       RowBox[{"{", 
        RowBox[{"d", ",", 
         RowBox[{"15", "-", "d"}]}], "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5", ",", "8", ",", "12"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->302616010],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteDashing[{2, 13}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[{5, 10}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[{8, 7}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[{12, 3}], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",\

 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->732478641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28246171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteDashing", "[", 
       RowBox[{"{", 
        RowBox[{"d", ",", 
         RowBox[{"15", "-", "d"}]}], "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5", ",", "8", ",", "12"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->740745970],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {AbsoluteDashing[{2, 13}], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydV21PE0EQ3t71BQu1LbUWmlSB2ChoA+FNRRFEqaLhgz+hwSbwwWiQv7/R
27nZ696z491VknI3O88+OzuzMzt3Obm7nv6Y3N1cTdY+3U5+Xd9c/V4b/7yN
hsKSUup79Pu2oqL3P9Eb/S611sF0Ou1GT6W+sqTC6CV6msEHpPkc/Q+jkZAR
8eg5j1aNFMYTzPQOac9Ye0/UnjLTkpHKsTYGLJP+mGffN1Il0TNHmzBHjGln
YF65FocJRgUg0zrqgBl7OegGoXcZ3S+E3mb0ALQhyOQRNWK71wqht5h7A7Rl
kBcJ/ZTRQ9BWQK4TesiWPCuE3mDuLdBWQaZToR4zegTaGsgLhB6wJTuF0H3m
3pW0OFv1GH0g2Yn7oKwwg69zuGP0Mtv9NoebPKqazP1O8i/GluJvBt8XQtfZ
ko+gXQSZThl5xgyOBbuNGNtbZulC2LsRMRvCZBaNqvgPZ4fary3a5lYqCwzH
F5wNdQdmpurNBa+09G+8V1tM5Svb6pRpXTLqyCd6Vk29XM5lQ9mcuSDy4A7b
hNmAsZVZsVIcso04uxibORnmnO1pp4rPzYI7GTFbi9mRtUQs6G08B5sOi3Q+
0TaZFfOrxVHoADtWyWLsiFpntibHGPeE1siseL4GDqsUJVxFZm2AvAqs7f9i
RVu6wNoFPVZembUJctuJkoneAsurgMOTKLO3BM+4Ng8E1lIkGjaZEX1n7LN1
xzyxO/AZvV4Oct61D/uBaiYbRsBl2gRdJZPpoY7z2c6mDjCMMDx7RbA7mw1z
yYjYNczHUmOP7+Ou52KxHse+Ichnmd1ZzHGcweHPLycemPkVMxcZZhrb71Df
4N2GPt7mFZ7nD+mdiGs12FqsnG7PIq9a1/4Xh3k9gX0HuUy288GKeSowBeIu
3Nxyx8dpH3tRxYwfp1YwcMziM/ZX6NmAGWr7jprOy+U3zBn39HaXuPJL7XRB
XgeBO9nXTnZ7Xw9YO203E3+ZYheIXn3BaKrbFL1A8L29+QeEwlOCsR5qp8Z6
N6x0Qxv0E0KjFmc/Ykvom4pWDqy3HVSfOZ8TCm9EvJNslm8TGveOHrR9yh6h
0fsYHdt3HBK6zfZKvY1BHRGqA1qsBfaupe+c+G5KVQZbcenLJrn/Qx49p9Ee
S/T1oFTpLwt5/eg=\
\>"]], ",", 
   Graphics3DBox[
    {AbsoluteDashing[{5, 10}], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylWG1PE0EQ3t4dFXkrL0VekspLbASUpCoqiiJYQY3hgz+hIZfAB6NB/v5F
b2aftdfnBu6CTdq72Xn22dmd2dmdng2uL9Ifg+vL88H656vBr4vL89/rpz+v
8qa44ZxL8+/3ZZe//8nf9HuWZVmUpumD/OncN0guzl9S/bhF1XzJf+NcjIHw
rSdobYokL76ba6u2D+x9U3uEvpMiJV7rAQuqfw/9jEhj//TgmFfMAUaYL3F4
/T442ibHnGJeArNUsFJeI5LVDvcc6NVa6B7s65A2Jnla0bvgXiNtQvKUoneA
3qyF3oIlXdKOkazecF1wPyZtk+QJRW8CvVMLvQb0LmnvkaxR4zqwu0facUt2
q+B+UcHt0UtAv6rg1t66D8SSN5adPGuNT2k8qIVuAX1orRh7Sz0qjce10BOw
+5PlaY4bnas0nhp2ywbznAlQX43ZhCxRiveRyMxzj+PecVbOJqO9NTcl6K4f
tjOmfGOPHlKci3MKoPoYfcrsrb/DDFNY07iQL7Ow3+z+t2SAQzDx7mUv2Wzc
S7wY5VN7BlaO/3qsnBtkX8iCPQErxxvPPDJZ2bsho07fiY1nJllF3NSCh2Zq
sfCO34ZNs3hyduf1s1k5DmfhlQViN3Nwib3Khjl4Z5rY2Qr2ms3Oq98BWwvr
y97iUWxW7rVSYJXnfIVfbFb28SKxLt6JtWWtL7wl6xwy5UoFe8NknzVWRkTx
qsRIBLlDOI53m33O8E5xRTZIz3vSZmXvjGXDG5rExKNarMVcyZ5JwCZN28Zo
t7PJHTaiaBJPLfMotZh4r4nomYZnBuM4A1Qzj4N577+Zgjf2DaZGLgrDDSwj
55oI74gjquSQXj2st31jj0r92lnx/jVc1clb+5d3JMdpf3ROATHSN0QZR1Xx
lmSPOoHZ8j7/QLMIlVKZIWQOzrFHWL/oxp7h3sW5qU9jR/BV3jLiWyvHnqDd
4xMjXx5jxknJHo7BcIsZL/makW/B6euNMOM2oUL91vK2kZaz3B44fe3HnuWM
2wPaV75NWMCoUJNpvVfK7XyebYOzo2g+E9nfXaA1G5fOZT7fQ5XVVfQk7GXU
Q3BuKYrtY/tXgX6qaD5H+awJ9ZLWYqXzkbP9Ari1FvN3n7R8tw/3ideK4tjk
LBgqH62qdITSOU6zFW6tqpz9H0ATmI+KCTVeMXLDSayVhq6BkGjt4lzjL2mc
N80=\
\>"]], ",", 
   Graphics3DBox[
    {AbsoluteDashing[{8, 7}], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylV2tPE0EUne6DIm9KK48IVhIigiKGKCgBERQwRhN/QkM2gQ9Gg/z9je69
e6adnhnYFUlaeueeOXPnvmbma+/mMvvRu7m66HXPrnu/Lq8ufndPf14XQ3HD
GJMVn+8Lpvj9p/iln295nps4y7Jc/0xbvsyX4jstBjsqnRffAomL/1F/9BTS
iMNQfIPhBHMekHZOtUfQTgS1B9BOi5T0bSt+tFS/j5VVSvt6cMwqZg8c7Tsw
r4GZJx9EJE8pegerLpE2JnlS0dvgflQL/QLox6RNSFZ/mQ2gV0mbkjyu6HXY
vVYLvQbup6QdIXlM0atAb1Zwl+guLNmq4NacMcvg3iZtk+RRRS8BvVMLPQ/0
m5CWZ5sO7H4bspP3YVrg3q+Fngb6MOQx9qhmi1jyIRQ7zhvlkMGTWugm0KcB
u6UISwtSWPA5sBvbI7x81xVklomLngPNOSEjMHA2DBjcTiFEZzQWUb+h2UOd
RFczgz41cfs8r3uUtgx2cgAOnVSCTZgv6B1HPgQT1z1HLMzGsySiUWHmK7By
LbCNUZCVa3kUntsEK2dqPdZQPxFW238m78XKO9zKByeJZMdULRbuAhsOS4zc
uSs6YVbOzBnsWPpF4rAHO20lO6NaYJ8A60zun8e3s/MO2ftyqkpmNYmdo8ar
hdl51qLjb/HMbAVrI8jKse5QFB+SnqMeZp0medaJmuuRxXuxzwQ8I+I4oqkl
ntm/ZUJz9ofXCHnT9Yvb2VYIy7kZXqFFckorVN1EwqxyN4xs50YtS3as34vN
nulTYLP1skA47qklm9vp+fZoT90FMHKeCWOjEIXJZwtlpYhlJAaRaRMu/idW
G5G9/2KxkXhOtnE9R5WsaVbe84REZ6f92TnOdm9eG6vv5mXljdecZyuWM2KX
dqFdxrszDHPZ7OGc++jIrhXDZ4aI3BfekxUxMTU8Jqn6BD3CHT+CP6NKhiR3
3lvO+Ak8a3fszE5cP9v6ced+wniJF3iHEMe5c9cZsofz7BA7bA75X6xh5DvX
F94ZOReIeH/fXqXzjnbAXb5BOeLcVV8CrRZq35Ruw/3dvvv0TemdEVxHz8C5
rGg+BfmMXgP6iaLHYAGj7AtOe7LHwWus5E7P9exj+5eA1v7gncd8Wtk3mb73
jL2xMWoOnPrO87zOMbQ3CK1tL6KcH/aupC83L1u4X4yCW19u5Y0o0FUSoI4V
5eZrhgeDiPrmUg9IA9O3lTGNv8s5X4Q=\
\>"]], ",", 
   Graphics3DBox[
    {AbsoluteDashing[{12, 3}], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydV2tPGzEQdJJLQwmEkAcEWh6lICEBKhUqoKJSBCr0oVbqT4jQSfChakX5
+6fW3hsT33hDro2US/Z2PF6v12P76/D+Jv0xvL+9Hq5f3Q1/3dxe/16//Hln
X9UqxpjUfr8PjP3/x/6T77csy0wtTdNMPqbnHuaLfdbty75YH+3TQRL7W7W/
OeYSVqPw9gLYpwGvfZqueM/gnXFW8tCr/dMR/ym45sb4T9B+3ln1Bz/6kLfm
GJjeI5g3wCzS6KtktwR9gKiWyVsje1bQ++B+Xgq9B/QaeROyJWNmB5FskLdO
dlPQ2+DemsCdo7eA3p7APS3ol4hkh7xPyJY6MOvg3iuFXgF6n7wNsqcEvQz0
gebl1maAuA9LofvgPtbi5HGYDtAnWsY4o6aNSE5LoWfBfabNHc+tcLiXF6XQ
DaCvlFE6M4+gjng/K2N3Jq8dqXfjNaNqxeYTIVyLxPOrLb0G5E/HEcbo1nOV
tEZvn4NdfzUz0qiZ8e0i3UjQ9h3aCjgH5SuZVSRaZZyf3G8pYR9lI5WNVv5E
dlaXBvL1Gqy8dnRWZuGZmUIWdsDKtVqOlVf9NFi9AnE+y7FqI3Ssa2B1e4qr
llYpNtaDFs3WUsCqVT+vNL0Xrtw2Yu4Su5axyeyM6oB9ltgZx1Hp7DzCHthd
rEnAzrPJvVVUdp7zBbC7V+0sOAU8EnfOrO7pge01fg5x98nPlaCz+urye4DL
glt/Xlv57MDVqrPyCGfA1kQ2RAZS/1n5rz46yngLlY019NgK1pm7ZCfEXMco
OG5WHZ29R3bIPOkMozP2s5FCJKgvF99AYatY07GMZ4oUzpoDMC4omSkyhvsL
n1J9Ta2CLcrEP7H5WdnM8orleijBNtplwbWbFdVS2yHHc4bZSbHH72cj7Yp3
52rE0cMcHqJdsxinV+xCm/lM1/JjcEyV4GhlwZkp4DihjDyJuOI8NMHFCvSe
uELtdNmImfyaZs0+w8gctBrEUKyOJI13zQtUi+8l6DeqBq6oy0Jvmuaeo9f8
ROawXLWnQOTn9Ena4O+N+U2H9xrWqaNwzNFJi0dzAHR+Q/WnZEb5W6HUdqTM
c2TvgnNJ0PpZZGRvA70iaN4Fee35U9YLQU8jXt5vN8C5KSj2ch+rQIvuRj1y
/M+yQCVkNFWlyhfB+UpQbfLy+uoCLbfAaN/kOfQniCNBa4rHu67jfivoLuLV
TowOJfe5fAcorG+v2ufiZ42rofUH8bqxO5GTG5Mxlb/apFte\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->688811923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450003349],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Dashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dotted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dotted"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DotDashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DotDashed"]], "InlineFormula"],
 " to specify predefined absolute dashings:"
}], "ExampleText",
 CellID->238968406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Dotted", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"DotDashed", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389342057],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{Small, Small}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0, Small}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0, Small, Small, Small}], LineBox[{{0, 0}, {2, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->888528440]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->481],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Dashing Specifications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->88423536],

Cell[TextData[{
 "No dashing: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->4313]
}], "ExampleText",
 CellID->322781052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"AbsoluteDashing", "[", 
     RowBox[{"{", "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11191970],

Cell[BoxData[
 GraphicsBox[
  {Dashing[{}], LineBox[{{0, 0}, {2, 1}}]}]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->636988516]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteDashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteDashing"], "[", 
   StyleBox["d", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteDashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteDashing"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["d", "TI"], ",", 
     StyleBox["d", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->982634541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteDashing", "[", "d", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5", ",", "8", ",", "12"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22421334],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteDashing[2], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[5], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[8], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[12], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->265786870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60872454],

Cell[TextData[{
 "Symbolic values for predefined absolute dashings: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->31185]
}], "ExampleText",
 CellID->6210372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteDashing", "[", "d", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493657934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[Tiny], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[Small], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[Medium], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[Large], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->53280123]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7129],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteDashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteDashing"]], "InlineFormula"],
 " defines the length of a segment in units of printer's points:"
}], "ExampleText",
 CellID->73834431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Thickness", "[", ".02", "]"}], ",", 
    RowBox[{"AbsoluteDashing", "[", 
     RowBox[{"{", "15", "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<15 points\>\"", ",", "Black", ",", 
        RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", "0.1"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221992543],

Cell[BoxData[
 GraphicsBox[
  {Thickness[0.02], AbsoluteDashing[{15}], LineBox[{{0, 0}, {1, 0}}], 
   InsetBox[
    StyleBox["\<\"15 points\"\>",
     StripOnInput->False,
     FrontFaceColor->GrayLevel[0],
     BackFaceColor->GrayLevel[0],
     GraphicsColor->GrayLevel[0],
     FontSize->15,
     FontColor->GrayLevel[0]], {0.5, 0.1}]}]], "Output",
 ImageSize->{184, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144337408]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteDashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteDashing"]], "InlineFormula"],
 " is independent of the image size:"
}], "ExampleText",
 CellID->339440019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteDashing", "[", "10", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "100", ",", "150"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106096680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteDashing[10], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->50], ",", 
   GraphicsBox[
    {AbsoluteDashing[10], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->100], ",", 
   GraphicsBox[
    {AbsoluteDashing[10], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->150]}], "}"}]], "Output",
 ImageSize->{341, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16185156]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->556552163],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " defines the length of a segment as a fraction of the total width of the \
graphic:"
}], "ExampleText",
 CellID->356846920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Thick", ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", 
       RowBox[{"0.05", ",", "0.1"}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25619052],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Large], Dashing[{0.05, 0.1}], LineBox[{{-1, 0}, {1, 0}}]},
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->25131674]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " depends on the image size:"
}], "ExampleText",
 CellID->85601104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Dashing", "[", ".05", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "100", ",", "150"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146120593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[0.05], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->50], ",", 
   GraphicsBox[
    {Dashing[0.05], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->100], ",", 
   GraphicsBox[
    {Dashing[0.05], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->150]}], "}"}]], "Output",
 ImageSize->{341, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->331473684]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20945],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dashed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dotted",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dotted"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DotDashed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DotDashed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteThickness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteThickness"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsolutePointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsolutePointSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Offset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Offset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27756]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20053],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->29178459],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->861489798]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AbsoluteDashing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 18.8600818}", "context" -> "System`", 
    "keywords" -> {
     "dashed edges", "dashed lines", "edge styling", "line styling"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "AbsoluteDashing[{d_1, d_2, ...}] is a graphics directive which specifies \
that lines which follow are to be drawn dashed, with successive segments \
having absolute lengths d_1, d_2, ... (repeated cyclically). \
AbsoluteDashing[d] is equivalent to AbsoluteDashing[{d, d}]. ", 
    "synonyms" -> {"absolute dashing"}, "title" -> "AbsoluteDashing", "type" -> 
    "Symbol", "uri" -> "ref/AbsoluteDashing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11869, 333, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->77548582]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37584, 1191}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2456, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3079, 84, 4199, 83, 70, "ObjectNameGrid"],
Cell[7281, 169, 1723, 54, 70, "Usage",
 CellID->5786]
}, Open  ]],
Cell[CellGroupData[{
Cell[9041, 228, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9519, 245, 239, 7, 70, "Notes",
 CellID->12263],
Cell[9761, 254, 317, 10, 70, "Notes",
 CellID->4313],
Cell[10081, 266, 536, 16, 70, "Notes",
 CellID->24355],
Cell[10620, 284, 818, 30, 70, "Notes",
 CellID->31185],
Cell[11441, 316, 391, 12, 70, "Notes",
 CellID->41]
}, Closed]],
Cell[CellGroupData[{
Cell[11869, 333, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->77548582],
Cell[CellGroupData[{
Cell[12253, 347, 148, 5, 70, "ExampleSection",
 CellID->225932913],
Cell[12404, 354, 138, 4, 70, "ExampleText",
 CellID->424926237],
Cell[CellGroupData[{
Cell[12567, 362, 689, 24, 47, "Input",
 CellID->302616010],
Cell[13259, 388, 565, 17, 75, "Output",
 CellID->732478641]
}, Open  ]],
Cell[13839, 408, 124, 3, 70, "ExampleDelimiter",
 CellID->28246171],
Cell[CellGroupData[{
Cell[13988, 415, 712, 24, 70, "Input",
 CellID->740745970],
Cell[14703, 441, 5772, 107, 104, "Output",
 CellID->688811923]
}, Open  ]],
Cell[20490, 551, 125, 3, 70, "ExampleDelimiter",
 CellID->450003349],
Cell[20618, 556, 476, 18, 70, "ExampleText",
 CellID->238968406],
Cell[CellGroupData[{
Cell[21119, 578, 1057, 37, 70, "Input",
 CellID->389342057],
Cell[22179, 617, 488, 15, 75, "Output",
 CellID->888528440]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22716, 638, 214, 7, 70, "ExampleSection",
 CellID->481],
Cell[CellGroupData[{
Cell[22955, 649, 242, 7, 70, "ExampleSubsection",
 CellID->88423536],
Cell[23200, 658, 152, 6, 70, "ExampleText",
 CellID->322781052],
Cell[CellGroupData[{
Cell[23377, 668, 418, 15, 70, "Input",
 CellID->11191970],
Cell[23798, 685, 214, 7, 115, "Output",
 CellID->636988516]
}, Open  ]],
Cell[24027, 695, 523, 19, 70, "ExampleText",
 CellID->982634541],
Cell[CellGroupData[{
Cell[24575, 718, 600, 21, 70, "Input",
 CellID->22421334],
Cell[25178, 741, 541, 16, 75, "Output",
 CellID->265786870]
}, Open  ]],
Cell[25734, 760, 124, 3, 70, "ExampleDelimiter",
 CellID->60872454],
Cell[25861, 765, 189, 6, 70, "ExampleText",
 CellID->6210372],
Cell[CellGroupData[{
Cell[26075, 775, 618, 21, 70, "Input",
 CellID->493657934],
Cell[26696, 798, 523, 16, 75, "Output",
 CellID->53280123]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[27280, 821, 232, 7, 70, "ExampleSection",
 CellID->7129],
Cell[27515, 830, 252, 7, 70, "ExampleText",
 CellID->73834431],
Cell[CellGroupData[{
Cell[27792, 841, 737, 22, 70, "Input",
 CellID->221992543],
Cell[28532, 865, 481, 15, 51, "Output",
 CellID->144337408]
}, Open  ]],
Cell[29028, 883, 225, 7, 70, "ExampleText",
 CellID->339440019],
Cell[CellGroupData[{
Cell[29278, 894, 667, 22, 70, "Input",
 CellID->106096680],
Cell[29948, 918, 473, 16, 101, "Output",
 CellID->16185156]
}, Open  ]],
Cell[30436, 937, 125, 3, 70, "ExampleDelimiter",
 CellID->556552163],
Cell[30564, 942, 258, 8, 70, "ExampleText",
 CellID->356846920],
Cell[CellGroupData[{
Cell[30847, 954, 556, 18, 70, "Input",
 CellID->25619052],
Cell[31406, 974, 309, 9, 162, "Output",
 CellID->25131674]
}, Open  ]],
Cell[31730, 986, 201, 7, 70, "ExampleText",
 CellID->85601104],
Cell[CellGroupData[{
Cell[31956, 997, 660, 22, 70, "Input",
 CellID->146120593],
Cell[32619, 1021, 456, 16, 101, "Output",
 CellID->331473684]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33136, 1044, 311, 9, 70, "SeeAlsoSection",
 CellID->20945],
Cell[33450, 1055, 1700, 62, 70, "SeeAlso",
 CellID->27756]
}, Open  ]],
Cell[CellGroupData[{
Cell[35187, 1122, 314, 9, 70, "TutorialsSection",
 CellID->20053],
Cell[35504, 1133, 197, 4, 70, "Tutorials",
 CellID->815154705]
}, Open  ]],
Cell[CellGroupData[{
Cell[35738, 1142, 318, 9, 70, "MoreAboutSection",
 CellID->29178459],
Cell[36059, 1153, 149, 3, 70, "MoreAbout",
 CellID->861489798]
}, Open  ]],
Cell[36223, 1159, 50, 0, 70, "History"],
Cell[36276, 1161, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

