(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53522,       1331]
NotebookOptionsPosition[     49222,       1187]
NotebookOutlinePosition[     50599,       1225]
CellTagsIndexPosition[     50513,       1220]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Offset" :> Documentation`HelpLookup["paclet:ref/Offset"], 
          "PointSize" :> Documentation`HelpLookup["paclet:ref/PointSize"], 
          "AbsoluteThickness" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteThickness"], 
          "AbsoluteDashing" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteDashing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Offset\"\>", 2->"\<\"PointSize\"\>",
        3->"\<\"AbsoluteThickness\"\>", 
       4->"\<\"AbsoluteDashing\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Directives\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AbsolutePointSize", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsolutePointSize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsolutePointSize"], "[", 
       StyleBox["d", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that points \
which follow are to be shown if possible as circular regions with absolute \
diameter ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13261]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The absolute diameter is measured in units of printer\[CloseCurlyQuote]s \
points, equal before magnification to ",
 Cell[BoxData[
  FractionBox["1", "72"]], "InlineFormula"],
 " of an inch. "
}], "Notes",
 CellID->10195],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsolutePointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsolutePointSize"]], "InlineFormula"],
 " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics, \
as well as in ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " specifications. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->32525],

Cell[TextData[{
 "The following symbolic forms for ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " can be used: ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->1264],

Cell[TextData[{
 "The initial default is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsolutePointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsolutePointSize"], "[", "3", "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8260]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52273055],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->761188656],

Cell["Specify the point sizes in units of printer's points: ", "ExampleText",
 CellID->62157263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsolutePointSize", "[", "d", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "2", ",", "7", ",", "15"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144138276],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsolutePointSize[0.5], PointBox[{0, 0}]}], ",", 
   GraphicsBox[
    {AbsolutePointSize[2], PointBox[{0, 0}]}], ",", 
   GraphicsBox[
    {AbsolutePointSize[7], PointBox[{0, 0}]}], ",", 
   GraphicsBox[
    {AbsolutePointSize[15], PointBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->22512264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->562345042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsolutePointSize", "[", "d", "]"}], ",", " ", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}], 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{"d", ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", " ", "2", ",", " ", "7", ",", " ", "15"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->590339034],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {AbsolutePointSize[0.5], Point3DBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydmP9P00AUwLu1HWOAg83BkLlNEFEEEVFAEmPiD/qTf8SCSyDRaJB/v9He
9XXrPvfYbjOh9u3e+/R6fd/uvg/ub4a/Bve314P+t7vBn5vb67/9r7/v0p/C
UhAEP9K/n+0gvf+X3tm/L0mSBOFwOEzsv6BnLsHn9BqnP/at9Cm9llMplP+z
X6/SqzGMC4T0KoRL0a2qo+cyWjNSNHp6etO142fCXjVSPBoXxlOrcyqM+hSd
E9FpqDodq3Mkz3qMlShD3rbah0Lc8tI+EPY2RkPIbau9L+yOl/aeaHcxGkG2
Mw36MpM+RmPIm1a7K+w9L+0dYe9jtAK5ZbW3hf3SS3tLtA8xugTZfj17NT8e
YbQKuWm1G8I+8dJeF+1TjC5Dtr4WrMlMzjBag7xhtVeEfe6lvSzalxhdgbxu
tauifTWDPdYuxuvHGc+oj60m4phzW4X8aGznxOWFv+2UCHwPeU2THT9i9PD7
+VEYJ++0N+AbOhRGBD2vrn0bh0L57UIUrjZjZh1yTaUwVt5A3tD0nXWgDx4v
RKFXMWc0tBVwKPSH1wtR6A/Mdk3ISyqFX/IVZFa4ikrhl2Se1in0eL43KeYp
JmFUVWu+74Gy6kZktMYqjTN+AXlZ5qJG8dy0isyNXqrTWpBZQ0Oh0UN02ibk
56Slt4wOncT+Zi/Ru6TMmt+B/U5PVpjz062fQM77C/ZBXLtIpe0ob2ZEtd+Y
SWNv1hQaM5sf7SnkelLoe+emsRNcERrzgk7j6rJTXBIaI9uP9gxy7te09qPt
FuT0Gpj+pr0QiR1uVufSnZHIJtNo9NCL1pK3ZG/CufnRGonuuYzJjMZnMhfk
vsY+kLnXj2Z8LVLyFL3Fj1ZNdF9bjBYLjdmHmdCPVhYasxRp5Qdp8dDdtbHq
6ta78mx6BiM8s7YvlP1o40/zxF3I/H4uqZvotZdzmk3K8zrrLlecPZZLMjk9
UnyZ1ZR51SXlO0jOnlWepJJD2hAS/YK9DPuEnDS5klrtnZ9Uk3VidWd3xnV0
SXk1YHVlz8m66JIiITEi2ANzByKk8a5TOKw07MjpbRnHYOh3fpbT/I17CkMo
paKxnPQYU8VozX1NxbGeVhfNLfdXsUMwq2/qGy25v4scS1ah3twEric9gDvV
0CHkZxu05E657FjSw+nH3LEXCePzGlrZ04K46JHmu2Y2zGLsKOx5xcQZSmbH
TMTYfciunugnlR8K8nh2zFLMNfmJbaadn5xR62JilTjKZ5iZhCPtljCpZb5l
lNcb5+25OsdJcV/JNWbWNtnKfK7s/CU/maTWvjCz0zd+c2a4vjCz88uOMKnV
EabtIhzPZ2y1RTs7He8Jk1pNebKNZbXjZs9gmLaKOJmDfULe39mcODp7plZF
ZmBjfyKfGU+LhGE91lbUylBOCoOg9B8KDO65\
\>"]], ",", 
   Graphics3DBox[
    {AbsolutePointSize[2], Point3DBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydmVtPU0EQgE9vlPv9DrYFRBFBRFRQY0x80Cd/REOaQKLRIH//RM/OzpbT
byftUhIOnbMz3253Z2dmlx/d+5ver+797XW38/2u++fm9vpv59vvu+JVrZJl
Wa/4/bmZFZ//FZ/k92ue51mt1+vl8pN13CP7Ujwbxcs9kT4Xz2oh1fSvf/tJ
pUaJUDyVcFU83cumk+p9fvGhLe3v1XoG1r71Qq3nIuuWtJ+r9aKTGv12ZTwR
nTPVWR6ic6L9rGIWqpC3RftYiRtJ2keqvYXWGmRpzw51JDtorUPeFO0DZbeS
tDvK7qC1AVm+V9ZS9kGS9q5qH6J1AvK6aG/pSJ6jtQl5TbQ3lH2cpL2m2ido
nYQsa50t60heoXUK8opoLyr7PEl7TtlvR2iLZ2Yzyr5M0p5S7Q9onYa8JNqT
qv0RrTOQF/va5b3IPoZYDezRK+jNQl54sIv2JWdhiO2QHciZn4M8b1K4My8s
K1Ijb+Q+eTMWhfuHnrdgzVNEofx6LArn6QzyIuQZk0J/5s5bgjxtUujnp0kU
zia9ijFj2Rp7RKFXvYS8Ys1jRKE/kMKx2BSuJGMmx9I0KVzJF2NRuAZHRi9O
lA3nXyuJe4f9MW+ESMu8N2HSmOWfQZ7OSzXLSNoaZGbAptLosTZtHfJTyPW8
VBGNpLFCkVz+EKOVxdW2WZuQ94uHQ3FtbGtWPy215gjFLqpfWA1t68gZqbkW
Nm3XmHMn0n/TaE8gh4qCcS6NxkpuXmmMVGm0NuTg2YwS49GCZzMy2TSu1R7k
mtK4A0irm7T9kuxCSrW/f4vTjeqM+tY2mfWvo1azh1qQHpxGcX3XEfv4zdNI
wd/ovYxyabSF3I5W3OWexnqL0WpWacxt9Jg02qTOGa2ZZ9Jojdz2N9JrSbSq
0rZHjG00LXgvIwGjtE0KUXkf7+n7tnVbv4VFHVareFrZl1tKYh6gvzGPxaQd
JbH6fDxpQ+eG5xeuJUnViLSa23GUuZ9ROyYt5XYMZU3CMcekkCm471l1cWcH
0mBfNSOyPZ7U1BnnrmA9yVwZk0Ldw13B+tY8EWZxzcPsw2qbnIpwHIbewjMD
q8ZK9F3oJamEXNbaxQcSePphLvCEYTnTfeRJjHtX5yD3eY/WPA2yevDWHBlr
Cp5MOWZPaeoYxrOmt7Ee5BnbUSqF6Kw9gZ7P+pRn/WpECLc9tJS7hkbZWyUf
iA3jEityue0YuIHxdvPaF/XfleSHXphnWCXZVsxzjELhntdrL6tErUt97+eI
rezDjaTe1w73ftQ6Vy3x5uhExEx2qtr+pL+pTGq5SOgWyd/ZMLpZ+aVft0S+
Ql/qqLa/KQ33qpbHNUJkjU4NjCAh8/lb9bYyqbWiWpJZzfqcFYUbgZzFJZaE
/w1wLhxTYpzPtAMeOqXtsnMH4przrbr2IZ4tOXGip3eeWVb5D0UUB4M=\
\>"]], ",", 
   Graphics3DBox[
    {AbsolutePointSize[7], Point3DBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydmFtPE0EUgKe7vdCWW7nYQoEWEQUUEUXAGBPjgz75IxrSBBKNBvn7G92Z
OUuXb450gIS2Z+fMN7Mz5zbzfXRzOf45urm6GA2/XY9+X15d/Bl+/XWdP0or
xphx/v+jZ/Lff/Nf7v9LlmUmHY/HmfszQ/thPuef1fzhtpM+5Z9WJc2/k/zb
63wUqX7n6bnozpS4+acZuNZT0W2rrSfSOmel6u2c8h9brv1Y2AtWqt22C2PT
6RwJY+kenUPRWcG7J5DXnfaBjPoErSnkNae9J+y1KO1dYffRWoXcc9o7wt6K
0t4u70uptQa567S3ZCZP0VqH7FbBbAh7N0p7Tdgv0NqAvOq0u8I+iNJeFe3D
Kdpur82SzOQIrTOQl532orDfRmnPi/YJWpuQnWWatszkFK0tyB2n3RT2h2jt
8tNzyG3Ii64XPZZj3dPrjq9ytFnIC5N+gX+eQXcO8nww00zxW+5AHIUe+k7r
RWpAoS/SdnQKrZV+dKytIdc4oFB+A3kRclul8A3pO3EU2uRryB3ILZVCe59G
aaoUWjJjh07hntCqXkFe0tYxoNAeXj6KQntg7FyG3FAp3Ml9hWKjkD4Hrtqe
QreiczT/+D/z4Dszb8wJib5WV2l89+eQW0JTfTDIlquQmQEbQqOl6jTWFM8g
V4VGW9NpXcg7DlGOsbaRu6yzepBtXWBRrJlqam9WPwMZmzPUe69D7ktvxnnu
hafRKjaUNbdvMm1nddom5KKiYHyLo7GSm8/0/dZXnbQB5MKyueNxNNaNdaGl
xgSRgm9bVYnbkJNssq+1nMooplOZp62VVyUaNIwJImo8hWtiaXYnEsVy4yn1
nNKSOdKCuRNx1LqsVxFrGPEeR/V5PseWemmRjPE0jj4rNO4OaWkUrSk0ZgrK
nsZVZ5Stye4wGjOjxdEKq2YUezjNJkvtvEfv00k7mX6io5fpvQeyJuVszV3g
XuqkDZkH4y1pjHmeVh6/yAOsSLkDJCUBqSckVoIPJ63IOnEtWBfwFBSSOplu
06xXOOeQVGQRRj7WUfTskFScUlkNsLZj9itIkycNWSfedDycVMQlZjtWqyRV
PCmoh+gfrJ1pbZ5jMbQWngBYUfqe1qO5pzyBMKJLTzylB8VRGFv5/jxT0W/l
/TOfF9mbp0PWAL43Z8a95EnVUiq5aHt7QkPGZ0+elNOgJ+2C9eF0QkvGZk+e
9ZOgJ6MA62R351ArW6jLAa4vYxF90t163LmJ8f2Keynqvy/Jk1GmVXbFDa7X
7oikaZXZ/u2Z6xnpzoTmtVey0k0u2OmtFnM2s5vdTbugvkphFceobT3ILqE/
8fdkBtTaFy1/d8M8r+UUOwN/N9fPwhtw+3OYlWqQ4JTBGNQXpr+hZn3AuNMV
tr9lH8gMqLUsWi6qBLU6/XheZuByioshyTg8kRd1r4uMPrsG1j0jOs7nXd60
pHIWSmQsZ+Eui1nJ3U8aU/kHeckItQ==\
\>"]], ",", 
   Graphics3DBox[
    {AbsolutePointSize[15], Point3DBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydmW1PE0EQgK+9tvTFFmrBlpeWIoiAIqIIGmNi/KCf/BENaQKJRoP8/Yve
7M6V67Nrb8EEubmZfW5fZmdml++T26vpz8nt9eVk/O1m8vvq+vLP+Ouvm/RV
XIqiaJr+/BhE6fPf9Mn8fEmSpDydTnfS31H0WaUoTh/S3/JybDSf0v/j9E2s
FvbtR5Vqc28/qFQXKbYYgW4b7bmSmiJVrNYajIz+TFu3/6M/1fbLIlVnev3G
0NicKONxrgfyWIa8YayP1Xo1yPpIv/8E2hjyurE+UPZ6kPW+Wm9CW4E8MNa7
2pMhtFXIfWO9k1+jQuuRsp9CW4NsZiHaUvZ+Adtab6j1QQF7zVj3tSdH0C5B
Nqtn2gj7OMi6p9Yn0NYh94z1ivbkNMi6o+wzaBuQjY9GLWWfQ9uE3DXWDWV/
CLbOv30PuQV5ZeE3HkE2+9DOwdxu5VcWtHN28QVs25A7d20X7FfOfBiFO/Ot
rxWpDoU79o1v9Jwdh8L9Q8/zU+jrlIsoLS+FfXv9IAp9kTtvBXLTS6Gfv4Lc
9X3VodDvGTPCKPTrl5CZg8w8OrGOXvUCcg/ykpfCNWDMDKNwDQ49lFl+d1pz
1hjlsyiarzH8/eDMPYfcVhL3Ws1L49iZq5pK4/r6aawVnnlmdlblODRvXszJ
e5ArSqOXVL20PuRdg8jHWFFynfysAWSpBwTF8ftbs+rZ1m+zh/7WG5A3k7sa
dNFa+GmsqWTf1iJrJ6+LVthS6WtDyBIjGinVGE6zf4x6YewRZPGpVopmxAmj
bXus2lHkRME1yBUvjVWk6Dspjf4eRtuBLJl8+cG0zEfDCfQod8cIK6uI6L33
YYiXiRFrFa7hAibmSWa9rCMuinnhVPEMX/xiP+MgougbSmQMYx/DiDKSqhLL
UeTkLOaOMGpV57GSEklgvLREriMjt+iz9Y5TKiM9+11MldQpXsjoEEbKzow8
17Fy8LceJ27u5hySVPaStrKZLlgReouftq79Yo3K1eAJwNLyoxkoiVGR+Z0x
2CWtJf6cfX9SV+eKHsgKhn12SR3tE6MgKyvuepeUnVdZH7DaY+ZzSXUlMT+z
6iSppKT5mFDx7IxAklMhcY+wmqa3WY5guMas5llj2payq7kSPE0wwmtLvKXf
82TD2shSsru9h7XmW+Z0ntHEvpSK0toSODbWGDwrVhzCko6AtQ5PvLHTkj6x
BZnn97JDaOq379+SEYBVs7mBqOa90+QA07ad+O8Xzd3H3H2MtWd0Zj5657Sz
fWR2YQTJ31tJ72yrrvaO1hf63lqxAmDmnbdeTfx3u9m9srXiuDhu8Yhqln/M
iUmYtBLPl8mwJ3/OMdftUK3tjRBPL4zOe9oDe0e3qT2g1ViZ9uZ0CC0jUJZV
7U31KHHv4eWxr1+29+lF98E9ZZrMPLtFptWyWpn45a0omV+kByYu2mjl+Hdd
ieaeyWRN/mUiVgvj6yaH1aZ67xhFpX8jgAlO\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->870692484]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->535252451],

Cell["Symbolic values for predefined absolute point sizes:", "ExampleText",
 CellID->163791331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsolutePointSize", "[", "d", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89436928],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsolutePointSize[Tiny], PointBox[{0, 0}]}], ",", 
   GraphicsBox[
    {AbsolutePointSize[Small], PointBox[{0, 0}]}], ",", 
   GraphicsBox[
    {AbsolutePointSize[Medium], PointBox[{0, 0}]}], ",", 
   GraphicsBox[
    {AbsolutePointSize[Large], PointBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->15963628]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4940],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsolutePointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsolutePointSize"]], "InlineFormula"],
 " defines the point size in units of printer's points:"
}], "ExampleText",
 CellID->301533345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"AbsolutePointSize", "[", "15", "]"}], ",", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<15 points\>\"", ",", "Black", ",", 
        RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.3"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->731553619],

Cell[BoxData[
 GraphicsBox[
  {AbsolutePointSize[15], PointBox[{0, 0}], InsetBox[
    StyleBox["\<\"15 points\"\>",
     StripOnInput->False,
     FrontFaceColor->GrayLevel[0],
     BackFaceColor->GrayLevel[0],
     GraphicsColor->GrayLevel[0],
     FontSize->15,
     FontColor->GrayLevel[0]], {0, 0.3}]}]], "Output",
 ImageSize->{184, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->398317311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->339289303],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PointSize"]], "InlineFormula"],
 " defines the point size as a fraction of the total width of the graphic:"
}], "ExampleText",
 CellID->101996017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.5", "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91390485],

Cell[BoxData[
 GraphicsBox[
  {PointSize[0.5], PointBox[{0, 0}]},
  Frame->True,
  PlotRangeClipping->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->114538667]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13829],

Cell["Points with random sizes:", "ExampleText",
 CellID->107041018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"AbsolutePointSize", "[", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "20"}], "}"}], "]"}], "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", "2", "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "200", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349910038],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.9410515411781799], AbsolutePointSize[4], 
    PointBox[{0.014497328391313236`, 0.4483340435958372}]}, 
   {Hue[0.37725387550802925`], AbsolutePointSize[18], 
    PointBox[{0.4883329444152915, 0.38169929060793706`}]}, 
   {Hue[0.39104960964400326`], AbsolutePointSize[6], 
    PointBox[{0.581733455338024, 0.13339842256086354`}]}, 
   {Hue[0.8364698481523032], AbsolutePointSize[15], 
    PointBox[{0.29630565502118067`, 0.8737400593669207}]}, 
   {Hue[0.829824931624283], AbsolutePointSize[20], 
    PointBox[{0.10112600836508845`, 0.9352729749155384}]}, 
   {Hue[0.7402409436352213], AbsolutePointSize[4], 
    PointBox[{0.2792421700232688, 0.554677119354454}]}, 
   {Hue[0.9518546944116031], AbsolutePointSize[11], 
    PointBox[{0.5330076378229816, 0.07565255054790843}]}, 
   {Hue[0.9377007354703957], AbsolutePointSize[11], 
    PointBox[{0.9396684527520434, 0.49983796714683915`}]}, 
   {Hue[0.36733743599858837`], AbsolutePointSize[16], 
    PointBox[{0.8932497127400691, 0.8667330041240076}]}, 
   {Hue[0.12685723118563108`], AbsolutePointSize[5], 
    PointBox[{0.47107861928681194`, 0.6753402909651041}]}, 
   {Hue[0.45149462741967805`], AbsolutePointSize[18], 
    PointBox[{0.9293959509276621, 0.2956822555645886}]}, 
   {Hue[0.24059704772932444`], AbsolutePointSize[16], 
    PointBox[{0.0039043280636479327`, 0.4484109211328704}]}, 
   {Hue[0.723247346134541], AbsolutePointSize[8], 
    PointBox[{0.2183484854978872, 0.6784983346762805}]}, 
   {Hue[0.5995581883562773], AbsolutePointSize[10], 
    PointBox[{0.02306841367040624, 0.6515792091148986}]}, 
   {Hue[0.8247696017974759], AbsolutePointSize[18], 
    PointBox[{0.9725839359063284, 0.8084773116036201}]}, 
   {Hue[0.28434636087950893`], AbsolutePointSize[8], 
    PointBox[{0.2720445210094764, 0.1413389924737587}]}, 
   {Hue[0.35732106459470026`], AbsolutePointSize[10], 
    PointBox[{0.967990038179972, 0.31987852115788185`}]}, 
   {Hue[0.10146735940623941`], AbsolutePointSize[13], 
    PointBox[{0.8911873584984251, 0.5685224804639144}]}, 
   {Hue[0.4071863804330904], AbsolutePointSize[12], 
    PointBox[{0.4550741573924677, 0.8954696577800163}]}, 
   {Hue[0.325462179302479], AbsolutePointSize[1], 
    PointBox[{0.29217209491190066`, 0.3827003809274314}]}, 
   {Hue[0.6191742490752503], AbsolutePointSize[2], 
    PointBox[{0.5395944094446685, 0.047591951612925065`}]}, 
   {Hue[0.6085557770882586], AbsolutePointSize[3], 
    PointBox[{0.2642591386421189, 0.5490896069969522}]}, 
   {Hue[0.04073593448403856], AbsolutePointSize[17], 
    PointBox[{0.9155305806339928, 0.751271562208569}]}, 
   {Hue[0.5022417922612972], AbsolutePointSize[14], 
    PointBox[{0.2763487727155003, 0.5365147453427284}]}, 
   {Hue[0.02468710245235628], AbsolutePointSize[12], 
    PointBox[{0.027251314197151988`, 0.8459679952640891}]}, 
   {Hue[0.4047550726033369], AbsolutePointSize[2], 
    PointBox[{0.012187859226344022`, 0.8281977187111842}]}, 
   {Hue[0.6152636681907484], AbsolutePointSize[5], 
    PointBox[{0.6694136177293013, 0.11501987225947996`}]}, 
   {Hue[0.82980049532471], AbsolutePointSize[16], 
    PointBox[{0.5329787826879686, 0.4796398463016509}]}, 
   {Hue[0.552288469698895], AbsolutePointSize[3], 
    PointBox[{0.834542039361722, 0.6507293667260445}]}, 
   {Hue[0.6564276813727317], AbsolutePointSize[5], 
    PointBox[{0.3354272006818948, 0.08582070838193734}]}, 
   {Hue[0.211198020130674], AbsolutePointSize[18], 
    PointBox[{0.25556776371290835`, 0.16367854762078027`}]}, 
   {Hue[0.7838640660959635], AbsolutePointSize[7], 
    PointBox[{0.9632158390214329, 0.03833304649478553}]}, 
   {Hue[0.046421190738477947`], AbsolutePointSize[13], 
    PointBox[{0.24728071826698605`, 0.2536240492443085}]}, 
   {Hue[0.4848836163533703], AbsolutePointSize[11], 
    PointBox[{0.6140386640693443, 0.6695975962996645}]}, 
   {Hue[0.23368167559903208`], AbsolutePointSize[1], 
    PointBox[{0.25061474468136136`, 0.9253135973597086}]}, 
   {Hue[0.837049182012845], AbsolutePointSize[12], 
    PointBox[{0.3425926170758271, 0.9860981671688511}]}, 
   {Hue[0.4491466871724392], AbsolutePointSize[18], 
    PointBox[{0.4854917384337938, 0.2893751249760781}]}, 
   {Hue[0.5296491872028637], AbsolutePointSize[9], 
    PointBox[{0.7401254483890878, 0.49822515205677487`}]}, 
   {Hue[0.03414265872941202], AbsolutePointSize[17], 
    PointBox[{0.8772632777620444, 0.4490088532296219}]}, 
   {Hue[0.4485704936145052], AbsolutePointSize[7], 
    PointBox[{0.607030988652107, 0.011385946562349814`}]}, 
   {Hue[0.6306742209753122], AbsolutePointSize[15], 
    PointBox[{0.1341171943265822, 0.23991240114853873`}]}, 
   {Hue[0.8403652621300708], AbsolutePointSize[17], 
    PointBox[{0.7521347923819626, 0.9271302948446294}]}, 
   {Hue[0.26207186235551316`], AbsolutePointSize[10], 
    PointBox[{0.3338733213958329, 0.36348900116940386`}]}, 
   {Hue[0.02431200242760756], AbsolutePointSize[14], 
    PointBox[{0.4322827148783923, 0.9409255099369895}]}, 
   {Hue[0.12089363269627551`], AbsolutePointSize[8], 
    PointBox[{0.837704881817652, 0.13849474909265935`}]}, 
   {Hue[0.2559746018746867], AbsolutePointSize[9], 
    PointBox[{0.8482227974748147, 0.8099286061068314}]}, 
   {Hue[0.21358639766798104`], AbsolutePointSize[3], 
    PointBox[{0.3528387974302438, 0.218181380147219}]}, 
   {Hue[0.9204626561730318], AbsolutePointSize[19], 
    PointBox[{0.9180298122516624, 0.3478703822952318}]}, 
   {Hue[0.20051434422101821`], AbsolutePointSize[3], 
    PointBox[{0.18370227483417434`, 0.11077796740512658`}]}, 
   {Hue[0.3577426513644133], AbsolutePointSize[3], 
    PointBox[{0.36370447421427476`, 0.8277679624988756}]}, 
   {Hue[0.6699665414498825], AbsolutePointSize[14], 
    PointBox[{0.151725051234763, 0.8731133812330261}]}, 
   {Hue[0.23763271061377056`], AbsolutePointSize[8], 
    PointBox[{0.23810676459076174`, 0.9072146137268959}]}, 
   {Hue[0.8629233182231348], AbsolutePointSize[20], 
    PointBox[{0.30266231693049717`, 0.20130978934178612`}]}, 
   {Hue[0.5083002856822247], AbsolutePointSize[18], 
    PointBox[{0.20164119460642427`, 0.8602833264991765}]}, 
   {Hue[0.18486641707218254`], AbsolutePointSize[1], 
    PointBox[{0.9250224060932952, 0.5407688241206534}]}, 
   {Hue[0.3847318181956827], AbsolutePointSize[1], 
    PointBox[{0.3964043056553863, 0.07499748751777968}]}, 
   {Hue[0.16819894189886186`], AbsolutePointSize[11], 
    PointBox[{0.33791979885204126`, 0.42453469900244634`}]}, 
   {Hue[0.9752512932744499], AbsolutePointSize[17], 
    PointBox[{0.4254811801134395, 0.8067163674788025}]}, 
   {Hue[0.9464488038085579], AbsolutePointSize[18], 
    PointBox[{0.32652741151699405`, 0.8139238512513216}]}, 
   {Hue[0.4846885387781461], AbsolutePointSize[3], 
    PointBox[{0.23034431347489637`, 0.33501100393647665`}]}, 
   {Hue[0.1812921372633196], AbsolutePointSize[19], 
    PointBox[{0.4243062129396802, 0.3481500224670231}]}, 
   {Hue[0.17423456588525066`], AbsolutePointSize[13], 
    PointBox[{0.9643522276396779, 0.0697748311808748}]}, 
   {Hue[0.9138239317817236], AbsolutePointSize[17], 
    PointBox[{0.7298755145339251, 0.8443426628493096}]}, 
   {Hue[0.7957078420991452], AbsolutePointSize[2], 
    PointBox[{0.24520650785523923`, 0.3129561475296989}]}, 
   {Hue[0.9249938096393981], AbsolutePointSize[15], 
    PointBox[{0.1110580004033932, 0.4584390293829079}]}, 
   {Hue[0.8931935419736685], AbsolutePointSize[10], 
    PointBox[{0.4347600382211043, 0.9377951816094932}]}, 
   {Hue[0.09865437964285584], AbsolutePointSize[12], 
    PointBox[{0.525517799145214, 0.1770878570355825}]}, 
   {Hue[0.3268773647058567], AbsolutePointSize[15], 
    PointBox[{0.33282761962743646`, 0.806855136214877}]}, 
   {Hue[0.3587227192207054], AbsolutePointSize[6], 
    PointBox[{0.8322338550558994, 0.08736823301905194}]}, 
   {Hue[0.015362114709184027`], AbsolutePointSize[7], 
    PointBox[{0.49615782074969483`, 0.8683853315952679}]}, 
   {Hue[0.5049228069319149], AbsolutePointSize[3], 
    PointBox[{0.7495750153658505, 0.7519727554718934}]}, 
   {Hue[0.4488510215866026], AbsolutePointSize[16], 
    PointBox[{0.5089323198240903, 0.21572048087427897`}]}, 
   {Hue[0.6427360591926605], AbsolutePointSize[4], 
    PointBox[{0.8090640781421785, 0.32079486151222736`}]}, 
   {Hue[0.5989066117415038], AbsolutePointSize[12], 
    PointBox[{0.3170026318155934, 0.33525999896617}]}, 
   {Hue[0.135039101329419], AbsolutePointSize[7], 
    PointBox[{0.9604874971925572, 0.7608169608173037}]}, 
   {Hue[0.6125987956593131], AbsolutePointSize[2], 
    PointBox[{0.7991717761468502, 0.2599659912521899}]}, 
   {Hue[0.44405279599058334`], AbsolutePointSize[14], 
    PointBox[{0.48807823601082867`, 0.7658424004297819}]}, 
   {Hue[0.5252227427130618], AbsolutePointSize[20], 
    PointBox[{0.873642364353773, 0.13285320190991712`}]}, 
   {Hue[0.11602648463538001`], AbsolutePointSize[2], 
    PointBox[{0.2685935454083639, 0.7910934806401384}]}, 
   {Hue[0.5882513662513529], AbsolutePointSize[4], 
    PointBox[{0.8980634213411018, 0.5151239969736106}]}, 
   {Hue[0.2074866104949824], AbsolutePointSize[9], 
    PointBox[{0.37016042039320696`, 0.2009299491521206}]}, 
   {Hue[0.6370697968998622], AbsolutePointSize[8], 
    PointBox[{0.9947800884108557, 0.10697338920268651`}]}, 
   {Hue[0.7507261456053687], AbsolutePointSize[6], 
    PointBox[{0.09081403329006998, 0.5771717944975199}]}, 
   {Hue[0.2395980779704785], AbsolutePointSize[10], 
    PointBox[{0.18376772192893576`, 0.49017383496512457`}]}, 
   {Hue[0.15332329301879044`], AbsolutePointSize[12], 
    PointBox[{0.9178105240863883, 0.19869643380158108`}]}, 
   {Hue[0.99607634401586], AbsolutePointSize[12], 
    PointBox[{0.8248442455016658, 0.7453460974854713}]}, 
   {Hue[0.3637550422950815], AbsolutePointSize[20], 
    PointBox[{0.4126027150929177, 0.10676964802433453`}]}, 
   {Hue[0.24838142694978638`], AbsolutePointSize[8], 
    PointBox[{0.8924350838769575, 0.052014253719946835`}]}, 
   {Hue[0.8976355702818066], AbsolutePointSize[15], 
    PointBox[{0.5154751830663371, 0.396004381862048}]}, 
   {Hue[0.22251821144807038`], AbsolutePointSize[4], 
    PointBox[{0.8270251524805399, 0.28197416880759074`}]}, 
   {Hue[0.4214882674776721], AbsolutePointSize[20], 
    PointBox[{0.45207410803776504`, 0.02725927070375267}]}, 
   {Hue[0.9077532460729385], AbsolutePointSize[9], 
    PointBox[{0.3871652028000665, 0.5245850475474816}]}, 
   {Hue[0.3629437924369585], AbsolutePointSize[16], 
    PointBox[{0.7583425648188513, 0.20095298038582565`}]}, 
   {Hue[0.32220907953244105`], AbsolutePointSize[16], 
    PointBox[{0.928379258238045, 0.8379589577998425}]}, 
   {Hue[0.4872171906738958], AbsolutePointSize[9], 
    PointBox[{0.6815520944509734, 0.21679670192549172`}]}, 
   {Hue[0.8641951632435985], AbsolutePointSize[13], 
    PointBox[{0.618720266009303, 0.5365740383109019}]}, 
   {Hue[0.27336447516975704`], AbsolutePointSize[20], 
    PointBox[{0.17723249321100387`, 0.7143713705335533}]}, 
   {Hue[0.7354021493073604], AbsolutePointSize[18], 
    PointBox[{0.001538980455785488, 0.06799049651607869}]}, 
   {Hue[0.9116920909049187], AbsolutePointSize[1], 
    PointBox[{0.07199185859227875, 0.2798877148457297}]}, 
   {Hue[0.45155160790969484`], AbsolutePointSize[3], 
    PointBox[{0.5821804867671598, 0.9721740628012459}]}, 
   {Hue[0.005424396519184027], AbsolutePointSize[8], 
    PointBox[{0.7634435955005452, 0.024002194000966703`}]}, 
   {Hue[0.6258515747250526], AbsolutePointSize[1], 
    PointBox[{0.5704375483962367, 0.6305195831549784}]}, 
   {Hue[0.21697823632420632`], AbsolutePointSize[18], 
    PointBox[{0.9211122827572742, 0.4859056059390239}]}, 
   {Hue[0.7552724784743703], AbsolutePointSize[14], 
    PointBox[{0.991040912954934, 0.5803127094661187}]}, 
   {Hue[0.7112876305914897], AbsolutePointSize[3], 
    PointBox[{0.28964786250192165`, 0.7601805177018106}]}, 
   {Hue[0.1663297319377146], AbsolutePointSize[18], 
    PointBox[{0.5243459003862889, 0.19116079512574147`}]}, 
   {Hue[0.08013401531841424], AbsolutePointSize[4], 
    PointBox[{0.9183413043570763, 0.11371765780405596`}]}, 
   {Hue[0.29609410567235606`], AbsolutePointSize[8], 
    PointBox[{0.6544195776892647, 0.12748468449679407`}]}, 
   {Hue[0.6048604641638062], AbsolutePointSize[16], 
    PointBox[{0.1697252947556127, 0.5531504231865485}]}, 
   {Hue[0.4806427098864452], AbsolutePointSize[15], 
    PointBox[{0.43339590509677306`, 0.7431387162116165}]}, 
   {Hue[0.5159390941453068], AbsolutePointSize[18], 
    PointBox[{0.9056229375044194, 0.9813827089586888}]}, 
   {Hue[0.3634483162878761], AbsolutePointSize[8], 
    PointBox[{0.3018454811456621, 0.06963566637399676}]}, 
   {Hue[0.19170127406224302`], AbsolutePointSize[19], 
    PointBox[{0.04780679418635425, 0.024354148932214992`}]}, 
   {Hue[0.10531221991137474`], AbsolutePointSize[16], 
    PointBox[{0.34530087524090103`, 0.33440994894216125`}]}, 
   {Hue[0.6103013867965992], AbsolutePointSize[8], 
    PointBox[{0.32139436772678587`, 0.38665421384033083`}]}, 
   {Hue[0.03183900666316042], AbsolutePointSize[5], 
    PointBox[{0.4027893330545862, 0.2635021875148089}]}, 
   {Hue[0.790327080324126], AbsolutePointSize[1], 
    PointBox[{0.662501449679199, 0.42373875275102346`}]}, 
   {Hue[0.26060439758560694`], AbsolutePointSize[6], 
    PointBox[{0.5507955996624085, 0.9985779605821163}]}, 
   {Hue[0.299914515565078], AbsolutePointSize[10], 
    PointBox[{0.4629357292441394, 0.5720468392089979}]}, 
   {Hue[0.22894556481822126`], AbsolutePointSize[8], 
    PointBox[{0.950013720858536, 0.397604746314701}]}, 
   {Hue[0.05341094573840621], AbsolutePointSize[3], 
    PointBox[{0.9380292124100262, 0.4709860674124582}]}, 
   {Hue[0.850668715916334], AbsolutePointSize[1], 
    PointBox[{0.07155774131178205, 0.04860303646465236}]}, 
   {Hue[0.5091392890568756], AbsolutePointSize[9], 
    PointBox[{0.49204042259944414`, 0.32745309539179956`}]}, 
   {Hue[0.9526626234958846], AbsolutePointSize[18], 
    PointBox[{0.9295478763766407, 0.8626281661890156}]}, 
   {Hue[0.6527254780327754], AbsolutePointSize[14], 
    PointBox[{0.7971341899028732, 0.6088347799525897}]}, 
   {Hue[0.7806455392882241], AbsolutePointSize[7], 
    PointBox[{0.865457511691071, 0.6334142690523468}]}, 
   {Hue[0.8956241693388927], AbsolutePointSize[7], 
    PointBox[{0.900580340039028, 0.19981909197145709`}]}, 
   {Hue[0.945615391521885], AbsolutePointSize[8], 
    PointBox[{0.661956618064423, 0.46625173684158505`}]}, 
   {Hue[0.9342081896864647], AbsolutePointSize[4], 
    PointBox[{0.38404105675481115`, 0.5660832170801204}]}, 
   {Hue[0.13014087083151282`], AbsolutePointSize[3], 
    PointBox[{0.8944830897126481, 0.5782607669160074}]}, 
   {Hue[0.5053592038842245], AbsolutePointSize[20], 
    PointBox[{0.03127575790629544, 0.9326860834747019}]}, 
   {Hue[0.532151946592679], AbsolutePointSize[6], 
    PointBox[{0.4286013530839703, 0.9657214252766035}]}, 
   {Hue[0.9982950681487419], AbsolutePointSize[6], 
    PointBox[{0.04681356556800309, 0.1364053725861345}]}, 
   {Hue[0.7571901772842553], AbsolutePointSize[20], 
    PointBox[{0.3918640663695403, 0.780872913290874}]}, 
   {Hue[0.7455262194154826], AbsolutePointSize[2], 
    PointBox[{0.633921026041705, 0.3737762901253361}]}, 
   {Hue[0.6380131682537531], AbsolutePointSize[20], 
    PointBox[{0.46262410436666834`, 0.012847696320845925`}]}, 
   {Hue[0.569254021574096], AbsolutePointSize[15], 
    PointBox[{0.9576986819570998, 0.8874021350845329}]}, 
   {Hue[0.3453488824782014], AbsolutePointSize[6], 
    PointBox[{0.6218518560143527, 0.23848646383517402`}]}, 
   {Hue[0.5854712544919534], AbsolutePointSize[19], 
    PointBox[{0.7714799948611579, 0.10332880471856298`}]}, 
   {Hue[0.41175498323765947`], AbsolutePointSize[10], 
    PointBox[{0.13949976936077535`, 0.06490600640715471}]}, 
   {Hue[0.3729632632155977], AbsolutePointSize[17], 
    PointBox[{0.054846040500683646`, 0.35503660805593906`}]}, 
   {Hue[0.8380559934849103], AbsolutePointSize[20], 
    PointBox[{0.5314560402782766, 0.7804754838885124}]}, 
   {Hue[0.2690023773547061], AbsolutePointSize[14], 
    PointBox[{0.24019524495648037`, 0.2111782810833982}]}, 
   {Hue[0.7217535623366524], AbsolutePointSize[17], 
    PointBox[{0.6503527247582057, 0.7231994425755748}]}, 
   {Hue[0.5406033768708784], AbsolutePointSize[8], 
    PointBox[{0.37069810464294983`, 0.40566180622046266`}]}, 
   {Hue[0.7579406108686642], AbsolutePointSize[16], 
    PointBox[{0.6292601326776737, 0.40395036258949557`}]}, 
   {Hue[0.7577182610752105], AbsolutePointSize[8], 
    PointBox[{0.9434089209383716, 0.43294009561961344`}]}, 
   {Hue[0.46097926349370666`], AbsolutePointSize[7], 
    PointBox[{0.9685120782863665, 0.5677460184618883}]}, 
   {Hue[0.03868900283300247], AbsolutePointSize[4], 
    PointBox[{0.7693795647616439, 0.9509463110254168}]}, 
   {Hue[0.34005197466890724`], AbsolutePointSize[5], 
    PointBox[{0.7880728298423361, 0.8896579545813403}]}, 
   {Hue[0.10927191223847466`], AbsolutePointSize[3], 
    PointBox[{0.0917553081944591, 0.16165761227116682`}]}, 
   {Hue[0.489890573057459], AbsolutePointSize[7], 
    PointBox[{0.7913411690355836, 0.2925622696893022}]}, 
   {Hue[0.498196358369678], AbsolutePointSize[7], 
    PointBox[{0.05382544376500098, 0.5427701823302593}]}, 
   {Hue[0.2524763807106074], AbsolutePointSize[9], 
    PointBox[{0.7576418149347528, 0.39114460906801063`}]}, 
   {Hue[0.6666917514391759], AbsolutePointSize[14], 
    PointBox[{0.29924319140137934`, 0.8787979093548361}]}, 
   {Hue[0.7806894939943163], AbsolutePointSize[11], 
    PointBox[{0.662473859989809, 0.31637470489482866`}]}, 
   {Hue[0.8291279326253158], AbsolutePointSize[10], 
    PointBox[{0.0707202143251775, 0.6528121302019343}]}, 
   {Hue[0.7728809868615716], AbsolutePointSize[14], 
    PointBox[{0.9195189074915668, 0.12112001161469088`}]}, 
   {Hue[0.949050035823729], AbsolutePointSize[8], 
    PointBox[{0.26868651252288855`, 0.5799339075244951}]}, 
   {Hue[0.6933460305005039], AbsolutePointSize[17], 
    PointBox[{0.65264629091238, 0.7124283418072619}]}, 
   {Hue[0.464501895220627], AbsolutePointSize[13], 
    PointBox[{0.6219954906242386, 0.4041092528401893}]}, 
   {Hue[0.7769939505548398], AbsolutePointSize[4], 
    PointBox[{0.6993767595903779, 0.09429234597894465}]}, 
   {Hue[0.9458336976479866], AbsolutePointSize[7], 
    PointBox[{0.28847337200705114`, 0.7370580035101797}]}, 
   {Hue[0.2225262773224057], AbsolutePointSize[19], 
    PointBox[{0.3703713785135716, 0.28748552202233757`}]}, 
   {Hue[0.980783139179185], AbsolutePointSize[16], 
    PointBox[{0.4520826027978555, 0.9958253496018572}]}, 
   {Hue[0.769249159154795], AbsolutePointSize[18], 
    PointBox[{0.8728665793815431, 0.1340592620226575}]}, 
   {Hue[0.5688994127609281], AbsolutePointSize[12], 
    PointBox[{0.34618516625765516`, 0.8539337952585078}]}, 
   {Hue[0.33785784263285357`], AbsolutePointSize[7], 
    PointBox[{0.1931413164633009, 0.9777602611313987}]}, 
   {Hue[0.9606576653745245], AbsolutePointSize[18], 
    PointBox[{0.5640213582067872, 0.42565247634428527`}]}, 
   {Hue[0.6276298070683197], AbsolutePointSize[1], 
    PointBox[{0.977123354597627, 0.33289717644248373`}]}, 
   {Hue[0.18790985517269476`], AbsolutePointSize[1], 
    PointBox[{0.7198488548217541, 0.5781007270872263}]}, 
   {Hue[0.016885435190309828`], AbsolutePointSize[7], 
    PointBox[{0.4051542080875601, 0.08685203354516324}]}, 
   {Hue[0.2982012682652575], AbsolutePointSize[7], 
    PointBox[{0.6380815275009446, 0.5762591223526417}]}, 
   {Hue[0.550288251523438], AbsolutePointSize[6], 
    PointBox[{0.8514145804282225, 0.7297440976180045}]}, 
   {Hue[0.7340462044712943], AbsolutePointSize[12], 
    PointBox[{0.29310818449683307`, 0.62601143449237}]}, 
   {Hue[0.042750009016958135`], AbsolutePointSize[11], 
    PointBox[{0.20716982738648237`, 0.2750813340438887}]}, 
   {Hue[0.9453296179746349], AbsolutePointSize[8], 
    PointBox[{0.6077419193676779, 0.3256316370417165}]}, 
   {Hue[0.126300808246103], AbsolutePointSize[15], 
    PointBox[{0.7742038428751274, 0.6994517437259502}]}, 
   {Hue[0.2923595678143138], AbsolutePointSize[11], 
    PointBox[{0.15887951311336646`, 0.6140094589257719}]}, 
   {Hue[0.7870396800555788], AbsolutePointSize[15], 
    PointBox[{0.8586365041421358, 0.546788378893073}]}, 
   {Hue[0.13144181299874114`], AbsolutePointSize[10], 
    PointBox[{0.9387297926290905, 0.16378457317618156`}]}, 
   {Hue[0.7816554494914385], AbsolutePointSize[4], 
    PointBox[{0.23960929728019043`, 0.5048680755693415}]}, 
   {Hue[0.22173317895057143`], AbsolutePointSize[10], 
    PointBox[{0.24598608807369216`, 0.4872760724741889}]}, 
   {Hue[0.32593478497723183`], AbsolutePointSize[17], 
    PointBox[{0.9083839895919059, 0.7877932679639503}]}, 
   {Hue[0.6380437111310198], AbsolutePointSize[3], 
    PointBox[{0.8653099969099707, 0.6904722245223587}]}, 
   {Hue[0.02356893450970654], AbsolutePointSize[3], 
    PointBox[{0.805131902894094, 0.15846500483065307`}]}, 
   {Hue[0.7310433680138535], AbsolutePointSize[16], 
    PointBox[{0.5622826331458193, 0.7340024304066621}]}, 
   {Hue[0.11493870874908385`], AbsolutePointSize[1], 
    PointBox[{0.5352671326130036, 0.9826228382078299}]}, 
   {Hue[0.656106157357081], AbsolutePointSize[13], 
    PointBox[{0.48012981881717876`, 0.12729103082174587`}]}, 
   {Hue[0.5900528194605481], AbsolutePointSize[1], 
    PointBox[{0.9838880550056261, 0.6605176524734482}]}, 
   {Hue[0.8665166245481033], AbsolutePointSize[19], 
    PointBox[{0.4351972825441559, 0.7842790672170346}]}, 
   {Hue[0.8862129208130811], AbsolutePointSize[8], 
    PointBox[{0.7140980209804759, 0.9089494239323206}]}, 
   {Hue[0.658526219053333], AbsolutePointSize[9], 
    PointBox[{0.2194907991514412, 0.12853278045789662`}]}, 
   {Hue[0.0902552197642017], AbsolutePointSize[9], 
    PointBox[{0.06872078017827521, 0.6136741617983663}]}, 
   {Hue[0.7698192166788336], AbsolutePointSize[20], 
    PointBox[{0.8705460555421516, 0.9376905888070606}]}, 
   {Hue[0.18517297808087663`], AbsolutePointSize[19], 
    PointBox[{0.5835773569729878, 0.7636646069729609}]}, 
   {Hue[0.5374642120070006], AbsolutePointSize[1], 
    PointBox[{0.9812832994909864, 0.058054043137035105`}]}, 
   {Hue[0.4539582286938926], AbsolutePointSize[2], 
    PointBox[{0.6474917041705459, 0.10120443449689631`}]}, 
   {Hue[0.8653508761591626], AbsolutePointSize[16], 
    PointBox[{0.305738480559, 0.7117753635462831}]}, 
   {Hue[0.8007281408830274], AbsolutePointSize[2], 
    PointBox[{0.2536697387755187, 0.29725285851878325`}]}}]], "Output",
 ImageSize->{184, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->527138174]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29011],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Offset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Offset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PointSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteThickness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteThickness"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteDashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteDashing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30771]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6202],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->65958460],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->300672800]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AbsolutePointSize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 22.5945524}", "context" -> "System`", 
    "keywords" -> {"absolute size", "styling of points"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AbsolutePointSize[d] is a graphics directive which specifies that points \
which follow are to be shown if possible as circular regions with absolute \
diameter d. ", "synonyms" -> {"absolute point size"}, "title" -> 
    "AbsolutePointSize", "type" -> "Symbol", "uri" -> 
    "ref/AbsolutePointSize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10156, 283, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->52273055]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 50370, 1213}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2166, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2789, 80, 4201, 83, 70, "ObjectNameGrid"],
Cell[6993, 165, 676, 20, 70, "Usage",
 CellID->13261]
}, Open  ]],
Cell[CellGroupData[{
Cell[7706, 190, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8184, 207, 239, 7, 70, "Notes",
 CellID->10195],
Cell[8426, 216, 540, 16, 70, "Notes",
 CellID->32525],
Cell[8969, 234, 769, 29, 70, "Notes",
 CellID->1264],
Cell[9741, 265, 378, 13, 70, "Notes",
 CellID->8260]
}, Closed]],
Cell[CellGroupData[{
Cell[10156, 283, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52273055],
Cell[CellGroupData[{
Cell[10540, 297, 148, 5, 70, "ExampleSection",
 CellID->761188656],
Cell[10691, 304, 96, 1, 70, "ExampleText",
 CellID->62157263],
Cell[CellGroupData[{
Cell[10812, 309, 480, 16, 28, "Input",
 CellID->144138276],
Cell[11295, 327, 515, 16, 123, "Output",
 CellID->22512264]
}, Open  ]],
Cell[11825, 346, 125, 3, 70, "ExampleDelimiter",
 CellID->562345042],
Cell[CellGroupData[{
Cell[11975, 353, 533, 17, 70, "Input",
 CellID->590339034],
Cell[12511, 372, 6688, 122, 131, "Output",
 CellID->870692484]
}, Open  ]],
Cell[19214, 497, 125, 3, 70, "ExampleDelimiter",
 CellID->535252451],
Cell[19342, 502, 95, 1, 70, "ExampleText",
 CellID->163791331],
Cell[CellGroupData[{
Cell[19462, 507, 494, 16, 70, "Input",
 CellID->89436928],
Cell[19959, 525, 528, 16, 123, "Output",
 CellID->15963628]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20536, 547, 232, 7, 70, "ExampleSection",
 CellID->4940],
Cell[20771, 556, 248, 7, 70, "ExampleText",
 CellID->301533345],
Cell[CellGroupData[{
Cell[21044, 567, 548, 16, 70, "Input",
 CellID->731553619],
Cell[21595, 585, 449, 14, 64, "Output",
 CellID->398317311]
}, Open  ]],
Cell[22059, 602, 125, 3, 70, "ExampleDelimiter",
 CellID->339289303],
Cell[22187, 607, 251, 7, 70, "ExampleText",
 CellID->101996017],
Cell[CellGroupData[{
Cell[22463, 618, 402, 12, 70, "Input",
 CellID->91390485],
Cell[22868, 632, 303, 10, 163, "Output",
 CellID->114538667]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23220, 648, 224, 7, 70, "ExampleSection",
 CellID->13829],
Cell[23447, 657, 68, 1, 70, "ExampleText",
 CellID->107041018],
Cell[CellGroupData[{
Cell[23540, 662, 609, 18, 70, "Input",
 CellID->349910038],
Cell[24152, 682, 22572, 406, 202, "Output",
 CellID->527138174]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46785, 1095, 311, 9, 70, "SeeAlsoSection",
 CellID->29011],
Cell[47099, 1106, 971, 35, 70, "SeeAlso",
 CellID->30771]
}, Open  ]],
Cell[CellGroupData[{
Cell[48107, 1146, 313, 9, 70, "TutorialsSection",
 CellID->6202],
Cell[48423, 1157, 197, 4, 70, "Tutorials",
 CellID->815154705]
}, Open  ]],
Cell[CellGroupData[{
Cell[48657, 1166, 318, 9, 70, "MoreAboutSection",
 CellID->65958460],
Cell[48978, 1177, 149, 3, 70, "MoreAbout",
 CellID->300672800]
}, Open  ]],
Cell[49142, 1183, 50, 0, 70, "History"],
Cell[49195, 1185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

