(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50500,       1471]
NotebookOptionsPosition[     45073,       1286]
NotebookOutlinePosition[     46448,       1324]
CellTagsIndexPosition[     46362,       1319]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Thick" :> Documentation`HelpLookup["paclet:ref/Thick"], "Thin" :> 
          Documentation`HelpLookup["paclet:ref/Thin"], "Thickness" :> 
          Documentation`HelpLookup["paclet:ref/Thickness"], "Offset" :> 
          Documentation`HelpLookup["paclet:ref/Offset"], "AbsoluteDashing" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteDashing"], 
          "AbsolutePointSize" :> 
          Documentation`HelpLookup["paclet:ref/AbsolutePointSize"], 
          "PointSize" :> Documentation`HelpLookup["paclet:ref/PointSize"], 
          "Dashing" :> Documentation`HelpLookup["paclet:ref/Dashing"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Thick\"\>", 
       2->"\<\"Thin\"\>", 3->"\<\"Thickness\"\>", 4->"\<\"Offset\"\>", 
       5->"\<\"AbsoluteDashing\"\>", 6->"\<\"AbsolutePointSize\"\>", 
       7->"\<\"PointSize\"\>", 8->"\<\"Dashing\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Directives\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AbsoluteThickness", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteThickness",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteThickness"], "[", 
       StyleBox["d", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that lines \
which follow are to be drawn with absolute thickness ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6072]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The absolute thickness is measured in units of printer\[CloseCurlyQuote]s \
points, equal before magnification to ",
 Cell[BoxData[
  FractionBox["1", "72"]], "InlineFormula"],
 " of an inch. "
}], "Notes",
 CellID->29350],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteThickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteThickness"]], "InlineFormula"],
 " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics, \
as well as in ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " specifications. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->18823],

Cell[TextData[{
 "The following symbolic forms for ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " can be used: ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->14485],

Cell[TextData[{
 "The initial default is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteThickness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteThickness"], "[", "0.5", "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->20556]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->690039376],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->40269442],

Cell["\<\
Specify the thickness of lines in units of printer's points: \
\>", "ExampleText",
 CellID->134466735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteThickness", "[", "d", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "2", ",", "5"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10989625],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteThickness[0.5], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], ",",
    
   GraphicsBox[
    {AbsoluteThickness[2], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteThickness[5], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->448961974]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteThickness", "[", "i", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "4", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "2", ",", "5"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26604277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {AbsoluteThickness[0.5], 
     Line3DBox[{{1, 1, 0}, {2, 2, 1}, {3, 3, 0}, {4, 4, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVWG1PE0EQ3t5de6WtQIFCLYXWIoIQXgRBNDEmftBP+h8aaAIfjAb5+xe9
nX32Xp49utCk3Zub2Wdedmd2tj+mD7ezX9OHu+vp+Pv99M/t3fXf8bff9+mr
sKaUukm/P/sqff6XPsn3JkkSpb6mv+FsNhsJ9QVUkI5BOm7L28+g6prS7HRM
f9WWcD9hTlzJ/QBuS1OR4RqBofAvgP1CU/WMD4xNkTkDxtIcmVPgrBSs0I8B
0X2RPgLiGnFDojdE+gDSG0+S3oclA+JGRK+L9C6wtzzYRnoH2GMPdk+kx8Ce
ELdOtERBbQN790nSm8DeI26D6FWR7kP6gLgx0bJ64qu25OhJ0qvAPiFuk+iu
SHeBfUbcBaKXRXoR2OeY1a6U6oB7nuTZMw9b9rG8DWGJHjlyPGtRZjVoFktV
z4oKXoc22+bMEr6zB08wu+uZ3ZHZEoUorwcm67QVPc9KufMNRKBMdlXlItvQ
zjFiqhjCUeo1kDY9SK0c6ZG6otFsro08vlWjhYQ2TKozt3K1HbSoEDklnw3g
vfHgNc2MMA9UXF4Flecb5zJ76mI1HSydP3pHHHuwYgdrATNN6JSya64nnXq8
bDhobSdiMbDeeyxzsTqOlyGwrjxYdQeL81Q/HmrPlalN87yMgFbO6rAQM/15
C7QAI2tkG13UNlZCdmG9mGsaX843pXAumIXKIj5HT+joacL6eqWeCexvPVNP
4OipJ4XK6ugZFeKkx+fjB0mhBkdFfI03QLy65Aevboyol+OkFzeoqNABofWg
refRYnducU8aj6rqOGtZgZY+xiK6gKY/3LnUMnTbBYSEuogIDem9XTdeASDS
215l9DsYpb+KMmwg83nInZHRxFK+KDXgz8RaZBJzVu6orb5aSmo9Rldl3zdH
Vwj/JiWPyjGcr5ElqjRqDcUao6MZZf48ri1ytOnY2L3gnpc50hb8sevHvVTo
IPMu4ZvAKCn2OrkmjnjgIHMOMfIA0eDc433jIrc8yOuweYAoiK2lCib1QbBs
1eb1W0mKfUxunVvdNZaxi8+MVaJfwOMdwShmlS0t1k/3VGMs2zXvJ/m5Ve4S
Dc5SBY721/bPcrdoZLZkRcnMXp4TaVu53nGEstn2jrGG8dLamkmwV1yvr0ox
4XVm6y7hk5HmFeVInGE1zEluqyxLHUPKdHF94naIPkzy/FPqJXH5jNwDtrkH
8T2Zd/kOpM1N0tetjyBt7uJDeMdStr82/x1sE5erRx+Y5t8Q7vC5iq1BWuq5
8t3UlyEtnbl6RVyuCR1IS+9tep6Kc8nmiHTVcs8pZ0gMFNnB0qGV9ja4F8LV
dum0/yiUqv0H9X6LtA==\
\>"]], ",", 
   Graphics3DBox[
    {AbsoluteThickness[2], 
     Line3DBox[{{1, 1, 0}, {2, 2, 1}, {3, 3, 0}, {4, 4, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyNmNtuEzEQhjd7SNIkNGmbpuk5tLSFnugBEKqEkBCCK3iHqIrUXiBQ6euv
YGf8e7P5bcWJ1GRnZ/yNx/aM7f4YPz9Mfo2fH+/Ho+9P4z8Pj/d/R99+PxWv
kloURZPi7+cwKp7/FU/69zXP8yiZTCa5fqI9+Yq+FN/ycqTSZ0hx8RsXv/v6
9hOkrEIovkG4Q5uGV/sRbVsipaX34mFX9e/RuiNSVurB2FGbG9h059hcwc8q
RRmTvKnWFyCuB6yHan0G9nAh69dgb5E2IXlDrY/B3iVtSvJArQ/B3l/IegTr
A9JmJOso6HxJT45IWye5r9bbYJ8sZL0J9ilpGySvqfUA7HPSNknWuVYPwn67
kPUK2NekXSJ5Ra2XYX0LHx2y6qlVB9rbfJo989im1RKs7ermkeNWuvp1xOJK
q1ag1bK2SitRy++LhVvF0TS3VgKtlGrWuWR6ZD/n8NoPtNfRdbIqLQgnIGws
TnDqRBJN82c7wGl7exI7ke3n/nxkXsvLKysCaDLWWyAeki2vZj8xxUxJrDaL
jgN9W/KS6k6sa7k/h7lnhqfBmZfmzQyri75dBFhNh1Wu98qYtUC7CkTacGjt
ioWl1UF7F+ibS+t4aDFob1RXvEBrriRMrzv0F0RPMBdZ8cz5zLTMoS1jNm12
NaMo2CeX0kZ0uvBKQ5tp0rMUcoidgj1rISLvVkIbgS5zIBG0A/TEoWeg8xoR
2g7obfSd6bxruXQ76zov01MPeEPwu5C5htsaPzsmMsy2CsfYZaT1OmirGAuO
KLFzVJk302OhDDyjKx7qtoKAmNn+cD1UCtflFGsysxWtklfcv1ruqz/r3pFr
gbmLWO26Mx8+YfGOajyxld9THZ5eWm1Zu3j2eX0aLzxWfi8JvNiTmp1T9sE0
4yPDShg47GZlb6pXIgoz2TPv2baHcloUly3MhJOlXjrnJdNtn3vwwlReJYbK
K4qp9qzaB9W7jh0qZyVTBxiBIUaAIxZqrRCFZohtzBffOlbRv718uirc84vJ
Nq70dle2O+pBlTFz3zLtlwNRNRHVMaLSKahi0I9ugGNPnOfoT2WHKPvS84yH
Firs5doOVWvqmW94ayTfomVc+mELJsgdNEYLM1McDZ987a3V8Hk+eyRfY0zN
/jlA1Gx1mVfqY8R3TZ73UzDNiXeTtLxjncDa3Dz4Zsor/RDW05teeYOnXLXr
31TkeXvkDqIzt/U90nJtGoJt/v/Ap2uuCn1Y65lZa+m8OteDtd5ctb6Xey2N
t4hnaqVkJyPbIF2qzaucM64B/Y3qjyoeJtiORftBtZJv4uBOpaj2H7UE/j0=
\
\>"]], ",", 
   Graphics3DBox[
    {AbsoluteThickness[5], 
     Line3DBox[{{1, 1, 0}, {2, 2, 1}, {3, 3, 0}, {4, 4, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyNl21PE0EQx7ft9Yk+UkqplIcKgoKCAmrUxJj4Ql/pd2hIE3hhNMjXv+jO
7H+57f+WXi9p72Zn5rePszv7Y3Z/M/81u7+9nk2/383+3Nxe/51++31niyol
Y8zc/n6Ojf3+Z7/0N0/T1Jiv9j+Zz+f7Kn2x/xUrle27/FD6GVJVJFHbt/03
e6r9BJ+6SInTOoNd1X+Ad4u8nfYdvDs57x3VX8G7L1L1QQ/GRG3egDFYYnMG
m82gFfJZJnms1i9R65i0FZK31PoF2NsrWR+DvUvahOSRWh+CvU/aKsnaL/MU
7IOVrPfAfkbaGslDtZ7A+vlK1k/QklPS1kneUOsR2K9I2yBZZ1hrEPbrlazX
wb4gbZPkdbXugX0FrxZZ6To0bWgv0yxelrGdV5O8eOTYq6dedbTIe60VeHXV
S9deVSLfP/bbXIDVWZlRM1ns9Au8OlnNFVRon8T+TkAYFhDaUYJ04wgEjkie
c0fg+WhYwhSESUEbWhkh24/sI4ydNB6NzFiLtqIMio+Nw4K+xCkVUDbRlqOC
tjSjlCoofVBOCiiNKKUGio+Hs4IeOYp2wRVqPUJopPEoZUI9R5BRaqLIj4es
OY5c7lEtR5Je1KXIysf4Zgq3J0/poH6Z4bJ9y+7aWoFUzZG66JGsf9nZe/bN
0c+UJEdpgeLLJKKkZ7tWHBgTn+mlRD9XD6cK4rSGtd0xsA/Ki2qBOY2HiM1I
LSPUkmDuo+uMT3nDJSLKGMv6G4Do1yOfU34XTvKkOTIPamMXxPYjRL9ew5F1
o7CQpwTEFog99Do8P8SSczT5LOVmbxQh10Eeoq1iLpsfj6Oj8S4Qa2sC4haI
0jbOh/j8c3S2CjM2oW8Yl4sIlXsb732CuRsRqR/s6A20eVlG5mjRfCegdkyW
KyXBeBaTeYUwWeZ8O5iZGJllR+Z55HPYR24FuYHUFDt3SlYUoqNyTDO1Yinj
NMvNGxFqOUddw2xt4r2FHo9A4HhZ9G4XtMlngxP00lTDM16jSDmcITGnA87U
t2rh7uIY3QJGAz2TE6L+CMPno3xvSdLs3FZfxF/Wg3Xy2ODZsZ/nqcvwQm83
joOIt89Ca4hnZ8lc9hSP6oJHbE5C+a1fPHN9Ak+/JtjD58YVv8LcXYsz2kA+
T4MdznBWybN/CmuXXT4hLa+5Y1i7rH8bbWarA1i5+9IOaTm29tMg/3V35yXn
3QRsd/fdIy3vMz7C3G2/6KY5hLVmr5pVx84dH2d6WzR8H+VdoAOm3hb1zpuP
yxZsztVG76wL8VKH/lL1/r7g4+S9lkprBPxRJVP6D1aaW8s=\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->163880823]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83527806],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Thick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thick"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Thin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thin"]], "InlineFormula"],
 " to specify predefined absolute thicknesses:"
}], "ExampleText",
 CellID->51732873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thin", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->593165007],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[Tiny], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Large], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{230, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->228788790]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198440045],

Cell["Symbolic values for predefined absolute thicknesses: ", "ExampleText",
 CellID->144867266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteThickness", "[", "d", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177085957],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteThickness[Tiny], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], 
   ",", 
   GraphicsBox[
    {AbsoluteThickness[Small], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], 
   ",", 
   GraphicsBox[
    {AbsoluteThickness[Medium], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], 
   ",", 
   GraphicsBox[
    {AbsoluteThickness[Large], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{452, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->388341578]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12717],

Cell["Style curve elements of plots: ", "ExampleText",
 CellID->25970681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151807951],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->247085485]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18696],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteThickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteThickness"]], "InlineFormula"],
 " defines the thickness of lines in units of printer's points:"
}], "ExampleText",
 CellID->106323155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"AbsoluteThickness", "[", "15", "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<15 points\>\"", ",", "White", ",", 
        RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->275776734],

Cell[BoxData[
 GraphicsBox[
  {AbsoluteThickness[15], LineBox[{{-1, 0}, {1, 0}}], InsetBox[
    StyleBox["\<\"15 points\"\>",
     StripOnInput->False,
     FrontFaceColor->GrayLevel[1],
     BackFaceColor->GrayLevel[1],
     GraphicsColor->GrayLevel[1],
     FontSize->15,
     FontColor->GrayLevel[1]], {0, 0}]}]], "Output",
 ImageSize->{154, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->205554653]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteThickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteThickness"]], "InlineFormula"],
 " is independent of the image size:"
}], "ExampleText",
 CellID->353597015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteThickness", "[", "3", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "100", ",", "150"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10908331],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteThickness[3], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->50], ",", 
   GraphicsBox[
    {AbsoluteThickness[3], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->100], ",", 
   GraphicsBox[
    {AbsoluteThickness[3], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->150]}], "}"}]], "Output",
 ImageSize->{341, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31861693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266255764],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 " defines the thickness ",
 "as a fraction of the total width of the graphic",
 ":"
}], "ExampleText",
 CellID->371080297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Thickness", "[", ".5", "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}],
    ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26636789],

Cell[BoxData[
 GraphicsBox[
  {Thickness[0.5], 
   LineBox[NCache[{{Rational[1, 2], 0}, {Rational[1, 2], 1}}, {{0.5, 0}, {
      0.5, 1}}]]},
  Frame->True,
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{154, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->489238264]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 " depends on the image size:"
}], "ExampleText",
 CellID->85601104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", ".03", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "100", ",", "150"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146120593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[0.03], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->50], ",", 
   GraphicsBox[
    {Thickness[0.03], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->100], ",", 
   GraphicsBox[
    {Thickness[0.03], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->150]}], "}"}]], "Output",
 ImageSize->{341, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->185552762]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24423],

Cell["Lines with random thickness:", "ExampleText",
 CellID->254482646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"AbsoluteThickness", "[", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "10"}], "}"}], "]"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "50", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75183773],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.31602052030732053`], AbsoluteThickness[5], 
    LineBox[{{0.809241951717204, 0.09153107679681316}, {0.5870075854234753, 
     0.7097488191727679}}]}, 
   {Hue[0.25230912897874047`], AbsoluteThickness[9], 
    LineBox[{{0.07610526151763142, 0.48547801618748454`}, {0.9432202563784049,
      0.6519767840091422}}]}, 
   {Hue[0.7552384588162271], AbsoluteThickness[1], 
    LineBox[{{0.406736201220103, 0.5927064587196322}, {0.14807866771421785`, 
     0.009825035359581236}}]}, 
   {Hue[0.9310061551524054], AbsoluteThickness[8], 
    LineBox[{{0.0550162206232232, 0.007618808430922996}, {0.9861464946098917, 
     0.2387532587739094}}]}, 
   {Hue[0.26427260254557816`], AbsoluteThickness[7], 
    LineBox[{{0.3158817786214614, 0.25599979667390826`}, {
     0.13401337348789144`, 0.0034458058413835424`}}]}, 
   {Hue[0.8144232474370798], AbsoluteThickness[7], 
    LineBox[{{0.6824230961491156, 0.8507814530404578}, {0.0627431797062481, 
     0.02703255737960064}}]}, 
   {Hue[0.03357288550756099], AbsoluteThickness[1], 
    LineBox[{{0.8375230760467527, 0.6815999237380905}, {0.5605774455406585, 
     0.31477412215188627`}}]}, 
   {Hue[0.9837309990543348], AbsoluteThickness[1], 
    LineBox[{{0.43161495188560073`, 0.11400772154660377`}, {
     0.31279476331315537`, 0.36280811411157887`}}]}, 
   {Hue[0.3999134307569474], AbsoluteThickness[6], 
    LineBox[{{0.6781526640281303, 0.5183091161856872}, {0.6192127656571111, 
     0.28343245226963454`}}]}, 
   {Hue[0.5553636834288105], AbsoluteThickness[8], 
    LineBox[{{0.31942210664814197`, 0.06456775985456198}, {0.7770944643288189,
      0.7571640237107309}}]}, 
   {Hue[0.41606689129525365`], AbsoluteThickness[7], 
    LineBox[{{0.8864715851674818, 0.7497132041733059}, {0.9243222243029277, 
     0.7241929325183674}}]}, 
   {Hue[0.9668130569931297], AbsoluteThickness[1], 
    LineBox[{{0.9766082462785863, 0.09947912552089799}, {0.4129515429861641, 
     0.6477876016688697}}]}, 
   {Hue[0.249682497819524], AbsoluteThickness[8], 
    LineBox[{{0.4478185000518893, 0.3862888969031377}, {0.910943368965236, 
     0.3502311098755788}}]}, 
   {Hue[0.7603875956255823], AbsoluteThickness[9], 
    LineBox[{{0.8069530684721689, 0.1209872990492975}, {0.16768429479208047`, 
     0.33826823334435696`}}]}, 
   {Hue[0.7391938278636301], AbsoluteThickness[2], 
    LineBox[{{0.9109996030226821, 0.9462070623259216}, {0.5066356096262368, 
     0.05734267404126525}}]}, 
   {Hue[0.05122266246156859], AbsoluteThickness[7], 
    LineBox[{{0.5636175071368694, 0.9737793461401594}, {0.38352946104312857`, 
     0.8709341899632554}}]}, 
   {Hue[0.0686961014501013], AbsoluteThickness[1], 
    LineBox[{{0.41107842764917035`, 0.6960063817774877}, {0.6203769699986328, 
     0.7355326994670977}}]}, 
   {Hue[0.09291547408743583], AbsoluteThickness[4], 
    LineBox[{{0.34195476766055966`, 0.39685256695701177`}, {0.440161771149858,
      0.8527802586449047}}]}, 
   {Hue[0.7364683089323476], AbsoluteThickness[7], 
    LineBox[{{0.9376779092289667, 0.20368335186306563`}, {0.08215911909089324,
      0.24814578647891583`}}]}, 
   {Hue[0.37030114979137774`], AbsoluteThickness[6], 
    LineBox[{{0.9424529956432015, 0.9187307226781887}, {0.06360563618521597, 
     0.5478619865781267}}]}, 
   {Hue[0.7216956218031996], AbsoluteThickness[10], 
    LineBox[{{0.30930265927477696`, 0.04761301951785213}, {0.746642125487557, 
     0.939423922301313}}]}, 
   {Hue[0.12939645722601112`], AbsoluteThickness[4], 
    LineBox[{{0.12288933577750116`, 0.6454192892405219}, {
     0.12543236724661666`, 0.061750236820853344`}}]}, 
   {Hue[0.14666938302196897`], AbsoluteThickness[4], 
    LineBox[{{0.28560209355223254`, 0.7061042660822967}, {0.7221788847122865, 
     0.044809329637465645`}}]}, 
   {Hue[0.7531589133696313], AbsoluteThickness[5], 
    LineBox[{{0.30836990323307845`, 0.6038529264409962}, {0.936799838460459, 
     0.17412376846311006`}}]}, 
   {Hue[0.7983522412917705], AbsoluteThickness[3], 
    LineBox[{{0.33945166219942435`, 0.22241890529045394`}, {
     0.21266216356382195`, 0.8786428198975695}}]}, 
   {Hue[0.6909420813722973], AbsoluteThickness[5], 
    LineBox[{{0.24281089438949488`, 0.5552051328140493}, {0.7634328899068399, 
     0.2110457857713226}}]}, 
   {Hue[0.7209792474871837], AbsoluteThickness[8], 
    LineBox[{{0.23347540280681156`, 0.13162819165869966`}, {
     0.7197272175778524, 0.7085394574801196}}]}, 
   {Hue[0.13556722597864845`], AbsoluteThickness[3], 
    LineBox[{{0.5076976045100856, 0.8423120631739343}, {0.6943275502191151, 
     0.2946892927610636}}]}, 
   {Hue[0.731565250321975], AbsoluteThickness[3], 
    LineBox[{{0.4776674622276138, 0.0029305073637861945`}, {
     0.11246303051368756`, 0.5820308417081175}}]}, 
   {Hue[0.9719036532419314], AbsoluteThickness[4], 
    LineBox[{{0.9800140550587988, 0.14230036424507264`}, {
     0.32182894683946905`, 0.327849419989092}}]}, 
   {Hue[0.9017792984159947], AbsoluteThickness[9], 
    LineBox[{{0.9871928654843034, 0.1735373976582033}, {0.5974750540605795, 
     0.28562335538526407`}}]}, 
   {Hue[0.1520958742129106], AbsoluteThickness[6], 
    LineBox[{{0.16166165360120743`, 0.9422498492922884}, {0.580478147978644, 
     0.6020768154444309}}]}, 
   {Hue[0.5488927460169322], AbsoluteThickness[9], 
    LineBox[{{0.6502678638144661, 0.6093292473319671}, {0.6969479639623606, 
     0.6078220495571838}}]}, 
   {Hue[0.0007598953778580331], AbsoluteThickness[6], 
    LineBox[{{0.30171053644414947`, 0.7721599999804023}, {0.8349852350206983, 
     0.9131183954980617}}]}, 
   {Hue[0.7338851688471326], AbsoluteThickness[4], 
    LineBox[{{0.005898409858883236, 0.5918137119352609}, {0.2570374839337106, 
     0.7951133016089107}}]}, 
   {Hue[0.23566748367905133`], AbsoluteThickness[2], 
    LineBox[{{0.27165317981069514`, 0.862672194116689}, {0.0565854406009727, 
     0.6222072966443419}}]}, 
   {Hue[0.7492453530123633], AbsoluteThickness[2], 
    LineBox[{{0.376573477585882, 0.5197994634516281}, {0.33853012734339494`, 
     0.8886930688338079}}]}, 
   {Hue[0.8063183200492634], AbsoluteThickness[5], 
    LineBox[{{0.3862567290036254, 0.07885986133440004}, {0.3611443005508521, 
     0.5764022438906606}}]}, 
   {Hue[0.8968378618320161], AbsoluteThickness[2], 
    LineBox[{{0.5871053947065119, 0.7265360332628257}, {0.4670275382988771, 
     0.26890178886800586`}}]}, 
   {Hue[0.49075551586332544`], AbsoluteThickness[6], 
    LineBox[{{0.6001421283282173, 0.5181485954636815}, {0.06446633246064049, 
     0.47318140233731754`}}]}, 
   {Hue[0.17820008095534456`], AbsoluteThickness[2], 
    LineBox[{{0.6129984869305647, 0.48914193664807626`}, {0.3941081561628519, 
     0.07260445563533535}}]}, 
   {Hue[0.13057925245960877`], AbsoluteThickness[3], 
    LineBox[{{0.40516491230498364`, 0.5318918538492727}, {0.2807679840363597, 
     0.4178342843772307}}]}, 
   {Hue[0.7609257449066162], AbsoluteThickness[2], 
    LineBox[{{0.32545707784141475`, 0.3022837513230654}, {
     0.17897660804384974`, 0.869679130653465}}]}, 
   {Hue[0.7275979787665299], AbsoluteThickness[10], 
    LineBox[{{0.7935887757926112, 0.266347756027705}, {0.3907897654360366, 
     0.42962457348445926`}}]}, 
   {Hue[0.9476771797821217], AbsoluteThickness[5], 
    LineBox[{{0.8276008461709123, 0.6209192881857841}, {0.29748762346399116`, 
     0.2142512556216447}}]}, 
   {Hue[0.5768263249444168], AbsoluteThickness[5], 
    LineBox[{{0.7350533444620415, 0.5860985412859661}, {0.31465371909716233`, 
     0.5389768737497744}}]}, 
   {Hue[0.19299224613198018`], AbsoluteThickness[8], 
    LineBox[{{0.8748577708406655, 0.4367381632924834}, {0.09261315208113086, 
     0.9093207104523016}}]}, 
   {Hue[0.6520486596456494], AbsoluteThickness[7], 
    LineBox[{{0.3663479605635549, 0.2981415340937228}, {0.29036831928028106`, 
     0.6739000450508417}}]}, 
   {Hue[0.31199005562799065`], AbsoluteThickness[7], 
    LineBox[{{0.3041480079319152, 0.9568472058835107}, {0.8250294104305356, 
     0.852473047743054}}]}, 
   {Hue[0.3896546864324131], AbsoluteThickness[7], 
    LineBox[{{0.3206679732835125, 0.32361825557087354`}, {0.2101714473411298, 
     0.18521633995966624`}}]}}]], "Output",
 ImageSize->{184, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->940498293]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13357],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thick",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thick"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thickness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thickness"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Offset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Offset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteDashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteDashing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsolutePointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsolutePointSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PointSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29337]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23216],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with AbsoluteThickness",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
AbsoluteThickness"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->34986837],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->241811379]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AbsoluteThickness - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 23.1883176}", "context" -> "System`", 
    "keywords" -> {
     "edge styling", "line styling", "line thickness", "line width"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "AbsoluteThickness[d] is a graphics directive which specifies that lines \
which follow are to be drawn with absolute thickness d. ", 
    "synonyms" -> {"absolute thickness"}, "title" -> "AbsoluteThickness", 
    "type" -> "Symbol", "uri" -> "ref/AbsoluteThickness"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10491, 286, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->690039376]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46218, 1312}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2531, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3154, 84, 4201, 83, 70, "ObjectNameGrid"],
Cell[7358, 169, 641, 19, 70, "Usage",
 CellID->6072]
}, Open  ]],
Cell[CellGroupData[{
Cell[8036, 193, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8514, 210, 240, 7, 70, "Notes",
 CellID->29350],
Cell[8757, 219, 540, 16, 70, "Notes",
 CellID->18823],
Cell[9300, 237, 770, 29, 70, "Notes",
 CellID->14485],
Cell[10073, 268, 381, 13, 70, "Notes",
 CellID->20556]
}, Closed]],
Cell[CellGroupData[{
Cell[10491, 286, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->690039376],
Cell[CellGroupData[{
Cell[10876, 300, 147, 5, 70, "ExampleSection",
 CellID->40269442],
Cell[11026, 307, 112, 3, 70, "ExampleText",
 CellID->134466735],
Cell[CellGroupData[{
Cell[11163, 314, 732, 24, 47, "Input",
 CellID->10989625],
Cell[11898, 340, 527, 16, 60, "Output",
 CellID->448961974]
}, Open  ]],
Cell[CellGroupData[{
Cell[12462, 361, 775, 24, 47, "Input",
 CellID->26604277],
Cell[13240, 387, 4807, 91, 101, "Output",
 CellID->163880823]
}, Open  ]],
Cell[18062, 481, 124, 3, 70, "ExampleDelimiter",
 CellID->83527806],
Cell[18189, 486, 344, 13, 70, "ExampleText",
 CellID->51732873],
Cell[CellGroupData[{
Cell[18558, 503, 731, 26, 70, "Input",
 CellID->593165007],
Cell[19292, 531, 383, 12, 75, "Output",
 CellID->228788790]
}, Open  ]],
Cell[19690, 546, 125, 3, 70, "ExampleDelimiter",
 CellID->198440045],
Cell[19818, 551, 96, 1, 70, "ExampleText",
 CellID->144867266],
Cell[CellGroupData[{
Cell[19939, 556, 762, 25, 70, "Input",
 CellID->177085957],
Cell[20704, 583, 643, 20, 60, "Output",
 CellID->388341578]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21396, 609, 223, 7, 70, "ExampleSection",
 CellID->12717],
Cell[21622, 618, 73, 1, 70, "ExampleText",
 CellID->25970681],
Cell[CellGroupData[{
Cell[21720, 623, 266, 8, 70, "Input",
 CellID->151807951],
Cell[21989, 633, 3425, 60, 70, "Output",
 Evaluatable->False,
 CellID->247085485]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25463, 699, 233, 7, 70, "ExampleSection",
 CellID->18696],
Cell[25699, 708, 256, 7, 70, "ExampleText",
 CellID->106323155],
Cell[CellGroupData[{
Cell[25980, 719, 684, 21, 70, "Input",
 CellID->275776734],
Cell[26667, 742, 510, 15, 161, "Output",
 CellID->205554653]
}, Open  ]],
Cell[27192, 760, 229, 7, 70, "ExampleText",
 CellID->353597015],
Cell[CellGroupData[{
Cell[27446, 771, 667, 22, 70, "Input",
 CellID->10908331],
Cell[28116, 795, 476, 16, 101, "Output",
 CellID->31861693]
}, Open  ]],
Cell[28607, 814, 125, 3, 70, "ExampleDelimiter",
 CellID->266255764],
Cell[28735, 819, 260, 9, 70, "ExampleText",
 CellID->371080297],
Cell[CellGroupData[{
Cell[29020, 832, 793, 26, 70, "Input",
 CellID->26636789],
Cell[29816, 860, 410, 13, 170, "Output",
 CellID->489238264]
}, Open  ]],
Cell[30241, 876, 205, 7, 70, "ExampleText",
 CellID->85601104],
Cell[CellGroupData[{
Cell[30471, 887, 662, 22, 70, "Input",
 CellID->146120593],
Cell[31136, 911, 462, 16, 101, "Output",
 CellID->185552762]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31647, 933, 224, 7, 70, "ExampleSection",
 CellID->24423],
Cell[31874, 942, 71, 1, 70, "ExampleText",
 CellID->254482646],
Cell[CellGroupData[{
Cell[31970, 947, 637, 19, 70, "Input",
 CellID->75183773],
Cell[32610, 968, 8277, 156, 198, "Output",
 CellID->940498293]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40948, 1131, 311, 9, 70, "SeeAlsoSection",
 CellID->13357],
Cell[41262, 1142, 1937, 71, 70, "SeeAlso",
 CellID->29337]
}, Open  ]],
Cell[CellGroupData[{
Cell[43236, 1218, 314, 9, 70, "TutorialsSection",
 CellID->23216],
Cell[43553, 1229, 197, 4, 70, "Tutorials",
 CellID->815154705]
}, Open  ]],
Cell[CellGroupData[{
Cell[43787, 1238, 305, 8, 70, "RelatedLinksSection"],
Cell[44095, 1248, 376, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44508, 1265, 318, 9, 70, "MoreAboutSection",
 CellID->34986837],
Cell[44829, 1276, 149, 3, 70, "MoreAbout",
 CellID->241811379]
}, Open  ]],
Cell[44993, 1282, 50, 0, 70, "History"],
Cell[45046, 1284, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

