(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45235,       1561]
NotebookOptionsPosition[     35965,       1244]
NotebookOutlinePosition[     37804,       1290]
CellTagsIndexPosition[     37718,       1285]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date and Time Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/DateAndTimeFunctions"], 
          "Global System Information" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GlobalSystemInformation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Date and Time Functions\"\>", 
       2->"\<\"Global System Information\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DateList" :> Documentation`HelpLookup["paclet:ref/DateList"], 
          "DateString" :> Documentation`HelpLookup["paclet:ref/DateString"], 
          "SessionTime" :> Documentation`HelpLookup["paclet:ref/SessionTime"],
           "TimeUsed" :> Documentation`HelpLookup["paclet:ref/TimeUsed"], 
          "Clock" :> Documentation`HelpLookup["paclet:ref/Clock"], 
          "AbsoluteTiming" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTiming"], "Timing" :> 
          Documentation`HelpLookup["paclet:ref/Timing"], "TimeZone" :> 
          Documentation`HelpLookup["paclet:ref/TimeZone"], "$TimeUnit" :> 
          Documentation`HelpLookup["paclet:ref/$TimeUnit"], "DatePlus" :> 
          Documentation`HelpLookup["paclet:ref/DatePlus"], "DateDifference" :> 
          Documentation`HelpLookup["paclet:ref/DateDifference"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DateList\"\>", 
       2->"\<\"DateString\"\>", 3->"\<\"SessionTime\"\>", 
       4->"\<\"TimeUsed\"\>", 5->"\<\"Clock\"\>", 6->"\<\"AbsoluteTiming\"\>",
        7->"\<\"Timing\"\>", 8->"\<\"TimeZone\"\>", 9->"\<\"$TimeUnit\"\>", 
       10->"\<\"DatePlus\"\>", 
       11->"\<\"DateDifference\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Date & Time\"\>", 
       2->"\<\"External Operations\"\>", 
       3->"\<\"Locale & Internationalization\"\>", 
       4->"\<\"Mathematica Session Information\"\>", 
       5->"\<\"Time Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AbsoluteTime", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteTime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteTime"], "[", "]"}]], "InlineFormula"],
     
     "\[LineSeparator]gives the total number of seconds since the beginning \
of January 1, 1900, in your time zone."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteTime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteTime"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["y", "TI"], ",", 
         StyleBox["m", "TI"], ",", 
         StyleBox["d", "TI"], ",", 
         StyleBox["h", "TI"], ",", 
         StyleBox["m", "TI"], ",", 
         StyleBox["s", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the absolute time specification corresponding to \
a date list. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteTime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteTime"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the absolute time specification corresponding to \
a date string."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteTime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteTime"], "[", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]takes the date string to contain the elements ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->20175]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"], "[", "]"}]], "InlineFormula"],
 " uses whatever date and time have been set on your computer system. It \
performs no corrections for time zones, daylight saving time, etc. "
}], "Notes",
 CellID->21459],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"], "[", 
   RowBox[{
    ButtonBox["TimeZone",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TimeZone"], " ", "->", " ", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives the date and time inferred for time zone ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " by assuming that your computer is set for the time zone specified by ",
 Cell[BoxData[
  ButtonBox["$TimeZone",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeZone"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->208232548]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->17825],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"], "[", "]"}]], "InlineFormula"],
 " is always accurate down to a granularity of ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 " seconds, but on many systems is much more accurate. "
}], "Notes",
 CellID->3221],

Cell[TextData[{
 "Shorter lists can be used in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["y", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ": ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["y", "TI"], "}"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], 
   "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"]}], "}"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]], 
  "InlineFormula"],
 ", etc."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->53342934],

Cell[TextData[{
 "Values of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " outside their normal ranges are appropriately reduced. Non-integer values \
of ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " can also be used. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->47250627]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->124355884]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56069656],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->364038735],

Cell["Absolute time in seconds since January 1, 1900:", "ExampleText",
 CellID->804777069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38756342],

Cell[BoxData["3.3834768444143846`17.28193819779754*^9"], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280934802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41146223],

Cell["Convert a date list or elided date list:", "ExampleText",
 CellID->4618039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16625090],

Cell[BoxData["3376598400"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357995837]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->363785470],

Cell[BoxData["3376598400"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->587038137]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->508911362],

Cell["Convert from a date string to absolute time:", "ExampleText",
 CellID->156776957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240228358],

Cell[BoxData["\<\"Wed 21 Mar 2007 14:40:44\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5257511]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->293255177],

Cell[BoxData["3383476844"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->43413625]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->548007546],

Cell["Specify date elements for interpreting a string:", "ExampleText",
 CellID->186401120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<05/06/07\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<YearShort\>\""}], 
     "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102498054],

Cell[BoxData["3389990400"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466468857]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1637],

Cell["Strings are automatically interpreted when possible:", "ExampleText",
 CellID->228124850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", "\"\<2006-12-1\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26535382],

Cell[BoxData["3373920000"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92885915]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", "\"\<10 March 2006\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->267969406],

Cell[BoxData["3350937600"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->428499849]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18424467],

Cell["Separators are assumed if not specified:", "ExampleText",
 CellID->171106044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<2/23/2007\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Month\>\"", ",", "\"\<Day\>\"", ",", "\"\<Year\>\""}], 
     "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168427058],

Cell[BoxData["3381177600"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84413484]
}, Open  ]],

Cell["Give explicit separators:", "ExampleText",
 CellID->213309941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<2/23/2007\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Month\>\"", ",", "\"\</\>\"", ",", "\"\<Day\>\"", ",", "\"\</\>\"", 
      ",", "\"\<Year\>\""}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387067767],

Cell[BoxData["3381177600"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->233026636]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->354619206],

Cell["Date lists are converted to standard normalized form:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->47250627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"2006", ",", "2", ",", "31"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67281060],

Cell[BoxData["3350332800"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->400340817]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"2006", ",", "3", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14666822],

Cell[BoxData["3350332800"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49742892]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675082110],

Cell["\<\
Day, hour, minute and second values in input date lists can be non-integer:\
\>", "ExampleText",
 CellID->27928209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "3", ",", "15.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->751779630],

Cell[BoxData["3.3829488`*^9"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18648819]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "3", ",", "15", ",", "12.3"}], "}"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->632638308],

Cell[BoxData["3.38294988`*^9"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->153415697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101806274],

Cell["The current year is used if not specified in a string:", "ExampleText",
 CellID->33092171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<2/15\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Month\>\"", ",", "\"\<Day\>\""}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12776873],

Cell[BoxData["3380486400"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30166901]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26534],

Cell["Give explicit date elements to interpret ambiguous strings:", \
"ExampleText",
 CellID->139144165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", "\"\<05/10/1\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187066901],

Cell[BoxData[
 RowBox[{
  RowBox[{"AbsoluteTime", "::", "\<\"ambig\"\>"}], ":", 
  " ", "\<\"Warning: the interpretation of the string \
\\!\\(\\\"05/10/1\\\"\\) as a date is ambiguous. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/AbsoluteTime\\\", ButtonNote -> \
\\\"AbsoluteTime::ambig\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->234195606],

Cell[BoxData["3198441600"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46374870]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<05/10/1\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<YearShort\>\"", ",", "\"\<Day\>\"", ",", "\"\<Month\>\""}], 
     "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->543728066],

Cell[BoxData["3314304000"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->334925174]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->638444795],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TimeZone",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->52275114],

Cell["Find the current absolute time in Greenwich, United Kingdom:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->208232548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"TimeZone", "\[Rule]", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78442617],

Cell[BoxData["3.383494896171671`17.281940514869007*^9"], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231537358]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10176],

Cell["\<\
Compute the number of seconds between Jan. 1, 1900 and Jan. 1, 1970:\
\>", "ExampleText",
 CellID->27262464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"1970", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->327940204],

Cell[BoxData["2208988800"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111415693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->571352979],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteTime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTime"]], "InlineFormula"],
 " represents dates as seconds since the beginning of 1900:"
}], "ExampleText",
 CellID->294473746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "1", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->244032669],

Cell[BoxData["3376598400"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164956314]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " represents dates as lists of date elements:"
}], "ExampleText",
 CellID->512534639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->452464721],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->159416231]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 " represents dates as strings:"
}], "ExampleText",
 CellID->221426326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->56881056],

Cell[BoxData["\<\"Mon 1 Jan 2007 00:00:00\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->99090961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123040038],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DateListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateListPlot"]], "InlineFormula"],
 " to plot data with absolute time ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates on a time scale:"
}], "ExampleText",
 CellID->17347369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3376598400", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3379276800", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3381696000", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3384374400", ",", "8"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111258812],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs9rE0EUnuyPpFi8eyxSC02lQrXexEPRnkQ8SM9rEdpDW6n9GwRF/wDB
g2Bail6UBj156kUh0GvP/iPr/Hiz+/J2dpM1M5A1E8jsvNmZb7/3zczLy7CP
kqOd53vJ0e52srB5mLzY2d1+ufDw4JA3hS3GWJ9/X11jvJ7ymvz205RfP/My
5GZHWl9EKcxUflhbtka8DHhjyK8xgwpTny6M130CuC5Cu+6rgfFYYS9Dv0Bj
R/l91coUiw6ADJeqB2LcJba8H2d2yajrorhqfILhmSuIT4ZpQM7dbVNW4lac
DYS+N8nYQGtY6Lk4QpGAKN/V6nYIUpFlu4hK0VbQnGlty2eknrYmDTQn3BEx
juldypdihoShqN5I8zUeMMM8wlpnEWYckRUtRraMM37buA4j0ouyWCMs5uU1
Bv0FZhv1XoL2EK5rBP2KHN0vKYUvX9VzIqy0ME6zRjq7IfLruHfBK+/enrN1
0usWse+Uq1GYnSDT+cHGB6xmOBgMqvDhvp6XcnTN5PevP8+Skx/fL4E/xc9t
xT+zh/jrFYKkzFv4kLuTYKO1FqdoZ4KrY/FGdq7LnFWe0442O7p5T+t7GsLu
ssfPGHWcoqtcq9zbKjWGIyaNOfZ4G39LmqL5zEVg7+n/56nbvWxPR7eRIqrI
09687t+/917ktPXyNJbl7DpbL3r65PFHjs2zWsvRuPfp58H+mchjJ8ktm7I2
pnlX+NjkPfWZaz10e5mrW+7u4iU+u7IfibU+fn95T5vraRPO1JyeBNbEXpX2
ce8Cstn1WtijYrJC33p6Avks1ozE5LGipcIj57E+Who4Tjva7OjmPf2HCOls
77qNCvTfrL2c1e1Jh1t0t793YDLd5veb97S5nvr81QZ2djpbqYgAVnj5M81v
DHCb4w1H5Eqm4yKLNwzUmewIFU6NXnyT1bI3NyYpWesvdRtEZw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->561835821]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23850],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SessionTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SessionTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeUsed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeUsed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clock",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTiming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTiming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Timing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Timing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeZone",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeZone"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$TimeUnit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$TimeUnit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DatePlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DatePlus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateDifference",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateDifference"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17398]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1626],

Cell[TextData[ButtonBox["Date and Time Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DateAndTimeFunctions"]], "Tutorials",
 CellID->31934],

Cell[TextData[ButtonBox["Global System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GlobalSystemInformation"]], "Tutorials",
 CellID->9299]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->170383484],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->352922216],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->38262679],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->513180909],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->89646801],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->34391197]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AbsoluteTime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 24.0008384}", "context" -> "System`", 
    "keywords" -> {
     "computer time", "NTP", "real-time clock", "standard time", 
      "system time", "timestamp"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AbsoluteTime[] gives the total number of seconds since the beginning of \
January 1, 1900, in your time zone. AbsoluteTime[{y, m, d, h, m, s}] gives \
the absolute time specification corresponding to a date list. \
AbsoluteTime[\"string\"] gives the absolute time specification corresponding \
to a date string. AbsoluteTime[{\" string\", {\"SubscriptBox[ e, 1]\", \
\"SubscriptBox[ e, 2]\", ...}}] takes the date string to contain the elements \
\"SubscriptBox[ e, i]\".", 
    "synonyms" -> {
     "absolute time", "asktime", "current-date", "GetSystemTime", "gettime", 
      "gettimeofday", "mktime", "systime", "time"}, "title" -> "AbsoluteTime",
     "type" -> "Symbol", "uri" -> "ref/AbsoluteTime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14985, 416, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->56069656]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37575, 1278}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3662, 77, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4285, 104, 4196, 83, 70, "ObjectNameGrid"],
Cell[8484, 189, 2240, 66, 70, "Usage",
 CellID->20175]
}, Open  ]],
Cell[CellGroupData[{
Cell[10761, 260, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11239, 277, 341, 9, 70, "Notes",
 CellID->21459],
Cell[11583, 288, 895, 27, 70, "Notes",
 CellID->17825],
Cell[12481, 317, 424, 13, 70, "Notes",
 CellID->3221],
Cell[12908, 332, 1088, 40, 70, "Notes",
 CellID->53342934],
Cell[13999, 374, 949, 37, 70, "Notes",
 CellID->124355884]
}, Closed]],
Cell[CellGroupData[{
Cell[14985, 416, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56069656],
Cell[CellGroupData[{
Cell[15369, 430, 148, 5, 70, "ExampleSection",
 CellID->364038735],
Cell[15520, 437, 90, 1, 70, "ExampleText",
 CellID->804777069],
Cell[CellGroupData[{
Cell[15635, 442, 102, 3, 28, "Input",
 CellID->38756342],
Cell[15740, 447, 197, 5, 36, "Output",
 CellID->280934802]
}, Open  ]],
Cell[15952, 455, 124, 3, 70, "ExampleDelimiter",
 CellID->41146223],
Cell[16079, 460, 81, 1, 70, "ExampleText",
 CellID->4618039],
Cell[CellGroupData[{
Cell[16185, 465, 200, 6, 70, "Input",
 CellID->16625090],
Cell[16388, 473, 167, 5, 36, "Output",
 CellID->357995837]
}, Open  ]],
Cell[CellGroupData[{
Cell[16592, 483, 158, 5, 70, "Input",
 CellID->363785470],
Cell[16753, 490, 167, 5, 36, "Output",
 CellID->587038137]
}, Open  ]],
Cell[16935, 498, 125, 3, 70, "ExampleDelimiter",
 CellID->508911362],
Cell[17063, 503, 87, 1, 70, "ExampleText",
 CellID->156776957],
Cell[CellGroupData[{
Cell[17175, 508, 101, 3, 70, "Input",
 CellID->240228358],
Cell[17279, 513, 188, 5, 36, "Output",
 CellID->5257511]
}, Open  ]],
Cell[CellGroupData[{
Cell[17504, 523, 108, 3, 70, "Input",
 CellID->293255177],
Cell[17615, 528, 166, 5, 36, "Output",
 CellID->43413625]
}, Open  ]],
Cell[17796, 536, 125, 3, 70, "ExampleDelimiter",
 CellID->548007546],
Cell[17924, 541, 91, 1, 70, "ExampleText",
 CellID->186401120],
Cell[CellGroupData[{
Cell[18040, 546, 275, 8, 70, "Input",
 CellID->102498054],
Cell[18318, 556, 167, 5, 36, "Output",
 CellID->466468857]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18534, 567, 215, 7, 70, "ExampleSection",
 CellID->1637],
Cell[18752, 576, 95, 1, 70, "ExampleText",
 CellID->228124850],
Cell[CellGroupData[{
Cell[18872, 581, 123, 3, 70, "Input",
 CellID->26535382],
Cell[18998, 586, 166, 5, 36, "Output",
 CellID->92885915]
}, Open  ]],
Cell[CellGroupData[{
Cell[19201, 596, 128, 3, 70, "Input",
 CellID->267969406],
Cell[19332, 601, 167, 5, 36, "Output",
 CellID->428499849]
}, Open  ]],
Cell[19514, 609, 124, 3, 70, "ExampleDelimiter",
 CellID->18424467],
Cell[19641, 614, 83, 1, 70, "ExampleText",
 CellID->171106044],
Cell[CellGroupData[{
Cell[19749, 619, 271, 8, 70, "Input",
 CellID->168427058],
Cell[20023, 629, 166, 5, 36, "Output",
 CellID->84413484]
}, Open  ]],
Cell[20204, 637, 68, 1, 70, "ExampleText",
 CellID->213309941],
Cell[CellGroupData[{
Cell[20297, 642, 314, 9, 70, "Input",
 CellID->387067767],
Cell[20614, 653, 167, 5, 36, "Output",
 CellID->233026636]
}, Open  ]],
Cell[20796, 661, 125, 3, 70, "ExampleDelimiter",
 CellID->354619206],
Cell[20924, 666, 143, 2, 70, "ExampleText",
 CellID->47250627],
Cell[CellGroupData[{
Cell[21092, 672, 168, 5, 70, "Input",
 CellID->67281060],
Cell[21263, 679, 167, 5, 36, "Output",
 CellID->400340817]
}, Open  ]],
Cell[CellGroupData[{
Cell[21467, 689, 167, 5, 70, "Input",
 CellID->14666822],
Cell[21637, 696, 166, 5, 36, "Output",
 CellID->49742892]
}, Open  ]],
Cell[21818, 704, 125, 3, 70, "ExampleDelimiter",
 CellID->675082110],
Cell[21946, 709, 125, 3, 70, "ExampleText",
 CellID->27928209],
Cell[CellGroupData[{
Cell[22096, 716, 171, 5, 70, "Input",
 CellID->751779630],
Cell[22270, 723, 169, 5, 36, "Output",
 CellID->18648819]
}, Open  ]],
Cell[CellGroupData[{
Cell[22476, 733, 184, 6, 70, "Input",
 CellID->632638308],
Cell[22663, 741, 171, 5, 36, "Output",
 CellID->153415697]
}, Open  ]],
Cell[22849, 749, 125, 3, 70, "ExampleDelimiter",
 CellID->101806274],
Cell[22977, 754, 96, 1, 70, "ExampleText",
 CellID->33092171],
Cell[CellGroupData[{
Cell[23098, 759, 241, 8, 70, "Input",
 CellID->12776873],
Cell[23342, 769, 166, 5, 36, "Output",
 CellID->30166901]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23557, 780, 239, 7, 70, "ExampleSection",
 CellID->26534],
Cell[23799, 789, 104, 2, 70, "ExampleText",
 CellID->139144165],
Cell[CellGroupData[{
Cell[23928, 795, 122, 3, 70, "Input",
 CellID->187066901],
Cell[24053, 800, 420, 8, 70, "Message",
 CellID->234195606],
Cell[24476, 810, 166, 5, 36, "Output",
 CellID->46374870]
}, Open  ]],
Cell[CellGroupData[{
Cell[24679, 820, 274, 8, 70, "Input",
 CellID->543728066],
Cell[24956, 830, 167, 5, 36, "Output",
 CellID->334925174]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25172, 841, 222, 7, 70, "ExampleSection",
 CellID->638444795],
Cell[CellGroupData[{
Cell[25419, 852, 228, 7, 70, "ExampleSubsection",
 CellID->52275114],
Cell[25650, 861, 153, 3, 70, "ExampleText",
 CellID->208232548],
Cell[CellGroupData[{
Cell[25828, 868, 143, 4, 70, "Input",
 CellID->78442617],
Cell[25974, 874, 197, 5, 36, "Output",
 CellID->231537358]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26232, 886, 233, 7, 70, "ExampleSection",
 CellID->10176],
Cell[26468, 895, 118, 3, 70, "ExampleText",
 CellID->27262464],
Cell[CellGroupData[{
Cell[26611, 902, 201, 6, 70, "Input",
 CellID->327940204],
Cell[26815, 910, 167, 5, 36, "Output",
 CellID->111415693]
}, Open  ]],
Cell[26997, 918, 125, 3, 70, "ExampleDelimiter",
 CellID->571352979],
Cell[27125, 923, 242, 7, 70, "ExampleText",
 CellID->294473746],
Cell[CellGroupData[{
Cell[27392, 934, 168, 5, 70, "Input",
 CellID->244032669],
Cell[27563, 941, 167, 5, 36, "Output",
 CellID->164956314]
}, Open  ]],
Cell[27745, 949, 221, 7, 70, "ExampleText",
 CellID->512534639],
Cell[CellGroupData[{
Cell[27991, 960, 104, 3, 70, "Input",
 CellID->452464721],
Cell[28098, 965, 252, 8, 36, "Output",
 CellID->159416231]
}, Open  ]],
Cell[28365, 976, 210, 7, 70, "ExampleText",
 CellID->221426326],
Cell[CellGroupData[{
Cell[28600, 987, 105, 3, 70, "Input",
 CellID->56881056],
Cell[28708, 992, 188, 5, 36, "Output",
 CellID->99090961]
}, Open  ]],
Cell[28911, 1000, 125, 3, 70, "ExampleDelimiter",
 CellID->123040038],
Cell[29039, 1005, 317, 11, 70, "ExampleText",
 CellID->17347369],
Cell[CellGroupData[{
Cell[29381, 1020, 415, 13, 70, "Input",
 CellID->111258812],
Cell[29799, 1035, 1180, 23, 70, "Output",
 Evaluatable->False,
 CellID->561835821]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31040, 1065, 311, 9, 70, "SeeAlsoSection",
 CellID->23850],
Cell[31354, 1076, 2682, 98, 70, "SeeAlso",
 CellID->17398]
}, Open  ]],
Cell[CellGroupData[{
Cell[34073, 1179, 313, 9, 70, "TutorialsSection",
 CellID->1626],
Cell[34389, 1190, 154, 3, 70, "Tutorials",
 CellID->31934],
Cell[34546, 1195, 158, 3, 70, "Tutorials",
 CellID->9299]
}, Open  ]],
Cell[CellGroupData[{
Cell[34741, 1203, 319, 9, 70, "MoreAboutSection",
 CellID->170383484],
Cell[35063, 1214, 134, 3, 70, "MoreAbout",
 CellID->352922216],
Cell[35200, 1219, 148, 3, 70, "MoreAbout",
 CellID->38262679],
Cell[35351, 1224, 170, 3, 70, "MoreAbout",
 CellID->513180909],
Cell[35524, 1229, 171, 3, 70, "MoreAbout",
 CellID->89646801],
Cell[35698, 1234, 172, 3, 70, "MoreAbout",
 CellID->34391197]
}, Open  ]],
Cell[35885, 1240, 50, 0, 70, "History"],
Cell[35938, 1242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

