(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16044,        570]
NotebookOptionsPosition[     12327,        446]
NotebookOutlinePosition[     13789,        487]
CellTagsIndexPosition[     13704,        482]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date and Time Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DateAndTimeFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Date and Time Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Timing" :> Documentation`HelpLookup["paclet:ref/Timing"], 
          "TimeConstrained" :> 
          Documentation`HelpLookup["paclet:ref/TimeConstrained"], 
          "SessionTime" :> Documentation`HelpLookup["paclet:ref/SessionTime"],
           "AbsoluteTime" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTime"], 
          "TimeConstraint" :> 
          Documentation`HelpLookup["paclet:ref/TimeConstraint"], "$TimeUnit" :> 
          Documentation`HelpLookup["paclet:ref/$TimeUnit"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Timing\"\>", 
       2->"\<\"TimeConstrained\"\>", 3->"\<\"SessionTime\"\>", 
       4->"\<\"AbsoluteTime\"\>", 5->"\<\"TimeConstraint\"\>", 
       6->"\<\"$TimeUnit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Date & Time\"\>", 
       2->"\<\"Time Measurement & Optimization\"\>", 
       3->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AbsoluteTiming", "ObjectName",
 CellID->26488],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteTiming",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteTiming"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", returning a list of the absolute number of seconds in real time that \
have elapsed, together with the result obtained. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28685]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteTiming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTiming"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19497],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteTiming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTiming"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ";"}], "]"}]], "InlineFormula"],
 " will give ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["timing", "TI"], ",", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2589],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteTiming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTiming"]], "InlineFormula"],
 " is always accurate down to a granularity of ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 " seconds, but on many systems is much more accurate. "
}], "Notes",
 CellID->15145]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->290891717],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->243296798],

Cell["Get the total time to do a computation:", "ExampleText",
 CellID->6604780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"x", " ", "=", " ", 
    RowBox[{"1", " ", "+", " ", "2"}]}], ";", " ", 
   RowBox[{"Pause", "[", "x", "]"}], ";", 
   RowBox[{"x", "+", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27042798],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.0002112`7.928696821470995", ",", "6"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->300398685]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Timing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Timing"]], "InlineFormula"],
 " just reports CPU time used:"
}], "ExampleText",
 CellID->242838017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"x", " ", "=", " ", 
    RowBox[{"1", " ", "+", " ", "2"}]}], ";", " ", 
   RowBox[{"Pause", "[", "x", "]"}], ";", 
   RowBox[{"x", "+", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1473351],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "6"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->586855584]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->398238672],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteTiming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTiming"]], "InlineFormula"],
 " takes into account all time, including getting data over the internet if \
needed:"
}], "ExampleText",
 CellID->122504860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"CountryData", "[", 
   RowBox[{"\"\<France\>\"", ",", "\"\<Population\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->529151027],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.50072`7.151139932041212", ",", "6.2312148`*^7"}], 
  "}"}]], "Output",
 ImageSize->{172, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162641369]
}, Open  ]],

Cell["\<\
The second time it is run is faster since the data has been saved for \
immediate reuse:\
\>", "ExampleText",
 CellID->32435741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"CountryData", "[", 
   RowBox[{"\"\<France\>\"", ",", "\"\<Population\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->225932309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "6.2312148`*^7"}], "}"}]], "Output",
 ImageSize->{123, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->115858788]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22044],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Timing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Timing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SessionTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SessionTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeConstraint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeConstraint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$TimeUnit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$TimeUnit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11258]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19353],

Cell[TextData[ButtonBox["Date and Time Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DateAndTimeFunctions"]], "Tutorials",
 CellID->19314]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->452201061],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->182993562],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->18041247],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->540668464]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AbsoluteTiming - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 24.8133592}", "context" -> "System`", 
    "keywords" -> {
     "benchmark", "process time", "wall clock time", "total time", 
      "total computation time"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AbsoluteTiming[expr] evaluates expr, returning a list of the absolute \
number of seconds in real time that have elapsed, together with the result \
obtained. ", 
    "synonyms" -> {"absolute timing", "duration", "timing", "tic", "toc"}, 
    "title" -> "AbsoluteTiming", "type" -> "Symbol", "uri" -> 
    "ref/AbsoluteTiming"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5729, 184, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->290891717]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13561, 475}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2646, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3269, 89, 52, 1, 70, "ObjectName",
 CellID->26488],
Cell[3324, 92, 666, 19, 70, "Usage",
 CellID->28685]
}, Open  ]],
Cell[CellGroupData[{
Cell[4027, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4505, 133, 318, 12, 70, "Notes",
 CellID->19497],
Cell[4826, 147, 460, 18, 70, "Notes",
 CellID->2589],
Cell[5289, 167, 403, 12, 70, "Notes",
 CellID->15145]
}, Closed]],
Cell[CellGroupData[{
Cell[5729, 184, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->290891717],
Cell[CellGroupData[{
Cell[6114, 198, 148, 5, 70, "ExampleSection",
 CellID->243296798],
Cell[6265, 205, 80, 1, 70, "ExampleText",
 CellID->6604780],
Cell[CellGroupData[{
Cell[6370, 210, 273, 8, 28, "Input",
 CellID->27042798],
Cell[6646, 220, 230, 7, 36, "Output",
 CellID->300398685]
}, Open  ]],
Cell[6891, 230, 201, 7, 70, "ExampleText",
 CellID->242838017],
Cell[CellGroupData[{
Cell[7117, 241, 264, 8, 28, "Input",
 CellID->1473351],
Cell[7384, 251, 205, 7, 36, "Output",
 CellID->586855584]
}, Open  ]],
Cell[7604, 261, 125, 3, 70, "ExampleDelimiter",
 CellID->398238672],
Cell[7732, 266, 272, 8, 70, "ExampleText",
 CellID->122504860],
Cell[CellGroupData[{
Cell[8029, 278, 205, 6, 70, "Input",
 CellID->529151027],
Cell[8237, 286, 243, 8, 39, "Output",
 CellID->162641369]
}, Open  ]],
Cell[8495, 297, 138, 4, 70, "ExampleText",
 CellID->32435741],
Cell[CellGroupData[{
Cell[8658, 305, 205, 6, 70, "Input",
 CellID->225932309],
Cell[8866, 313, 218, 7, 39, "Output",
 CellID->115858788]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9145, 327, 311, 9, 70, "SeeAlsoSection",
 CellID->22044],
Cell[9459, 338, 1469, 53, 70, "SeeAlso",
 CellID->11258]
}, Open  ]],
Cell[CellGroupData[{
Cell[10965, 396, 314, 9, 70, "TutorialsSection",
 CellID->19353],
Cell[11282, 407, 154, 3, 70, "Tutorials",
 CellID->19314]
}, Open  ]],
Cell[CellGroupData[{
Cell[11473, 415, 319, 9, 70, "MoreAboutSection",
 CellID->452201061],
Cell[11795, 426, 134, 3, 70, "MoreAbout",
 CellID->182993562],
Cell[11932, 431, 172, 3, 70, "MoreAbout",
 CellID->18041247],
Cell[12107, 436, 148, 3, 70, "MoreAbout",
 CellID->540668464]
}, Open  ]],
Cell[12270, 442, 27, 0, 70, "History"],
Cell[12300, 444, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

