(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     66290,       1750]
NotebookOptionsPosition[     59423,       1508]
NotebookOutlinePosition[     60752,       1546]
CellTagsIndexPosition[     60666,       1541]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FoldList" :> Documentation`HelpLookup["paclet:ref/FoldList"], 
          "Differences" :> Documentation`HelpLookup["paclet:ref/Differences"],
           "Total" :> Documentation`HelpLookup["paclet:ref/Total"], "Sum" :> 
          Documentation`HelpLookup["paclet:ref/Sum"], "Plus" :> 
          Documentation`HelpLookup["paclet:ref/Plus"], "MovingAverage" :> 
          Documentation`HelpLookup["paclet:ref/MovingAverage"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FoldList\"\>", 
       2->"\<\"Differences\"\>", 3->"\<\"Total\"\>", 4->"\<\"Sum\"\>", 
       5->"\<\"Plus\"\>", 6->"\<\"MovingAverage\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists" :> 
          Documentation`HelpLookup["paclet:guide/ApplyingFunctionsToLists"], 
          "Arithmetic Functions" :> 
          Documentation`HelpLookup["paclet:guide/ArithmeticFunctions"], 
          "Data Transforms and Smoothing" :> 
          Documentation`HelpLookup["paclet:guide/DataTransformsAndSmoothing"],
           "Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Applying Functions to Lists\"\>", 
       2->"\<\"Arithmetic Functions\"\>", 
       3->"\<\"Data Transforms and Smoothing\"\>", 
       4->"\<\"Discrete & Integer Data\"\>", 
       5->"\<\"Math & Counting Operations on Lists\"\>", 
       6->"\<\"Numerical Data\"\>", 7->"\<\"New in 6.0: Core Language\"\>", 
       8->"\<\"New in 6.0: List Manipulation\"\>", 
       9->"\<\"New in 6.0: Numerical Data Handling\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Accumulate", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Accumulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Accumulate"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the successive accumulated totals of \
elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " has length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accumulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accumulate"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " will have the same length. "
}], "Notes",
 CellID->21543],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accumulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accumulate"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rest"], "[", 
   RowBox[{
    ButtonBox["FoldList",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FoldList"], "[", 
    RowBox[{
     ButtonBox["Plus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plus"], ",", "0", ",", 
     StyleBox["list", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25347]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->400985983],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->73541491],

Cell["Cumulative sums:", "ExampleText",
 CellID->608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accumulate", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1758],

Cell["Accumulate within columns:", "ExampleText",
 CellID->29954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accumulate", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20888],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ",", 
     RowBox[{"b", "+", "d"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "c", "+", "e"}], ",", 
     RowBox[{"b", "+", "d", "+", "f"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14146]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->748],

Cell[TextData[{
 "The head does not need to be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accumulate", "[", 
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4536],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}], "]"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20783]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15185],

Cell["Triangular numbers:", "ExampleText",
 CellID->7038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accumulate", "[", 
  RowBox[{"Range", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9853],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "6", ",", "10", ",", "15", ",", "21", ",", "28", ",", 
   "36", ",", "45", ",", "55"}], "}"}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98489025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11224],

Cell["Random walk:", "ExampleText",
 CellID->15748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Accumulate", "[", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "100"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19923],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw9lAswnFcUxzfiLUKQEnQkHqkgSQn1Cv7WrkdYYa21Jm2piBmJppoYTSrl
SzQICSOiHUZCvSuZJlGmppraaiMRLS0JaSnStHkxst1iVwltx7n9Zna++e3/
nHvuPed/vy1J74gPaPB4vOR/f/+9Vx9FAOrND9i2TnTRH+BWJHceR1cGrKIu
EodSnulW3SfdGLv7djocxjSxGe6O6Z55g/eQ2AKbpSnu7UHDlG8Nx0nL8Nrk
v4g347NPVamnGnhYZVu0hRTbR9gz3R4aRaV8Dwcl8VbUV1SIPHpniB1xd1hZ
a/PVIrETlPlTfney54hd8OP7l0/qD7L1dqAlfKcqNYHFv4r1oV/nepZpUX1X
VDba3PDMMiB2w9HGwOGoPn3iXTjUmucWnsvYHW5/z9k96dQj9kBPQf+sbMaI
+DVYdt+cPHnUlNgTyvQ/k9x9XyL2Qulb51JDBzYRe+O+Yv6GdJjpPjh7Oea8
70Om+8Lw+Amp7llL4t34dU153EQxi/dD3+AX9qVPzYj90Wr18mjeuAlxALY8
DzhycYTtD5B48Y3TmtatMgeol3sSem8bkh6IX/gN20btjUkPxILVaROzQnYe
PtTyibZ8/Q2k81Gjt1Y4lsH6FwRc2x45MK5JehAcQ2V1ma6sXwJonvNXOSUw
XYBp36bHZYoVmo8QrWl1hReu0vw4ITpdrg9mCplfgmHdf1up47+G8oMRYdeU
f8JpLekhqLGaWom1WKD8EEg7sz9v8dMgPRSyiVuO6Rt0KD8UKrMm7oGSzTcM
hfee/9C/lZ0vDK+L1JlFatbfPRjrX9r4yUXqL7cHGh76syFeG0kPh9yovDrT
gvrFhaOsu0mQdXU96RHo25eTa2zM1o/AdMsrpz9IY/MSwcX5+r7qUra+CKGT
pm+/SGR6JEzkhmHCXpYfidZ183mzNmw+e5HXUfFNWRntl9uL5Xtf+mmlM79E
4fuChMP6KeQvRKErN2l9eKUFxUfh0PGewIifKV4ehe+0hFN5Xez80RicHzqY
2046oqF9ZKlhIJvVi4bYv0RR4037kUdD5KcQR8Uw/4kR0uAr0NMhP0CMj1q1
FjP62DzEuDImiSyy0qV8MZbiH7WXtbH5x6D+w8XFkd7Z1fkiBh2pwf6ipT9o
3jGYfJHSfGbH76ssjwHf1vo3H8158pcEbzofUy+7aFB9CSy6HOz2K2g/nAS1
Le8tNHuz+hJsc0k2j/vfP7HgZ+zXHtlO3xvEYrBZ2FNoqKb6sbh0sHvoXR+K
l8diVHTsQdY1bcqXQsskqLJ4mc4DKTosz8t8q8n/nBQTV5bnqk6Rn+VS1LpK
uW5D6g8vDkHmJcH15sSIw1NVbWLWx1SPi8NPBfEC53S6H/I4ZDYpDXaZsvsn
w0zys7pbJXRfIcO3jpyZ3RPyJydDucqGZ5RD3wO5DBcaF3IeWZDfePEQ3Kwa
v7TJAP8A4iKwgw==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 100.}, {-0.8828650213530191, 6.636750556323261}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208397220]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16142],

Cell["Idealized random mountainside:", "ExampleText",
 CellID->31196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Accumulate", "[", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "30"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21948],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261226464]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32257],

Cell["Cumulative sums of terms in a series:", "ExampleText",
 CellID->24766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"List", "@@", 
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4944],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "3"], "6"]}], ",", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], ",", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "7"], "5040"]}], ",", 
   FractionBox[
    SuperscriptBox["x", "9"], "362880"]}], "}"}]], "Output",
 ImageSize->{208, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38058471]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Accumulate", "[", "%", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23318],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->693013862]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25411],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Differences",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Differences"]], "InlineFormula"],
 " is almost the inverse of ",
 Cell[BoxData[
  ButtonBox["Accumulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accumulate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accumulate", "[", 
  RowBox[{"Range", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "6", ",", "10", ",", "15", ",", "21", ",", "28", ",", 
   "36", ",", "45", ",", "55"}], "}"}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20804400]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Differences", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", ",", "9", 
   ",", "10"}], "}"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54335009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->148742318],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Accumulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accumulate"]], "InlineFormula"],
 " is equivalent to a particular case of ",
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1863065730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"FoldList", "[", 
   RowBox[{"Plus", ",", "0", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->838354101],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63522846]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accumulate", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->171781849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->536581097]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47430388],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " to symbolically accumulate sequences:"
}], "ExampleText",
 CellID->519612608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"i", "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237443408],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "n"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "n"}]}], ")"}]}]], "Output",
 ImageSize->{123, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202464782]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"s", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->389016197],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "5", ",", "14", ",", "30", ",", "55", ",", "91", ",", "140", ",", 
   "204", ",", "285", ",", "385"}], "}"}]], "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72734555]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accumulate", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->561076830],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "5", ",", "14", ",", "30", ",", "55", ",", "91", ",", "140", ",", 
   "204", ",", "285", ",", "385"}], "}"}]], "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->477698562]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17964],

Cell["Diagonals of Pascal's triangle:", "ExampleText",
 CellID->23342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{"Accumulate", ",", 
    RowBox[{"Range", "[", "5", "]"}], ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "6", ",", "10", ",", "15", ",", "21", ",", "28"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "20", ",", "35", ",", "56", ",", "84"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "15", ",", "35", ",", "70", ",", "126", ",", "210"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{405, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17913]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26463],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FoldList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FoldList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Differences",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Differences"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MovingAverage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MovingAverage"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5049]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Accumulate",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Accumulate"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->502769349],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "MoreAbout",
 CellID->19133413],

Cell[TextData[ButtonBox["Arithmetic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ArithmeticFunctions"]], "MoreAbout",
 CellID->615322017],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "MoreAbout",
 CellID->320605463],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->14363928],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->614347019],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->371423871],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->660487536],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->127292842],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->31614957]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Accumulate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 25.3914990}", "context" -> "System`", 
    "keywords" -> {
     "accumulate", "prefix sums", "cascade", "fold list", "partial sum", 
      "indefinite sum", "list sum"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Accumulate[list] gives a list of the successive accumulated totals of \
elements in list. ", "synonyms" -> {}, "title" -> "Accumulate", "type" -> 
    "Symbol", "uri" -> "ref/Accumulate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7437, 215, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->400985983]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 60523, 1534}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3020, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3643, 88, 1575, 37, 70, "ObjectNameGrid"],
Cell[5221, 127, 592, 19, 70, "Usage",
 CellID->28]
}, Open  ]],
Cell[CellGroupData[{
Cell[5850, 151, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6328, 168, 407, 16, 70, "Notes",
 CellID->21543],
Cell[6738, 186, 662, 24, 70, "Notes",
 CellID->25347]
}, Closed]],
Cell[CellGroupData[{
Cell[7437, 215, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->400985983],
Cell[CellGroupData[{
Cell[7822, 229, 147, 5, 70, "ExampleSection",
 CellID->73541491],
Cell[7972, 236, 53, 1, 70, "ExampleText",
 CellID->608],
Cell[CellGroupData[{
Cell[8050, 241, 169, 5, 28, "Input",
 CellID->32060],
Cell[8222, 248, 322, 10, 36, "Output",
 CellID->21221]
}, Open  ]],
Cell[8559, 261, 120, 3, 70, "ExampleDelimiter",
 CellID->1758],
Cell[8682, 266, 65, 1, 70, "ExampleText",
 CellID->29954],
Cell[CellGroupData[{
Cell[8772, 271, 312, 11, 70, "Input",
 CellID->20888],
Cell[9087, 284, 481, 17, 36, "Output",
 CellID->14146]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9617, 307, 237, 7, 70, "ExampleSection",
 CellID->748],
Cell[9857, 316, 200, 8, 70, "ExampleText",
 CellID->27067],
Cell[CellGroupData[{
Cell[10082, 328, 173, 5, 70, "Input",
 CellID->4536],
Cell[10258, 335, 327, 10, 36, "Output",
 CellID->20783]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10634, 351, 223, 7, 70, "ExampleSection",
 CellID->15185],
Cell[10860, 360, 57, 1, 70, "ExampleText",
 CellID->7038],
Cell[CellGroupData[{
Cell[10942, 365, 134, 4, 70, "Input",
 CellID->9853],
Cell[11079, 371, 297, 9, 36, "Output",
 CellID->98489025]
}, Open  ]],
Cell[11391, 383, 121, 3, 70, "ExampleDelimiter",
 CellID->11224],
Cell[11515, 388, 51, 1, 70, "ExampleText",
 CellID->15748],
Cell[CellGroupData[{
Cell[11591, 393, 285, 10, 70, "Input",
 CellID->19923],
Cell[11879, 405, 1978, 41, 128, "Output",
 CellID->208397220]
}, Open  ]],
Cell[13872, 449, 121, 3, 70, "ExampleDelimiter",
 CellID->16142],
Cell[13996, 454, 69, 1, 70, "ExampleText",
 CellID->31196],
Cell[CellGroupData[{
Cell[14090, 459, 334, 11, 70, "Input",
 CellID->21948],
Cell[14427, 472, 28370, 469, 70, "Output",
 Evaluatable->False,
 CellID->261226464]
}, Open  ]],
Cell[42812, 944, 121, 3, 70, "ExampleDelimiter",
 CellID->32257],
Cell[42936, 949, 76, 1, 70, "ExampleText",
 CellID->24766],
Cell[CellGroupData[{
Cell[43037, 954, 280, 9, 70, "Input",
 CellID->4944],
Cell[43320, 965, 477, 17, 54, "Output",
 CellID->38058471]
}, Open  ]],
Cell[CellGroupData[{
Cell[43834, 987, 275, 9, 70, "Input",
 CellID->23318],
Cell[44112, 998, 4385, 76, 70, "Output",
 Evaluatable->False,
 CellID->693013862]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48546, 1080, 233, 7, 70, "ExampleSection",
 CellID->25411],
Cell[48782, 1089, 334, 12, 70, "ExampleText",
 CellID->21025],
Cell[CellGroupData[{
Cell[49141, 1105, 135, 4, 70, "Input",
 CellID->20355],
Cell[49279, 1111, 297, 9, 36, "Output",
 CellID->20804400]
}, Open  ]],
Cell[CellGroupData[{
Cell[49613, 1125, 103, 3, 70, "Input",
 CellID->22549],
Cell[49719, 1130, 281, 9, 36, "Output",
 CellID->54335009]
}, Open  ]],
Cell[50015, 1142, 125, 3, 70, "ExampleDelimiter",
 CellID->148742318],
Cell[50143, 1147, 346, 12, 70, "ExampleText",
 CellID->1863065730],
Cell[CellGroupData[{
Cell[50514, 1163, 246, 8, 70, "Input",
 CellID->838354101],
Cell[50763, 1173, 325, 10, 36, "Output",
 CellID->63522846]
}, Open  ]],
Cell[CellGroupData[{
Cell[51125, 1188, 173, 5, 70, "Input",
 CellID->171781849],
Cell[51301, 1195, 326, 10, 36, "Output",
 CellID->536581097]
}, Open  ]],
Cell[51642, 1208, 124, 3, 70, "ExampleDelimiter",
 CellID->47430388],
Cell[51769, 1213, 214, 8, 70, "ExampleText",
 CellID->519612608],
Cell[CellGroupData[{
Cell[52008, 1225, 232, 8, 70, "Input",
 CellID->237443408],
Cell[52243, 1235, 341, 12, 51, "Output",
 CellID->202464782]
}, Open  ]],
Cell[CellGroupData[{
Cell[52621, 1252, 184, 6, 70, "Input",
 CellID->389016197],
Cell[52808, 1260, 302, 9, 36, "Output",
 CellID->72734555]
}, Open  ]],
Cell[CellGroupData[{
Cell[53147, 1274, 249, 8, 70, "Input",
 CellID->561076830],
Cell[53399, 1284, 303, 9, 36, "Output",
 CellID->477698562]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53751, 1299, 224, 7, 70, "ExampleSection",
 CellID->17964],
Cell[53978, 1308, 70, 1, 70, "ExampleText",
 CellID->23342],
Cell[CellGroupData[{
Cell[54073, 1313, 212, 6, 70, "Input",
 CellID->8075],
Cell[54288, 1321, 714, 22, 54, "Output",
 CellID->17913]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55063, 1350, 311, 9, 70, "SeeAlsoSection",
 CellID->26463],
Cell[55377, 1361, 1422, 53, 70, "SeeAlso",
 CellID->5049]
}, Open  ]],
Cell[CellGroupData[{
Cell[56836, 1419, 305, 8, 70, "RelatedLinksSection"],
Cell[57144, 1429, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57546, 1446, 319, 9, 70, "MoreAboutSection",
 CellID->502769349],
Cell[57868, 1457, 162, 3, 70, "MoreAbout",
 CellID->19133413],
Cell[58033, 1462, 151, 3, 70, "MoreAbout",
 CellID->615322017],
Cell[58187, 1467, 167, 3, 70, "MoreAbout",
 CellID->320605463],
Cell[58357, 1472, 156, 3, 70, "MoreAbout",
 CellID->14363928],
Cell[58516, 1477, 190, 4, 70, "MoreAbout",
 CellID->614347019],
Cell[58709, 1483, 139, 3, 70, "MoreAbout",
 CellID->371423871],
Cell[58851, 1488, 156, 3, 70, "MoreAbout",
 CellID->660487536],
Cell[59010, 1493, 164, 3, 70, "MoreAbout",
 CellID->127292842],
Cell[59177, 1498, 174, 3, 70, "MoreAbout",
 CellID->31614957]
}, Open  ]],
Cell[59366, 1504, 27, 0, 70, "History"],
Cell[59396, 1506, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

