(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47711,       1693]
NotebookOptionsPosition[     38721,       1375]
NotebookOutlinePosition[     40181,       1415]
CellTagsIndexPosition[     40095,       1410]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Precision" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalPrecision"], 
          "The Uncertainties of Numerical Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheUncertaintiesOfNumericalMathematics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Numerical Precision\"\>", 
       2->"\<\"The Uncertainties of Numerical Mathematics\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Precision" :> Documentation`HelpLookup["paclet:ref/Precision"],
           "RealExponent" :> 
          Documentation`HelpLookup["paclet:ref/RealExponent"], "N" :> 
          Documentation`HelpLookup["paclet:ref/N"], "Chop" :> 
          Documentation`HelpLookup["paclet:ref/Chop"], "SetAccuracy" :> 
          Documentation`HelpLookup["paclet:ref/SetAccuracy"], "AccuracyGoal" :> 
          Documentation`HelpLookup["paclet:ref/AccuracyGoal"], 
          "WorkingPrecision" :> 
          Documentation`HelpLookup["paclet:ref/WorkingPrecision"], 
          "NumberMarks" :> 
          Documentation`HelpLookup["paclet:ref/NumberMarks"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Precision\"\>", 
       2->"\<\"RealExponent\"\>", 3->"\<\"N\"\>", 4->"\<\"Chop\"\>", 
       5->"\<\"SetAccuracy\"\>", 6->"\<\"AccuracyGoal\"\>", 
       7->"\<\"WorkingPrecision\"\>", 
       8->"\<\"NumberMarks\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Numerical Evaluation & Precision\"\>", 
       2->"\<\"Precision & Accuracy Control\"\>", 
       3->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Accuracy", "ObjectName",
 CellID->32685],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Accuracy",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Accuracy"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the effective number of digits to the right of \
the decimal point in the number ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25313]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives a measure of the absolute uncertainty in the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6698],

Cell[TextData[{
 "With uncertainty ",
 Cell[BoxData[
  StyleBox["dx", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"-", 
   RowBox[{
    ButtonBox["Log",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Log"], "[", 
    RowBox[{"10", ",", 
     StyleBox["dx", "TI"]}], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5589],

Cell[TextData[{
 "For exact numbers such as integers, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12722],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " does not normally yield an integer result, and need not be positive. "
}], "Notes",
 CellID->5938],

Cell[TextData[{
 "For any approximate number ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Precision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Precision"], "[", 
    StyleBox["x", "TI"], "]"}], "-", 
   RowBox[{
    ButtonBox["RealExponent",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RealExponent"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->97107366],

Cell[TextData[{
 "For machine\[Hyphen]precision numbers, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives the same as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["$MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachinePrecision"], "-", 
   RowBox[{
    ButtonBox["Log",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Log"], "[", 
    RowBox[{"10", ",", 
     RowBox[{
      ButtonBox["Abs",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Abs"], "[", 
      StyleBox["x", "TI"], "]"}]}], "]"}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->55622304]
}], "Notes",
 CellID->19037],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"], "[", "0.", "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   RowBox[{"10", ",", 
    ButtonBox["$MinMachineNumber",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MinMachineNumber"]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->553070060]
}], "Notes",
 CellID->6410],

Cell[TextData[{
 "Numbers entered in the form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["digits", "TI"], "``", 
    StyleBox["a", "TI"]}]]], "InlineFormula"],
 " are taken to have accuracy ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31461],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is not a number, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives the minimum value of ",
 Cell[BoxData[
  ButtonBox["Accuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accuracy"]], "InlineFormula"],
 " for all the numbers that appear in ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->37408250]
}], "Notes",
 CellID->6234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25463265],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->613783552],

Cell["Machine-precision number:", "ExampleText",
 CellID->421249407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "1.2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11096231],

Cell[BoxData["15.87540852414338`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237802794]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135059416],

Cell["Arbitrary-precision number:", "ExampleText",
 CellID->3448096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "1.2``20", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153474450],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249061356]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->692577826],

Cell["Exact number:", "ExampleText",
 CellID->297284483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "3", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46174991],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1585905]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10866611],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Accuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accuracy"]], "InlineFormula"],
 " is the effective number of digits known to the right of the decimal \
point:"
}], "ExampleText",
 CellID->514328375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "123456789.987654321", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->799383347],

Cell[BoxData["9.000000000000002`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->570109236]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3605412],

Cell["A zero known to accuracy 20:", "ExampleText",
 CellID->352368042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", "=", "0``20"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39426141],

Cell[BoxData["0``20."], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72699176]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "z", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167591720],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->348707867]
}, Open  ]],

Cell[TextData[{
 "The precision of ",
 Cell[BoxData[
  RowBox[{"z", "+", "1"}]], "InlineFormula"],
 " is the same as the accuracy of ",
 Cell[BoxData["z"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->140544857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "z"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->319029520],

Cell[BoxData["1.`20."], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->55958557]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->103449877],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->35118938]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675815304],

Cell["Accuracy of a machine zero:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->553070060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "0.", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303230998],

Cell[BoxData["307.6526555685888`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->448160536]
}, Open  ]],

Cell[TextData[{
 "The uncertainty ",
 Cell[BoxData["dx"], "InlineFormula"],
 " is effectively the smallest positive machine number:"
}], "ExampleText",
 CellID->368867855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dx", "=", "$MinMachineNumber"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->209364474],

Cell[BoxData["2.2250738585072014`*^-308"], "Output",
 ImageSize->{99, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->394374486]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Log", "[", 
   RowBox[{"10", ",", "dx"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->160926941],

Cell[BoxData["307.6526555685887`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2090307]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->248768657],

Cell[TextData[{
 "Specify accuracy as the goal for ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7767385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"1", "/", "GoldenRatio"}], "-", "GoldenRatio"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Infinity]", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->667233917],

Cell[BoxData["0``30."], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5153899]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56253730],

Cell[BoxData["30.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->248098235]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->75035793],

Cell["\<\
The accuracy of a symbolic expression is the minimum of the accuracies of its \
numbers:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->37408250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", 
  RowBox[{"f", "[", 
   RowBox[{"1``25", ",", "2``30"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99306668],

Cell[BoxData["25.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120751695]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", 
  RowBox[{"1``25", "+", 
   RowBox[{"3``30", " ", 
    RowBox[{"x", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->620257596],

Cell[BoxData["25.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100759440]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->852406319],

Cell["Check the quality of a result:", "ExampleText",
 CellID->551088138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "1234`32", "]"}], "+", "12.`34"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->147132312],

Cell[BoxData["12.601927654762497334555047625712448239080592882378`30.\
10676648557029"], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->486214782]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->35230516],

Cell[BoxData["29.00632950348493`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24084096]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->524227960],

Cell["Track loss of accuracy in a repetitive calculation:", "ExampleText",
 CellID->243398517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"logistic", "=", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"4", " ", "#", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", 
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"1", "/", "Pi"}], ",", "30"}], "]"}], ",", "20"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12630614],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.318309886183790671537767526745028724068919465732`30.", ",", 
   "0.867954810165811600375552254141204340658242320512`29.83358699570566", 
   ",", "0.458437030703366192594167986182804187589133652602`28.\
954309580979626", ",", 
   "0.99309007833298830171554900593974559151`28.687958541715883", ",", 
   "0.02744869859826984222841441846916507566`26.527431665822732", ",", 
   "0.10678107017412472570726730226536690625`26.515344185155232", ",", 
   "0.38151549290637350651196345415566890939`26.466302103575913", ",", 
   "0.94384568631512149258038655460975085698`26.25763092869219", ",", 
   "0.21200402695783509522130913584810687521`25.007014052381056", ",", 
   "0.66823327804598650176735708251893348717`24.903538050467013", ",", 
   "0.88679025663160718450293876351139003482`24.424370872189872", ",", 
   "0.40157318949942181772164212120993060195`23.47825467809718", ",", 
   "0.96124865189873308989962754932619493218`23.255265720493068", ",", 
   "0.14899872448640539016699587224472497048`21.843552536051714", ",", 
   "0.50719241835131859586878641962302165222`21.773482747074137", ",", 
   "0.99979307647303846196500989612591990944`21.46616012772981", ",", 
   "0.00082752283846211133052805116539958442`17.78196999997449", ",", 
   "0.00330735217765573976369766624255912271`17.781610462588873", ",", 
   "0.01318565439691478239879285745554853514`17.780171717255993", ",", 
   "0.05204717166015961705943987078`17.774407171582986", ",", 
   "0.19735305432934997868341913021`17.751193898265548"}], "}"}]], "Output",
 ImageSize->{552, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->746421887]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Map", "[", 
   RowBox[{"Accuracy", ",", "logistic"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->343669980],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 30.497149872694134`}, {2., 29.89508988136617}, {3., 
     29.29302989003821}, {4., 28.690969898710243`}, {5., 
     28.088909907382284`}, {6., 27.48684991605432}, {7., 26.88478992472636}, {
     8., 26.282729933398393`}, {9., 25.680669942070434`}, {10., 
     25.07860995074247}, {11., 24.47654995941451}, {12., 
     23.874489968086547`}, {13., 23.27242997675859}, {14., 
     22.67036998543062}, {15., 22.068309994102663`}, {16., 
     21.4662500027747}, {17., 20.864190011446738`}, {18., 
     20.262130020118775`}, {19., 19.660070028790813`}, {20., 
     19.058010037462846`}, {21., 18.455950046134884`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 20.},
  PlotRange->{{0., 21.}, {18.455950046134884`, 30.497149872694134`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16834479]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->190933827],

Cell[TextData[{
 "For machine\[Hyphen]precision numbers, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["$MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachinePrecision"], "-", 
   RowBox[{
    ButtonBox["Log",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Log"], "[", 
    RowBox[{"10", ",", 
     RowBox[{
      ButtonBox["Abs",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Abs"], "[", 
      StyleBox["x", "TI"], "]"}]}], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->55622304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}], " ", 
   RowBox[{"10", "^", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "300"}], ",", "300"}], "}"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216964836],

Cell[BoxData[
 RowBox[{"-", "4.680992863270506`*^-137"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232712837]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387012710],

Cell[BoxData["152.28425179119657`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->98594744]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$MachinePrecision", "-", 
  RowBox[{"Log", "[", 
   RowBox[{"10", ",", 
    RowBox[{"Abs", "[", "x", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->179598991],

Cell[BoxData["152.28425179119657`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->587411264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37261581],

Cell[TextData[{
 "For nonmachine numbers, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Precision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Precision"], "[", 
    StyleBox["x", "TI"], "]"}], " ", "==", " ", 
   RowBox[{
    RowBox[{
     ButtonBox["RealExponent",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RealExponent"], "[", 
     StyleBox["x", "TI"], "]"}], " ", "+", " ", 
    RowBox[{"Accuracy", "[", 
     StyleBox["x", "TI"], "]"}]}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->612732052],

Cell[BoxData[
 RowBox[{
  RowBox[{"numberTypes", "=", 
   RowBox[{"{", 
    RowBox[{"123456789.987654321", ",", "0``40", ",", "2`21", ",", 
     RowBox[{"N", "[", 
      RowBox[{"Pi", ",", "18.9"}], "]"}], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"N", "[", 
      RowBox[{"Exp", "[", 
       RowBox[{"10", "+", "I"}], "]"}], "]"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286235684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Precision", "[", "x", "]"}], ",", 
       RowBox[{"RealExponent", "[", "x", "]"}], ",", 
       RowBox[{"Accuracy", "[", "x", "]"}], ",", 
       RowBox[{
        RowBox[{"Precision", "[", "x", "]"}], "==", 
        RowBox[{
         RowBox[{"RealExponent", "[", "x", "]"}], "+", 
         RowBox[{"Accuracy", "[", "x", "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "numberTypes"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<x\>\"", ",", "\"\<Precision\>\"", ",", "\"\<RealExponent\>\"", 
        ",", "\"\<Accuracy\>\"", ",", "\"\<equality\>\""}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48002357],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"x\"\>",
       HoldForm], 
      TagBox["\<\"Precision\"\>",
       HoldForm], 
      TagBox["\<\"RealExponent\"\>",
       HoldForm], 
      TagBox["\<\"Accuracy\"\>",
       HoldForm], 
      TagBox["\<\"equality\"\>",
       HoldForm]},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "1.23456789987654321`17.091514980643627*^8", "17.091514980643627`", 
      "8.091514980643627`", "9.000000000000002`", "True"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "0``40.", "0.`", 
      RowBox[{"-", "40.`"}], "40.`", "True"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "2.`21.", "21.`", 
      "0.3010299956639812`", "20.69897000433602`", "True"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "3.14159265358979323846264338358`18.900000000000002", 
      "18.900000000000002`", "0.4971498726941334`", "18.402850127305868`", 
      "True"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      RowBox[{"-", "7"}], "\[Infinity]", "0.8450980400142569`", "\[Infinity]",
       "True"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      RowBox[{"11900.950259059777`", "\[InvisibleSpace]", "+", 
       RowBox[{"18534.631864193456`", " ", "\[ImaginaryI]"}]}], 
      "MachinePrecision", "4.342944819032518`", "11.611644951158484`", 
      "True"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$, 
    TableHeadings -> {{}, {
      "x", "Precision", "RealExponent", "Accuracy", "equality"}}]]]], "Output",\

 ImageSize->{510, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->7256414]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3039],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Accuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accuracy"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " in iterating the logistic map:"
}], "ExampleText",
 CellID->23151542],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "#", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"1", "/", "Pi"}], ",", "30"}], "]"}], ",", "56"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94117939],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Accuracy", "/@", "i"}]}], ";", " ", 
  RowBox[{"p", "=", 
   RowBox[{"Precision", "/@", "i"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->521809281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "p"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", "Axis"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->233071193],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[3]=",
 CellID->332142167]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1515],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetAccuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetAccuracy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AccuracyGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AccuracyGoal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberMarks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberMarks"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25269]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12508],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "Tutorials",
 CellID->9961],

Cell[TextData[ButtonBox["The Uncertainties of Numerical Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheUncertaintiesOfNumericalMathematics"]], "Tutorials",
 CellID->3856]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->330492951],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->120250838],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->392170836],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->110704345]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Accuracy - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 26.8915374}", "context" -> "System`", 
    "keywords" -> {
     "absolute error", "absolute error interval", 
      "arbitrary-precision numbers", "arbitrary-precision vectors", 
      "conformity", "error interval", "number of decimal places", 
      "significance arithmetic", "veracity"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Accuracy[x] gives the effective number of digits to the right of the \
decimal point in the number x. ", "synonyms" -> {"``"}, "title" -> "Accuracy",
     "type" -> "Symbol", "uri" -> "ref/Accuracy"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9516, 332, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->25463265]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39953, 1403}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3126, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3749, 97, 46, 1, 70, "ObjectName",
 CellID->32685],
Cell[3798, 100, 605, 19, 70, "Usage",
 CellID->25313]
}, Open  ]],
Cell[CellGroupData[{
Cell[4440, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4918, 141, 342, 12, 70, "Notes",
 CellID->6698],
Cell[5263, 155, 526, 22, 70, "Notes",
 CellID->5589],
Cell[5792, 179, 389, 15, 70, "Notes",
 CellID->12722],
Cell[6184, 196, 287, 9, 70, "Notes",
 CellID->5938],
Cell[6474, 207, 682, 26, 70, "Notes",
 CellID->97107366],
Cell[7159, 235, 806, 29, 70, "Notes",
 CellID->19037],
Cell[7968, 266, 566, 21, 70, "Notes",
 CellID->6410],
Cell[8537, 289, 296, 12, 70, "Notes",
 CellID->31461],
Cell[8836, 303, 643, 24, 70, "Notes",
 CellID->6234]
}, Closed]],
Cell[CellGroupData[{
Cell[9516, 332, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25463265],
Cell[CellGroupData[{
Cell[9900, 346, 148, 5, 70, "ExampleSection",
 CellID->613783552],
Cell[10051, 353, 68, 1, 70, "ExampleText",
 CellID->421249407],
Cell[CellGroupData[{
Cell[10144, 358, 105, 3, 28, "Input",
 CellID->11096231],
Cell[10252, 363, 175, 5, 36, "Output",
 CellID->237802794]
}, Open  ]],
Cell[10442, 371, 125, 3, 70, "ExampleDelimiter",
 CellID->135059416],
Cell[10570, 376, 68, 1, 70, "ExampleText",
 CellID->3448096],
Cell[CellGroupData[{
Cell[10663, 381, 110, 3, 70, "Input",
 CellID->153474450],
Cell[10776, 386, 161, 5, 36, "Output",
 CellID->249061356]
}, Open  ]],
Cell[10952, 394, 125, 3, 70, "ExampleDelimiter",
 CellID->692577826],
Cell[11080, 399, 56, 1, 70, "ExampleText",
 CellID->297284483],
Cell[CellGroupData[{
Cell[11161, 404, 103, 3, 70, "Input",
 CellID->46174991],
Cell[11267, 409, 166, 5, 36, "Output",
 CellID->1585905]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11482, 420, 219, 7, 70, "ExampleSection",
 CellID->10866611],
Cell[11704, 429, 254, 8, 70, "ExampleText",
 CellID->514328375],
Cell[CellGroupData[{
Cell[11983, 441, 122, 3, 70, "Input",
 CellID->799383347],
Cell[12108, 446, 175, 5, 36, "Output",
 CellID->570109236]
}, Open  ]],
Cell[12298, 454, 123, 3, 70, "ExampleDelimiter",
 CellID->3605412],
Cell[12424, 459, 71, 1, 70, "ExampleText",
 CellID->352368042],
Cell[CellGroupData[{
Cell[12520, 464, 95, 3, 70, "Input",
 CellID->39426141],
Cell[12618, 469, 162, 5, 36, "Output",
 CellID->72699176]
}, Open  ]],
Cell[CellGroupData[{
Cell[12817, 479, 104, 3, 70, "Input",
 CellID->167591720],
Cell[12924, 484, 161, 5, 36, "Output",
 CellID->348707867]
}, Open  ]],
Cell[13100, 492, 217, 8, 70, "ExampleText",
 CellID->140544857],
Cell[CellGroupData[{
Cell[13342, 504, 92, 3, 70, "Input",
 CellID->319029520],
Cell[13437, 509, 163, 5, 36, "Output",
 CellID->55958557]
}, Open  ]],
Cell[CellGroupData[{
Cell[13637, 519, 105, 3, 70, "Input",
 CellID->103449877],
Cell[13745, 524, 160, 5, 36, "Output",
 CellID->35118938]
}, Open  ]],
Cell[13920, 532, 125, 3, 70, "ExampleDelimiter",
 CellID->675815304],
Cell[14048, 537, 118, 2, 70, "ExampleText",
 CellID->553070060],
Cell[CellGroupData[{
Cell[14191, 543, 105, 3, 70, "Input",
 CellID->303230998],
Cell[14299, 548, 175, 5, 36, "Output",
 CellID->448160536]
}, Open  ]],
Cell[14489, 556, 171, 5, 70, "ExampleText",
 CellID->368867855],
Cell[CellGroupData[{
Cell[14685, 565, 109, 3, 70, "Input",
 CellID->209364474],
Cell[14797, 570, 182, 5, 36, "Output",
 CellID->394374486]
}, Open  ]],
Cell[CellGroupData[{
Cell[15016, 580, 143, 5, 70, "Input",
 CellID->160926941],
Cell[15162, 587, 173, 5, 36, "Output",
 CellID->2090307]
}, Open  ]],
Cell[15350, 595, 125, 3, 70, "ExampleDelimiter",
 CellID->248768657],
Cell[15478, 600, 200, 8, 70, "ExampleText",
 CellID->7767385],
Cell[CellGroupData[{
Cell[15703, 612, 259, 8, 70, "Input",
 CellID->667233917],
Cell[15965, 622, 161, 5, 36, "Output",
 CellID->5153899]
}, Open  ]],
Cell[CellGroupData[{
Cell[16163, 632, 103, 3, 70, "Input",
 CellID->56253730],
Cell[16269, 637, 161, 5, 36, "Output",
 CellID->248098235]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16479, 648, 242, 7, 70, "ExampleSection",
 CellID->75035793],
Cell[16724, 657, 186, 5, 70, "ExampleText",
 CellID->37408250],
Cell[CellGroupData[{
Cell[16935, 666, 163, 5, 70, "Input",
 CellID->99306668],
Cell[17101, 673, 161, 5, 36, "Output",
 CellID->120751695]
}, Open  ]],
Cell[CellGroupData[{
Cell[17299, 683, 184, 6, 70, "Input",
 CellID->620257596],
Cell[17486, 691, 161, 5, 36, "Output",
 CellID->100759440]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17696, 702, 227, 7, 70, "ExampleSection",
 CellID->852406319],
Cell[17926, 711, 73, 1, 70, "ExampleText",
 CellID->551088138],
Cell[CellGroupData[{
Cell[18024, 716, 133, 4, 70, "Input",
 CellID->147132312],
Cell[18160, 722, 229, 6, 36, "Output",
 CellID->486214782]
}, Open  ]],
Cell[CellGroupData[{
Cell[18426, 733, 103, 3, 70, "Input",
 CellID->35230516],
Cell[18532, 738, 174, 5, 36, "Output",
 CellID->24084096]
}, Open  ]],
Cell[18721, 746, 125, 3, 70, "ExampleDelimiter",
 CellID->524227960],
Cell[18849, 751, 94, 1, 70, "ExampleText",
 CellID->243398517],
Cell[CellGroupData[{
Cell[18968, 756, 368, 13, 70, "Input",
 CellID->12630614],
Cell[19339, 771, 1690, 29, 173, "Output",
 CellID->746421887]
}, Open  ]],
Cell[CellGroupData[{
Cell[21066, 805, 172, 5, 70, "Input",
 CellID->343669980],
Cell[21241, 812, 1093, 25, 127, "Output",
 CellID->16834479]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22383, 843, 237, 7, 70, "ExampleSection",
 CellID->190933827],
Cell[22623, 852, 773, 27, 70, "ExampleText",
 CellID->55622304],
Cell[CellGroupData[{
Cell[23421, 883, 373, 13, 70, "Input",
 CellID->216964836],
Cell[23797, 898, 199, 6, 36, "Output",
 CellID->232712837]
}, Open  ]],
Cell[CellGroupData[{
Cell[24033, 909, 104, 3, 70, "Input",
 CellID->387012710],
Cell[24140, 914, 175, 5, 36, "Output",
 CellID->98594744]
}, Open  ]],
Cell[CellGroupData[{
Cell[24352, 924, 195, 6, 70, "Input",
 CellID->179598991],
Cell[24550, 932, 176, 5, 36, "Output",
 CellID->587411264]
}, Open  ]],
Cell[24741, 940, 124, 3, 70, "ExampleDelimiter",
 CellID->37261581],
Cell[24868, 945, 542, 19, 70, "ExampleText",
 CellID->612732052],
Cell[25413, 966, 411, 12, 70, "Input",
 CellID->286235684],
Cell[CellGroupData[{
Cell[25849, 982, 940, 27, 70, "Input",
 CellID->48002357],
Cell[26792, 1011, 2948, 84, 144, "Output",
 CellID->7256414]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29789, 1101, 223, 7, 70, "ExampleSection",
 CellID->3039],
Cell[30015, 1110, 338, 12, 70, "ExampleText",
 CellID->23151542],
Cell[30356, 1124, 387, 14, 70, "Input",
 CellID->94117939],
Cell[30746, 1140, 213, 7, 70, "Input",
 CellID->521809281],
Cell[CellGroupData[{
Cell[30984, 1151, 376, 12, 70, "Input",
 CellID->233071193],
Cell[31363, 1165, 3380, 60, 70, "Output",
 Evaluatable->False,
 CellID->332142167]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34804, 1232, 310, 9, 70, "SeeAlsoSection",
 CellID->1515],
Cell[35117, 1243, 1945, 71, 70, "SeeAlso",
 CellID->25269]
}, Open  ]],
Cell[CellGroupData[{
Cell[37099, 1319, 314, 9, 70, "TutorialsSection",
 CellID->12508],
Cell[37416, 1330, 147, 3, 70, "Tutorials",
 CellID->9961],
Cell[37566, 1335, 193, 4, 70, "Tutorials",
 CellID->3856]
}, Open  ]],
Cell[CellGroupData[{
Cell[37796, 1344, 319, 9, 70, "MoreAboutSection",
 CellID->330492951],
Cell[38118, 1355, 175, 3, 70, "MoreAbout",
 CellID->120250838],
Cell[38296, 1360, 167, 3, 70, "MoreAbout",
 CellID->392170836],
Cell[38466, 1365, 160, 3, 70, "MoreAbout",
 CellID->110704345]
}, Open  ]],
Cell[38641, 1371, 50, 0, 70, "History"],
Cell[38694, 1373, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

