(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34743,       1217]
NotebookOptionsPosition[     28684,       1008]
NotebookOutlinePosition[     30092,       1047]
CellTagsIndexPosition[     30006,       1042]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Evaluation of Sums and Products" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalEvaluationOfSumsAndProducts"], 
          "The Uncertainties of Numerical Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheUncertaintiesOfNumericalMathematics"], 
          "Controlling the Precision of Results" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ControllingThePrecisionOfResults"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Evaluation of Sums and Products\"\>", 
       2->"\<\"The Uncertainties of Numerical Mathematics\"\>", 
       3->"\<\"Controlling the Precision of Results\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PrecisionGoal" :> 
          Documentation`HelpLookup["paclet:ref/PrecisionGoal"], 
          "WorkingPrecision" :> 
          Documentation`HelpLookup["paclet:ref/WorkingPrecision"], "Accuracy" :> 
          Documentation`HelpLookup["paclet:ref/Accuracy"], "SetAccuracy" :> 
          Documentation`HelpLookup["paclet:ref/SetAccuracy"], "Precision" :> 
          Documentation`HelpLookup["paclet:ref/Precision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PrecisionGoal\"\>", 
       2->"\<\"WorkingPrecision\"\>", 3->"\<\"Accuracy\"\>", 
       4->"\<\"SetAccuracy\"\>", 5->"\<\"Precision\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Differential Equations" :> 
          Documentation`HelpLookup["paclet:guide/DifferentialEquations"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Differential Equations\"\>", 
       2->"\<\"Numerical Evaluation & Precision\"\>", 
       3->"\<\"Precision & Accuracy Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AccuracyGoal", "ObjectName",
 CellID->4186],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AccuracyGoal",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
     "\[LineSeparator]is an option for various numerical operations which \
specifies how many effective digits of accuracy should be sought in the final \
result. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19690]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " is an option for such functions as ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1650],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AccuracyGoal", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " normally yields an accuracy goal equal to half the setting for ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5662],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AccuracyGoal", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " specifies that accuracy should not be used as the criterion for \
terminating the numerical procedure. ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " is typically used in this case. "
}], "Notes",
 CellID->21634],

Cell[TextData[{
 "Even though you may specify ",
 Cell[BoxData[
  RowBox[{"AccuracyGoal", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", the results you get may sometimes have much less than ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]digit accuracy. "
}], "Notes",
 CellID->10893],

Cell[TextData[{
 "In most cases, you must set ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " to be at least as large as ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10353],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " effectively specifies the absolute error allowed in a numerical procedure. \
"
}], "Notes",
 CellID->21416],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"AccuracyGoal", "->", 
   StyleBox["a", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrecisionGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrecisionGoal"], "->", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " attempts to make the numerical error in a result of size ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " be less than ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "a"}]], "+"}], "\[VerticalSeparator]", "x", 
    "\[VerticalSeparator]", 
    SuperscriptBox["10", 
     RowBox[{"-", "p"}]]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->13452]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->563596514],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->95786385],

Cell["\<\
Approximate a numerical integral to at least 8 digits of accuracy:\
\>", "ExampleText",
 CellID->348038384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "8"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->386129588],

Cell[BoxData[
 RowBox[{"-", "5.935887200955563`*^-17"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6717466]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->155190464],

Cell["\<\
Use precision (relative error) as the basis for error control in solving an \
ODE:\
\>", "ExampleText",
 CellID->12261670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"x", "[", "t", "]"}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
       RowBox[{"10", "^", 
        RowBox[{"-", "20"}]}]}]}], "}"}], ",", "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"AccuracyGoal", "\[Rule]", "\[Infinity]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142742754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->762011485]
}, Open  ]],

Cell["The relative error is small:", "ExampleText",
 CellID->302226211],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"relerr", "[", "t_", "]"}], "=", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Exp", "[", "t", "]"}], " ", 
       RowBox[{"10", "^", 
        RowBox[{"-", "20"}]}]}], ")"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104028663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"relerr", "[", "1", "]"}], "/.", "s"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->781204127],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"-", "8.003986806670582`*^-9"}], "}"}]], "Output",
 ImageSize->{111, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->29283195]
}, Open  ]],

Cell[TextData[{
 "Without specifying the ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 ", the relative error is much larger:"
}], "ExampleText",
 CellID->23299109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"relerr", "[", "1", "]"}], "/.", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"x", "[", "t", "]"}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
       RowBox[{"10", "^", 
        RowBox[{"-", "20"}]}]}]}], "}"}], ",", "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->70621134],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"-", "0.0008148395914187034`"}], "}"}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->239494669]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->743382457],

Cell[TextData[{
 "Find a minimum with convergence criteria ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     SubscriptBox["x", "k"], "-", 
     SuperscriptBox["x", "*"]}], "||", " ", 
    RowBox[{"\[LessEqual]", " ", 
     RowBox[{"max", "(", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "10"}]], ",", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]], "||", 
        SubscriptBox["x", "k"], "||"}]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[EmptyDownTriangle]", " ", 
     RowBox[{"f", "(", 
      SubscriptBox["x", "k"], ")"}]}], "\[LessEqual]", 
    SuperscriptBox["10", 
     RowBox[{"-", "10"}]]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->764461149],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50954599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "10"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "8"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1625295724],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.170803763674703`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->227597389]
}, Open  ]],

Cell[TextData[{
 "Use convergence criteria ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     SubscriptBox["x", "k"], "-", 
     SuperscriptBox["x", "*"]}], "||", " ", 
    RowBox[{"\[LessEqual]", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "10"}]]}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[EmptyDownTriangle]", " ", 
     RowBox[{"f", "(", 
      SubscriptBox["x", "k"], ")"}]}], "\[LessEqual]", 
    SuperscriptBox["10", 
     RowBox[{"-", "10"}]]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->255782270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "10"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->453268449],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.170803763674703`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->755266289]
}, Open  ]],

Cell[TextData[{
 "Use convergence criteria ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     SubscriptBox["x", "k"], "-", 
     SuperscriptBox["x", "*"]}], "||", " ", 
    RowBox[{"\[LessEqual]", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "20"}]]}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[EmptyDownTriangle]", " ", 
     RowBox[{"f", "(", 
      SubscriptBox["x", "k"], ")"}]}], "\[LessEqual]", 
    SuperscriptBox["10", 
     RowBox[{"-", "20"}]]}], TraditionalForm]], "InlineMath"],
 " not possible at machine precision:"
}], "ExampleText",
 CellID->188214728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "20"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->151031849],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"lstol\"\>"}], ":", 
  " ", "\<\"The line search decreased the step size to within tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function.  You may need more than \
\\!\\(MachinePrecision\\) digits of working precision to meet these \
tolerances. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindMinimum/lstol\\\", ButtonNote -> \
\\\"FindMinimum::lstol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->154400462],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.170803763674711`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->382146179]
}, Open  ]],

Cell["Use a higher working precision to allow convergence:", "ExampleText",
 CellID->450391656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "20"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "\[Infinity]"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "40"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->36348711],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`40."}], ",", 
   RowBox[{"{", 
    RowBox[{
    "x", "\[Rule]", 
     "2.1708037636748029780890438818723873547073369575224988348876`40."}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{342, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->182055539]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->311509694],

Cell["\<\
Solve a differential equation using high-precision arithmetic:\
\>", "ExampleText",
 CellID->137303445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s32", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "^", "5"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "32"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->631190080],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5.`32."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{519, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132497075]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], "/.", "s32"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->563876876],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42061108]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " at half the 32-digit working precision:"
}], "ExampleText",
 CellID->697087395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sag", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "^", "5"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "32"}], ",", 
    RowBox[{"AccuracyGoal", "\[Rule]", "16"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "16"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->337245167],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5.`32."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{519, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->126319108]
}, Open  ]],

Cell[TextData[{
 "This corresponds to the automatic setting used by ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->55136399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s32", "===", "sag"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->509765148],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->50622180]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16634],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrecisionGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrecisionGoal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetAccuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetAccuracy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26303]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14008],

Cell[TextData[ButtonBox["Numerical Evaluation of Sums and Products",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalEvaluationOfSumsAndProducts"]], "Tutorials",
 CellID->7262],

Cell[TextData[ButtonBox["The Uncertainties of Numerical Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheUncertaintiesOfNumericalMathematics"]], "Tutorials",
 CellID->3856],

Cell[TextData[ButtonBox["Controlling the Precision of Results",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ControllingThePrecisionOfResults"]], "Tutorials",\

 CellID->22233]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->78267840],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DifferentialEquations"]], "MoreAbout",
 CellID->309202562],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->52415191],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->756937]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AccuracyGoal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 26.5009024}", "context" -> "System`", 
    "keywords" -> {
     "absolute error", "accuracy of result", "decimal places", 
      "number of digits", "precision"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AccuracyGoal is an option for various numerical operations which \
specifies how many effective digits of accuracy should be sought in the final \
result. ", "synonyms" -> {"accuracy goal"}, "title" -> "AccuracyGoal", "type" -> 
    "Symbol", "uri" -> "ref/AccuracyGoal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8105, 264, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->563596514]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29863, 1035}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3105, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3728, 97, 49, 1, 70, "ObjectName",
 CellID->4186],
Cell[3780, 100, 533, 15, 70, "Usage",
 CellID->19690]
}, Open  ]],
Cell[CellGroupData[{
Cell[4350, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4828, 137, 593, 22, 70, "Notes",
 CellID->1650],
Cell[5424, 161, 412, 13, 70, "Notes",
 CellID->5662],
Cell[5839, 176, 476, 14, 70, "Notes",
 CellID->21634],
Cell[6318, 192, 317, 10, 70, "Notes",
 CellID->10893],
Cell[6638, 204, 378, 13, 70, "Notes",
 CellID->10353],
Cell[7019, 219, 253, 8, 70, "Notes",
 CellID->21416],
Cell[7275, 229, 793, 30, 70, "Notes",
 CellID->13452]
}, Closed]],
Cell[CellGroupData[{
Cell[8105, 264, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->563596514],
Cell[CellGroupData[{
Cell[8490, 278, 147, 5, 70, "ExampleSection",
 CellID->95786385],
Cell[8640, 285, 117, 3, 70, "ExampleText",
 CellID->348038384],
Cell[CellGroupData[{
Cell[8782, 292, 300, 9, 28, "Input",
 CellID->386129588],
Cell[9085, 303, 196, 6, 36, "Output",
 CellID->6717466]
}, Open  ]],
Cell[9296, 312, 125, 3, 70, "ExampleDelimiter",
 CellID->155190464],
Cell[9424, 317, 132, 4, 70, "ExampleText",
 CellID->12261670],
Cell[CellGroupData[{
Cell[9581, 325, 579, 18, 70, "Input",
 CellID->142742754],
Cell[10163, 345, 466, 17, 36, "Output",
 CellID->762011485]
}, Open  ]],
Cell[10644, 365, 71, 1, 70, "ExampleText",
 CellID->302226211],
Cell[10718, 368, 367, 13, 70, "Input",
 CellID->104028663],
Cell[CellGroupData[{
Cell[11110, 385, 126, 4, 70, "Input",
 CellID->781204127],
Cell[11239, 391, 219, 7, 39, "Output",
 CellID->29283195]
}, Open  ]],
Cell[11473, 401, 248, 8, 70, "ExampleText",
 CellID->23299109],
Cell[CellGroupData[{
Cell[11746, 413, 550, 18, 70, "Input",
 CellID->70621134],
Cell[12299, 433, 219, 7, 36, "Output",
 CellID->239494669]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12567, 446, 220, 7, 70, "ExampleSection",
 CellID->743382457],
Cell[12790, 455, 814, 29, 70, "ExampleText",
 CellID->764461149],
Cell[13607, 486, 195, 7, 70, "Input",
 CellID->50954599],
Cell[CellGroupData[{
Cell[13827, 497, 313, 9, 70, "Input",
 CellID->1625295724],
Cell[14143, 508, 299, 11, 36, "Output",
 CellID->227597389]
}, Open  ]],
Cell[14457, 522, 612, 22, 70, "ExampleText",
 CellID->255782270],
Cell[CellGroupData[{
Cell[15094, 548, 322, 9, 70, "Input",
 CellID->453268449],
Cell[15419, 559, 299, 11, 36, "Output",
 CellID->755266289]
}, Open  ]],
Cell[15733, 573, 646, 22, 70, "ExampleText",
 CellID->188214728],
Cell[CellGroupData[{
Cell[16404, 599, 322, 9, 70, "Input",
 CellID->151031849],
Cell[16729, 610, 616, 11, 70, "Message",
 CellID->154400462],
Cell[17348, 623, 299, 11, 36, "Output",
 CellID->382146179]
}, Open  ]],
Cell[17662, 637, 95, 1, 70, "ExampleText",
 CellID->450391656],
Cell[CellGroupData[{
Cell[17782, 642, 377, 10, 70, "Input",
 CellID->36348711],
Cell[18162, 654, 362, 13, 54, "Output",
 CellID->182055539]
}, Open  ]],
Cell[18539, 670, 125, 3, 70, "ExampleDelimiter",
 CellID->311509694],
Cell[18667, 675, 113, 3, 70, "ExampleText",
 CellID->137303445],
Cell[CellGroupData[{
Cell[18805, 682, 790, 25, 70, "Input",
 CellID->631190080],
Cell[19598, 709, 467, 17, 36, "Output",
 CellID->132497075]
}, Open  ]],
Cell[CellGroupData[{
Cell[20102, 731, 239, 8, 70, "Input",
 CellID->563876876],
Cell[20344, 741, 2558, 46, 70, "Output",
 Evaluatable->False,
 CellID->42061108]
}, Open  ]],
Cell[22917, 790, 373, 13, 70, "ExampleText",
 CellID->697087395],
Cell[CellGroupData[{
Cell[23315, 807, 897, 27, 70, "Input",
 CellID->337245167],
Cell[24215, 836, 467, 17, 36, "Output",
 CellID->126319108]
}, Open  ]],
Cell[24697, 856, 230, 8, 70, "ExampleText",
 CellID->55136399],
Cell[CellGroupData[{
Cell[24952, 868, 98, 3, 70, "Input",
 CellID->509765148],
Cell[25053, 873, 160, 5, 36, "Output",
 CellID->50622180]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25274, 885, 311, 9, 70, "SeeAlsoSection",
 CellID->16634],
Cell[25588, 896, 1220, 44, 70, "SeeAlso",
 CellID->26303]
}, Open  ]],
Cell[CellGroupData[{
Cell[26845, 945, 314, 9, 70, "TutorialsSection",
 CellID->14008],
Cell[27162, 956, 190, 4, 70, "Tutorials",
 CellID->7262],
Cell[27355, 962, 193, 4, 70, "Tutorials",
 CellID->3856],
Cell[27551, 968, 181, 4, 70, "Tutorials",
 CellID->22233]
}, Open  ]],
Cell[CellGroupData[{
Cell[27769, 977, 318, 9, 70, "MoreAboutSection",
 CellID->78267840],
Cell[28090, 988, 155, 3, 70, "MoreAbout",
 CellID->309202562],
Cell[28248, 993, 174, 3, 70, "MoreAbout",
 CellID->52415191],
Cell[28425, 998, 164, 3, 70, "MoreAbout",
 CellID->756937]
}, Open  ]],
Cell[28604, 1004, 50, 0, 70, "History"],
Cell[28657, 1006, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

