(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65972,       2129]
NotebookOptionsPosition[     57471,       1835]
NotebookOutlinePosition[     58914,       1875]
CellTagsIndexPosition[     58828,       1870]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
          "PopupMenu" :> Documentation`HelpLookup["paclet:ref/PopupMenu"], 
          "DockedCells" :> 
          Documentation`HelpLookup["paclet:ref/DockedCells"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Button\"\>", 2->"\<\"PopupMenu\"\>",
        3->"\<\"DockedCells\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "Toolbars" :> Documentation`HelpLookup["paclet:guide/Toolbars"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Custom Interface Construction\"\>", 
       3->"\<\"Stand-Alone Interfaces\"\>", 4->"\<\"Toolbars\"\>", 
       5->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ActionMenu", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ActionMenu",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ActionMenu"], "[", 
       RowBox[{
        StyleBox["name", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["1", "TR"]], ":>", 
           SubscriptBox[
            StyleBox["act", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["2", "TR"]], ":>", 
           SubscriptBox[
            StyleBox["act", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an action menu with label ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     ", and with items labeled ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", that evaluates the expression ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["act", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " if the corresponding item is chosen."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32745]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " and the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be any expressions."
}], "Notes",
 CellID->31762],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ActionMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ActionMenu"]], "InlineFormula"],
 " by default displays ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " and the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData["\"\<ActionMenu\>\""], "InlineFormula"],
 " style, which typically uses the system menu font. "
}], "Notes",
 CellID->28423],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ActionMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ActionMenu"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Delimiter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Delimiter"]], "InlineFormula"],
 " can appear as an element of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ", specifying a horizontal delimiter in the displayed menu."
}], "Notes",
 CellID->27531],

Cell["The following options can be given: ", "Notes",
 CellID->9318],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the menu ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the menu", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the menu is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Evaluator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Evaluator"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the kernel in which to evaluate the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["act", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FieldSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FieldSize"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "50"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "10"}], "}"}]}], "}"}], Cell[
    "the size of the field for menu items ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameMargins"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "margins to leave inside the menu frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed menu ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the displayed menu ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->5602],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " include: "
}], "Notes",
 CellID->31907],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "display only ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     ", without modification"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "display in a special action menu form (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PopupMenu\>\"", Cell[TextData[{
     "display like a popup menu with initial value ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Button\>\"", Cell[
    "display like a button", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->24307],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<ActionMenu\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->358302238],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->327989428],

Cell["\<\
Create an action menu that prints the result of an evaluation:\
\>", "ExampleText",
 CellID->317929816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionMenu", "[", 
  RowBox[{"\"\<Print Factorials\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<4!\>\"", "\[RuleDelayed]", 
      RowBox[{"Print", "[", 
       RowBox[{"4", "!"}], "]"}]}], ",", 
     RowBox[{"\"\<7!\>\"", "\[RuleDelayed]", 
      RowBox[{"Print", "[", 
       RowBox[{"7", "!"}], "]"}]}], ",", 
     RowBox[{"\"\<10!\>\"", "\[RuleDelayed]", 
      RowBox[{"Print", "[", 
       RowBox[{"10", "!"}], "]"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325309079],

Cell[BoxData[
 PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
       Factorial[4]], "7!" :> Print[
       Factorial[7]], "10!" :> Print[
       Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
  2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Print Factorials\"\>",
  Appearance->"ActionMenu",
  Background->Automatic,
  ImageSize->Automatic,
  MenuAppearance->"Menu"]], "Output",
 ImageSize->{109, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->538141336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->370479120],

Cell["\<\
Create an action menu that perform a simple assignment operation:\
\>", "ExampleText",
 CellID->1992641483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ActionMenu", "[", 
    RowBox[{"\"\<Set x\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<x = 1\>\"", "\[RuleDelayed]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "=", "1"}], ";"}], ")"}]}], ",", 
       RowBox[{"\"\<x = 2\>\"", "\[RuleDelayed]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "=", "2"}], ";"}], ")"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41628265],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[
    Dynamic[{"ActionMenu", Automatic}, 
     Part[{"x = 1" :> ($CellContext`x = 1; Null), 
       "x = 2" :> ($CellContext`x = 2; Null)}, #, 2]& , Evaluator -> 
     Automatic], {1->"\<\"x = 1\"\>", 2->"\<\"x = 2\"\>"}, "\<\"Set x\"\>",
    Appearance->"ActionMenu",
    Background->Automatic,
    ImageSize->Automatic,
    MenuAppearance->"Menu"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{96, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171338734]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->524609274],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Delimiter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Delimiter"]], "InlineFormula"],
 " to separate menu items:"
}], "ExampleText",
 CellID->548636552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ActionMenu", "[", 
    RowBox[{"\"\<Set x\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<x = 1\>\"", "\[RuleDelayed]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "=", "1"}], ";"}], ")"}]}], ",", "Delimiter", ",", 
       RowBox[{"\"\<x = 2\>\"", "\[RuleDelayed]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "=", "2"}], ";"}], ")"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->666047010],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[
    Dynamic[{"ActionMenu", Automatic}, 
     Part[{"x = 1" :> ($CellContext`x = 1; Null), Delimiter, 
       "x = 2" :> ($CellContext`x = 2; Null)}, #, 2]& , Evaluator -> 
     Automatic], {1->"\<\"x = 1\"\>", Delimiter, 
    3->"\<\"x = 2\"\>"}, "\<\"Set x\"\>",
    Appearance->"ActionMenu",
    Background->Automatic,
    ImageSize->Automatic,
    MenuAppearance->"Menu"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{96, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442436456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->799224616],

Cell["The labels can be any expression:", "ExampleText",
 CellID->28511550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ActionMenu", "[", 
    RowBox[{"\"\<Set x\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"Disk", "[", "]"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}], "\[RuleDelayed]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "=", "1"}], ";"}], ")"}]}], ",", "Delimiter", ",", 
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}], "^", "4"}], "]"}], 
        "\[RuleDelayed]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "=", "2"}], ";"}], ")"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->507103776],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{Graphics[
         Disk[{0, 0}], ImageSize -> 20] :> ($CellContext`x = 1; Null), 
       Delimiter, $CellContext`a^4 + (4 $CellContext`a^3) $CellContext`b + (
          6 $CellContext`a^2) $CellContext`b^2 + (
          4 $CellContext`a) $CellContext`b^3 + $CellContext`b^4 :> \
($CellContext`x = 2; Null)}, #, 2]& , Evaluator -> Automatic], {1->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->20], Delimiter, 3->
    RowBox[{
     SuperscriptBox["a", "4"], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "3"], " ", "b"}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "+", 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "3"]}], "+", 
     SuperscriptBox["b", "4"]}]}, "\<\"Set x\"\>",
    Appearance->"ActionMenu",
    Background->Automatic,
    ImageSize->Automatic,
    MenuAppearance->"Menu"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{96, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32217517]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->580259199],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->48850658],

Cell["Use different display appearances for the menu:", "ExampleText",
 CellID->40110156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ActionMenu", "[", 
    RowBox[{"\"\<Factorials\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<4!\>\"", "\[RuleDelayed]", 
        RowBox[{"Print", "[", 
         RowBox[{"4", "!"}], "]"}]}], ",", 
       RowBox[{"\"\<7!\>\"", "\[RuleDelayed]", 
        RowBox[{"Print", "[", 
         RowBox[{"7", "!"}], "]"}]}], ",", 
       RowBox[{"\"\<10!\>\"", "\[RuleDelayed]", 
        RowBox[{"Print", "[", 
         RowBox[{"10", "!"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "None", ",", "Automatic", ",", "\"\<PopupMenu\>\"", ",", 
       "\"\<Button\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47702686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Dynamic[{"ActionMenu", None}, Part[{"4!" :> Print[
         Factorial[4]], "7!" :> Print[
         Factorial[7]], "10!" :> Print[
         Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
    2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>", 
    StyleBox["\<\"Factorials\"\>",
     Background->Automatic],
    Appearance->Automatic,
    ImageSize->Automatic,
    MenuAppearance->"Menu"], ",", 
   PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
         Factorial[4]], "7!" :> Print[
         Factorial[7]], "10!" :> Print[
         Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
    2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
    Appearance->"ActionMenu",
    Background->Automatic,
    ImageSize->Automatic,
    MenuAppearance->"Menu"], ",", 
   PopupMenuBox[Dynamic[{"ActionMenu", "PopupMenu"}, Part[{"4!" :> Print[
         Factorial[4]], "7!" :> Print[
         Factorial[7]], "10!" :> Print[
         Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
    2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
    Appearance->"Popup",
    Background->Automatic,
    ImageSize->Automatic,
    MenuAppearance->"Menu"], ",", 
   PopupMenuBox[Dynamic[{"ActionMenu", "Button"}, Part[{"4!" :> Print[
         Factorial[4]], "7!" :> Print[
         Factorial[7]], "10!" :> Print[
         Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
    2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>", 
    ButtonBox["\<\"Factorials\"\>",
     Appearance->Automatic,
     Background->Automatic,
     ButtonData->"paclet:ref/Factorials",
     ButtonFrame->"DialogBox",
     Evaluator->Automatic,
     Method->"Preemptive"],
    Appearance->Automatic,
    ImageSize->Automatic,
    MenuAppearance->"Menu"]}], "}"}]], "Output",
 ImageSize->{310, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183824851]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->143699387],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["ActionMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ActionMenu"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionMenu", "[", 
  RowBox[{"\"\<Factorials\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<4!\>\"", "\[RuleDelayed]", 
      RowBox[{"Print", "[", 
       RowBox[{"4", "!"}], "]"}]}], ",", 
     RowBox[{"\"\<7!\>\"", "\[RuleDelayed]", 
      RowBox[{"Print", "[", 
       RowBox[{"7", "!"}], "]"}]}], ",", 
     RowBox[{"\"\<10!\>\"", "\[RuleDelayed]", 
      RowBox[{"Print", "[", 
       RowBox[{"10", "!"}], "]"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->982957658],

Cell[BoxData[
 PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
       Factorial[4]], "7!" :> Print[
       Factorial[7]], "10!" :> Print[
       Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
  2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
  Appearance->"ActionMenu",
  Background->Automatic,
  ImageSize->Automatic,
  MenuAppearance->"Menu"]], "Output",
 ImageSize->{84, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->405520304]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->232886807],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the menu is disabled:"
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionMenu", "[", 
  RowBox[{"\"\<Factorials\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<4!\>\"", "\[RuleDelayed]", 
      RowBox[{"Print", "[", 
       RowBox[{"4", "!"}], "]"}]}], ",", 
     RowBox[{"\"\<7!\>\"", "\[RuleDelayed]", 
      RowBox[{"Print", "[", 
       RowBox[{"7", "!"}], "]"}]}], ",", 
     RowBox[{"\"\<10!\>\"", "\[RuleDelayed]", 
      RowBox[{"Print", "[", 
       RowBox[{"10", "!"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288335823],

Cell[BoxData[
 PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
       Factorial[4]], "7!" :> Print[
       Factorial[7]], "10!" :> Print[
       Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
  2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
  Appearance->"ActionMenu",
  Background->Automatic,
  Enabled->False,
  ImageSize->Automatic,
  MenuAppearance->"Menu"]], "Output",
 ImageSize->{84, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328741501]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Evaluator",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->63466735],

Cell["\<\
By default the button function is sent to the kernel for evaluation:\
\>", "ExampleText",
 CellID->96906759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionMenu", "[", 
  RowBox[{"\"\<Kernel\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<Brace\>\"", "\[RuleDelayed]", 
      RowBox[{"SelectionMove", "[", 
       RowBox[{
        RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", "ButtonCell"}],
        "]"}]}], ",", 
     RowBox[{"\"\<Group\>\"", "\[RuleDelayed]", 
      RowBox[{"SelectionMove", "[", 
       RowBox[{
        RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", "CellGroup"}], 
       "]"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->528731854],

Cell[BoxData[
 PopupMenuBox[
  Dynamic[{"ActionMenu", Automatic}, Part[{"Brace" :> SelectionMove[
       ButtonNotebook[], All, ButtonCell], "Group" :> SelectionMove[
       ButtonNotebook[], All, CellGroup]}, #, 2]& , Evaluator -> Automatic], {
  1->"\<\"Brace\"\>", 2->"\<\"Group\"\>"}, "\<\"Kernel\"\>",
  Appearance->"ActionMenu",
  Background->Automatic,
  ImageSize->Automatic,
  MenuAppearance->"Menu"]], "Output",
 ImageSize->{68, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169272835]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138017001],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["Evaluator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluator"]], "InlineFormula"],
 ", the button function is evaluated in the front end:"
}], "ExampleText",
 CellID->1578363691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionMenu", "[", 
  RowBox[{"\"\<Front End\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<Brace\>\"", "\[RuleDelayed]", 
      RowBox[{"SelectionMove", "[", 
       RowBox[{
        RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", "ButtonCell"}],
        "]"}]}], ",", 
     RowBox[{"\"\<Group\>\"", "\[RuleDelayed]", 
      RowBox[{"SelectionMove", "[", 
       RowBox[{
        RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", "CellGroup"}], 
       "]"}]}]}], "}"}], ",", 
   RowBox[{"Evaluator", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->887974882],

Cell[BoxData[
 PopupMenuBox[
  Dynamic[{"ActionMenu", Automatic}, Part[{"Brace" :> SelectionMove[
       ButtonNotebook[], All, ButtonCell], "Group" :> SelectionMove[
       ButtonNotebook[], All, CellGroup]}, #, 2]& , Evaluator -> None], {
  1->"\<\"Brace\"\>", 2->"\<\"Group\"\>"}, "\<\"Front End\"\>",
  Appearance->"ActionMenu",
  Background->Automatic,
  ImageSize->Automatic,
  MenuAppearance->"Menu"]], "Output",
 ImageSize->{85, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->920183]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FieldSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->295384684],

Cell["Change the field size:", "ExampleText",
 CellID->315587762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ActionMenu", "[", 
    RowBox[{"\"\<Factorials\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<4!\>\"", "\[RuleDelayed]", 
        RowBox[{"Print", "[", 
         RowBox[{"4", "!"}], "]"}]}], ",", 
       RowBox[{"\"\<7!\>\"", "\[RuleDelayed]", 
        RowBox[{"Print", "[", 
         RowBox[{"7", "!"}], "]"}]}], ",", 
       RowBox[{"\"\<10!\>\"", "\[RuleDelayed]", 
        RowBox[{"Print", "[", 
         RowBox[{"10", "!"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"FieldSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90514679],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
         Factorial[4]], "7!" :> Print[
         Factorial[7]], "10!" :> Print[
         Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
    2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
    Appearance->"ActionMenu",
    Background->Automatic,
    FieldSize->5,
    ImageSize->Automatic,
    MenuAppearance->"Menu"], ",", 
   PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
         Factorial[4]], "7!" :> Print[
         Factorial[7]], "10!" :> Print[
         Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
    2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
    Appearance->"ActionMenu",
    Background->Automatic,
    FieldSize->10,
    ImageSize->Automatic,
    MenuAppearance->"Menu"], ",", 
   PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
         Factorial[4]], "7!" :> Print[
         Factorial[7]], "10!" :> Print[
         Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
    2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
    Appearance->"ActionMenu",
    Background->Automatic,
    FieldSize->20,
    ImageSize->Automatic,
    MenuAppearance->"Menu"]}], "}"}]], "Output",
 ImageSize->{423, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->749298314]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26332616],

Cell["Add margins within the menu:", "ExampleText",
 CellID->223866528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ActionMenu", "[", 
    RowBox[{"\"\<Factorials\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<4!\>\"", "\[RuleDelayed]", 
        RowBox[{"Print", "[", 
         RowBox[{"4", "!"}], "]"}]}], ",", 
       RowBox[{"\"\<7!\>\"", "\[RuleDelayed]", 
        RowBox[{"Print", "[", 
         RowBox[{"7", "!"}], "]"}]}], ",", 
       RowBox[{"\"\<10!\>\"", "\[RuleDelayed]", 
        RowBox[{"Print", "[", 
         RowBox[{"10", "!"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72593874],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
         Factorial[4]], "7!" :> Print[
         Factorial[7]], "10!" :> Print[
         Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
    2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
    Appearance->"ActionMenu",
    Background->Automatic,
    FrameMargins->0,
    ImageSize->Automatic,
    MenuAppearance->"Menu"], ",", 
   PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
         Factorial[4]], "7!" :> Print[
         Factorial[7]], "10!" :> Print[
         Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
    2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
    Appearance->"ActionMenu",
    Background->Automatic,
    FrameMargins->5,
    ImageSize->Automatic,
    MenuAppearance->"Menu"], ",", 
   PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
         Factorial[4]], "7!" :> Print[
         Factorial[7]], "10!" :> Print[
         Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>", 
    2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
    Appearance->"ActionMenu",
    Background->Automatic,
    FrameMargins->10,
    ImageSize->Automatic,
    MenuAppearance->"Menu"]}], "}"}]], "Output",
 ImageSize->{311, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4092047]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->431449172],

Cell["Add margins outside the menu:", "ExampleText",
 CellID->231230235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"ActionMenu", "[", 
     RowBox[{"\"\<Factorials\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<4!\>\"", "\[RuleDelayed]", 
         RowBox[{"Print", "[", 
          RowBox[{"4", "!"}], "]"}]}], ",", 
        RowBox[{"\"\<7!\>\"", "\[RuleDelayed]", 
         RowBox[{"Print", "[", 
          RowBox[{"7", "!"}], "]"}]}], ",", 
        RowBox[{"\"\<10!\>\"", "\[RuleDelayed]", 
         RowBox[{"Print", "[", 
          RowBox[{"10", "!"}], "]"}]}]}], "}"}], ",", 
      RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132793213],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
          Factorial[4]], "7!" :> Print[
          Factorial[7]], "10!" :> Print[
          Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>",
      2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
     Appearance->"ActionMenu",
     Background->Automatic,
     ImageMargins->0,
     ImageSize->Automatic,
     MenuAppearance->"Menu"],
    StripOnInput->False], ",", 
   FrameBox[
    PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
          Factorial[4]], "7!" :> Print[
          Factorial[7]], "10!" :> Print[
          Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>",
      2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
     Appearance->"ActionMenu",
     Background->Automatic,
     ImageMargins->5,
     ImageSize->Automatic,
     MenuAppearance->"Menu"],
    StripOnInput->False], ",", 
   FrameBox[
    PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
          Factorial[4]], "7!" :> Print[
          Factorial[7]], "10!" :> Print[
          Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {1->"\<\"4!\"\>",
      2->"\<\"7!\"\>", 3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
     Appearance->"ActionMenu",
     Background->Automatic,
     ImageMargins->10,
     ImageSize->Automatic,
     MenuAppearance->"Menu"],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{341, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10653136]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->136322937],

Cell["Specify the overall image size:", "ExampleText",
 CellID->334184626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ActionMenu", "[", 
     RowBox[{"\"\<Factorials\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<4!\>\"", "\[RuleDelayed]", 
         RowBox[{"Print", "[", 
          RowBox[{"4", "!"}], "]"}]}], ",", 
        RowBox[{"\"\<7!\>\"", "\[RuleDelayed]", 
         RowBox[{"Print", "[", 
          RowBox[{"7", "!"}], "]"}]}], ",", 
        RowBox[{"\"\<10!\>\"", "\[RuleDelayed]", 
         RowBox[{"Print", "[", 
          RowBox[{"10", "!"}], "]"}]}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "30", ",", "50"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "100", ",", "200"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113778332],

Cell[BoxData[
 TagBox[GridBox[{
    {
     PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
           Factorial[4]], "7!" :> Print[
           Factorial[7]], "10!" :> Print[
           Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"4!\"\>", 2->"\<\"7!\"\>", 
      3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
      Appearance->"ActionMenu",
      Background->Automatic,
      ImageSize->{50, 20},
      MenuAppearance->"Menu"], 
     PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
           Factorial[4]], "7!" :> Print[
           Factorial[7]], "10!" :> Print[
           Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"4!\"\>", 2->"\<\"7!\"\>", 
      3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
      Appearance->"ActionMenu",
      Background->Automatic,
      ImageSize->{100, 20},
      MenuAppearance->"Menu"], 
     PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
           Factorial[4]], "7!" :> Print[
           Factorial[7]], "10!" :> Print[
           Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"4!\"\>", 2->"\<\"7!\"\>", 
      3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
      Appearance->"ActionMenu",
      Background->Automatic,
      ImageSize->{200, 20},
      MenuAppearance->"Menu"]},
    {
     PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
           Factorial[4]], "7!" :> Print[
           Factorial[7]], "10!" :> Print[
           Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"4!\"\>", 2->"\<\"7!\"\>", 
      3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
      Appearance->"ActionMenu",
      Background->Automatic,
      ImageSize->{50, 30},
      MenuAppearance->"Menu"], 
     PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
           Factorial[4]], "7!" :> Print[
           Factorial[7]], "10!" :> Print[
           Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"4!\"\>", 2->"\<\"7!\"\>", 
      3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
      Appearance->"ActionMenu",
      Background->Automatic,
      ImageSize->{100, 30},
      MenuAppearance->"Menu"], 
     PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
           Factorial[4]], "7!" :> Print[
           Factorial[7]], "10!" :> Print[
           Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"4!\"\>", 2->"\<\"7!\"\>", 
      3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
      Appearance->"ActionMenu",
      Background->Automatic,
      ImageSize->{200, 30},
      MenuAppearance->"Menu"]},
    {
     PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
           Factorial[4]], "7!" :> Print[
           Factorial[7]], "10!" :> Print[
           Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"4!\"\>", 2->"\<\"7!\"\>", 
      3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
      Appearance->"ActionMenu",
      Background->Automatic,
      ImageSize->{50, 50},
      MenuAppearance->"Menu"], 
     PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
           Factorial[4]], "7!" :> Print[
           Factorial[7]], "10!" :> Print[
           Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"4!\"\>", 2->"\<\"7!\"\>", 
      3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
      Appearance->"ActionMenu",
      Background->Automatic,
      ImageSize->{100, 50},
      MenuAppearance->"Menu"], 
     PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{"4!" :> Print[
           Factorial[4]], "7!" :> Print[
           Factorial[7]], "10!" :> Print[
           Factorial[10]]}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"4!\"\>", 2->"\<\"7!\"\>", 
      3->"\<\"10!\"\>"}, "\<\"Factorials\"\>",
      Appearance->"ActionMenu",
      Background->Automatic,
      ImageSize->{200, 50},
      MenuAppearance->"Menu"]}
   }],
  "Grid"]], "Output",
 ImageSize->{370, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168130352]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->169130843],

Cell["Choose between various graphics objects:", "ExampleText",
 CellID->59152949],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"g1", ",", "g2", ",", "g3", ",", "g4"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Disk", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Rectangle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->456496182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", 
     RowBox[{"{", "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ActionMenu", "[", 
      RowBox[{"\"\<Graphics\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"g1", "\[RuleDelayed]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", "=", 
             RowBox[{"Disk", "[", "]"}]}], ";"}], ")"}]}], ",", 
         RowBox[{"g2", "\[RuleDelayed]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", "=", 
             RowBox[{"Circle", "[", "]"}]}], ";"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"g3", "\[RuleDelayed]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", "=", 
             RowBox[{"Rectangle", "[", "]"}]}], ";"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"g4", "\[RuleDelayed]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", "=", 
             RowBox[{"Polygon", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}]}], "}"}], "]"}]}], 
            ";"}], ")"}]}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Pink", ",", "x"}], "}"}], "]"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->311345451],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = Circle[{0, 0}]}, 
  RowBox[{"{", 
   RowBox[{
    PopupMenuBox[Dynamic[{"ActionMenu", Automatic}, Part[{Graphics[
          Disk[{0, 0}], ImageSize -> 20] :> ($CellContext`x$$ = Disk[]; Null),
         Graphics[
          Circle[{0, 0}], ImageSize -> 20] :> ($CellContext`x$$ = Circle[]; 
         Null), Graphics[
          Rectangle[{0, 0}], ImageSize -> 20] :> ($CellContext`x$$ = 
          Rectangle[]; Null), Graphics[
          Polygon[{{-1, 0}, {1, 0}, {0, 3^Rational[1, 2]}}], ImageSize -> 
          20] :> ($CellContext`x$$ = Polygon[{{-1, 0}, {1, 0}, {0, 
              Sqrt[3]}}]; Null)}, #, 2]& , Evaluator -> Automatic], {1->
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->20], 2->
     GraphicsBox[CircleBox[{0, 0}],
      ImageSize->20], 3->
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->20], 4->
     GraphicsBox[
      PolygonBox[
       NCache[{{-1, 0}, {1, 0}, {0, 3^Rational[1, 2]}}, {{-1, 0}, {1, 0}, {
         0, 1.7320508075688772`}}]],
      ImageSize->20]}, "\<\"Graphics\"\>",
     Appearance->"ActionMenu",
     Background->Automatic,
     ImageSize->Automatic,
     MenuAppearance->"Menu"], ",", 
    DynamicBox[ToBoxes[
      Graphics[{Pink, $CellContext`x$$}], StandardForm],
     ImageSizeCache->{180., {88., 92.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{285, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1122783350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->526716479],

Cell["Control the range of a graphic:", "ExampleText",
 CellID->339295457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"range", "=", "1"}], "}"}], ",", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ActionMenu", "[", 
       RowBox[{"\"\<Zoom\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<In\>\"", "\[RuleDelayed]", 
           RowBox[{"(", 
            RowBox[{"range", "=", 
             RowBox[{"range", " ", 
              RowBox[{"3", "/", "4"}]}]}], ")"}]}], ",", 
          RowBox[{"\"\<Out\>\"", "\[RuleDelayed]", 
           RowBox[{"(", 
            RowBox[{"range", "=", 
             RowBox[{"range", " ", 
              RowBox[{"4", "/", "3"}]}]}], ")"}]}], ",", 
          RowBox[{"\"\<Reset\>\"", "\[RuleDelayed]", 
           RowBox[{"(", 
            RowBox[{"range", "=", "1"}], ")"}]}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Circle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", "#"}], "]"}], "&"}], "/@", 
          
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "5"}], ",", 
            RowBox[{"1", "/", "2"}], ",", "1", ",", "5", ",", "10"}], "}"}]}],
          "}"}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"Dynamic", "[", "range", "]"}]}]}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->680957261],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`range$$ = 1}, 
  TagBox[GridBox[{
     {
      PopupMenuBox[
       Dynamic[{"ActionMenu", Automatic}, 
        Part[{"In" :> ($CellContext`range$$ = $CellContext`range$$ (3/4)), 
          "Out" :> ($CellContext`range$$ = $CellContext`range$$ (4/3)), 
          "Reset" :> ($CellContext`range$$ = 1)}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"In\"\>", 2->"\<\"Out\"\>", 
       3->"\<\"Reset\"\>"}, "\<\"Zoom\"\>",
       Appearance->"ActionMenu",
       Background->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]},
     {
      GraphicsBox[{CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2]], 
        CircleBox[{0, 0}, NCache[Rational[1, 2], 0.5]], CircleBox[{0, 0}], 
        CircleBox[{0, 0}, 5], CircleBox[{0, 0}, 10]},
       Axes->True,
       PlotRange->Dynamic[$CellContext`range$$]]}
    },
    ColumnsEqual->False,
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    RowsEqual->False],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{184, 205},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->484254054]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->452012988],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ActionMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ActionMenu"]], "InlineFormula"],
 " has the same effect as a ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 " series:"
}], "ExampleText",
 CellID->485676014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ActionMenu", "[", 
    RowBox[{"\"\<Set x\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<x = 1\>\"", "\[RuleDelayed]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "=", "1"}], ";"}], ")"}]}], ",", 
       RowBox[{"\"\<x = 2\>\"", "\[RuleDelayed]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "=", "2"}], ";"}], ")"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522989548],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[
    Dynamic[{"ActionMenu", Automatic}, 
     Part[{"x = 1" :> ($CellContext`x = 1; Null), 
       "x = 2" :> ($CellContext`x = 2; Null)}, #, 2]& , Evaluator -> 
     Automatic], {1->"\<\"x = 1\"\>", 2->"\<\"x = 2\"\>"}, "\<\"Set x\"\>",
    Appearance->"ActionMenu",
    Background->Automatic,
    ImageSize->Automatic,
    MenuAppearance->"Menu"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{96, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156248347]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Button", "[", 
    RowBox[{"\"\<y = 1\>\"", ",", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"y", "=", "1"}], ";"}], ")"}]}], "]"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<y = 2\>\"", ",", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"y", "=", "2"}], ";"}], ")"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47433638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"y = 1\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/y = 1",
    ButtonFrame->"DialogBox",
    ButtonFunction:>($CellContext`y = 1; Null),
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"y = 2\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/y = 2",
    ButtonFrame->"DialogBox",
    ButtonFunction:>($CellContext`y = 2; Null),
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{7., {2., 6.}}]}], "}"}]], "Output",
 ImageSize->{118, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->389723571]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26809],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupMenu"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DockedCells",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DockedCells"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4084]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1012],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->187478014],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->418667540],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->560515950],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->273727181],

Cell[TextData[ButtonBox["Toolbars",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Toolbars"]], "MoreAbout",
 CellID->126939218],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->1023236057]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ActionMenu - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 30.7353858}", "context" -> "System`", 
    "keywords" -> {
     "menu bar", "menu", "popup menu", "button menu", "event menu", 
      "button list"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ActionMenu[name, {lbl_1 :> act_1, lbl_2 :> act_2, ...}] represents an \
action menu with label name, and with items labeled lbl_i, that evaluates the \
expression act_i if the corresponding item is chosen.", 
    "synonyms" -> {"action menu"}, "title" -> "ActionMenu", "type" -> 
    "Symbol", "uri" -> "ref/ActionMenu"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12850, 388, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->358302238]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 58684, 1863}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2714, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3337, 89, 1575, 37, 70, "ObjectNameGrid"],
Cell[4915, 128, 1475, 46, 70, "Usage",
 CellID->32745]
}, Open  ]],
Cell[CellGroupData[{
Cell[6427, 179, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6905, 196, 248, 10, 70, "Notes",
 CellID->31762],
Cell[7156, 208, 488, 17, 70, "Notes",
 CellID->28423],
Cell[7647, 227, 562, 20, 70, "Notes",
 CellID->27531],
Cell[8212, 249, 68, 1, 70, "Notes",
 CellID->9318],
Cell[8283, 252, 2877, 79, 70, "3ColumnTableMod",
 CellID->5602],
Cell[11163, 333, 208, 8, 70, "Notes",
 CellID->31907],
Cell[11374, 343, 1089, 28, 70, "2ColumnTableMod",
 CellID->24307],
Cell[12466, 373, 347, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[12850, 388, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->358302238],
Cell[CellGroupData[{
Cell[13235, 402, 148, 5, 70, "ExampleSection",
 CellID->327989428],
Cell[13386, 409, 113, 3, 70, "ExampleText",
 CellID->317929816],
Cell[CellGroupData[{
Cell[13524, 416, 534, 15, 47, "Input",
 CellID->325309079],
Cell[14061, 433, 547, 14, 44, "Output",
 CellID->538141336]
}, Open  ]],
Cell[14623, 450, 125, 3, 70, "ExampleDelimiter",
 CellID->370479120],
Cell[14751, 455, 117, 3, 70, "ExampleText",
 CellID->1992641483],
Cell[CellGroupData[{
Cell[14893, 462, 553, 17, 70, "Input",
 CellID->41628265],
Cell[15449, 481, 651, 18, 70, "Output",
 CellID->171338734]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16149, 505, 220, 7, 70, "ExampleSection",
 CellID->524609274],
Cell[16372, 514, 212, 8, 70, "ExampleText",
 CellID->548636552],
Cell[CellGroupData[{
Cell[16609, 526, 572, 17, 70, "Input",
 CellID->666047010],
Cell[17184, 545, 678, 19, 70, "Output",
 CellID->442436456]
}, Open  ]],
Cell[17877, 567, 125, 3, 70, "ExampleDelimiter",
 CellID->799224616],
Cell[18005, 572, 75, 1, 70, "ExampleText",
 CellID->28511550],
Cell[CellGroupData[{
Cell[18105, 577, 840, 26, 70, "Input",
 CellID->507103776],
Cell[18948, 605, 1220, 31, 70, "Output",
 CellID->32217517]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20217, 642, 222, 7, 70, "ExampleSection",
 CellID->580259199],
Cell[CellGroupData[{
Cell[20464, 653, 230, 7, 70, "ExampleSubsection",
 CellID->48850658],
Cell[20697, 662, 89, 1, 70, "ExampleText",
 CellID->40110156],
Cell[CellGroupData[{
Cell[20811, 667, 835, 24, 70, "Input",
 CellID->47702686],
Cell[21649, 693, 2041, 50, 70, "Output",
 CellID->183824851]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23739, 749, 228, 7, 70, "ExampleSubsection",
 CellID->143699387],
Cell[23970, 758, 210, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[24205, 770, 528, 15, 70, "Input",
 CellID->982957658],
Cell[24736, 787, 540, 14, 70, "Output",
 CellID->405520304]
}, Open  ]],
Cell[25291, 804, 125, 3, 70, "ExampleDelimiter",
 CellID->232886807],
Cell[25419, 809, 319, 12, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[25763, 825, 578, 16, 70, "Input",
 CellID->288335823],
Cell[26344, 843, 558, 15, 70, "Output",
 CellID->328741501]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26951, 864, 229, 7, 70, "ExampleSubsection",
 CellID->63466735],
Cell[27183, 873, 118, 3, 70, "ExampleText",
 CellID->96906759],
Cell[CellGroupData[{
Cell[27326, 880, 578, 16, 70, "Input",
 CellID->528731854],
Cell[27907, 898, 551, 14, 70, "Output",
 CellID->169272835]
}, Open  ]],
Cell[28473, 915, 125, 3, 70, "ExampleDelimiter",
 CellID->138017001],
Cell[28601, 920, 248, 8, 70, "ExampleText",
 CellID->1578363691],
Cell[CellGroupData[{
Cell[28874, 932, 632, 17, 70, "Input",
 CellID->887974882],
Cell[29509, 951, 546, 14, 70, "Output",
 CellID->920183]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30104, 971, 230, 7, 70, "ExampleSubsection",
 CellID->295384684],
Cell[30337, 980, 65, 1, 70, "ExampleText",
 CellID->315587762],
Cell[CellGroupData[{
Cell[30427, 985, 771, 22, 70, "Input",
 CellID->90514679],
Cell[31201, 1009, 1470, 37, 70, "Output",
 CellID->749298314]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32720, 1052, 232, 7, 70, "ExampleSubsection",
 CellID->26332616],
Cell[32955, 1061, 71, 1, 70, "ExampleText",
 CellID->223866528],
Cell[CellGroupData[{
Cell[33051, 1066, 773, 22, 70, "Input",
 CellID->72593874],
Cell[33827, 1090, 1476, 37, 70, "Output",
 CellID->4092047]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35352, 1133, 233, 7, 70, "ExampleSubsection",
 CellID->431449172],
Cell[35588, 1142, 72, 1, 70, "ExampleText",
 CellID->231230235],
Cell[CellGroupData[{
Cell[35685, 1147, 822, 23, 70, "Input",
 CellID->132793213],
Cell[36510, 1172, 1624, 43, 70, "Output",
 CellID->10653136]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38183, 1221, 230, 7, 70, "ExampleSubsection",
 CellID->136322937],
Cell[38416, 1230, 74, 1, 70, "ExampleText",
 CellID->334184626],
Cell[CellGroupData[{
Cell[38515, 1235, 1014, 30, 70, "Input",
 CellID->113778332],
Cell[39532, 1267, 4076, 101, 70, "Output",
 CellID->168130352]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[43669, 1375, 227, 7, 70, "ExampleSection",
 CellID->169130843],
Cell[43899, 1384, 82, 1, 70, "ExampleText",
 CellID->59152949],
Cell[43984, 1387, 1153, 35, 70, "Input",
 CellID->456496182],
Cell[CellGroupData[{
Cell[45162, 1426, 1741, 51, 70, "Input",
 CellID->311345451],
Cell[46906, 1479, 1497, 37, 70, "Output",
 CellID->1122783350]
}, Open  ]],
Cell[48418, 1519, 125, 3, 70, "ExampleDelimiter",
 CellID->526716479],
Cell[48546, 1524, 74, 1, 70, "ExampleText",
 CellID->339295457],
Cell[CellGroupData[{
Cell[48645, 1529, 1555, 45, 70, "Input",
 CellID->680957261],
Cell[50203, 1576, 1234, 32, 70, "Output",
 CellID->484254054]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51486, 1614, 237, 7, 70, "ExampleSection",
 CellID->452012988],
Cell[51726, 1623, 335, 12, 70, "ExampleText",
 CellID->485676014],
Cell[CellGroupData[{
Cell[52086, 1639, 554, 17, 70, "Input",
 CellID->522989548],
Cell[52643, 1658, 651, 18, 70, "Output",
 CellID->156248347]
}, Open  ]],
Cell[CellGroupData[{
Cell[53331, 1681, 453, 15, 70, "Input",
 CellID->47433638],
Cell[53787, 1698, 740, 23, 70, "Output",
 CellID->389723571]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54588, 1728, 311, 9, 70, "SeeAlsoSection",
 CellID->26809],
Cell[54902, 1739, 699, 26, 70, "SeeAlso",
 CellID->4084]
}, Open  ]],
Cell[CellGroupData[{
Cell[55638, 1770, 313, 9, 70, "TutorialsSection",
 CellID->1012],
Cell[55954, 1781, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[56116, 1786, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[56301, 1794, 319, 9, 70, "MoreAboutSection",
 CellID->187478014],
Cell[56623, 1805, 141, 3, 70, "MoreAbout",
 CellID->418667540],
Cell[56767, 1810, 168, 3, 70, "MoreAbout",
 CellID->560515950],
Cell[56938, 1815, 154, 3, 70, "MoreAbout",
 CellID->273727181],
Cell[57095, 1820, 128, 3, 70, "MoreAbout",
 CellID->126939218],
Cell[57226, 1825, 173, 3, 70, "MoreAbout",
 CellID->1023236057]
}, Open  ]],
Cell[57414, 1831, 27, 0, 70, "History"],
Cell[57444, 1833, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

