(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23261,        925]
NotebookOptionsPosition[     17151,        707]
NotebookOutlinePosition[     18416,        744]
CellTagsIndexPosition[     18331,        739]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Forms of Assignment" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialFormsOfAssignment"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Special Forms of Assignment\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Increment" :> Documentation`HelpLookup["paclet:ref/Increment"],
           "PreIncrement" :> 
          Documentation`HelpLookup["paclet:ref/PreIncrement"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"], "PrependTo" :> 
          Documentation`HelpLookup["paclet:ref/PrependTo"], "Plus" :> 
          Documentation`HelpLookup["paclet:ref/Plus"], "TimesBy" :> 
          Documentation`HelpLookup["paclet:ref/TimesBy"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Increment\"\>", 2->"\<\"PreIncrement\"\>", 
       3->"\<\"Set\"\>", 4->"\<\"PrependTo\"\>", 5->"\<\"Plus\"\>", 
       6->"\<\"TimesBy\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "AddTo ",
 StyleBox["(+=)", "OperatorCharacter"]
}], "ObjectName",
 CellID->9762],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "+=", 
       StyleBox["dx", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]adds ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and returns the new value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5967]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AddTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AddTo"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24408],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "+=", 
   StyleBox["dx", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   RowBox[{
    StyleBox["x", "TI"], "+", 
    StyleBox["dx", "TI"]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4415]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->450296902],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->346051095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", "1"}], ";", 
  RowBox[{"k", "+=", "5"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->501313468],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95770673]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["k"], "Input",
 CellLabel->"In[2]:=",
 CellID->230791865],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->628428876]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8166],

Cell["Add to a numerical value:", "ExampleText",
 CellID->1113876286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "1.5"}], ";", " ", 
  RowBox[{"x", "+=", "3.75"}], ";", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1774324750],

Cell[BoxData["5.25`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->119070060]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206580424],

Cell["Add to a symbolic value:", "ExampleText",
 CellID->838884225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", "a"}], ";", 
  RowBox[{"v", "+=", "b"}], ";", "v"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1698859122],

Cell[BoxData[
 RowBox[{"a", "+", "b"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170074584]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2063940682],

Cell["Add to all values in a list:", "ExampleText",
 CellID->822015323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2332824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352245540]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+=", "17"}], ";", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1729906436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"18", ",", "19", ",", "20"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161461597]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+=", 
   RowBox[{"{", 
    RowBox[{"20", ",", "21", ",", "22"}], "}"}]}], ";", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->628970065],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"38", ",", "40", ",", "42"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8406846]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17692],

Cell["Find the first prime above one million:", "ExampleText",
 CellID->2078680352],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{
    RowBox[{"10", "^", "6"}], "-", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"PrimeQ", "[", "i", "]"}]}], ",", 
    RowBox[{"i", "+=", "2"}]}], "]"}], ";"}], "\n", "i"}], "Input",
 CellLabel->"In[1]:=",
 CellID->84768696],

Cell[BoxData["1000003"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->800004185]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21787],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AddTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AddTo"]], "InlineFormula"],
 " is a short form of this assignment:"
}], "ExampleText",
 CellID->2065810971],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"k", "=", 
  RowBox[{"k", "+", "5"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1887499219],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1736880614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->607562233],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PreIncrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreIncrement"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["AddTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AddTo"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1728269985],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"k", "+=", "1"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->683214900],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191200413]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"++", "k"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->304619170],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->259023431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160021160],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SubtractFrom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubtractFrom"]], "InlineFormula"],
 " is closely related:"
}], "ExampleText",
 CellID->650476513],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"k", "+=", 
  RowBox[{"-", "5"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->169527740],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77640076]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "-=", "5"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->452459319],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4116872]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->85252602],

Cell[TextData[{
 "A related operation for lists is ",
 Cell[BoxData[
  ButtonBox["AppendTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppendTo"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->208286109],

Cell[BoxData[
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1246355825],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"list", ",", "4"}], "]"}], ";"}], "\n", "list"}], "Input",
 CellLabel->"In[2]:=",
 CellID->1899364858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->269621667]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28532],

Cell["A variable to be incremented must have an initial value:", "ExampleText",
 CellID->992262862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "+=", "2"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1397421414],

Cell[BoxData[
 RowBox[{
  RowBox[{"AddTo", "::", "\<\"rvalue\"\>"}], ":", 
  " ", "\<\"\\!\\(x\\) is not a variable with a value, so its value cannot be \
changed.\"\>"}]], "Message", "MSG",
 CellID->433084485],

Cell[BoxData[
 RowBox[{"x", "+=", "2"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->477662969]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5204],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Increment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Increment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PreIncrement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PreIncrement"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrependTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrependTo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimesBy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimesBy"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29486]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1908],

Cell[TextData[ButtonBox["Special Forms of Assignment",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFormsOfAssignment"]], "Tutorials",
 CellID->17223]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->73193373],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->679482790]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AddTo (+=) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 31.9072908}", "context" -> "System`", 
    "keywords" -> {
     "add to value", "increase by", "increment a list", "increment value"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "x += dx adds dx to x and returns the new value of x. ", 
    "synonyms" -> {"add to", "+="}, "title" -> "AddTo", "type" -> "Symbol", 
    "uri" -> "ref/AddTo"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4793, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->450296902]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18188, 732}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2253, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2876, 80, 98, 4, 70, "ObjectName",
 CellID->9762],
Cell[2977, 86, 630, 22, 70, "Usage",
 CellID->5967]
}, Open  ]],
Cell[CellGroupData[{
Cell[3644, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4122, 130, 308, 12, 70, "Notes",
 CellID->24408],
Cell[4433, 144, 323, 14, 70, "Notes",
 CellID->4415]
}, Closed]],
Cell[CellGroupData[{
Cell[4793, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->450296902],
Cell[CellGroupData[{
Cell[5178, 177, 148, 5, 70, "ExampleSection",
 CellID->346051095],
Cell[CellGroupData[{
Cell[5351, 186, 139, 5, 28, "Input",
 CellID->501313468],
Cell[5493, 193, 157, 5, 36, "Output",
 CellID->95770673]
}, Open  ]],
Cell[CellGroupData[{
Cell[5687, 203, 70, 2, 28, "Input",
 CellID->230791865],
Cell[5760, 207, 158, 5, 36, "Output",
 CellID->628428876]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5967, 218, 215, 7, 70, "ExampleSection",
 CellID->8166],
Cell[6185, 227, 69, 1, 70, "ExampleText",
 CellID->1113876286],
Cell[CellGroupData[{
Cell[6279, 232, 160, 5, 70, "Input",
 CellID->1774324750],
Cell[6442, 239, 162, 5, 36, "Output",
 CellID->119070060]
}, Open  ]],
Cell[6619, 247, 125, 3, 70, "ExampleDelimiter",
 CellID->206580424],
Cell[6747, 252, 67, 1, 70, "ExampleText",
 CellID->838884225],
Cell[CellGroupData[{
Cell[6839, 257, 150, 5, 70, "Input",
 CellID->1698859122],
Cell[6992, 264, 180, 6, 36, "Output",
 CellID->170074584]
}, Open  ]],
Cell[7187, 273, 126, 3, 70, "ExampleDelimiter",
 CellID->2063940682],
Cell[7316, 278, 71, 1, 70, "ExampleText",
 CellID->822015323],
Cell[CellGroupData[{
Cell[7412, 283, 147, 5, 70, "Input",
 CellID->2332824],
Cell[7562, 290, 213, 7, 36, "Output",
 CellID->352245540]
}, Open  ]],
Cell[CellGroupData[{
Cell[7812, 302, 118, 4, 70, "Input",
 CellID->1729906436],
Cell[7933, 308, 216, 7, 36, "Output",
 CellID->161461597]
}, Open  ]],
Cell[CellGroupData[{
Cell[8186, 320, 178, 6, 70, "Input",
 CellID->628970065],
Cell[8367, 328, 214, 7, 36, "Output",
 CellID->8406846]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8630, 341, 223, 7, 70, "ExampleSection",
 CellID->17692],
Cell[8856, 350, 83, 1, 70, "ExampleText",
 CellID->2078680352],
Cell[CellGroupData[{
Cell[8964, 355, 338, 12, 70, "Input",
 CellID->84768696],
Cell[9305, 369, 164, 5, 36, "Output",
 CellID->800004185]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9518, 380, 233, 7, 70, "ExampleSection",
 CellID->21787],
Cell[9754, 389, 208, 7, 70, "ExampleText",
 CellID->2065810971],
Cell[CellGroupData[{
Cell[9987, 400, 169, 6, 70, "Input",
 CellID->1887499219],
Cell[10159, 408, 159, 5, 36, "Output",
 CellID->1736880614]
}, Open  ]],
Cell[10333, 416, 125, 3, 70, "ExampleDelimiter",
 CellID->607562233],
Cell[10461, 421, 327, 12, 70, "ExampleText",
 CellID->1728269985],
Cell[CellGroupData[{
Cell[10813, 437, 146, 5, 70, "Input",
 CellID->683214900],
Cell[10962, 444, 158, 5, 36, "Output",
 CellID->191200413]
}, Open  ]],
Cell[CellGroupData[{
Cell[11157, 454, 88, 3, 70, "Input",
 CellID->304619170],
Cell[11248, 459, 158, 5, 36, "Output",
 CellID->259023431]
}, Open  ]],
Cell[11421, 467, 125, 3, 70, "ExampleDelimiter",
 CellID->160021160],
Cell[11549, 472, 205, 7, 70, "ExampleText",
 CellID->650476513],
Cell[CellGroupData[{
Cell[11779, 483, 182, 6, 70, "Input",
 CellID->169527740],
Cell[11964, 491, 157, 5, 36, "Output",
 CellID->77640076]
}, Open  ]],
Cell[CellGroupData[{
Cell[12158, 501, 93, 3, 70, "Input",
 CellID->452459319],
Cell[12254, 506, 156, 5, 36, "Output",
 CellID->4116872]
}, Open  ]],
Cell[12425, 514, 124, 3, 70, "ExampleDelimiter",
 CellID->85252602],
Cell[12552, 519, 216, 8, 70, "ExampleText",
 CellID->208286109],
Cell[12771, 529, 173, 6, 70, "Input",
 CellID->1246355825],
Cell[CellGroupData[{
Cell[12969, 539, 166, 5, 70, "Input",
 CellID->1899364858],
Cell[13138, 546, 223, 7, 36, "Output",
 CellID->269621667]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13410, 559, 226, 7, 70, "ExampleSection",
 CellID->28532],
Cell[13639, 568, 99, 1, 70, "ExampleText",
 CellID->992262862],
Cell[CellGroupData[{
Cell[13763, 573, 94, 3, 70, "Input",
 CellID->1397421414],
Cell[13860, 578, 210, 5, 70, "Message",
 CellID->433084485],
Cell[14073, 585, 181, 6, 36, "Output",
 CellID->477662969]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14315, 598, 310, 9, 70, "SeeAlsoSection",
 CellID->5204],
Cell[14628, 609, 1423, 53, 70, "SeeAlso",
 CellID->29486]
}, Open  ]],
Cell[CellGroupData[{
Cell[16088, 667, 313, 9, 70, "TutorialsSection",
 CellID->1908],
Cell[16404, 678, 162, 3, 70, "Tutorials",
 CellID->17223]
}, Open  ]],
Cell[CellGroupData[{
Cell[16603, 686, 318, 9, 70, "MoreAboutSection",
 CellID->73193373],
Cell[16924, 697, 155, 3, 70, "MoreAbout",
 CellID->679482790]
}, Open  ]],
Cell[17094, 703, 27, 0, 70, "History"],
Cell[17124, 705, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

