(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     63000,       2286]
NotebookOptionsPosition[     52058,       1906]
NotebookOutlinePosition[     53543,       1947]
CellTagsIndexPosition[     53407,       1941]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AiryAi" :> Documentation`HelpLookup["paclet:ref/AiryAi"], 
          "AiryBi" :> Documentation`HelpLookup["paclet:ref/AiryBi"], 
          "AiryAiPrime" :> 
          Documentation`HelpLookup["paclet:ref/AiryAiPrime"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AiryAi\"\>", 2->"\<\"AiryBi\"\>", 
       3->"\<\"AiryAiPrime\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bessel-Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/BesselRelatedFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Bessel-Related Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AiryBiPrime", "ObjectName",
 CellID->1608],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AiryBiPrime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AiryBiPrime"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the derivative of the Airy function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12654]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["AiryBiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiPrime"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->66248513],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryBiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiPrime"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryBiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiPrime"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->741043077],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->94785187],

Cell["Evaluate numerically:", "ExampleText",
 CellID->13130859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryBiPrime", "[", "1.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43571376],

Cell[BoxData["2.985540050846599`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115125852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->739595651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"AiryBiPrime", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51025695],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158138415]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->368856164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"AiryBiPrime", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12533781],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["3", 
     RowBox[{"1", "/", "6"}]], 
    RowBox[{"Gamma", "[", 
     FractionBox["1", "3"], "]"}]], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"2", " ", 
     SuperscriptBox["3", 
      RowBox[{"1", "/", "6"}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["2", "3"], "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], 
    RowBox[{
     SuperscriptBox["3", 
      RowBox[{"5", "/", "6"}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["1", "3"], "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], 
    RowBox[{"30", " ", 
     SuperscriptBox["3", 
      RowBox[{"1", "/", "6"}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["2", "3"], "]"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {3^Rational[1, 6]/Gamma[
     Rational[1, 3]], 0, Rational[1, 2] 3^Rational[-1, 6]/Gamma[
     Rational[2, 3]], 3^Rational[-5, 6]/Gamma[
     Rational[1, 3]], 0, Rational[1, 30] 3^Rational[-1, 6]/Gamma[
     Rational[2, 3]]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{445, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->705692454]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->277002630],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->364441246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryBiPrime", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168847979],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.2050484049806622`"}], "+", 
  RowBox[{"8.290971678096389`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->201758051]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198533595],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->324834177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"AiryBiPrime", "[", 
    RowBox[{"5", "/", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->439682482],

Cell[BoxData["9.\
4214233173343017555823088857282415621646345227564022236010296767138`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->579451871]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->60457714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryBiPrime", "[", "2.50000000000000000000000", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->490382689],

Cell[BoxData["9.42142331733430175558230888572824156213`24.26964019176784"], \
"Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->910817402]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->599595922],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryBiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiPrime"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->454184032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryBiPrime", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->551143274],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.2212313987048948`", ",", "1.8862122548481652`", ",", 
   "2.985540050846599`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113899342]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100179844],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->202452547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryBiPrime", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->304801961],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["3", 
   RowBox[{"1", "/", "6"}]], 
  RowBox[{"Gamma", "[", 
   FractionBox["1", "3"], "]"}]]], "Output",
 ImageSize->{68, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154287879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259738993],

Cell["Find series expansions at infinity:", "ExampleText",
 CellID->238082080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"AiryBiPrime", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->547572138],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", 
      RowBox[{"3", "/", "2"}]]}], "3"]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SqrtBox["\[Pi]"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "x"], ")"}], 
        RowBox[{"1", "/", "4"}]]}]], "-", 
     FractionBox[
      RowBox[{"7", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "x"], ")"}], 
        RowBox[{"5", "/", "4"}]]}], 
      RowBox[{"48", " ", 
       SqrtBox["\[Pi]"]}]], "-", 
     FractionBox[
      RowBox[{"455", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "x"], ")"}], 
        RowBox[{"11", "/", "4"}]]}], 
      RowBox[{"4608", " ", 
       SqrtBox["\[Pi]"]}]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], 
       RowBox[{"13", "/", "4"}]],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, -1, 13, 4],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {
     Pi^Rational[-1, 2], 0, 0, 0, 0, 0, Rational[-7, 48] Pi^Rational[-1, 2], 
      0, 0, 0, 0, 0, Rational[-455, 4608] Pi^Rational[-1, 2]}, -1, 13, 4],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{348, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205887]
}, Open  ]],

Cell["The behavior at negative infinity is quite different:", "ExampleText",
 CellID->372636252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"AiryBiPrime", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->246753746],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"-", "x"}]], " ", "x"}], "3"]}], "]"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"1", "/", "4"}]], 
       RowBox[{
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"1", "/", "4"}]]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], 
        RowBox[{"5", "/", "4"}]],
       SeriesData[$CellContext`x, 
        DirectedInfinity[-1], {}, -1, 5, 4],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[-1], {(-1)^Rational[1, 4] Pi^Rational[-1, 2]}, -1, 5, 
      4],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{"7", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"3", "/", "4"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"5", "/", "4"}]]}], 
       RowBox[{"48", " ", 
        SqrtBox["\[Pi]"]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], 
        RowBox[{"3", "/", "2"}]],
       SeriesData[$CellContext`x, 
        DirectedInfinity[-1], {}, 5, 6, 4],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[-1], {
      Rational[7, 48] (-1)^Rational[3, 4] Pi^Rational[-1, 2]}, 5, 6, 4],
     Editable->False], ")"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"-", "x"}]], " ", "x"}], "3"]}], "]"}]}]}]], "Output",
 ImageSize->{575, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->324286680]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106476311],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->71121208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AiryBiPrime", "[", "z", "]"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->169273241],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->636044130]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21724],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryBiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiPrime"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->76549378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryBiPrime", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}], "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->595216601],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["3", 
     RowBox[{"1", "/", "6"}]], 
    RowBox[{"Gamma", "[", 
     FractionBox["1", "3"], "]"}]], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"2", " ", 
     SuperscriptBox["3", 
      RowBox[{"1", "/", "6"}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["2", "3"], "]"}]}]], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SuperscriptBox["3", 
         RowBox[{"5", "/", "6"}]], " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["1", "3"], "]"}]}]], "-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "6"}]], " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["2", "3"], "]"}]}]]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["3", 
         RowBox[{"1", "/", "6"}]], 
        RowBox[{"2", " ", 
         RowBox[{"Gamma", "[", 
          FractionBox["1", "3"], "]"}]}]]}], "+", 
      FractionBox["11", 
       RowBox[{"24", " ", 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "6"}]], " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["2", "3"], "]"}]}]]}], ")"}], " ", 
    SuperscriptBox["x", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {3^Rational[1, 6]/Gamma[
     Rational[1, 3]], 0, Rational[1, 2] 3^Rational[-1, 6]/Gamma[
     Rational[2, 3]], 3^Rational[-5, 6]/Gamma[
      Rational[1, 3]] + Rational[-1, 2] 3^Rational[-1, 6]/Gamma[
      Rational[2, 3]], Rational[-1, 2] 3^Rational[1, 6]/Gamma[
      Rational[1, 3]] + Rational[11, 24] 3^Rational[-1, 6]/Gamma[
      Rational[2, 3]]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{431, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157780385]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->96566509],

Cell[TextData[{
 "Solve differential equations in terms of ",
 Cell[BoxData[
  ButtonBox["AiryBiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiPrime"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->167071978],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "9"}], " ", 
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"w", "[", "z", "]"}]}], "+", 
     RowBox[{"9", " ", 
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"w", "[", "z", "]"}]}], "-", 
     RowBox[{"15", " ", 
      RowBox[{
       RowBox[{"w", "'"}], "[", "z", "]"}]}], "+", 
     RowBox[{"20", " ", 
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{
       RowBox[{"w", "'"}], "[", "z", "]"}]}], "+", 
     RowBox[{"15", " ", "z", " ", 
      RowBox[{
       RowBox[{"w", "''"}], "[", "z", "]"}]}], "-", 
     RowBox[{"10", " ", 
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{
       RowBox[{"w", "''"}], "[", "z", "]"}]}], "-", 
     RowBox[{"6", " ", 
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{
       RowBox[{"w", "'''"}], "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{
       RowBox[{"w", "''''"}], "[", "z", "]"}]}]}], "==", "0"}], ",", "w", ",",
    "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->359144995],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "z", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"AiryAiPrime", "[", "z", "]"}], "3"], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"AiryAiPrime", "[", "z", "]"}], "2"], " ", 
        RowBox[{"AiryBiPrime", "[", "z", "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}]}], "+", 
       RowBox[{
        RowBox[{"AiryAiPrime", "[", "z", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"AiryBiPrime", "[", "z", "]"}], "2"], " ", 
        RowBox[{"C", "[", "3", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"AiryBiPrime", "[", "z", "]"}], "3"], " ", 
        RowBox[{"C", "[", "4", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{529, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403304527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8567786],

Cell[TextData[{
 "Solution of the modified linearized ",
 ButtonBox["Korteweg-deVries equation",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Korteweg-deVriesEquation.html"], 
    None}],
 " for any function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->150919136],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"3", " ", "t"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "/", "3"}], ")"}]}], " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AiryBiPrime", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "y"}], ")"}], " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", " ", "t"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "3"}], ")"}]}]}], "]"}], " ", 
      RowBox[{"f", "[", "y", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->737523458],

Cell["Verify the solution:", "ExampleText",
 CellID->336418360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "t", ",", "x"}], "]"}], "+", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x", ",", "x", ",", 
     "x"}], "]"}]}], "//.", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Alpha]_.", 
     RowBox[{"Integrate", "[", 
      RowBox[{"a_", ",", "i_"}], "]"}]}], "+", " ", 
    RowBox[{"\[Beta]_.", 
     RowBox[{"Integrate", "[", 
      RowBox[{"b_", ",", "i_"}], "]"}]}]}], "\[RuleDelayed]", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Alpha]", " ", "a"}], "+", 
      RowBox[{"\[Beta]", " ", "b"}]}], ",", "i"}], "]"}], " "}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->353915168],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27214445]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->252346190],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify Airy functions, here in the ",
 ButtonBox["Wronskian",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Wronskian.html"], None}],
 " of the Airy equation:"
}], "ExampleText",
 CellID->194346008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"#1", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "#2"}], "}"}]}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AiryAi", "[", "x", "]"}], ",", 
      RowBox[{"AiryBi", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21190722],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"AiryAiPrime", "[", "x", "]"}]}], " ", 
   RowBox[{"AiryBi", "[", "x", "]"}]}], "+", 
  RowBox[{
   RowBox[{"AiryAi", "[", "x", "]"}], " ", 
   RowBox[{"AiryBiPrime", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->880142304]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->44369521],

Cell[BoxData[
 FractionBox["1", "\[Pi]"]], "Output",
 ImageSize->{17, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->943022721]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138797173],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " tries to simplify the argument of ",
 Cell[BoxData[
  ButtonBox["AiryBiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiPrime"]], "InlineFormula"],
 ":  "
}], "ExampleText",
 CellID->34037544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionExpand", " ", "[", 
   RowBox[{"AiryBiPrime", "[", 
    RowBox[{"z", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"2", "Pi", " ", 
       RowBox[{"I", "/", "3"}]}], "]"}]}], "]"}], "]"}], " ", "//", " ", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21740304],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "4"]}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", 
    SqrtBox["3"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"AiryAiPrime", "[", "z", "]"}]}], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"AiryBiPrime", "[", "z", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{331, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313347257]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->484517591],

Cell["Generate Airy functions from differential equations:", "ExampleText",
 CellID->42244441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{
       RowBox[{"w", "''"}], "[", "z", "]"}]}], "-", 
     RowBox[{
      RowBox[{"w", "'"}], "[", "z", "]"}], "-", 
     RowBox[{
      RowBox[{"z", "^", "2"}], 
      RowBox[{"w", "[", "z", "]"}]}]}], "\[Equal]", "0"}], ",", "w", ",", 
   "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30040937],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "z", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"AiryAiPrime", "[", "z", "]"}], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{
        RowBox[{"AiryBiPrime", "[", "z", "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{428, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252246911]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->270782226],

Cell["Integrals:", "ExampleText",
 CellID->789102543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "a"}], " ", 
    RowBox[{
     RowBox[{"AiryBiPrime", "[", "z", "]"}], "^", "2"}]}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131281908],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["4", "9"], " ", 
   SuperscriptBox["z", 
    RowBox[{"3", "+", "a"}]], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", 
     FractionBox["a", "3"]}], "]"}], " ", 
   RowBox[{"HypergeometricPFQRegularized", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       RowBox[{"1", "+", 
        FractionBox["a", "3"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "3"], ",", 
       FractionBox["5", "3"], ",", 
       RowBox[{"2", "+", 
        FractionBox["a", "3"]}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["z", "3"]}], "9"]}], "]"}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      FractionBox[
       RowBox[{"2", " ", "a"}], "3"]}]], " ", 
    SuperscriptBox["3", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"2", " ", "a"}], "3"]}]], " ", 
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"2", " ", "a"}]}], ")"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          FractionBox[
           RowBox[{"1", "+", "a"}], "3"], ",", 
          FractionBox[
           RowBox[{"3", "+", "a"}], "3"], ",", 
          FractionBox[
           RowBox[{"5", "+", "a"}], "3"]}], "}"}], ",", 
        RowBox[{"{", "0", "}"}]}], "}"}], ",", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["2", "3"], ")"}], 
        RowBox[{"2", "/", "3"}]], " ", "z"}], ",", 
      FractionBox["1", "3"]}], "]"}]}], 
   SuperscriptBox["\[Pi]", 
    RowBox[{"3", "/", "2"}]]]}]], "Output",
 ImageSize->{552, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->618719324]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->271763305],

Cell["Integral transforms:", "ExampleText",
 CellID->240522850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"AiryBiPrime", "[", 
    RowBox[{"-", "t"}], "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55980567],

Cell[BoxData[
 FractionBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"HypergeometricPFQ", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", "3"], ",", 
         FractionBox["5", "6"]}], "}"}], ",", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox["s", "6"], "36"]}]}], "]"}]}], 
    RowBox[{
     SuperscriptBox["3", 
      RowBox[{"1", "/", "6"}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["2", "3"], "]"}]}]], "+", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["s", "2"], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"-", 
       FractionBox["4", "3"]}], "]"}], " ", 
     RowBox[{"HypergeometricPFQ", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["2", "3"], ",", 
         FractionBox["7", "6"]}], "}"}], ",", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox["s", "6"], "36"]}]}], "]"}]}], 
    RowBox[{"3", " ", 
     SuperscriptBox["3", 
      RowBox[{"1", "/", "3"}]], " ", "\[Pi]"}]]}], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{445, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->389147183]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->303239008],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["AiryBiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiPrime"]], "InlineFormula"],
 " from sums:  "
}], "ExampleText",
 CellID->144142464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{"1", "/", "6"}]], " "}], 
     RowBox[{"Gamma", "[", 
      FractionBox["1", "3"], "]"}]], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]"], 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        RowBox[{"Pochhammer", "[", 
         RowBox[{
          FractionBox["1", "3"], ",", "k"}], "]"}], " ", 
        RowBox[{"k", "!"}]}]], 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         SuperscriptBox["z", "3"], "9"], ")"}], "k"]}]}]}], "+", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "2"], " "}], 
     RowBox[{"2", " ", 
      SuperscriptBox["3", 
       RowBox[{"1", "/", "6"}]], " ", 
      RowBox[{"Gamma", "[", 
       FractionBox["2", "3"], "]"}]}]], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]"], 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        RowBox[{"Pochhammer", "[", 
         RowBox[{
          FractionBox["5", "3"], ",", "k"}], "]"}], " ", 
        RowBox[{"k", "!"}]}]], 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         SuperscriptBox["z", "3"], "9"], ")"}], "k"]}]}]}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->598775545],

Cell[BoxData[
 RowBox[{"AiryBiPrime", "[", "z", "]"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280398066]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33245808],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryBiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiPrime"]], "InlineFormula"],
 " appears in special cases of several mathematical functions:  "
}], "ExampleText",
 CellID->448728449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"Hypergeometric0F1", "[", 
        RowBox[{
         FractionBox["5", "3"], ",", 
         FractionBox[
          SuperscriptBox["z", "3"], "9"]}], "]"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["3", 
        RowBox[{"1", "/", "6"}]], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["2", "3"], "]"}]}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["3", 
        RowBox[{"1", "/", "6"}]], " ", 
       RowBox[{"Hypergeometric0F1", "[", 
        RowBox[{
         FractionBox["1", "3"], ",", 
         FractionBox[
          SuperscriptBox["z", "3"], "9"]}], "]"}]}], 
      RowBox[{" ", 
       RowBox[{"Gamma", "[", 
        FractionBox["1", "3"], "]"}]}]]}], ",", " ", "\[IndentingNewLine]", 
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "6"]}], ",", 
          FractionBox["1", "3"]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          FractionBox["2", "3"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "6"]}], ",", 
          FractionBox["1", "3"]}], "}"}]}], "}"}], ",", 
      RowBox[{
       SuperscriptBox["3", 
        RowBox[{
         RowBox[{"-", "2"}], "/", "3"}]], " ", "z"}], ",", 
      FractionBox["1", "3"]}], "]"}]}], "}"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137547933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AiryBiPrime", "[", "z", "]"}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"AiryBiPrime", "[", "z", "]"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["3", 
       RowBox[{"1", "/", "6"}]], " ", "\[Pi]"}]]}]}], "}"}]], "Output",
 ImageSize->{237, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->748798243]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->401424036],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellID->189118510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryBiPrime", "[", 
  RowBox[{"-", 
   RowBox[{"10.", "^", "12"}]}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->410685067],

Cell[BoxData[
 RowBox[{"-", "555.5520667444995`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72629478]
}, Open  ]],

Cell["Use arbitrary-precision evaluation instead:", "ExampleText",
 CellID->494537860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"AiryBiPrime", "[", 
    RowBox[{"-", 
     RowBox[{"10", "^", "12"}]}], " ", "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->481789306],

Cell[BoxData[
 RowBox[{"-", "429.218360706976961712`10."}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->758736870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292265757],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->329596819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"AiryBiPrime", "[", 
    RowBox[{"-", 
     RowBox[{"10", "^", "100"}]}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264968981],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(AiryBiPrime[\\(\\(-\
100000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000\\)\\)]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->230372888],

Cell[BoxData["0``-24.751425063652935"], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->535836947]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"AiryBiPrime", "[", 
      RowBox[{"-", 
       RowBox[{"10", "^", "100"}]}], "]"}], ",", "20"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91165186],

Cell[BoxData[
 RowBox[{"-", "2.56475186353307735793383763527152`20.*^24"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->317772825]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->355668738],

Cell["\<\
Machine-number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText",
 CellID->166873796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryBiPrime", "[", 
  RowBox[{"10.", "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->338168219],

Cell[BoxData["1.710055114621322272299442233266316`15.954589770191005*^9156"], \
"Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9424206]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->497420131],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->373748705]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29130],

Cell[TextData[{
 "Nested integrals of the square of ",
 Cell[BoxData[
  ButtonBox["AiryBiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiPrime"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->240352699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{"#", ",", "z"}], "]"}], "&"}], ",", 
     RowBox[{
      RowBox[{"AiryBiPrime", "[", "z", "]"}], "^", "2"}], ",", "4"}], "]"}], "//",
    "Simplify"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120575640],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], "2"], ",", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["z", "2"]}], " ", 
        SuperscriptBox[
         RowBox[{"Bi", "(", "z", ")"}], "2"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], " ", 
        RowBox[{"Bi", "(", "z", ")"}]}], "+", 
       RowBox[{"z", " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], "2"]}]}], 
      ")"}]}], ",", 
    RowBox[{
     FractionBox["1", "30"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"9", "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "3"]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Bi", "(", "z", ")"}], "2"]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], " ", 
        RowBox[{"Bi", "(", "z", ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], "2"]}]}], 
      ")"}]}], ",", 
    RowBox[{
     FractionBox["1", "210"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        RowBox[{"Bi", "(", "z", ")"}], " ", 
        RowBox[{
         SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], " ", 
        SuperscriptBox["z", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"63", " ", "z"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["z", "4"]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Bi", "(", "z", ")"}], "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["z", "3"]}], "-", "15"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], "2"]}]}], 
      ")"}]}], ",", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"371", " ", 
          SuperscriptBox["z", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["z", "5"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Bi", "(", "z", ")"}], "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["z", "3"]}], "-", "175"}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], " ", 
       RowBox[{"Bi", "(", "z", ")"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["z", "3"]}], "-", "365"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], "2"]}]}], 
     "1890"]}], "}"}], TraditionalForm]], "Output",
 ImageSize->{511, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->297316799]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22290],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AiryAi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryAi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AiryBi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryBi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AiryAiPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryAiPrime"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31339]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32707],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->24245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1338],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/AiryFunctions.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/BesselAiryStruveFunctions/AiryBiPrime/"],
    None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->217694179],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "MoreAbout",
 CellID->157498716]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AiryBiPrime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 53.0797078}", "context" -> "System`", 
    "keywords" -> {"Airy Bi derivative", "Airy Bi prime", "Airy functions"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "AiryBiPrime[z] gives the derivative of the Airy function Bi^\\[Prime] \
(z). ", "synonyms" -> {"airy bi prime"}, "title" -> "AiryBiPrime", "type" -> 
    "Symbol", "uri" -> "ref/AiryBiPrime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4619, 158, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->741043077]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[45202, 1660, 268, 9, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->240352699]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 53109, 1930},
 {"XRef-2005-4-26-23-37-1.8558342", 53266, 1934}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1929, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2552, 75, 48, 1, 70, "ObjectName",
 CellID->1608],
Cell[2603, 78, 651, 21, 70, "Usage",
 CellID->12654]
}, Open  ]],
Cell[CellGroupData[{
Cell[3291, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3769, 121, 120, 4, 70, "Notes",
 CellID->20640],
Cell[3892, 127, 253, 8, 70, "Notes",
 CellID->66248513],
Cell[4148, 137, 224, 7, 70, "Notes",
 CellID->31226],
Cell[4375, 146, 207, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[4619, 158, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->741043077],
Cell[CellGroupData[{
Cell[5004, 172, 147, 5, 70, "ExampleSection",
 CellID->94785187],
Cell[5154, 179, 63, 1, 70, "ExampleText",
 CellID->13130859],
Cell[CellGroupData[{
Cell[5242, 184, 108, 3, 28, "Input",
 CellID->43571376],
Cell[5353, 189, 175, 5, 36, "Output",
 CellID->115125852]
}, Open  ]],
Cell[5543, 197, 125, 3, 70, "ExampleDelimiter",
 CellID->739595651],
Cell[CellGroupData[{
Cell[5693, 204, 242, 8, 28, "Input",
 CellID->51025695],
Cell[5938, 214, 3010, 53, 136, "Output",
 Evaluatable->False,
 CellID->158138415]
}, Open  ]],
Cell[8963, 270, 125, 3, 70, "ExampleDelimiter",
 CellID->368856164],
Cell[CellGroupData[{
Cell[9113, 277, 222, 7, 70, "Input",
 CellID->12533781],
Cell[9338, 286, 1383, 44, 63, "Output",
 CellID->705692454]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10770, 336, 220, 7, 70, "ExampleSection",
 CellID->277002630],
Cell[10993, 345, 74, 1, 70, "ExampleText",
 CellID->364441246],
Cell[CellGroupData[{
Cell[11092, 350, 132, 4, 70, "Input",
 CellID->168847979],
Cell[11227, 356, 269, 8, 36, "Output",
 CellID->201758051]
}, Open  ]],
Cell[11511, 367, 125, 3, 70, "ExampleDelimiter",
 CellID->198533595],
Cell[11639, 372, 70, 1, 70, "ExampleText",
 CellID->324834177],
Cell[CellGroupData[{
Cell[11734, 377, 185, 6, 70, "Input",
 CellID->439682482],
Cell[11922, 385, 235, 7, 36, "Output",
 CellID->579451871]
}, Open  ]],
Cell[12172, 395, 112, 3, 70, "ExampleText",
 CellID->60457714],
Cell[CellGroupData[{
Cell[12309, 402, 131, 3, 70, "Input",
 CellID->490382689],
Cell[12443, 407, 218, 6, 36, "Output",
 CellID->910817402]
}, Open  ]],
Cell[12676, 416, 125, 3, 70, "ExampleDelimiter",
 CellID->599595922],
Cell[12804, 421, 216, 7, 70, "ExampleText",
 CellID->454184032],
Cell[CellGroupData[{
Cell[13045, 432, 170, 5, 70, "Input",
 CellID->551143274],
Cell[13218, 439, 274, 9, 36, "Output",
 CellID->113899342]
}, Open  ]],
Cell[13507, 451, 125, 3, 70, "ExampleDelimiter",
 CellID->100179844],
Cell[13635, 456, 91, 1, 70, "ExampleText",
 CellID->202452547],
Cell[CellGroupData[{
Cell[13751, 461, 107, 3, 70, "Input",
 CellID->304801961],
Cell[13861, 466, 280, 10, 63, "Output",
 CellID->154287879]
}, Open  ]],
Cell[14156, 479, 125, 3, 70, "ExampleDelimiter",
 CellID->259738993],
Cell[14284, 484, 78, 1, 70, "ExampleText",
 CellID->238082080],
Cell[CellGroupData[{
Cell[14387, 489, 230, 7, 70, "Input",
 CellID->547572138],
Cell[14620, 498, 1507, 50, 71, "Output",
 CellID->205887]
}, Open  ]],
Cell[16142, 551, 96, 1, 70, "ExampleText",
 CellID->372636252],
Cell[CellGroupData[{
Cell[16263, 556, 251, 8, 70, "Input",
 CellID->246753746],
Cell[16517, 566, 2202, 75, 71, "Output",
 CellID->324286680]
}, Open  ]],
Cell[18734, 644, 125, 3, 70, "ExampleDelimiter",
 CellID->106476311],
Cell[18862, 649, 202, 7, 70, "ExampleText",
 CellID->71121208],
Cell[CellGroupData[{
Cell[19089, 660, 147, 5, 70, "Input",
 CellID->169273241],
Cell[19239, 667, 267, 9, 50, "Output",
 CellID->636044130]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19555, 682, 239, 7, 70, "ExampleSection",
 CellID->21724],
Cell[19797, 691, 214, 7, 70, "ExampleText",
 CellID->76549378],
Cell[CellGroupData[{
Cell[20036, 702, 240, 8, 70, "Input",
 CellID->595216601],
Cell[20279, 712, 2093, 65, 110, "Output",
 CellID->157780385]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22421, 783, 226, 7, 70, "ExampleSection",
 CellID->96566509],
Cell[22650, 792, 230, 8, 70, "ExampleText",
 CellID->167071978],
Cell[CellGroupData[{
Cell[22905, 804, 1106, 36, 70, "Input",
 CellID->359144995],
Cell[24014, 842, 1027, 30, 58, "Output",
 CellID->403304527]
}, Open  ]],
Cell[25056, 875, 123, 3, 70, "ExampleDelimiter",
 CellID->8567786],
Cell[25182, 880, 353, 12, 70, "ExampleText",
 CellID->150919136],
Cell[25538, 894, 860, 30, 70, "Input",
 CellID->737523458],
Cell[26401, 926, 63, 1, 70, "ExampleText",
 CellID->336418360],
Cell[CellGroupData[{
Cell[26489, 931, 805, 26, 70, "Input",
 CellID->353915168],
Cell[27297, 959, 157, 5, 36, "Output",
 CellID->27214445]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27503, 970, 237, 7, 70, "ExampleSection",
 CellID->252346190],
Cell[27743, 979, 392, 13, 70, "ExampleText",
 CellID->194346008],
Cell[CellGroupData[{
Cell[28160, 996, 477, 16, 70, "Input",
 CellID->21190722],
Cell[28640, 1014, 393, 13, 36, "Output",
 CellID->880142304]
}, Open  ]],
Cell[CellGroupData[{
Cell[29070, 1032, 107, 3, 70, "Input",
 CellID->44369521],
Cell[29180, 1037, 182, 6, 51, "Output",
 CellID->943022721]
}, Open  ]],
Cell[29377, 1046, 125, 3, 70, "ExampleDelimiter",
 CellID->138797173],
Cell[29505, 1051, 356, 12, 70, "ExampleText",
 CellID->34037544],
Cell[CellGroupData[{
Cell[29886, 1067, 316, 10, 70, "Input",
 CellID->21740304],
Cell[30205, 1079, 495, 17, 51, "Output",
 CellID->313347257]
}, Open  ]],
Cell[30715, 1099, 125, 3, 70, "ExampleDelimiter",
 CellID->484517591],
Cell[30843, 1104, 94, 1, 70, "ExampleText",
 CellID->42244441],
Cell[CellGroupData[{
Cell[30962, 1109, 419, 15, 70, "Input",
 CellID->30040937],
Cell[31384, 1126, 563, 18, 36, "Output",
 CellID->252246911]
}, Open  ]],
Cell[31962, 1147, 125, 3, 70, "ExampleDelimiter",
 CellID->270782226],
Cell[32090, 1152, 53, 1, 70, "ExampleText",
 CellID->789102543],
Cell[CellGroupData[{
Cell[32168, 1157, 246, 9, 70, "Input",
 CellID->131281908],
Cell[32417, 1168, 2047, 70, 100, "Output",
 CellID->618719324]
}, Open  ]],
Cell[34479, 1241, 125, 3, 70, "ExampleDelimiter",
 CellID->271763305],
Cell[34607, 1246, 63, 1, 70, "ExampleText",
 CellID->240522850],
Cell[CellGroupData[{
Cell[34695, 1251, 206, 6, 70, "Input",
 CellID->55980567],
Cell[34904, 1259, 1312, 45, 83, "Output",
 CellID->389147183]
}, Open  ]],
Cell[36231, 1307, 125, 3, 70, "ExampleDelimiter",
 CellID->303239008],
Cell[36359, 1312, 208, 8, 70, "ExampleText",
 CellID->144142464],
Cell[CellGroupData[{
Cell[36592, 1324, 1378, 49, 70, "Input",
 CellID->598775545],
Cell[37973, 1375, 196, 6, 36, "Output",
 CellID->280398066]
}, Open  ]],
Cell[38184, 1384, 124, 3, 70, "ExampleDelimiter",
 CellID->33245808],
Cell[38311, 1389, 245, 7, 70, "ExampleText",
 CellID->448728449],
Cell[CellGroupData[{
Cell[38581, 1400, 1702, 57, 70, "Input",
 CellID->137547933],
Cell[40286, 1459, 422, 14, 53, "Output",
 CellID->748798243]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40757, 1479, 230, 7, 70, "ExampleSection",
 CellID->401424036],
Cell[40990, 1488, 116, 3, 70, "ExampleText",
 CellID->189118510],
Cell[CellGroupData[{
Cell[41131, 1495, 157, 5, 70, "Input",
 CellID->410685067],
Cell[41291, 1502, 191, 6, 36, "Output",
 CellID->72629478]
}, Open  ]],
Cell[41497, 1511, 86, 1, 70, "ExampleText",
 CellID->494537860],
Cell[CellGroupData[{
Cell[41608, 1516, 213, 7, 70, "Input",
 CellID->481789306],
Cell[41824, 1525, 200, 6, 36, "Output",
 CellID->758736870]
}, Open  ]],
Cell[42039, 1534, 125, 3, 70, "ExampleDelimiter",
 CellID->292265757],
Cell[42167, 1539, 246, 8, 70, "ExampleText",
 CellID->329596819],
Cell[CellGroupData[{
Cell[42438, 1551, 209, 7, 70, "Input",
 CellID->264968981],
Cell[42650, 1560, 548, 11, 70, "Message",
 CellID->230372888],
Cell[43201, 1573, 179, 5, 36, "Output",
 CellID->535836947]
}, Open  ]],
Cell[CellGroupData[{
Cell[43417, 1583, 343, 12, 70, "Input",
 CellID->91165186],
Cell[43763, 1597, 217, 6, 36, "Output",
 CellID->317772825]
}, Open  ]],
Cell[43995, 1606, 125, 3, 70, "ExampleDelimiter",
 CellID->355668738],
Cell[44123, 1611, 113, 3, 70, "ExampleText",
 CellID->166873796],
Cell[CellGroupData[{
Cell[44261, 1618, 132, 4, 70, "Input",
 CellID->338168219],
Cell[44396, 1624, 218, 6, 36, "Output",
 CellID->9424206]
}, Open  ]],
Cell[CellGroupData[{
Cell[44651, 1635, 110, 3, 70, "Input",
 CellID->497420131],
Cell[44764, 1640, 162, 5, 36, "Output",
 CellID->373748705]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44975, 1651, 224, 7, 70, "ExampleSection",
 CellID->29130],
Cell[45202, 1660, 268, 9, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->240352699],
Cell[CellGroupData[{
Cell[45495, 1673, 370, 12, 70, "Input",
 CellID->120575640],
Cell[45868, 1687, 3278, 104, 148, "Output",
 CellID->297316799]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49207, 1798, 311, 9, 70, "SeeAlsoSection",
 CellID->22290],
Cell[49521, 1809, 694, 26, 70, "SeeAlso",
 CellID->31339]
}, Open  ]],
Cell[CellGroupData[{
Cell[50252, 1840, 314, 9, 70, "TutorialsSection",
 CellID->32707],
Cell[50569, 1851, 144, 3, 70, "Tutorials",
 CellID->24245]
}, Open  ]],
Cell[CellGroupData[{
Cell[50750, 1859, 320, 9, 70, "RelatedLinksSection",
 CellID->1338],
Cell[51073, 1870, 184, 4, 70, "RelatedLinks"],
Cell[51260, 1876, 209, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51506, 1885, 319, 9, 70, "MoreAboutSection",
 CellID->217694179],
Cell[51828, 1896, 158, 3, 70, "MoreAbout",
 CellID->157498716]
}, Open  ]],
Cell[52001, 1902, 27, 0, 70, "History"],
Cell[52031, 1904, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

