(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23998,        901]
NotebookOptionsPosition[     18198,        698]
NotebookOutlinePosition[     19554,        736]
CellTagsIndexPosition[     19469,        731]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicNumberFields"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Algebraic Number Fields\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AlgebraicIntegerQ" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicIntegerQ"], 
          "MinimalPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/MinimalPolynomial"], 
          "AlgebraicNumber" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AlgebraicIntegerQ\"\>", 
       2->"\<\"MinimalPolynomial\"\>", 
       3->"\<\"AlgebraicNumber\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AlgebraicNumberDenominator", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AlgebraicNumberDenominator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AlgebraicNumberDenominator"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the smallest positive integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " such that ",
     Cell[BoxData[
      RowBox[{
       StyleBox["n", "TI"], " ", 
       StyleBox["a", "TI"]}]], "InlineFormula"],
     " is an algebraic integer."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->226233082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberDenominator", "[", 
  RowBox[{"1", "/", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51833909],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->523275307]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1615390373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberDenominator", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"Sqrt", "[", "5", "]"}]}], ")"}], "/", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1377733637],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8913296]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Radical expressions:", "ExampleText",
 CellID->873012776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberDenominator", "[", 
  RowBox[{"1", "/", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", "3"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1117449928],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77052772]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberDenominator", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"3", "I"}]}], ")"}], "^", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "3"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1910960595],

Cell[BoxData["10"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->262020207]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186804023],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->2141606294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberDenominator", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"5", "-", 
      RowBox[{"6", "#1"}], "+", 
      RowBox[{"3", 
       RowBox[{"#1", "^", "3"}]}]}], " ", "&"}], " ", ",", " ", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3575891],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40592757]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberDenominator", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "5"}], ",", " ", "1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->394617174],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->112174116]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1145063576],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumberDenominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumberDenominator"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->540435224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberDenominator", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", 
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], ",", " ", 
    RowBox[{"1", "/", "3"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1029306361],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->616646006]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "Representation of  ",
 Cell[BoxData[
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["3"]}], ")"}]}]], "InlineFormula"],
 " as a quotient ",
 Cell[BoxData[
  RowBox[{
   StyleBox["\[Alpha]", "TR"], 
   StyleBox["/", "TR"], 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " of an algebraic integer ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " and an integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1749701170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n", "=", " ", 
  RowBox[{"AlgebraicNumberDenominator", "[", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Sqrt", "[", "3", "]"}]}], ")"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1449138602],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->332049966]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Alpha]", " ", "=", 
  RowBox[{"n", "  ", 
   RowBox[{"ToNumberField", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], ")"}]}], ",", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1746570143],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   SqrtBox["3"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Output",
 ImageSize->{205, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->216346214]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicIntegerQ", "[", "\[Alpha]", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->148299781],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14263452]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "For an algebraic integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", the denominator is one:"
}], "ExampleText",
 CellID->229562247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberDenominator", "[", 
  RowBox[{"Sqrt", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1372055317],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1005666436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->913058377],

Cell["\<\
Multiplying an algebraic number by its denominator gives an algebraic \
integer:\
\>", "ExampleText",
 CellID->13195798],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", "I"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96639597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicIntegerQ", "[", "\[Alpha]", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->764867560],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->359486983]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicIntegerQ", "[", 
  RowBox[{
   RowBox[{"AlgebraicNumberDenominator", "[", "\[Alpha]", "]"}], "\[Alpha]"}],
   "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->40282303],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->293915690]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["The argument must be an algebraic number:", "ExampleText",
 CellID->49403315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberDenominator", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1392827463],

Cell[BoxData[
 RowBox[{
  RowBox[{"AlgebraicNumberDenominator", "::", "\<\"nalg\"\>"}], ":", 
  " ", "\<\"\\!\\(\[Pi]\\) is not an explicit algebraic number. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/nalg\\\", \
ButtonNote -> \\\"AlgebraicNumberDenominator::nalg\\\"]\\)\"\>"}]], "Message",\
 "MSG",
 CellID->245534043],

Cell[BoxData[
 RowBox[{"AlgebraicNumberDenominator", "[", "\[Pi]", "]"}]], "Output",
 ImageSize->{208, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->296977465]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"Pi", ",", " ", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1405120757],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47657633]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicIntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicIntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->96395057],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->278819559]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AlgebraicNumberDenominator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 54.5484954}", "context" -> "System`", 
    "keywords" -> {"algebraic integer", "algebraic number"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AlgebraicNumberDenominator[a] gives the smallest positive integer n such \
that n a is an algebraic integer.", 
    "synonyms" -> {"algebraic number denominator"}, "title" -> 
    "AlgebraicNumberDenominator", "type" -> "Symbol", "uri" -> 
    "ref/AlgebraicNumberDenominator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5071, 146, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19334, 724}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2062, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2685, 79, 1591, 37, 70, "ObjectNameGrid"],
Cell[4279, 118, 755, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5071, 146, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[5448, 160, 148, 5, 70, "ExampleSection",
 CellID->226233082],
Cell[CellGroupData[{
Cell[5621, 169, 176, 5, 28, "Input",
 CellID->51833909],
Cell[5800, 176, 158, 5, 36, "Output",
 CellID->523275307]
}, Open  ]],
Cell[5973, 184, 126, 3, 70, "ExampleDelimiter",
 CellID->1615390373],
Cell[CellGroupData[{
Cell[6124, 191, 229, 7, 28, "Input",
 CellID->1377733637],
Cell[6356, 200, 156, 5, 36, "Output",
 CellID->8913296]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6561, 211, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[6785, 220, 63, 1, 70, "ExampleText",
 CellID->873012776],
Cell[CellGroupData[{
Cell[6873, 225, 237, 7, 70, "Input",
 CellID->1117449928],
Cell[7113, 234, 157, 5, 36, "Output",
 CellID->77052772]
}, Open  ]],
Cell[CellGroupData[{
Cell[7307, 244, 286, 10, 70, "Input",
 CellID->1910960595],
Cell[7596, 256, 159, 5, 36, "Output",
 CellID->262020207]
}, Open  ]],
Cell[7770, 264, 125, 3, 70, "ExampleDelimiter",
 CellID->186804023],
Cell[7898, 269, 322, 12, 70, "ExampleText",
 CellID->2141606294],
Cell[CellGroupData[{
Cell[8245, 285, 323, 11, 70, "Input",
 CellID->3575891],
Cell[8571, 298, 157, 5, 36, "Output",
 CellID->40592757]
}, Open  ]],
Cell[CellGroupData[{
Cell[8765, 308, 307, 10, 70, "Input",
 CellID->394617174],
Cell[9075, 320, 158, 5, 36, "Output",
 CellID->112174116]
}, Open  ]],
Cell[9248, 328, 126, 3, 70, "ExampleDelimiter",
 CellID->1145063576],
Cell[9377, 333, 247, 7, 70, "ExampleText",
 CellID->540435224],
Cell[CellGroupData[{
Cell[9649, 344, 302, 9, 70, "Input",
 CellID->1029306361],
Cell[9954, 355, 261, 9, 36, "Output",
 CellID->616646006]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10264, 370, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[10494, 379, 529, 21, 70, "ExampleText",
 CellID->1749701170],
Cell[CellGroupData[{
Cell[11048, 404, 261, 8, 70, "Input",
 CellID->1449138602],
Cell[11312, 414, 158, 5, 36, "Output",
 CellID->332049966]
}, Open  ]],
Cell[CellGroupData[{
Cell[11507, 424, 347, 11, 70, "Input",
 CellID->1746570143],
Cell[11857, 437, 306, 11, 43, "Output",
 CellID->216346214]
}, Open  ]],
Cell[CellGroupData[{
Cell[12200, 453, 120, 3, 70, "Input",
 CellID->148299781],
Cell[12323, 458, 160, 5, 36, "Output",
 CellID->14263452]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12532, 469, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[12773, 478, 170, 6, 70, "ExampleText",
 CellID->229562247],
Cell[CellGroupData[{
Cell[12968, 488, 154, 4, 70, "Input",
 CellID->1372055317],
Cell[13125, 494, 159, 5, 36, "Output",
 CellID->1005666436]
}, Open  ]],
Cell[13299, 502, 125, 3, 70, "ExampleDelimiter",
 CellID->913058377],
Cell[13427, 507, 130, 4, 70, "ExampleText",
 CellID->13195798],
Cell[13560, 513, 199, 7, 70, "Input",
 CellID->96639597],
Cell[CellGroupData[{
Cell[13784, 524, 120, 3, 70, "Input",
 CellID->764867560],
Cell[13907, 529, 162, 5, 36, "Output",
 CellID->359486983]
}, Open  ]],
Cell[CellGroupData[{
Cell[14106, 539, 201, 6, 70, "Input",
 CellID->40282303],
Cell[14310, 547, 161, 5, 36, "Output",
 CellID->293915690]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14520, 558, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[14754, 567, 83, 1, 70, "ExampleText",
 CellID->49403315],
Cell[CellGroupData[{
Cell[14862, 572, 124, 3, 70, "Input",
 CellID->1392827463],
Cell[14989, 577, 415, 8, 70, "Message",
 CellID->245534043],
Cell[15407, 587, 215, 6, 36, "Output",
 CellID->296977465]
}, Open  ]],
Cell[CellGroupData[{
Cell[15659, 598, 142, 4, 70, "Input",
 CellID->1405120757],
Cell[15804, 604, 161, 5, 36, "Output",
 CellID->47657633]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16026, 616, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[16345, 627, 750, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[17132, 658, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[17453, 669, 159, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[17649, 677, 318, 9, 70, "MoreAboutSection",
 CellID->96395057],
Cell[17970, 688, 156, 3, 70, "MoreAbout",
 CellID->278819559]
}, Open  ]],
Cell[18141, 694, 27, 0, 70, "History"],
Cell[18171, 696, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

