(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27901,       1048]
NotebookOptionsPosition[     21795,        835]
NotebookOutlinePosition[     23094,        872]
CellTagsIndexPosition[     23009,        867]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicNumberFields"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Algebraic Number Fields\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AlgebraicNumberNorm" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicNumberNorm"], 
          "MinimalPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/MinimalPolynomial"], 
          "SymmetricPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/SymmetricPolynomial"], 
          "NumberFieldDiscriminant" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldDiscriminant"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"AlgebraicNumberNorm\"\>", 
       2->"\<\"MinimalPolynomial\"\>", 3->"\<\"SymmetricPolynomial\"\>", 
       4->"\<\"NumberFieldDiscriminant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AlgebraicNumberTrace", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AlgebraicNumberTrace",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AlgebraicNumberTrace"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the trace of the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The trace of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is defined to be the sum of the roots of its minimal polynomial."
}], "Notes",
 CellID->4932284],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumberTrace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumberTrace"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    RowBox[{
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "\[Rule]", 
     StyleBox["\[Theta]", "TR"]}]}], "]"}]], "InlineFormula"],
 " finds the trace of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " over the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "\[Theta]", "]"}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->251581752]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->157587717],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->127903949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  RowBox[{"5", "+", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->604200087],

Cell[BoxData["10"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114361198]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "4"}], "+", 
      RowBox[{"11", 
       RowBox[{"#", "^", "3"}]}], "+", 
      RowBox[{"#", "^", "2"}], "+", "#", "+", "1"}], "&"}], ",", "1"}], "]"}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151246758],

Cell[BoxData[
 RowBox[{"-", "11"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70790721]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Integers and rational numbers:", "ExampleText",
 CellID->1216392566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", "2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2013020969],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73707409]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  RowBox[{
   RowBox[{"-", "2"}], "/", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1606475006],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["2", "3"]}]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1849842391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2140009798],

Cell["Radical expressions:", "ExampleText",
 CellID->1088555030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"1", "+", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->931200417],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1180307918]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->247893264],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->223812868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "#1", "+", 
      RowBox[{"#1", "^", "2"}], "+", 
      RowBox[{"#1", "^", "3"}], "+", 
      RowBox[{"#1", "^", "4"}]}], " ", "&"}], " ", ",", " ", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1379006579],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1128730487]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], " ", "I"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1002952795],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1850241058]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1805255463],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumberTrace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumberTrace"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->760339003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"5", "+", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], ",", " ", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"Pi", "*", 
       RowBox[{"I", "/", "8"}]}], ")"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404604487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "0"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1438253246]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2061341341],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Extension",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->190853506],

Cell[TextData[{
 "Trace of ",
 Cell[BoxData[
  FormBox["5", TraditionalForm]], "InlineMath"],
 " over ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    SqrtBox["2"], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1406213757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  RowBox[{"5", ",", " ", 
   RowBox[{"Extension", " ", "\[Rule]", " ", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1065034295],

Cell[BoxData["10"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->646374890]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumberTrace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumberTrace"]], "InlineFormula"],
 " is additive:"
}], "ExampleText",
 CellID->985596506],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "/", "2"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->431798215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AlgebraicNumberTrace", "[", 
   RowBox[{
    RowBox[{"\[Alpha]", "+", "\[Beta]"}], ",", 
    RowBox[{"Extension", "\[Rule]", 
     RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}], "\[Equal]", 
  RowBox[{"Total", "@", 
   RowBox[{"AlgebraicNumberTrace", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", 
     RowBox[{"Extension", "\[Rule]", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->479817075],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1650489704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2071876542],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToNumberField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToNumberField"]], "InlineFormula"],
 " to find the trace of  ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"2", "\[Pi]\[ImaginaryI]"}], "3"]], TraditionalForm]], 
  "InlineMath"],
 "in the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     RadicalBox["2", "3"], ",", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{"2", 
        StyleBox["\[Pi]\[ImaginaryI]", "TI"]}], "3"]]}], "]"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->2036075640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[DoubleStruckCapitalF]", "=", 
  RowBox[{
   RowBox[{"ToNumberField", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "3"}], ")"}]}], ",", 
      RowBox[{"E", "^", 
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi", "*", 
         RowBox[{"I", "/", "3"}]}], ")"}]}]}], "}"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99280480],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"9", "+", 
     RowBox[{"9", " ", "#1"}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["#1", "4"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     SuperscriptBox["#1", "6"]}], "&"}], ",", "6"}], "]"}]], "Output",
 ImageSize->{277, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->734186829]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"2", "*", "Pi", "*", 
      RowBox[{"I", "/", "3"}]}], ")"}]}], ",", " ", 
   RowBox[{"Extension", " ", "\[Rule]", " ", "\[DoubleStruckCapitalF]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->842214844],

Cell[BoxData[
 RowBox[{"-", "3"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36999341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1400447929],

Cell["The trace is the sum of its minimal polynomial roots:", "ExampleText",
 CellID->907571583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"MinimalPolynomial", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "/", "2"}], ",", "x"}], 
      "]"}], "\[Equal]", "0"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61631155],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SqrtBox["2"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox["2"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{173, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1225150204]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Plus", "@@", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351140780],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1026271192]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "/", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->832732613],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2098754887]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicNumberNorm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumberNorm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymmetricPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SymmetricPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldDiscriminant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldDiscriminant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->15335746],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->492828328]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AlgebraicNumberTrace - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 56.6891752}", "context" -> "System`", 
    "keywords" -> {"algebraic number", "invariant", "trace"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AlgebraicNumberTrace[a] gives the trace of the algebraic number a.", 
    "synonyms" -> {"algebraic number trace"}, "title" -> 
    "AlgebraicNumberTrace", "type" -> "Symbol", "uri" -> 
    "ref/AlgebraicNumberTrace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6429, 196, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->157587717]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22866, 860}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2234, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2857, 81, 1585, 37, 70, "ObjectNameGrid"],
Cell[4445, 120, 586, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5068, 143, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5546, 160, 190, 6, 70, "Notes",
 CellID->4932284],
Cell[5739, 168, 653, 23, 70, "Notes",
 CellID->251581752]
}, Closed]],
Cell[CellGroupData[{
Cell[6429, 196, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->157587717],
Cell[CellGroupData[{
Cell[6814, 210, 148, 5, 70, "ExampleSection",
 CellID->127903949],
Cell[CellGroupData[{
Cell[6987, 219, 171, 5, 28, "Input",
 CellID->604200087],
Cell[7161, 226, 207, 7, 36, "Output",
 CellID->114361198]
}, Open  ]],
Cell[CellGroupData[{
Cell[7405, 238, 355, 12, 28, "Input",
 CellID->151246758],
Cell[7763, 252, 175, 6, 36, "Output",
 CellID->70790721]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7987, 264, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8211, 273, 74, 1, 70, "ExampleText",
 CellID->1216392566],
Cell[CellGroupData[{
Cell[8310, 278, 117, 3, 70, "Input",
 CellID->2013020969],
Cell[8430, 283, 157, 5, 36, "Output",
 CellID->73707409]
}, Open  ]],
Cell[CellGroupData[{
Cell[8624, 293, 159, 5, 70, "Input",
 CellID->1606475006],
Cell[8786, 300, 197, 7, 51, "Output",
 CellID->1849842391]
}, Open  ]],
Cell[8998, 310, 126, 3, 70, "ExampleDelimiter",
 CellID->2140009798],
Cell[9127, 315, 64, 1, 70, "ExampleText",
 CellID->1088555030],
Cell[CellGroupData[{
Cell[9216, 320, 204, 6, 70, "Input",
 CellID->931200417],
Cell[9423, 328, 159, 5, 36, "Output",
 CellID->1180307918]
}, Open  ]],
Cell[9597, 336, 125, 3, 70, "ExampleDelimiter",
 CellID->247893264],
Cell[9725, 341, 321, 12, 70, "ExampleText",
 CellID->223812868],
Cell[CellGroupData[{
Cell[10071, 357, 373, 12, 70, "Input",
 CellID->1379006579],
Cell[10447, 371, 176, 6, 36, "Output",
 CellID->1128730487]
}, Open  ]],
Cell[CellGroupData[{
Cell[10660, 382, 293, 9, 70, "Input",
 CellID->1002952795],
Cell[10956, 393, 159, 5, 36, "Output",
 CellID->1850241058]
}, Open  ]],
Cell[11130, 401, 126, 3, 70, "ExampleDelimiter",
 CellID->1805255463],
Cell[11259, 406, 235, 7, 70, "ExampleText",
 CellID->760339003],
Cell[CellGroupData[{
Cell[11519, 417, 334, 11, 70, "Input",
 CellID->404604487],
Cell[11856, 430, 253, 9, 36, "Output",
 CellID->1438253246]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12158, 445, 223, 7, 70, "ExampleSection",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[12406, 456, 230, 7, 70, "ExampleSubsection",
 CellID->190853506],
Cell[12639, 465, 278, 11, 70, "ExampleText",
 CellID->1406213757],
Cell[CellGroupData[{
Cell[12942, 480, 231, 6, 70, "Input",
 CellID->1065034295],
Cell[13176, 488, 207, 7, 36, "Output",
 CellID->646374890]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[13444, 502, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[13685, 511, 214, 7, 70, "ExampleText",
 CellID->985596506],
Cell[13902, 520, 342, 13, 70, "Input",
 CellID->431798215],
Cell[CellGroupData[{
Cell[14269, 537, 522, 15, 70, "Input",
 CellID->479817075],
Cell[14794, 554, 162, 5, 36, "Output",
 CellID->1650489704]
}, Open  ]],
Cell[14971, 562, 126, 3, 70, "ExampleDelimiter",
 CellID->2071876542],
Cell[15100, 567, 709, 26, 70, "ExampleText",
 CellID->2036075640],
Cell[CellGroupData[{
Cell[15834, 597, 491, 16, 70, "Input",
 CellID->99280480],
Cell[16328, 615, 516, 17, 39, "Output",
 CellID->734186829]
}, Open  ]],
Cell[CellGroupData[{
Cell[16881, 637, 330, 10, 70, "Input",
 CellID->842214844],
Cell[17214, 649, 222, 8, 36, "Output",
 CellID->36999341]
}, Open  ]],
Cell[17451, 660, 126, 3, 70, "ExampleDelimiter",
 CellID->1400447929],
Cell[17580, 665, 96, 1, 70, "ExampleText",
 CellID->907571583],
Cell[CellGroupData[{
Cell[17701, 670, 387, 13, 70, "Input",
 CellID->61631155],
Cell[18091, 685, 433, 17, 51, "Output",
 CellID->1225150204]
}, Open  ]],
Cell[CellGroupData[{
Cell[18561, 707, 131, 4, 70, "Input",
 CellID->351140780],
Cell[18695, 713, 159, 5, 36, "Output",
 CellID->1026271192]
}, Open  ]],
Cell[CellGroupData[{
Cell[18891, 723, 222, 7, 70, "Input",
 CellID->832732613],
Cell[19116, 732, 159, 5, 36, "Output",
 CellID->2098754887]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19336, 744, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[19655, 755, 1037, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[20729, 795, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[21050, 806, 159, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[21246, 814, 318, 9, 70, "MoreAboutSection",
 CellID->15335746],
Cell[21567, 825, 156, 3, 70, "MoreAbout",
 CellID->492828328]
}, Open  ]],
Cell[21738, 831, 27, 0, 70, "History"],
Cell[21768, 833, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

