(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27401,       1021]
NotebookOptionsPosition[     21339,        811]
NotebookOutlinePosition[     22608,        847]
CellTagsIndexPosition[     22523,        842]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicNumberFields"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Algebraic Number Fields\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AlgebraicIntegerQ" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicIntegerQ"], 
          "AlgebraicNumberDenominator" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicNumberDenominator"], 
          "RootOfUnityQ" :> 
          Documentation`HelpLookup["paclet:ref/RootOfUnityQ"], 
          "AlgebraicNumber" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicNumber"], 
          "MinimalPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/MinimalPolynomial"], 
          "RootReduce" :> Documentation`HelpLookup["paclet:ref/RootReduce"], 
          "Algebraics" :> 
          Documentation`HelpLookup["paclet:ref/Algebraics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AlgebraicIntegerQ\"\>", 
       2->"\<\"AlgebraicNumberDenominator\"\>", 3->"\<\"RootOfUnityQ\"\>", 
       4->"\<\"AlgebraicNumber\"\>", 5->"\<\"MinimalPolynomial\"\>", 
       6->"\<\"RootReduce\"\>", 7->"\<\"Algebraics\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AlgebraicUnitQ", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AlgebraicUnitQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AlgebraicUnitQ"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " is an algebraic unit, and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
A number is an algebraic unit if both it and its reciprocal are algebraic \
integers.\
\>", "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2519453],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->274527504],

Cell[TextData[{
 "Test whether ",
 Cell[BoxData[
  RowBox[{"1", "-", 
   RowBox[{"6", 
    RadicalBox["6", "3"]}], "+", 
   RowBox[{"3", 
    RadicalBox["36", "3"]}]}]], "InlineFormula"],
 " is an algebraic unit:"
}], "ExampleText",
 CellID->182997880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", 
  RowBox[{"1", "-", 
   RowBox[{"6", " ", 
    RowBox[{"6", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "3"}], ")"}]}]}], "+", 
   RowBox[{"3", " ", 
    RowBox[{"36", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "3"}], ")"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4574886],

Cell[BoxData["True"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1354483834]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12658769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", 
  RowBox[{"Sqrt", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->984742062],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1483139838]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1561265014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", "GoldenRatio", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4967857],

Cell[BoxData["True"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1288566537]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Simple algebraic units:", "ExampleText",
 CellID->363159967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "/@", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}], ",", "I", ",", 
    RowBox[{"-", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15927634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1712691011]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "/@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"I", " ", "k", " ", "2", 
      RowBox[{"Pi", "/", "5"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->820659465],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->327017489]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->201157440],

Cell["Radical expressions:", "ExampleText",
 CellID->59173675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", 
  RowBox[{
   RowBox[{"2", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "3"}], ")"}]}], "+", 
   RowBox[{"4", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "5"}], ")"}]}], "+", "17"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->766805639],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->772284950]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "I"}], ")"}], "/", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->182625958],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->401992182]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1483870734],

Cell[TextData[{
 " ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->501764796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", "#1", "+", 
      SuperscriptBox["#1", "2"], "+", 
      SuperscriptBox["#1", "3"], "+", 
      SuperscriptBox["#1", "4"], "+", 
      SuperscriptBox["#1", "5"], "+", 
      SuperscriptBox["#1", "6"]}], "&"}], ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1609838684],

Cell[BoxData["True"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299049412]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#1", "^", "3"}], "-", 
        RowBox[{"4", " ", "#1"}], "+", "17"}], "&"}], ",", "1"}], "]"}], ",", 
    
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->736060597],

Cell[BoxData["False"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1011733504]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1075857913],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicUnitQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicUnitQ"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->1229914907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", 
  RowBox[{"{", 
   RowBox[{"I", ",", 
    RowBox[{"Sqrt", "[", "2", "]"}], ",", 
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", "5", "]"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2120704657],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "False"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->429484782]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["An algebraic unit and its reciprocal are algebraic integers:", \
"ExampleText",
 CellID->392159497],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"1", "-", 
    RowBox[{"6", " ", 
     RowBox[{"6", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "3"}], ")"}]}]}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"36", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "3"}], ")"}]}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177225740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicIntegerQ", " ", "/@", " ", 
  RowBox[{"{", 
   RowBox[{"a", ",", " ", 
    RowBox[{"1", "/", "a"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73193791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->658193507]
}, Open  ]],

Cell["The reciprocal is an algebraic unit:", "ExampleText",
 CellID->334698580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", " ", "/@", " ", 
  RowBox[{"{", 
   RowBox[{"a", ",", " ", 
    RowBox[{"1", "/", "a"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->803058356],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->570006452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1420129440],

Cell[TextData[{
 "An algebraic unit has norm ",
 Cell[BoxData["1"], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19487],

Cell[BoxData[
 RowBox[{
  RowBox[{"al", "=", 
   RowBox[{"{", 
    RowBox[{"GoldenRatio", ",", 
     RowBox[{"1", "-", 
      RowBox[{"6", "*", 
       RowBox[{"6", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}]}]}], "+", 
      RowBox[{"3", "*", 
       RowBox[{"36", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}]}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->641849141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "/@", "al"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->269357289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->173889497]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberNorm", "/@", "al"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->191825393],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1983016159]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1824215608],

Cell["\<\
An algebraic unit raised to a power is again an algebraic unit:\
\>", "ExampleText",
 CellID->2115179084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"AlgebraicUnitQ", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "^", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->370572350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1753866520]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicIntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicIntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicNumberDenominator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumberDenominator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootOfUnityQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootOfUnityQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Algebraics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Algebraics"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->833130001],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->174049269]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AlgebraicUnitQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 57.5641976}", "context" -> "System`", 
    "keywords" -> {"fundamental unit", "unit"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AlgebraicUnitQ[a] yields True if a is an algebraic unit, and yields \
False otherwise.", "synonyms" -> {"algebraic unit q"}, "title" -> 
    "AlgebraicUnitQ", "type" -> "Symbol", "uri" -> "ref/AlgebraicUnitQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6338, 187, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->2519453]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22382, 835}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2587, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3210, 89, 1579, 37, 70, "ObjectNameGrid"],
Cell[4792, 128, 863, 28, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5692, 161, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6170, 178, 131, 4, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[6338, 187, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2519453],
Cell[CellGroupData[{
Cell[6721, 201, 148, 5, 70, "ExampleSection",
 CellID->274527504],
Cell[6872, 208, 252, 10, 70, "ExampleText",
 CellID->182997880],
Cell[CellGroupData[{
Cell[7149, 222, 346, 12, 28, "Input",
 CellID->4574886],
Cell[7498, 236, 210, 7, 36, "Output",
 CellID->1354483834]
}, Open  ]],
Cell[7723, 246, 124, 3, 70, "ExampleDelimiter",
 CellID->12658769],
Cell[CellGroupData[{
Cell[7872, 253, 141, 4, 28, "Input",
 CellID->984742062],
Cell[8016, 259, 163, 5, 36, "Output",
 CellID->1483139838]
}, Open  ]],
Cell[8194, 267, 126, 3, 70, "ExampleDelimiter",
 CellID->1561265014],
Cell[CellGroupData[{
Cell[8345, 274, 118, 3, 70, "Input",
 CellID->4967857],
Cell[8466, 279, 212, 7, 36, "Output",
 CellID->1288566537]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8727, 292, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8951, 301, 66, 1, 70, "ExampleText",
 CellID->363159967],
Cell[CellGroupData[{
Cell[9042, 306, 212, 7, 70, "Input",
 CellID->15927634],
Cell[9257, 315, 237, 7, 36, "Output",
 CellID->1712691011]
}, Open  ]],
Cell[CellGroupData[{
Cell[9531, 327, 324, 10, 70, "Input",
 CellID->820659465],
Cell[9858, 339, 252, 8, 36, "Output",
 CellID->327017489]
}, Open  ]],
Cell[10125, 350, 125, 3, 70, "ExampleDelimiter",
 CellID->201157440],
Cell[10253, 355, 62, 1, 70, "ExampleText",
 CellID->59173675],
Cell[CellGroupData[{
Cell[10340, 360, 294, 10, 70, "Input",
 CellID->766805639],
Cell[10637, 372, 162, 5, 36, "Output",
 CellID->772284950]
}, Open  ]],
Cell[CellGroupData[{
Cell[10836, 382, 214, 7, 70, "Input",
 CellID->182625958],
Cell[11053, 391, 161, 5, 36, "Output",
 CellID->401992182]
}, Open  ]],
Cell[11229, 399, 126, 3, 70, "ExampleDelimiter",
 CellID->1483870734],
Cell[11358, 404, 327, 13, 70, "ExampleText",
 CellID->501764796],
Cell[CellGroupData[{
Cell[11710, 421, 408, 12, 70, "Input",
 CellID->1609838684],
Cell[12121, 435, 209, 7, 36, "Output",
 CellID->299049412]
}, Open  ]],
Cell[CellGroupData[{
Cell[12367, 447, 422, 14, 70, "Input",
 CellID->736060597],
Cell[12792, 463, 211, 7, 36, "Output",
 CellID->1011733504]
}, Open  ]],
Cell[13018, 473, 126, 3, 70, "ExampleDelimiter",
 CellID->1075857913],
Cell[13147, 478, 224, 7, 70, "ExampleText",
 CellID->1229914907],
Cell[CellGroupData[{
Cell[13396, 489, 260, 8, 70, "Input",
 CellID->2120704657],
Cell[13659, 499, 273, 9, 36, "Output",
 CellID->429484782]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13981, 514, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[14222, 523, 105, 2, 70, "ExampleText",
 CellID->392159497],
Cell[14330, 527, 357, 13, 70, "Input",
 CellID->177225740],
Cell[CellGroupData[{
Cell[14712, 544, 195, 6, 70, "Input",
 CellID->73193791],
Cell[14910, 552, 209, 7, 36, "Output",
 CellID->658193507]
}, Open  ]],
Cell[15134, 562, 79, 1, 70, "ExampleText",
 CellID->334698580],
Cell[CellGroupData[{
Cell[15238, 567, 193, 6, 70, "Input",
 CellID->803058356],
Cell[15434, 575, 209, 7, 36, "Output",
 CellID->570006452]
}, Open  ]],
Cell[15658, 585, 126, 3, 70, "ExampleDelimiter",
 CellID->1420129440],
Cell[15787, 590, 190, 8, 70, "ExampleText",
 CellID->19487],
Cell[15980, 600, 435, 15, 70, "Input",
 CellID->641849141],
Cell[CellGroupData[{
Cell[16440, 619, 107, 3, 70, "Input",
 CellID->269357289],
Cell[16550, 624, 209, 7, 36, "Output",
 CellID->173889497]
}, Open  ]],
Cell[CellGroupData[{
Cell[16796, 636, 112, 3, 70, "Input",
 CellID->191825393],
Cell[16911, 641, 223, 8, 36, "Output",
 CellID->1983016159]
}, Open  ]],
Cell[17149, 652, 126, 3, 70, "ExampleDelimiter",
 CellID->1824215608],
Cell[17278, 657, 115, 3, 70, "ExampleText",
 CellID->2115179084],
Cell[CellGroupData[{
Cell[17418, 664, 330, 11, 70, "Input",
 CellID->370572350],
Cell[17751, 677, 322, 9, 36, "Output",
 CellID->1753866520]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18134, 693, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[18453, 704, 1782, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[20272, 771, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[20593, 782, 159, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[20789, 790, 319, 9, 70, "MoreAboutSection",
 CellID->833130001],
Cell[21111, 801, 156, 3, 70, "MoreAbout",
 CellID->174049269]
}, Open  ]],
Cell[21282, 807, 27, 0, 70, "History"],
Cell[21312, 809, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

