(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52511,       1437]
NotebookOptionsPosition[     48153,       1289]
NotebookOutlinePosition[     49505,       1327]
CellTagsIndexPosition[     49419,       1322]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"], 
          "Redrawing and Combining Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RedrawingAndCombiningPlots"], 
          "Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Options for Cells\"\>", 
       2->"\<\"Redrawing and Combining Plots\"\>", 
       3->"\<\"Tables and Matrices\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BaselinePosition" :> 
          Documentation`HelpLookup["paclet:ref/BaselinePosition"], 
          "Alignment" :> Documentation`HelpLookup["paclet:ref/Alignment"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"BaselinePosition\"\>", 
       2->"\<\"Alignment\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Combining Graphics\"\>", 
       2->"\<\"Graphics Annotation & Appearance\"\>", 
       3->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AlignmentPoint", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AlignmentPoint",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AlignmentPoint"]], "InlineFormula"],
     "\[LineSeparator]is an option which specifies how objects should by \
default be aligned when they appear in ",
     Cell[BoxData[
      ButtonBox["Inset",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32651]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 " has ",
 Cell[BoxData[
  RowBox[{"AlignmentPoint", "->", 
   StyleBox["opos", "TI"]}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    StyleBox["pos", "TI"], ",", 
    StyleBox["opos", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->32765],

Cell[TextData[{
 "Typical settings for ",
 Cell[BoxData[
  ButtonBox["AlignmentPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlignmentPoint"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->19601],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], Cell[
    "ordinary coordinates in a plot ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "scaled coordinates from 0 to 1 ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["ImageScaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImageScaled"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "scaled coordinates from 0 to 1 across a whole image ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Offset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Offset"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["dx", "TI"], ",", 
        StyleBox["dy", "TI"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "absolute offset in printer's points ", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"]], "InlineFormula"],
     ", etc. "
    }], "TableText"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{"Center", ",", "Center"}], "}"}]], "InlineFormula"],
     ", etc. "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->17209],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates can be numbers, ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Axis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Axis"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1497],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinates can be numbers, ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Baseline",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Baseline"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Axis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Axis"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27283],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Axis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Axis"]], "InlineFormula"],
 " corresponds to the position of the axis in a plot, or the center line in \
typeset text. "
}], "Notes",
 CellID->29250],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " corresponds to a position centered with respect to the whole image. "
}], "Notes",
 CellID->18058]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->28975008],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->344676785],

Cell[TextData[{
 "Specify the coordinates within ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 " to be aligned with the center of the enclosing graphic:"
}], "ExampleText",
 CellID->642016114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Inset", "[", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"Circle", "[", "]"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", "30"}], ",", 
          RowBox[{"AlignmentPoint", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"a", ",", "0"}], "}"}]}]}], "]"}], ",", "Center"}], "]"}],
       "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "70"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149359173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[InsetBox[
     GraphicsBox[CircleBox[{0, 0}],
      AlignmentPoint->{-1, 0},
      ImageSize->30], ImageScaled[{0.5, 0.5}]],
    Axes->True,
    ImageSize->70,
    Ticks->None], ",", 
   GraphicsBox[InsetBox[
     GraphicsBox[CircleBox[{0, 0}],
      AlignmentPoint->{0, 0},
      ImageSize->30], ImageScaled[{0.5, 0.5}]],
    Axes->True,
    ImageSize->70,
    Ticks->None], ",", 
   GraphicsBox[InsetBox[
     GraphicsBox[CircleBox[{0, 0}],
      AlignmentPoint->{1, 0},
      ImageSize->30], ImageScaled[{0.5, 0.5}]],
    Axes->True,
    ImageSize->70,
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{251, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->303642548]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Inset", "[", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"Circle", "[", "]"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", "30"}], ",", 
          RowBox[{"AlignmentPoint", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0", ",", "a"}], "}"}]}]}], "]"}], ",", "Center"}], "]"}],
       "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "70"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->361327031],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[InsetBox[
     GraphicsBox[CircleBox[{0, 0}],
      AlignmentPoint->{0, -1},
      ImageSize->30], ImageScaled[{0.5, 0.5}]],
    Axes->True,
    ImageSize->70,
    Ticks->None], ",", 
   GraphicsBox[InsetBox[
     GraphicsBox[CircleBox[{0, 0}],
      AlignmentPoint->{0, 0},
      ImageSize->30], ImageScaled[{0.5, 0.5}]],
    Axes->True,
    ImageSize->70,
    Ticks->None], ",", 
   GraphicsBox[InsetBox[
     GraphicsBox[CircleBox[{0, 0}],
      AlignmentPoint->{0, 1},
      ImageSize->30], ImageScaled[{0.5, 0.5}]],
    Axes->True,
    ImageSize->70,
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{251, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6896783]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10700],

Cell[TextData[{
 "Specify the position to be aligned in 3D Inset, using ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ",",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->79404433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Inset", "[", 
       RowBox[{
        RowBox[{"Graphics3D", "[", 
         RowBox[{
          RowBox[{"Sphere", "[", "]"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", "50"}], ",", 
          RowBox[{"AlignmentPoint", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"a", ",", 
             RowBox[{"1", "/", "2"}]}], "}"}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->27695968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[InsetBox[
     Graphics3DBox[SphereBox[{0, 0, 0}],
      AlignmentPoint->NCache[{0, 
         Rational[1, 2]}, {0, 0.5}],
      ImageSize->50], {0, 0}],
    Axes->True,
    ImageSize->100,
    Ticks->None,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztmPlXFFcWx1sBTTRmTGKMk/FkMn/AQ2OMyUwSJzmJmuSkhBhDQBMn6GNV
IksIEBSQRSCyqq2ERRbZBEH2RUwDsm+hkR1ZbWhAdhsamq7vmaluGodpG4P5
ZebMSZ/qqnqv7vJ5t25V3fcY4+/MTayMv7M4ZvzqPltja3OLY3av7j1py3Vp
reLxeJT7W23hcef/5M6UfwqAu7DM/jXFXouTg/LH2/577/9R71+43WpTU9MN
Gq++wu20uKs8Le6EOyr6ntEouVVlR1t11Cz1surqmsdKvaTy+pSyf8GtAmK9
RukXVbaUV7UXpBcU1mmUf15lfcMK5Teq7CuOPJ2H8iqmpzXqPKvSeX7JCBSn
q9XaazRqr1cRbvpN2k+rfL+kJq2l1tbRqL1Wpf3H36S9Rk1K3Yq2pvYjVnSW
RvypA4RSQm0IPU2oJ6F+hPoTeo5QjUTqxBptL80pZQb+gSH0S6UbW0LdCP2R
UD6hEYTGEppEaCqh6br0BqFXCFXorF25p0fzayPny5BQC0IdlOMJIjRU6ShZ
l2bq0vxtVLCTluykZbtoxU6q9hQ8zIJHvKlHVj1XdBZ96y+6d1x0H0ZoHDdI
XZqzg/78Ji19m1a/R+s/oI176OqWfVRppeqvVFOMV8aifqeU7c0cix6hRlxI
CbUnJu7EIoCcCCUnY1+zSdllm/uWnWC3XfmHtnUf2zQy37YdONH1hUWvoYnI
SBGTPgPavp+qZ9uqFdFo/+d9UeQah8LbfJDQo8TSmpx0Id+d2+Z4abtz9A7X
5Lfcsna7Cz70KPvEvU7fvcnAreOwS+8/nAeOOQ6b2o2an+TsjFvQ+ya095CS
ZxXXoeBYGYsynlsX2hyEcrM8RKwtiaMjcfEiHue3e0fsPJf4t4D09wMLPgoq
1Q+uMQhu/Cqo42hgr5m/+Pi5kZPeE7buEnsXzsiso/X09+YPbGm/CdV5YhZl
NP+kRDBhiJU+cTAmrjbE23Wbv99rwZd38WN2h6TsCcv5NLzw84iqw5FC4yut
ZhE9VhEDtqEj34dM/MCfdgmWnfHnLM57uso97efdT0hPUd7SqKyQYqsS4eQB
4mxIvM1JgAPhe+4IDd4VGfHu1YS9cen7EwsMrpV+nVRnktx0PKnTJknkcG34
VMLEmbhpr5hZ3ytyv1DOIhsUwAZ5sYHOrJ+V1J0qclV7WQ71HFVy/FkZjW8Z
4naQnDtC+FYk/NS2GJ83E/h/T47al5qsn55tmCn4JrvCLEf4bW6bfU6Pc47Y
LXvUK1PyY7o0MHXufBJ7KUGBEhaGsAsI+xE/ncZFqx57uvhRXT4yGoleYYg5
Q1wZEvAlCTmqG23zeqLbrlS/3Rkh+3Ji9W+mGt3KMxYUWxRVWxc1OhR3nC6+
51E07Fs0ESCQXrg1F5I/H56DyAyF0dgExEchPgSxfoh2YS+baf8mmh8Y4s+Q
sEMk1pSk2L+e6fFOfuDen8P0i+ONStOMKwosq0ptquucaprdarvO1vT71Yyc
r35wuXIuvGI+qlQeW4zEnxVGUzNx4zrSYnEjFNf9Eee4mL+/TqKjulNmDPFl
SChDEox00yx25Dm8LfDaU3JerzLCsCbR+JcMS+Et2zvlTk2/uDW3ejd3BzSL
LzaP/dQkibwzHyuUJ/7CXq9BWoXCbo4AebnIT0NeHHJCkebNe0KaV5VxucSQ
eD2SfnjHzeNv3XZ6v9L707oLBg2R3zQlWbRl2XQInDorznQJfbrbAnt6+d2D
Yd3j0V0z8Z3y6x1sWiub1YS8BoVdQSWKilF8E8VpKIxDAZ9NcdB+Yh4fhkTv
J2mfk4KvdpSeeLfmh48bfA628I90RJl1J1v3ZTuJCs/0V/qIhYGD7ZcG+8IH
h2IGJxLF0pR+NlPE5vayBV0o7FDYLROiohpVJai6iYobKI1ic73+zXOMQ9FM
prF64b4CEQzJYnRvf/5G7ZHdzVafdDob3PMxFvOPj0TZjye7TGWflRQGTFfy
pQ3h0vars31J0uE06WS2VFowLS+SsKWTimeaM9bcidYmtNaipRh30lERsnyM
NJK8wJAYhhQw26o+29V05MPOE5+JnL8e9jEbv2jzIMp5JtlzLttPXniRrQxH
w1W0X0NfGoZyMHFrwRRvHepn0PgALeMKw3dF6OpEVyM6K9GWj7rIJ6ThKpJ4
hhQx24V679w9/LHo+JcjTkcnva1mLjjIIs/Ik3zZrPOsIJStiIYwceFzxtsw
U4H5WpYVsmiWo12Gzhn0TCoMi0QQdeBePboL5+ujl6ndNHI8w6UNQ8qZnc16
7/UZ7b9vcXjK0WzWy1YWfGo+4iybGMhmXmaV49/Ymo2eAoiLMVaB6VrIGoAW
Fh0suuXok6FfCrESZqgX4ib0lWiuXtUplLXWU4xuJfNGh/4HYqMDE6bfzNif
kHk4zAedWfD8QkEsSpNRl4nmfHQVob8cI7V40IDZFrB3gR5AxEIsx7AMIzMY
Vd6g++2c3DIVtEYGHYZUMju7mL33vzCQHKVzC3d9c0ggYkOQGo28a7idhupc
NApwtwz3ajAsxGQLpHch5wj6gUFgBBhjMTGHKQkmhzkDsv6yJQw6DxmwUJ0q
K0Ythgg4z4q2oirmbbGywylX+PqCfwFR4UiOQ3YKCrNQeQvC22irQk89xM0Y
64CkB3P9YIeAUWACmAIkLKalkIxyltY+xrOi6lRm1Vbmo3G9QzJDC5h/Dwd3
ePkh+BIiopCYiIx0FOShtBB15WiqQ2cjRO0Y7saECDNDkI1CzvmUADNgpdw2
x06PzY61q+Z/y3lWZKeWaibJe5nZM8ockn9hyR51hI0nXAPh9xNCruJqMlKy
kFuAIu5FVA2hEG0t6OnEQB9GxJgcwcwE5h5AxrmehXyO2+alkvvqd1brMRyr
VRxrFzje7WcM5/QsWCNHWHrBKRhnw3A+DldSkZiDDAEKylFSh5pGNLajowe9
/RAPY2Qck1OQzGBmFrMySGWsZHZ2YLxP/S29pI7WXsqhtTiv3cLoTzGm8oMO
MPaCdTBcw3EuHpfTEJOH60XIroSgHuXNqOtEUx86BtE7goFJDEswKsX4HMa5
1J+T902Nq1fwq5bx/HBNYDNzZJaxg4EHTINgHw6PBASmIzQf3Lc7tQq5QhS2
orwLdSI0DqF9DF1T6JuGSIr+OfTNom1KurI6XT0mynFvYsyx3wWH/GERCsd4
eKUhOB9htxFXhdQG5LRC0I0yEaqHUD+Gxkm0SNA6jeZpVI/NK3L412vghyPd
uN8ThnxYxsAxBV65CCpCaCWuCnG9BZldyL+HwkGUjKB8HBUTKBnDejyuYlIf
tXI8zzLu7IEQmCTALgNut3CuDPxaRDQirh1J3bhxDxkDSB9ATOf8Biz3xVic
oyvnrusWPHx2BfQGbG/i9G14VcGvHgF34FuP5zSyPa3Gpt7eolFrnZqU+sxU
s9Z6Fa269Iuq/H5UY4OapPocQbGqong3aZ53L669qGs9q9Jaq1FL8+qOgl1n
8Rl8ROc5laelq2NrVF42atR4QaWhpZLapFFqk+qq5nj+L6wa/t773+t9/Go9
b9W/ALHGVnU=\
\>"]], ",", 
   GraphicsBox[InsetBox[
     Graphics3DBox[SphereBox[{0, 0, 0}],
      AlignmentPoint->NCache[{
         Rational[1, 2], 
         Rational[1, 2]}, {0.5, 0.5}],
      ImageSize->50], {0, 0}],
    Axes->True,
    ImageSize->100,
    Ticks->None,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   GraphicsBox[InsetBox[
     Graphics3DBox[SphereBox[{0, 0, 0}],
      AlignmentPoint->NCache[{1, 
         Rational[1, 2]}, {1, 0.5}],
      ImageSize->50], {0, 0}],
    Axes->True,
    ImageSize->100,
    Ticks->None,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5508554]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Inset", "[", 
       RowBox[{
        RowBox[{"Graphics3D", "[", 
         RowBox[{
          RowBox[{"Sphere", "[", "]"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", "50"}], ",", 
          RowBox[{"AlignmentPoint", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", "a"}], "}"}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->238949188],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[InsetBox[
     Graphics3DBox[SphereBox[{0, 0, 0}],
      AlignmentPoint->NCache[{
         Rational[1, 2], 0}, {0.5, 0}],
      ImageSize->50], {0, 0}],
    Axes->True,
    ImageSize->100,
    Ticks->None,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   GraphicsBox[InsetBox[
     Graphics3DBox[SphereBox[{0, 0, 0}],
      AlignmentPoint->NCache[{
         Rational[1, 2], 
         Rational[1, 2]}, {0.5, 0.5}],
      ImageSize->50], {0, 0}],
    Axes->True,
    ImageSize->100,
    Ticks->None,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztWHlUVNcdJqDZmrTa5NikxsSkaZO0vRCjJjHtaUzjMTbNQzQuRKNGeEMQ
AQmLAcEQQdlkVVAUQSKbgAyLLCOyDcGRRQFZZd9hkHVYhmXed9r33gyIw6ix
f+X05J2Ze+697/f7vu/d3+/cjdprayqw2Gu7z3jv8k+s91qZ7jO2Wb7+gDXb
pfOYlpaWgP1bvKDF1v/D1vi/AAD74j7lCq7UYe3AP8r2L73/J70L+LZAIFC1
/3zXasGsFfssZE3+Mu+dgH905mCwpQrj7ZleLunY8nG2rc1WlG91VS0t3pkH
4y3m4rzFv/qrylJHTflCjdZcyXUu1GS9YPY72cqbvP0bKvQnNdkvnLVXcbzB
+7yu4nj6EXxeU/E8+4Cv4Kraau3Xee/lKu/fPMRbR639B957mUrv4v/JWz1j
1L3UM+g13uulmV4TExOuyitfuJ3QpoS2JTQL58aW2j6EVvfXjLf03vixqM/w
sBsJvYMHPUhoF0L78NDnCR1N6HhCJxI6WZcWEloViyfUsF+9i31P3Fh4rae4
3sUUofUJvYvQFoQ+RGgPQp8g9DmeJUGXTtOlr75N566mC1bTEva3iuZYnlRj
WX6XZV6klcMzO67Ps3ybZvgcCe1O6EBChxE6hqcUraJz19CSv9MlH9Hl6+jK
9XTNBo6y6mM6ZxX9+E/i1VHj5dtLWN7NhN5JaDNCOxCTY8QsgFiEEqvod75J
es+Gpc5ba1O43rr0U6uqjZb1n5s3b/u6zZCj7jCkW7bQ5evnsb+ikZ2P7oJZ
dvbRZqm1lhgSgYDstyVWLsTOV8/hzAqnyHechR8cyVjrwpJf/8ylbPOR6u3f
N3x5uO0rx276YK+JNQs6uO/rAVO615iu30qr56Vmft5qqZKfJWZ/BsR8N7G2
JIccibMnORq0wiN89fH4v/mmfuyX/WkAS37TMKB6t3+jsV+7qXePhVe/lduw
zREWcfxbuwl7yzE7k6EDtJb617/Ms/9erZfPv6U879cUObCVOAjIETvi6aLn
67fi5Nn3T0WtPZO0/twV/dD8rWEsdYVRWJ1paKvluW6bs/32wcOOgePO/lMu
x1lExbHDiqM2U0fMRh3msy+7P/tLFDHVJzafE+cviac58XfUPe2+MiTw/fDz
H0bEbYhO3XQx2zBWsieOZa8xj2u2ieu0j+07HCNziRp3+2HSM1Thc4ZFZPy9
GX9Xxs9e4WU25ERzucyl1MM18EqXUURAERt94rqd+BiRU9+QUOcVEd5rLgZ/
dCniX4kJm1NEO1LFRmnF+9JZGfUH09uc0qUuqYPuKWPeSRP+CVMnY3E6ipMR
chYhAQjxQLCDwt9US5vVoD6LPUDHy2wMKHLUgAR8QUJM9CLsVsW6vpfovzY1
5NOM6M8zk3dmXzXOLdifd8NazOpodBZ3Hsvr88qV+WdPBGVNnREpQtMQnsyB
RkUjOgzRQYj0xHn7EZ95s5pmFXw2vsLnwxGKBBiQsF0kxkwv0f7dNLcPM09s
yAnbnB+789pl+nq2eZHEprjsUAkrpMW9pNu3ZOBk8Whw4XSoZPqHHxVReYjN
4nCFKUiMQ9IFCE8j3gPhVvPm0wcrsaWIH0XC9EncLr0Ui1WZjv/I9dxwLWhT
UfjOG/F0WZr5rVzbykLHqlsu1aySVr9qaVDVUEjleHiFIqpcEXuTERYjWcLh
pmdBlIYrCRBdQFoQhEceUclRioRQJNaApO5ZmXXgg4LD64q8Npae+qLiglF1
wv7bGbb1YqfGItemCq9mVkn76ebe0ObhiKaJiw1MQh2TXMOkVeFKOYebK0Fe
LsQZEAuR8wNEfvPWMH610npRU44sZ+NCkeiN5PIWkvPVaonV2pvffVZxfFtt
8N6GCLNmoU1bhmOH2LWr2Ku7MqCHVdIR1nMnskcW1zWR2MmktjOiFia7CXl1
HK6kDIVFKBKjSITr8RCfHb9krT4qSi3GLJL2/VWx83UkRUSU3rVt75UZ/bPW
Sr/J+YsOb1oabNkf8e2Q8HuZyGM033+85LS8MkzOqYqX9yXLZRnjk1ljjHiE
kQzrKBfEylbU1KO2ArVFqM5B+SVG7DMvUg8Yn99SJJ4iedTbN7asqTH6pNlq
S9d3X/UdNxs6bTsacVgudJsS+SrEp5jiUFRGcju9jmTcEYFbyrWeRvkYqmSo
7edAG9vQVI+mW2i4htrU0TyvR1CxiCKJFLmmv7LS4MOmPVTXgR39hwUyLyv5
qUPTF1wVCd5MRiCTd44pikBFHKeC33s+O/wjJgqhuMkwFQxqFKifRNMoWgY5
9I42tNeirQQNmY+SL89Q5DJFSqh36zat69i1uc9iz4ij2aSn3XSQsyLcg4kP
YNLPMPzYL2JltGVD+iOGCjFeiukKoJZBA4MWBdqn0DWOHl6JtAld5WjJ1qzi
BbVefpZ/iiKXKL1S6v2mzZ9Id26TmRnLHQ5MuTkoTh5llJvy57KjIRGiLJUb
jRYxugsxcBOjFZiqBRqBVqCTQc807kyifwz9fIh6qxStOfNWm6UadfC7oAWU
bim1po3694DhjjE+5kvY+TrmLJIjcDUeBSm4eYUT0CRB5w30VUBWi4lGMG1A
FyAF+oFBBYYnIJNx0P21Y01XHoGfXWmKBTOPkRm+OQhnF3h7IzgIEWEQxkCU
CHE6irM5FfUlaLsFaQ0GGzDWimlWQi8wAAwBI8DoNMZGMSLVtJPUrIFTyo/2
Mm4QKNmm3YovzWHuAMdj8PBD4BmEX0BcPFIvIycTEjEnoqYUzVXoqkdfC2Sd
kPdiagCKYZYeGAcjZ39yZrR3SFo6c6p6uA4dlQ5+bVxKrbxNfSbT36MwtGRM
HGHnDtcT8DuHkChEC5GUjivZyL/GaamsQP1ttDWjpwMDUoz0Qz6MyVFMsyom
MT0JxYR8bKRr3qlFfQ2+jyq2yo/ji9T6PmrXlIEls9sJlh5wCoRnGIJiEJ6E
eBFS85BdyMkprUZ1Axpb0d4N6R30D0E2gjE5xicxMQX5lGJ4fHTe3KWuTanl
d2zJ5eOvuNYL1PZxaj+2O0LgCdtAuJyHbyzOpiAyE8J8iIo58sJalDWhpgON
UrT1o1uGO2MYmMDgFAam0Cufruvv/Gnc3DjMngWXUAKFvj12uGN/IBzOwy0W
Jy4j9CpiCpBUwhGL61DYgrJOVPeifhDNMrSPo2MCnZNolaNqcFg9B9RZ+RV2
3jrLf/kiyhKbXLA7ABahcIqFRwoCsxBWgIs8tagOeS2QdOFGL8oHualau2aM
RakcRb5UNjvbzDvzKmcm9b03z7iYsmEMPLErGJZRcEyCRyZO5iOUH2LhbaQ1
42oH8qQo6IdkENeHkD+g8rzn9K5keGnuSD5LeWH7OeyLxbdpcM2B73UO83w1
ohtwqQWJHUjuQmIXtH49R9ddtS+rqeVP90/PnlS2RmJfCuyyOEz3EviUw7cC
izUivaJSpbwfUDtpzTlJP6eyU3q9qsb/xEO8n9cY5Zl7hod5L1Ll/zLe63U1
rAUP8X5G5a08P/9RzVvjCXOON6eNSxneT+tPmHu/c38vHRWn8v7ozXszgnWb
e+PDxYITpMvbvoWZu6Y56HxbeTXFtZW3Y9wN1+w8+TO7qful9+fW++B7c63H
/gseR+6T\
\>"]], ",", 
   GraphicsBox[InsetBox[
     Graphics3DBox[SphereBox[{0, 0, 0}],
      AlignmentPoint->NCache[{
         Rational[1, 2], 1}, {0.5, 1}],
      ImageSize->50], {0, 0}],
    Axes->True,
    ImageSize->100,
    Ticks->None,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztWGlUFFcW7hjNZmaSmGQmi4lmkpNlcp5xiR7jJLNwEmOWImg07iimaAUl
4AK4oBgBWcQFEBBlaQRBoREURBYFWRQalE2FRqFlp5sGbJqtl/rOTFV1G5yy
4zIz/yZ9uqvrvnfv933v3VtV7xVlt2mNvZPdJocf7SZ+ucHOZY3Djxsnznbe
wDY9/phIJLJnf06viNjzf7Jn/G8ygFFisfhJ9l/0OHvC/rNH0QecLSLskWt8
2mLvh+bYZzlrtKnX5PA+3/++Ofr3nDXml34zxnu8z7tmjBfu4/OO2efFu1Rw
p6ME9ju891tm1t/xvewYzb1jHip6gpnr+QdEPy6w3+ajx5u5xz0gerTA/tMv
0Xe3/uco3Aie46xn5hPantCuhN5JaBYpmNCHCR1NaAl/FM6BkOGte3RxWRnL
2c9ThP6e0HaEdib0dkL7ETqYp4gntJTQpyfTZz+icyfRuVPo7Em0oMJGsF+3
mHe+3saxDDY8wwZCexJ6D6HDCB3Dk5yaRmdNo/On08Uz6bJZ9OXP6IrPOJJL
02ghz8QRnvtkn5/Ll1lGa0Kzc7aSH9YOQgdwpKslUxxOTHVkeXM+cSz8zFFm
taZytvja17Scom9+x/E2WNO1c2iRkHuCRW5h7XBaRrHUopfZCbUl9DqyZitZ
50tcQsjGGOJ+fOrm0zO3sOSFn28t+3pLtc3muvmuDYs2Ni9zbrNd27mSBRJ3
rqCbF9OiJx6Knx/r6LvnnGf/wxLiuJq4uBI3L7Jt/2TPwx/vOjZjd+qnvlmf
+7HsMhv/qh/86pb5Nq70abXfpXTY0b1uq8bZlcXRujhonGiVmBbyv2mRn6+y
8SabJabIGmviYkvcnYmnB/EJIAGhU/dJZgYl/+1gxuzQ89ZhLHnF0vDrdmGN
q0Nb14Wo1gf1uu7VbvYf2ubNguh3uOk8nIa2intcaGH9WubnVY7nmR2/I5sW
EE8x8XUl+3ZNDdn/8aEjsyKPWUWnfR2bPTeucHEcS35VHH9jXVzzhqOd7pIe
j2jtziODXuGG3cEsojFgtzHAg/Ffr/NardxAc5nliEzz/pqA90kzrwNFNs8j
3svIvrUkdBuJ9J0mOTjrWIzV8RPfJGfMTzm/9OSlVaksb61LmsIttd3jpHqn
tM8naSAgUbc3HkESFpEJDUHYHib0ZwRv1PuLORJhRb9hUQM/9jcpIqaIuzXx
W0iC7cgRl8lHPace3/MXafjnaXHfZqQsyDy7PLvAPke2LpeVUb8lt9kzV+mT
0xuQNbg/UxeSrg9PxWEpBxoTC0kEJAcQ7Y2IjRpfWnhPur+KDRTxtSahi0mM
/aTETdNSds3M2G+Vdfjb3IQF+WnLC3LERUVOxZc3XWRVNOy61OZ3Ub23uC+4
aPhQgT4yzyjJRfxZDvSEFEnHkByFE0FI8EaU08Op4KtlAl8HXhQJpUjsEpLk
MCndfWaWzz/ygr4pjJp/6bit7LS4/NxPVy66VVZsr2SFKAKqOg5U9oRV9B+5
opeUG+NLjccvQlrA4Z4+i/RTyDiB9GicCkLSjnvuqOPvq2QTRYJYGRRJWTrl
zNrp57f8tcj3q9KQ7y/HLKtKEl/N+Ol6nltdyXZ5lXc9q6QpuL7zUH1vlHww
rtZ4/LpRWsOkVSKjnMPNKURuLs5n4FwScqJwJvBRlEzkJySSItK55OzyqflO
s0q2fXHZz6Y6dGmthK5Pdmo446rI395U6tNcHdjCKmmOaFHGtNw+1jyUdItJ
VTAZN5ksOXKvcbgF5Si6iIt5KM5A0QnkRRhTtwjzY9LyqqUqYbUcoEiiNcn8
nlywnSFzsqr0oGr9F90IW6WIXdss3dSe6dF5wVspC+yqDulitbRI1KqELo1U
NXRKyWR2MDltTH4ziho5XNk1lFfgcgku56H8NErimOzdj6blMEXSqEn5P0wv
XfFp9U9z5NvnK/xtW8IcOmM3dEm39WR63b6wRyML0dZEaDktif2qFK3mtHY4
S8Ocv80UdOOSCrJ2DreyATV1uFqJqyWoyUWFlCk48AhaXqJIHEWyqY8uzZte
vcKq3sm6yWNJh799V5hzb+xmrfTngUz/oQtBOlmEvkai57SkGFTpek22fjhP
x938RU/hahcHKlegvg43KiAvwrUMpvTQI6h4gU0NRfKpj67YfCJf8WWT0/zO
bSt7/NZqQ10HJTv0yb5M5n4mP5wpjUF1ArhKSTeBiJ41yBimwogaHWoHUa9B
g5rDvqVA03XcKseNXOZK9KPlJokixdbTrtn8XbGU6ly7pHerfb+viz5kqyHG
25gUyGSEMnlRTEk8v8IQidijMh+9xRgsg6ECzFUGdUbcNODWMFq0HHp7O9ob
0FqFW/n95RHC6+f1X9cyliJHKSKjZshtrNoWz+1xsB3Y7KjzcTUEexqj/Jnj
wYxpDl6oSOPmRJGHjmL0yNBfCf01oJ5BI4MmI9oM6NRBxYvpaoHyOlqK7nnG
W9bBP2ueoCaVUdMbrWerFi7Q2q8acnU28Jl/KS0GOYkoPonLZzgBjUVok0Fd
gb5rGK4H0wi0AO2AioHagJ4h9Go4aHW9sbXYMv8rgtaneJsipdSMW9ScbtN4
X/HcgUA/HApG3BGcjENWMgrSUZbDabhRguYrUF7FbTkGG2FgBXQAXUAPoGHQ
Z4B2AH0qFqa/6fzDa+B5X5+3ZHiZA9a5YtvP8AvEwVBIopGUiIxU5J1FSR4n
oK4ct6rRXofuBmibMdwBI8veC/QB/WAGgcEh9Kv1PfUc5MMpGHNHAbcgoKbd
oL7qtV5mXOTIrN4MN2947cOBQ4g8ioQkpKUjJwdFhZwU9qZwk831TSib0NuO
/i4M90LfB+MAmCEww+xXpx9Qq5VVMK2XLdemUM0osxre+zXqC7X1UsPctczK
LXD2wY4gBBxBWDxiUyDNRGYe8i9yWiprUCtHowJtrVAp0duNfg2GBqAbgkEH
Hfsd1t3u6xCuPoRr3BFF3GKfr45Xqem11MJha0dm0Ras2Q23YHhH4UAiIlOR
kIW0C8gu4RSUXUf1TciboehAmxqq2+jph2YIWh369ejTMeqB/nv2QkI9lmeE
38n8kZqjpOyNc92xfDecguERBf9EHDyFmBycKES6jBNRVIfyRtS0Qq5EYzda
NOgYgHIYXez1qUProOGeihAqeM3idcorGEct7KPWY54XVgVhfSQ8ExF4CuE5
OFqE5DKO/pwcRQqUtaFKhes9qO9DwwBGKYZYrPoB3H3vuWcvNfKcH3VnVzyO
2ooFgaAjsPEYdqZhbzbCCxHLM6XLkaPAhVZcUqK8GxUaVGlRqYXsNp7hYv9t
n2/CFu5bzftDD8YmGKskWC+FZyYC8hFayhEk1OJkAzKakd2BcyrkqXFOjZRm
w9hfQX/jbuVjqT1YJIHDSbhnw4u/WEKrEFmL2JuIVyBOAdFzd6kZGf8Egcan
BbapXkf22i+aWU3REwXeTz0g+iWLuX/LjPmgaI6b6zbV7NsCb8tvIkaiubct
XBGY9j533p08KIrLLTf5pvcY7wq8LV/dI9FPmKNN72veM3NajBr9S5RZ54d8
zAeCrI254yu+85nM+/3ZjM2DmTpEJntEzRTe887bqdECrabeKf91q2k4ps9K
9jfqf4T7W+tvrb+1/n+12t/3KHrsXzISMv4=\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->231603232]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->530],

Cell[TextData[{
 "The alignment point can be specified as an argument of ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 ": ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->32765]
}], "ExampleText",
 CellID->379601423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Inset", "[", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"Circle", "[", "]"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], ",", "Center", ",",
         
        RowBox[{"{", 
         RowBox[{"a", ",", "0"}], "}"}]}], "]"}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "70"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78984998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[InsetBox[
     GraphicsBox[CircleBox[{0, 0}],
      ImageSize->30], ImageScaled[{0.5, 0.5}], {-1, 0}],
    Axes->True,
    ImageSize->70,
    Ticks->None], ",", 
   GraphicsBox[InsetBox[
     GraphicsBox[CircleBox[{0, 0}],
      ImageSize->30], ImageScaled[{0.5, 0.5}], {0, 0}],
    Axes->True,
    ImageSize->70,
    Ticks->None], ",", 
   GraphicsBox[InsetBox[
     GraphicsBox[CircleBox[{0, 0}],
      ImageSize->30], ImageScaled[{0.5, 0.5}], {1, 0}],
    Axes->True,
    ImageSize->70,
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{251, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->437931]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Inset", "[", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"Circle", "[", "]"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], ",", "Center", ",",
         
        RowBox[{"{", 
         RowBox[{"0", ",", "a"}], "}"}]}], "]"}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "70"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->113894623],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[InsetBox[
     GraphicsBox[CircleBox[{0, 0}],
      ImageSize->30], ImageScaled[{0.5, 0.5}], {0, -1}],
    Axes->True,
    ImageSize->70,
    Ticks->None], ",", 
   GraphicsBox[InsetBox[
     GraphicsBox[CircleBox[{0, 0}],
      ImageSize->30], ImageScaled[{0.5, 0.5}], {0, 0}],
    Axes->True,
    ImageSize->70,
    Ticks->None], ",", 
   GraphicsBox[InsetBox[
     GraphicsBox[CircleBox[{0, 0}],
      ImageSize->30], ImageScaled[{0.5, 0.5}], {0, 1}],
    Axes->True,
    ImageSize->70,
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{251, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144801823]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3271],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaselinePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaselinePosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Alignment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Alignment"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4287]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8421],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->992],

Cell[TextData[ButtonBox["Redrawing and Combining Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RedrawingAndCombiningPlots"]], "Tutorials",
 CellID->25408],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->811360059]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->101708530],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "MoreAbout",
 CellID->407675758],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->412562149],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->35219267]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AlignmentPoint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 2.9862114}", "context" -> "System`", 
    "keywords" -> {
     "align objects", "positioning", "position offset", "relative position"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "AlignmentPoint is an option which specifies how objects should by \
default be aligned when they appear in Inset.", 
    "synonyms" -> {"alignment point"}, "title" -> "AlignmentPoint", "type" -> 
    "Symbol", "uri" -> "ref/AlignmentPoint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11267, 367, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->28975008]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 49276, 1315}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2608, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3231, 88, 1579, 37, 70, "ObjectNameGrid"],
Cell[4813, 127, 626, 19, 70, "Usage",
 CellID->32651]
}, Open  ]],
Cell[CellGroupData[{
Cell[5476, 151, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5954, 168, 770, 30, 70, "Notes",
 CellID->32765],
Cell[6727, 200, 211, 8, 70, "Notes",
 CellID->19601],
Cell[6941, 210, 2183, 64, 70, "2ColumnTableMod",
 CellID->17209],
Cell[9127, 276, 743, 30, 70, "Notes",
 CellID->1497],
Cell[9873, 308, 870, 35, 70, "Notes",
 CellID->27283],
Cell[10746, 345, 249, 8, 70, "Notes",
 CellID->29250],
Cell[10998, 355, 232, 7, 70, "Notes",
 CellID->18058]
}, Closed]],
Cell[CellGroupData[{
Cell[11267, 367, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->28975008],
Cell[CellGroupData[{
Cell[11651, 381, 148, 5, 70, "ExampleSection",
 CellID->344676785],
Cell[11802, 388, 263, 8, 70, "ExampleText",
 CellID->642016114],
Cell[CellGroupData[{
Cell[12090, 400, 841, 26, 65, "Input",
 CellID->149359173],
Cell[12934, 428, 779, 28, 93, "Output",
 CellID->303642548]
}, Open  ]],
Cell[CellGroupData[{
Cell[13750, 461, 841, 26, 65, "Input",
 CellID->361327031],
Cell[14594, 489, 777, 28, 93, "Output",
 CellID->6896783]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15420, 523, 216, 7, 70, "ExampleSection",
 CellID->10700],
Cell[15639, 532, 263, 9, 70, "ExampleText",
 CellID->79404433],
Cell[CellGroupData[{
Cell[15927, 545, 928, 28, 70, "Input",
 CellID->27695968],
Cell[16858, 575, 11919, 218, 132, "Output",
 CellID->5508554]
}, Open  ]],
Cell[CellGroupData[{
Cell[28814, 798, 929, 28, 70, "Input",
 CellID->238949188],
Cell[29746, 828, 12124, 221, 132, "Output",
 CellID->231603232]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41919, 1055, 237, 7, 70, "ExampleSection",
 CellID->530],
Cell[42159, 1064, 316, 11, 70, "ExampleText",
 CellID->379601423],
Cell[CellGroupData[{
Cell[42500, 1079, 786, 25, 70, "Input",
 CellID->78984998],
Cell[43289, 1106, 710, 25, 93, "Output",
 CellID->437931]
}, Open  ]],
Cell[CellGroupData[{
Cell[44036, 1136, 787, 25, 70, "Input",
 CellID->113894623],
Cell[44826, 1163, 713, 25, 93, "Output",
 CellID->144801823]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45600, 1195, 310, 9, 70, "SeeAlsoSection",
 CellID->3271],
Cell[45913, 1206, 468, 17, 70, "SeeAlso",
 CellID->4287]
}, Open  ]],
Cell[CellGroupData[{
Cell[46418, 1228, 313, 9, 70, "TutorialsSection",
 CellID->8421],
Cell[46734, 1239, 141, 3, 70, "Tutorials",
 CellID->992],
Cell[46878, 1244, 166, 3, 70, "Tutorials",
 CellID->25408],
Cell[47047, 1249, 151, 3, 70, "Tutorials",
 CellID->811360059]
}, Open  ]],
Cell[CellGroupData[{
Cell[47235, 1257, 319, 9, 70, "MoreAboutSection",
 CellID->101708530],
Cell[47557, 1268, 147, 3, 70, "MoreAbout",
 CellID->407675758],
Cell[47707, 1273, 175, 3, 70, "MoreAbout",
 CellID->412562149],
Cell[47885, 1278, 196, 4, 70, "MoreAbout",
 CellID->35219267]
}, Open  ]],
Cell[48096, 1285, 27, 0, 70, "History"],
Cell[48126, 1287, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

