(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13378,        453]
NotebookOptionsPosition[     11055,        381]
NotebookOutlinePosition[     12285,        413]
CellTagsIndexPosition[     12242,        410]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ScriptLevel" :> 
         Documentation`HelpLookup["paclet:ref/ScriptLevel"], 
         "LimitsPositioning" :> 
         Documentation`HelpLookup["paclet:ref/LimitsPositioning"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"ScriptLevel\"\>", 
      2->"\<\"LimitsPositioning\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AllowScriptLevelChange", "ObjectName",
 CellID->24925],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->331866734],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AllowScriptLevelChange",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AllowScriptLevelChange"]], "InlineFormula"],
     " \[LineSeparator]is an option for fractions and grids that controls \
whether certain operators, such as ",
     Cell[BoxData[
      FormBox["\[Sum]", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["\[Product]", TraditionalForm]], "InlineMath"],
     ", and ",
     Cell[BoxData[
      FormBox["\[Integral]", TraditionalForm]], "InlineMath"],
     ", always appear smaller than normal size."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21265]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A fraction can be created using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 " or ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Typesetting",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Typesetting"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Fraction", "MenuName"],
 "."
}], "Notes",
 CellID->31260],

Cell[TextData[{
 "Certain formatting constructs change the level, or ",
 Cell[BoxData[
  ButtonBox["ScriptLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptLevel"]], "InlineFormula"],
 ", at which a selection is displayed. For example, ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " occurs at the second level of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["a", "b"], TraditionalForm]], "InlineMath"],
 " and has ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScriptLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptLevel"], "->", "2"}]], "InlineFormula"],
 ". By default, fractions also increment the ",
 Cell[BoxData[
  ButtonBox["ScriptLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptLevel"]], "InlineFormula"],
 " of the numerator and denominator; for example, each character in ",
 Cell[BoxData[
  FormBox[
   FractionBox["a", "b"], TraditionalForm]], "InlineMath"],
 " has ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScriptLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptLevel"], "->", "2"}]], "InlineFormula"],
 ". By default, grids also increment the ",
 Cell[BoxData[
  ButtonBox["ScriptLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptLevel"]], "InlineFormula"],
 " of their elements; for example, each character in",
 " ",
 Cell[BoxData[GridBox[{
    {
     StyleBox["a", "TI"], 
     StyleBox["b", "TI"]},
    {
     StyleBox["c", "TI"], 
     StyleBox["d", "TI"]}
   },
   GridBoxDividers->{
    "Columns" -> {True, {True}, True}, "ColumnsIndexed" -> {}, 
     "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}]]],
 " has ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScriptLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptLevel"], "->", "2"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20778],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"AllowScriptLevelChange", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ScriptLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptLevel"]], "InlineFormula"],
 " is incremented by 1 for the numerator and denominator for each entry in a \
grid. This means that operators affected by ",
 Cell[BoxData[
  ButtonBox["LimitsPositioning",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LimitsPositioning"]], "InlineFormula"],
 " appear smaller than normal size, as shown here."
}], "Notes",
 CellID->5821],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[Integral]", "f"}], "1"], " ", 
  RowBox[{"\[Integral]", "f"}]}]], "Input",
 ShowCellBracket->False,
 CellID->13855],

Cell[BoxData[
 RowBox[{GridBox[{
    {
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", "1"}], "100"], 
     UnderoverscriptBox["\[Product]", 
      RowBox[{"i", "=", "1"}], "n"]},
    {
     SubsuperscriptBox["\[Integral]", "a", "b"], 
     UnderscriptBox["lim", 
      RowBox[{"n", "\[Rule]", " ", "\[Infinity]"}]]}
   },
   AllowScriptLevelChange->True,
   GridBoxDividers->{
    "Columns" -> {{True}}, "ColumnsIndexed" -> {}, "Rows" -> {{True}}, 
     "RowsIndexed" -> {}}], "  ", 
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"j", "=", "1"}], "100"]}]], "Input",
 ShowCellBracket->False,
 CellID->2520],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"AllowScriptLevelChange", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ScriptLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptLevel"]], "InlineFormula"],
 " is not incremented for the numerator and denominator and grid entries; in \
other words, ",
 Cell[BoxData[
  ButtonBox["ScriptLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptLevel"]], "InlineFormula"],
 " for a selected part has the same value as it would outside the fraction or \
grid. With this setting, subexpressions within a fraction or grid can have a \
",
 Cell[BoxData[
  ButtonBox["ScriptLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptLevel"]], "InlineFormula"],
 " of 0, which allows operators such as ",
 Cell[BoxData[
  FormBox["\[Sum]", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[Product]", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["\[Integral]", TraditionalForm]], "InlineMath"],
 " to appear at their normal size and formatting, as shown here."
}], "Notes",
 CellID->12927],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[Integral]", "f"}], "1"], " ", 
  RowBox[{"\[Integral]", "f"}]}]], "Input",
 ShowCellBracket->False,
 FractionBoxOptions->{AllowScriptLevelChange->False},
 CellID->24773],

Cell[BoxData[
 RowBox[{GridBox[{
    {
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", "1"}], "100"], 
     UnderoverscriptBox["\[Product]", 
      RowBox[{"i", "=", "1"}], "n"]},
    {
     SubsuperscriptBox["\[Integral]", "a", "b"], 
     UnderscriptBox["lim", 
      RowBox[{"n", "\[Rule]", " ", "\[Infinity]"}]]}
   },
   AllowScriptLevelChange->False,
   GridBoxDividers->{
    "Columns" -> {{True}}, "ColumnsIndexed" -> {}, "Rows" -> {{True}}, 
     "RowsIndexed" -> {}}], " ", 
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"j", "=", "1"}], "100"]}]], "Input",
 ShowCellBracket->False,
 CellID->25134],

Cell[TextData[{
 "For a selected fraction or grid, ",
 Cell[BoxData[
  ButtonBox["AllowScriptLevelChange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AllowScriptLevelChange"]], "InlineFormula"],
 " is set as an option for ",
 Cell[BoxData[
  ButtonBox["FractionBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionBox"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 ", and applies only to the selection."
}], "Notes",
 CellID->27251],

Cell[TextData[{
 "At the cell level, ",
 Cell[BoxData[
  ButtonBox["AllowScriptLevelChange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AllowScriptLevelChange"]], "InlineFormula"],
 " is set as a suboption of the ",
 Cell[TextData[Cell[BoxData[
  ButtonBox["FractionBoxOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionBoxOptions"]], "InlineFormula"]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData["GridBoxOptions"], "InlineFormula"],
 " option for cells. It specifies the default setting of ",
 Cell[BoxData[
  ButtonBox["AllowScriptLevelChange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AllowScriptLevelChange"]], "InlineFormula"],
 " for any fraction or grid in the cell."
}], "Notes",
 CellID->22675]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScriptLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LimitsPositioning",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LimitsPositioning"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5974]
}, Open  ]],

Cell["New in 4.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AllowScriptLevelChange - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 4.5956276}", "context" -> "System`", 
    "keywords" -> {"font size", "subscript size"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AllowScriptLevelChange is an option for fractions and grids that \
controls whether certain operators, such as \\[Sum], \\[Product], and \
\\[Integral], always appear smaller than normal size.", 
    "synonyms" -> {"allow script level change"}, "title" -> 
    "AllowScriptLevelChange", "type" -> "Symbol", "uri" -> 
    "ref/AllowScriptLevelChange"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 707, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1330, 44, 60, 1, 70, "ObjectName",
 CellID->24925],
Cell[1393, 47, 218, 6, 70, "AwaitingReviewNote",
 CellID->331866734],
Cell[1614, 55, 816, 23, 70, "Usage",
 CellID->21265]
}, Open  ]],
Cell[CellGroupData[{
Cell[2467, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2945, 100, 571, 17, 70, "Notes",
 CellID->31260],
Cell[3519, 119, 1821, 60, 70, "Notes",
 CellID->20778],
Cell[5343, 181, 679, 20, 70, "Notes",
 CellID->5821],
Cell[6025, 203, 168, 6, 70, "Input",
 CellID->13855],
Cell[6196, 211, 615, 19, 70, "Input",
 CellID->2520],
Cell[6814, 232, 1209, 36, 70, "Notes",
 CellID->12927],
Cell[8026, 270, 222, 7, 70, "Input",
 CellID->24773],
Cell[8251, 279, 616, 19, 70, "Input",
 CellID->25134],
Cell[8870, 300, 550, 18, 70, "Notes",
 CellID->27251],
Cell[9423, 320, 734, 21, 70, "Notes",
 CellID->22675]
}, Closed]],
Cell[CellGroupData[{
Cell[10194, 346, 310, 9, 70, "SeeAlsoSection",
 CellID->9310],
Cell[10507, 357, 474, 17, 70, "SeeAlso",
 CellID->5974]
}, Open  ]],
Cell[10996, 377, 29, 0, 70, "History"],
Cell[11028, 379, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

