(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13465,        477]
NotebookOptionsPosition[     10368,        372]
NotebookOutlinePosition[     11602,        408]
CellTagsIndexPosition[     11517,        403]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns Involving Alternatives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsInvolvingAlternatives"], 
          "Patterns for Some Common Types of Expression" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsForSomeCommonTypesOfExpression"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns Involving Alternatives\"\>", 
       2->"\<\"Patterns for Some Common Types of Expression\"\>", 
       3->"\<\"String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Optional" :> Documentation`HelpLookup["paclet:ref/Optional"], 
          "Except" :> Documentation`HelpLookup["paclet:ref/Except"], "Cases" :> 
          Documentation`HelpLookup["paclet:ref/Cases"], "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Optional\"\>", 2->"\<\"Except\"\>", 
       3->"\<\"Cases\"\>", 4->"\<\"StringExpression\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Patterns\"\>", 
       3->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Alternatives ",
 StyleBox["(|)", "OperatorCharacter"]
}], "ObjectName",
 CellID->1401],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["p", "TI"], 
        StyleBox["1", "TR"]], "|", 
       SubscriptBox[
        StyleBox["p", "TI"], 
        StyleBox["2", "TR"]], "|", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     "\[LineSeparator]is a pattern object which represents any of the \
patterns ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If a named pattern such as ",
 Cell[BoxData["x_"], "InlineFormula"],
 " appears in ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["p", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " that are not used in a particular match, then the named pattern is taken \
to have a value that is a zero-length sequence ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"], "[", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->123024411]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20564230],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->150471996],

Cell[TextData[{
 "Replace instances of either ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31536796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "d", ",", "a", ",", "b", ",", "b", ",", 
    "b"}], "}"}], "/.", 
  RowBox[{
   RowBox[{"a", "|", "b"}], "\[Rule]", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45764754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "x", ",", "c", ",", "d", ",", "x", ",", "x", ",", "x", ",", "x"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28984560]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25981],

Cell["Pick out integers or reals:", "ExampleText",
 CellID->853107409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5.6", ",", 
     RowBox[{"5", "/", "6"}], ",", "5", ",", "6", ",", "x"}], "}"}], ",", 
   RowBox[{"_Integer", "|", "_Real"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->253722071],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.6`", ",", "5", ",", "6"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16388798]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18721],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Optional",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Optional"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31426]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20736],

Cell[TextData[ButtonBox["Patterns Involving Alternatives",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsInvolvingAlternatives"]], "Tutorials",
 CellID->27478],

Cell[TextData[ButtonBox["Patterns for Some Common Types of Expression",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PatternsForSomeCommonTypesOfExpression"]], "Tutorials",
 CellID->39836925],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->233787148],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->161591273],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->150450202],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->355591792]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Alternatives (|) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 4.8143832}", "context" -> "System`", 
    "keywords" -> {"vertical bar"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "p_1 | p_2 | ... is a pattern object which represents any of the patterns \
p_i. ", "synonyms" -> {"|"}, "title" -> "Alternatives", "type" -> "Symbol", 
    "uri" -> "ref/Alternatives"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5172, 162, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20564230]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11375, 396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2676, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3299, 88, 104, 4, 70, "ObjectName",
 CellID->1401],
Cell[3406, 94, 700, 24, 70, "Usage",
 CellID->9078]
}, Open  ]],
Cell[CellGroupData[{
Cell[4143, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4621, 140, 514, 17, 70, "Notes",
 CellID->123024411]
}, Closed]],
Cell[CellGroupData[{
Cell[5172, 162, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20564230],
Cell[CellGroupData[{
Cell[5556, 176, 148, 5, 70, "ExampleSection",
 CellID->150471996],
Cell[5707, 183, 214, 9, 70, "ExampleText",
 CellID->31536796],
Cell[CellGroupData[{
Cell[5946, 196, 261, 9, 28, "Input",
 CellID->45764754],
Cell[6210, 207, 269, 9, 36, "Output",
 CellID->28984560]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6528, 222, 216, 7, 70, "ExampleSection",
 CellID->25981],
Cell[6747, 231, 70, 1, 70, "ExampleText",
 CellID->853107409],
Cell[CellGroupData[{
Cell[6842, 236, 266, 8, 70, "Input",
 CellID->253722071],
Cell[7111, 246, 215, 7, 36, "Output",
 CellID->16388798]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7387, 260, 311, 9, 70, "SeeAlsoSection",
 CellID->18721],
Cell[7701, 271, 947, 35, 70, "SeeAlso",
 CellID->31426]
}, Open  ]],
Cell[CellGroupData[{
Cell[8685, 311, 314, 9, 70, "TutorialsSection",
 CellID->20736],
Cell[9002, 322, 171, 3, 70, "Tutorials",
 CellID->27478],
Cell[9176, 327, 199, 4, 70, "Tutorials",
 CellID->39836925],
Cell[9378, 333, 139, 3, 70, "Tutorials",
 CellID->8153]
}, Open  ]],
Cell[CellGroupData[{
Cell[9554, 341, 319, 9, 70, "MoreAboutSection",
 CellID->233787148],
Cell[9876, 352, 145, 3, 70, "MoreAbout",
 CellID->161591273],
Cell[10024, 357, 128, 3, 70, "MoreAbout",
 CellID->150450202],
Cell[10155, 362, 141, 3, 70, "MoreAbout",
 CellID->355591792]
}, Open  ]],
Cell[10311, 368, 27, 0, 70, "History"],
Cell[10341, 370, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

