(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9479,        340]
NotebookOptionsPosition[      6707,        250]
NotebookOutlinePosition[      8059,        287]
CellTagsIndexPosition[      7975,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Searching Files" :> 
          Documentation`HelpLookup["paclet:tutorial/SearchingFiles"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Searching Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WordSearch" :> 
          Documentation`HelpLookup["paclet:ref/WordSearch"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"WordSearch\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AnchoredSearch", "ObjectName",
 CellID->25012],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AnchoredSearch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AnchoredSearch"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Find",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Find"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["FindList",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
     " which specifies whether the text searched for must be at the beginning \
of a record. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28411]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RecordSeparators",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RecordSeparators"], "->", 
   RowBox[{"{", 
    RowBox[{"\"\<\\n\>\"", ",", "\"\<\\r\\n\>\"", ",", "\"\<\\r\>\""}], 
    "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"AnchoredSearch", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " specifies that the text must appear at the beginning of a line. "
}], "Notes",
 CellID->11959]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->193086942],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->197368759],

Cell["Find lines starting with \"def\":", "ExampleText",
 CellID->372805228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{
   RowBox[{"StringToStream", "[", "\"\<abcdef\\ndefghi\>\"", "]"}], ",", 
   "\"\<def\>\"", ",", 
   RowBox[{"AnchoredSearch", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->886394748],

Cell[BoxData[
 RowBox[{"{", "\<\"defghi\"\>", "}"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4307221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145103409],

Cell["Find lines with \"def\" anywhere in the line:", "ExampleText",
 CellID->121348758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{
   RowBox[{"StringToStream", "[", "\"\<abcdef\\ndefghi\>\"", "]"}], ",", 
   "\"\<def\>\"", ",", 
   RowBox[{"AnchoredSearch", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->605481556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abcdef\"\>", ",", "\<\"defghi\"\>"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232861493]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5507],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["WordSearch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordSearch"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->292]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16251],

Cell[TextData[ButtonBox["Searching Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SearchingFiles"]], "Tutorials",
 CellID->18738]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AnchoredSearch - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 10.3145240}", "context" -> "System`", 
    "keywords" -> {"starting point for search", "anchor point for search"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "AnchoredSearch is an option for Find and FindList which specifies \
whether the text searched for must be at the beginning of a record. ", 
    "synonyms" -> {"anchored search"}, "title" -> "AnchoredSearch", "type" -> 
    "Symbol", "uri" -> "ref/AnchoredSearch"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3726, 130, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->193086942]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7832, 275}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1152, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1775, 58, 52, 1, 70, "ObjectName",
 CellID->25012],
Cell[1830, 61, 784, 24, 70, "Usage",
 CellID->28411]
}, Open  ]],
Cell[CellGroupData[{
Cell[2651, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3129, 107, 560, 18, 70, "Notes",
 CellID->11959]
}, Closed]],
Cell[CellGroupData[{
Cell[3726, 130, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->193086942],
Cell[CellGroupData[{
Cell[4111, 144, 148, 5, 70, "ExampleSection",
 CellID->197368759],
Cell[4262, 151, 76, 1, 70, "ExampleText",
 CellID->372805228],
Cell[CellGroupData[{
Cell[4363, 156, 261, 7, 28, "Input",
 CellID->886394748],
Cell[4627, 165, 191, 6, 36, "Output",
 CellID->4307221]
}, Open  ]],
Cell[4833, 174, 125, 3, 70, "ExampleDelimiter",
 CellID->145103409],
Cell[4961, 179, 88, 1, 70, "ExampleText",
 CellID->121348758],
Cell[CellGroupData[{
Cell[5074, 184, 262, 7, 70, "Input",
 CellID->605481556],
Cell[5339, 193, 230, 7, 36, "Output",
 CellID->232861493]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5630, 207, 310, 9, 70, "SeeAlsoSection",
 CellID->5507],
Cell[5943, 218, 198, 6, 70, "SeeAlso",
 CellID->292]
}, Open  ]],
Cell[CellGroupData[{
Cell[6178, 229, 314, 9, 70, "TutorialsSection",
 CellID->16251],
Cell[6495, 240, 140, 3, 70, "Tutorials",
 CellID->18738]
}, Open  ]],
Cell[6650, 246, 27, 0, 70, "History"],
Cell[6680, 248, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

